/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers;

import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.migration.datafilters.model.DataFilterContext;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.mediaclient.MediaClient;
import com.atlassian.jira.migration.migration.MigratedFileEntity;
import com.atlassian.jira.migration.migration.MigratedFileRepository;
import com.atlassian.jira.migration.orchestratorclient.tasks.MigrationTask;
import com.atlassian.jira.migration.orchestratorclient.tasks.ProjectTask;
import com.atlassian.jira.migration.plan.ProjectDataMigrationMode;
import com.atlassian.jira.migration.serverdataextractors.attachments.JiraAttachmentsService;
import com.atlassian.jira.migration.tracking.tasks.Task;
import com.atlassian.jira.migration.workers.AttachmentMediaIdService;
import com.atlassian.jira.project.ProjectManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 !2\u00020\u0001:\u0001!B7\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\u0006\u0010\u0013\u001a\u00020\u0012J\u0018\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J,\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0014\b\u0002\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001c0\u00102\u0006\u0010\u001d\u001a\u00020\u001eJ4\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u00122\u0014\b\u0002\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001c0\u00102\u0006\u0010\u001d\u001a\u00020\u001eR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/atlassian/jira/migration/workers/AttachmentMediaIdService;", "", "jiraAttachmentsService", "Lcom/atlassian/jira/migration/serverdataextractors/attachments/JiraAttachmentsService;", "mediaClient", "Lcom/atlassian/jira/migration/mediaclient/MediaClient;", "migratedFileRepository", "Lcom/atlassian/jira/migration/migration/MigratedFileRepository;", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "attachmentManager", "Lcom/atlassian/jira/issue/AttachmentManager;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "(Lcom/atlassian/jira/migration/serverdataextractors/attachments/JiraAttachmentsService;Lcom/atlassian/jira/migration/mediaclient/MediaClient;Lcom/atlassian/jira/migration/migration/MigratedFileRepository;Lcom/atlassian/jira/project/ProjectManager;Lcom/atlassian/jira/issue/AttachmentManager;Lcom/atlassian/jira/migration/discovery/DiscoveryService;)V", "attachmentMediaIdResolvingAction", "Lkotlin/Function1;", "", "", "containerToken", "createMigrationFileIfNotExists", "attachmentId", "mediaClientId", "generateAttachmentMediaIds", "", "task", "Lcom/atlassian/jira/migration/tracking/tasks/Task;", "onProgressUpdate", "", "dataFilterContext", "Lcom/atlassian/jira/migration/datafilters/model/DataFilterContext;", "generateMediaFileIds", "projectKey", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAttachmentMediaIdService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttachmentMediaIdService.kt\ncom/atlassian/jira/migration/workers/AttachmentMediaIdService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n1603#2,9:129\n1855#2:138\n1856#2:140\n1612#2:141\n1#3:139\n*S KotlinDebug\n*F\n+ 1 AttachmentMediaIdService.kt\ncom/atlassian/jira/migration/workers/AttachmentMediaIdService\n*L\n69#1:129,9\n69#1:138\n69#1:140\n69#1:141\n69#1:139\n*E\n"})
public final class AttachmentMediaIdService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JiraAttachmentsService jiraAttachmentsService;
    @NotNull
    private final MediaClient mediaClient;
    @NotNull
    private final MigratedFileRepository migratedFileRepository;
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final AttachmentManager attachmentManager;
    @NotNull
    private final DiscoveryService discoveryService;
    private static final Logger log = LoggerFactory.getLogger(AttachmentMediaIdService.class);
    @NotNull
    public static final String ATTACHMENT_ONLY_ENTITY_TYPE = "attachment";

    @Inject
    public AttachmentMediaIdService(@NotNull JiraAttachmentsService jiraAttachmentsService, @NotNull MediaClient mediaClient, @NotNull MigratedFileRepository migratedFileRepository, @NotNull ProjectManager projectManager, @NotNull AttachmentManager attachmentManager, @NotNull DiscoveryService discoveryService) {
        Intrinsics.checkNotNullParameter((Object)jiraAttachmentsService, (String)"jiraAttachmentsService");
        Intrinsics.checkNotNullParameter((Object)mediaClient, (String)"mediaClient");
        Intrinsics.checkNotNullParameter((Object)migratedFileRepository, (String)"migratedFileRepository");
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)attachmentManager, (String)"attachmentManager");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        this.jiraAttachmentsService = jiraAttachmentsService;
        this.mediaClient = mediaClient;
        this.migratedFileRepository = migratedFileRepository;
        this.projectManager = projectManager;
        this.attachmentManager = attachmentManager;
        this.discoveryService = discoveryService;
    }

    public final int generateAttachmentMediaIds(@NotNull Task task, @NotNull Function1<? super String, Unit> onProgressUpdate2, @NotNull DataFilterContext dataFilterContext) {
        int n;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter(onProgressUpdate2, (String)"onProgressUpdate");
        Intrinsics.checkNotNullParameter((Object)dataFilterContext, (String)"dataFilterContext");
        MigrationTask migrationTask = task.getMigrationTask();
        Intrinsics.checkNotNull((Object)migrationTask, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.orchestratorclient.tasks.ProjectTask");
        ProjectTask projectTask = (ProjectTask)migrationTask;
        log.info(task.getMigrationId() + '-' + task.getTaskId() + ": generating media ids for " + projectTask.getProjectKey());
        int it = n = this.generateMediaFileIds(task, projectTask.getProjectKey(), onProgressUpdate2, dataFilterContext);
        boolean bl = false;
        log.info(task.getMigrationId() + '-' + task.getTaskId() + ": generated " + it + " media ids for " + projectTask.getProjectKey() + ", exporting data now");
        return n;
    }

    public static /* synthetic */ int generateAttachmentMediaIds$default(AttachmentMediaIdService attachmentMediaIdService, Task task, Function1 function1, DataFilterContext dataFilterContext, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = generateAttachmentMediaIds.1.INSTANCE;
        }
        return attachmentMediaIdService.generateAttachmentMediaIds(task, (Function1<? super String, Unit>)function1, dataFilterContext);
    }

    @NotNull
    public final Function1<Long, String> attachmentMediaIdResolvingAction(@NotNull String containerToken) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        String mediaClientId = this.mediaClient.getMediaClientId(containerToken);
        return (Function1)new Function1<Long, String>(this, mediaClientId){
            final /* synthetic */ AttachmentMediaIdService this$0;
            final /* synthetic */ String $mediaClientId;
            {
                this.this$0 = $receiver;
                this.$mediaClientId = $mediaClientId;
                super(1);
            }

            @NotNull
            public final String invoke(long it) {
                return AttachmentMediaIdService.access$createMigrationFileIfNotExists(this.this$0, it, this.$mediaClientId);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public final int generateMediaFileIds(@NotNull Task task, @NotNull String projectKey, @NotNull Function1<? super String, Unit> onProgressUpdate2, @NotNull DataFilterContext dataFilterContext) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        Intrinsics.checkNotNullParameter(onProgressUpdate2, (String)"onProgressUpdate");
        Intrinsics.checkNotNullParameter((Object)dataFilterContext, (String)"dataFilterContext");
        ProjectDataMigrationMode projectDataMode = DiscoveryService.retrievePlanFor$default(this.discoveryService, task, false, 2, null).getProjectDataMigrationMode();
        String containerToken = task.getCloudSite().getContainerToken();
        Long projectId = this.projectManager.getProjectObjByKey(projectKey).getId();
        String mediaClientId = this.mediaClient.getMediaClientId(containerToken);
        Intrinsics.checkNotNull((Object)projectId);
        List<Long> allAttachmentIds = this.jiraAttachmentsService.getAttachmentIdsByProject(projectId);
        HashSet<Long> generatedFileMediaIds = this.migratedFileRepository.getMigratedFileIdsByProject(projectId, mediaClientId);
        int total = allAttachmentIds.size() - generatedFileMediaIds.size();
        Ref.LongRef count2 = new Ref.LongRef();
        Ref.LongRef percentage = new Ref.LongRef();
        Function2 getMsg2 = (Function2)new Function2<Long, Long, String>(total){
            final /* synthetic */ int $total;
            {
                this.$total = $total;
                super(2);
            }

            @NotNull
            public final String invoke(long a, long b) {
                return "Preparing attachments, total=" + this.$total + ", completed=" + a + " (" + b + "%)";
            }
        };
        Iterable $this$mapNotNull$iv = allAttachmentIds;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Attachment it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            long attachmentId = ((Number)element$iv$iv).longValue();
            boolean bl2 = false;
            if (this.attachmentManager.getAttachment(Long.valueOf(attachmentId)) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Sequence allAttachments = CollectionsKt.asSequence((Iterable)((List)destination$iv$iv));
        List filteredAttachmentIds2 = SequencesKt.toList((Sequence)SequencesKt.map(this.jiraAttachmentsService.filterEntities(dataFilterContext, allAttachments, "Filtering attachments using data filters", task.getMigrationId(), task.getCloudId(), projectKey, ATTACHMENT_ONLY_ENTITY_TYPE, projectDataMode), (Function1)generateMediaFileIds.filteredAttachmentIds.1.INSTANCE));
        return SequencesKt.count((Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.map((Sequence)SequencesKt.chunked((Sequence)SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)filteredAttachmentIds2), (Function1)((Function1)new Function1<Long, Boolean>(generatedFileMediaIds){
            final /* synthetic */ HashSet<Long> $generatedFileMediaIds;
            {
                this.$generatedFileMediaIds = $generatedFileMediaIds;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Long it) {
                return this.$generatedFileMediaIds.contains(it);
            }
        })), (int)1000), (Function1)((Function1)new Function1<List<? extends Long>, List<? extends MigratedFileRepository.MigratedFileData>>(mediaClientId, this, count2, percentage, total, onProgressUpdate2, (Function2<? super Long, ? super Long, String>)getMsg2, projectKey){
            final /* synthetic */ String $mediaClientId;
            final /* synthetic */ AttachmentMediaIdService this$0;
            final /* synthetic */ Ref.LongRef $count;
            final /* synthetic */ Ref.LongRef $percentage;
            final /* synthetic */ int $total;
            final /* synthetic */ Function1<String, Unit> $onProgressUpdate;
            final /* synthetic */ Function2<Long, Long, String> $getMsg;
            final /* synthetic */ String $projectKey;
            {
                this.$mediaClientId = $mediaClientId;
                this.this$0 = $receiver;
                this.$count = $count;
                this.$percentage = $percentage;
                this.$total = $total;
                this.$onProgressUpdate = $onProgressUpdate;
                this.$getMsg = $getMsg;
                this.$projectKey = $projectKey;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<MigratedFileRepository.MigratedFileData> invoke(@NotNull List<Long> chunk) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter(chunk, (String)"chunk");
                Iterable iterable = chunk;
                Object object = this.$mediaClientId;
                boolean $i$f$map = false;
                Ref.LongRef longRef = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Long l = (Long)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    long l2 = it.longValue();
                    String string = UUID.randomUUID().toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    collection.add(new MigratedFileRepository.MigratedFileData(l2, string, (String)object));
                }
                iterable = (List)destination$iv$iv;
                object = this.this$0;
                Ref.LongRef longRef2 = this.$count;
                longRef = this.$percentage;
                int n = this.$total;
                Function1<String, Unit> function1 = this.$onProgressUpdate;
                Iterator<T> iterator2 = this.$getMsg;
                String string = this.$projectKey;
                Iterable $this$invoke_u24lambda_u241 = iterable;
                boolean bl = false;
                AttachmentMediaIdService.access$getMigratedFileRepository$p((AttachmentMediaIdService)object).batchInsertMigratedFile((List<MigratedFileRepository.MigratedFileData>)$this$invoke_u24lambda_u241);
                longRef2.element += (long)$this$invoke_u24lambda_u241.size();
                longRef.element = n > 0 ? longRef2.element * (long)100 / (long)n : 0L;
                function1.invoke(iterator2.invoke(longRef2.element, longRef.element));
                if (longRef2.element % (long)1000 == 0L || $this$invoke_u24lambda_u241.size() < 1000) {
                    AttachmentMediaIdService.access$getLog$cp().info("Preparing attachments, project key=" + string + " total=" + n + ", completed=" + longRef2.element + " (" + longRef.element + "%)");
                }
                return iterable;
            }
        }))));
    }

    public static /* synthetic */ int generateMediaFileIds$default(AttachmentMediaIdService attachmentMediaIdService, Task task, String string, Function1 function1, DataFilterContext dataFilterContext, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = generateMediaFileIds.1.INSTANCE;
        }
        return attachmentMediaIdService.generateMediaFileIds(task, string, (Function1<? super String, Unit>)function1, dataFilterContext);
    }

    private final synchronized String createMigrationFileIfNotExists(long attachmentId, String mediaClientId) {
        MigratedFileEntity exists = this.migratedFileRepository.findMigratedFile(attachmentId, mediaClientId);
        if (exists != null) {
            return exists.getFileMediaId();
        }
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String fileMediaId = string;
        MigratedFileRepository.recordMigration$default(this.migratedFileRepository, attachmentId, fileMediaId, mediaClientId, false, null, 16, null);
        return fileMediaId;
    }

    public static final /* synthetic */ String access$createMigrationFileIfNotExists(AttachmentMediaIdService $this, long attachmentId, String mediaClientId) {
        return $this.createMigrationFileIfNotExists(attachmentId, mediaClientId);
    }

    public static final /* synthetic */ MigratedFileRepository access$getMigratedFileRepository$p(AttachmentMediaIdService $this) {
        return $this.migratedFileRepository;
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/workers/AttachmentMediaIdService$Companion;", "", "()V", "ATTACHMENT_ONLY_ENTITY_TYPE", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

