/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers;

import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.common.LocalFileDataOutput;
import com.atlassian.jira.migration.common.MigrationTaskMetadata;
import com.atlassian.jira.migration.datafilters.DataFiltersContextService;
import com.atlassian.jira.migration.datafilters.model.DataFilterContext;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.export.ExportFacade;
import com.atlassian.jira.migration.export.ReportExportOutcome;
import com.atlassian.jira.migration.export.ReportExportOutcomeSerializer;
import com.atlassian.jira.migration.jiraservice.JiraExtensionsKt;
import com.atlassian.jira.migration.migration.DryRunMigration;
import com.atlassian.jira.migration.migration.DryRunMigrationRepository;
import com.atlassian.jira.migration.migration.MigrationCommandService;
import com.atlassian.jira.migration.migration.MigrationProtocol;
import com.atlassian.jira.migration.orchestratorclient.tasks.MigrationTask;
import com.atlassian.jira.migration.orchestratorclient.tasks.V4CrossProjectMigrationTask;
import com.atlassian.jira.migration.orchestratorclient.tasks.V4ProjectMigrationTask;
import com.atlassian.jira.migration.plan.CrossProjectConfig;
import com.atlassian.jira.migration.plan.CrossProjectExportConfig;
import com.atlassian.jira.migration.plan.MigrationType;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.plan.ProjectDataMigrationMode;
import com.atlassian.jira.migration.plan.UsersGroupsMigrationOption;
import com.atlassian.jira.migration.platform.TransferStatus;
import com.atlassian.jira.migration.prc.PrcStatusUpdateService;
import com.atlassian.jira.migration.preflight.reports.DryRunWriteService;
import com.atlassian.jira.migration.tracking.polling.InProgressMigrationIds;
import com.atlassian.jira.migration.tracking.tasks.PrcTask;
import com.atlassian.jira.migration.workers.PlatformUtilKt;
import com.atlassian.jira.migration.workers.PrcProgressUpdater;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.thread.JiraThreadLocalUtil;
import com.atlassian.migration.api.MigrationId;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0099\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0014\b\u0002\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001d\u0012\u0014\b\u0002\u0010 \u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0\u001d\u00a2\u0006\u0002\u0010#J\b\u0010E\u001a\u00020FH\u0002J\b\u0010G\u001a\u00020HH\u0002J\u0010\u0010I\u001a\u00020H2\u0006\u0010J\u001a\u00020KH\u0002J\u0014\u0010=\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0\u001dH\u0007J\u0006\u0010L\u001a\u00020MJ\b\u0010N\u001a\u00020MH\u0002J\b\u0010O\u001a\u00020MH\u0002J\u0010\u0010P\u001a\u00020M2\u0006\u0010Q\u001a\u00020HH\u0002J\f\u0010R\u001a\u00020M*\u00020\u001fH\u0002R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020)\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010/\u001a\n 1*\u0004\u0018\u00010000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00102\u001a\n 1*\u0004\u0018\u00010303X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00104\u001a\u000205\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0011\u00108\u001a\u000209\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010<\u001a\u00020\"8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b?\u0010@\u001a\u0004\b=\u0010>R\u001a\u0010 \u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010A\u001a\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010.R\u0011\u0010C\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010.\u00a8\u0006S"}, d2={"Lcom/atlassian/jira/migration/workers/DryRunReportProcessor;", "", "exportFacade", "Lcom/atlassian/jira/migration/export/ExportFacade;", "dryRunWriteService", "Lcom/atlassian/jira/migration/preflight/reports/DryRunWriteService;", "jiraThreadLocalUtil", "Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;", "prcStatusUpdateService", "Lcom/atlassian/jira/migration/prc/PrcStatusUpdateService;", "task", "Lcom/atlassian/jira/migration/tracking/tasks/PrcTask;", "localFileDataOutput", "Lcom/atlassian/jira/migration/common/LocalFileDataOutput;", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "dataFiltersContextService", "Lcom/atlassian/jira/migration/datafilters/DataFiltersContextService;", "dryRunMigrationRepository", "Lcom/atlassian/jira/migration/migration/DryRunMigrationRepository;", "migrationCommandService", "Lcom/atlassian/jira/migration/migration/MigrationCommandService;", "migrationIds", "Lcom/atlassian/jira/migration/tracking/polling/InProgressMigrationIds;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "userManager", "Lcom/atlassian/jira/user/util/UserManager;", "heartbeatSchedulerProvider", "Lkotlin/Function1;", "", "Ljava/util/concurrent/ScheduledExecutorService;", "progressUpdaterProvider", "Lcom/atlassian/migration/api/MigrationId;", "Lcom/atlassian/jira/migration/workers/PrcProgressUpdater;", "(Lcom/atlassian/jira/migration/export/ExportFacade;Lcom/atlassian/jira/migration/preflight/reports/DryRunWriteService;Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;Lcom/atlassian/jira/migration/prc/PrcStatusUpdateService;Lcom/atlassian/jira/migration/tracking/tasks/PrcTask;Lcom/atlassian/jira/migration/common/LocalFileDataOutput;Lcom/atlassian/jira/project/ProjectManager;Lcom/atlassian/jira/migration/datafilters/DataFiltersContextService;Lcom/atlassian/jira/migration/migration/DryRunMigrationRepository;Lcom/atlassian/jira/migration/migration/MigrationCommandService;Lcom/atlassian/jira/migration/tracking/polling/InProgressMigrationIds;Lcom/atlassian/jira/migration/discovery/DiscoveryService;Lcom/atlassian/jira/user/util/UserManager;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "applicationUser", "Lcom/atlassian/jira/user/ApplicationUser;", "getApplicationUser", "()Lcom/atlassian/jira/user/ApplicationUser;", "cloudSite", "Lcom/atlassian/jira/migration/cloud/CloudSite;", "getCloudSite", "()Lcom/atlassian/jira/migration/cloud/CloudSite;", "fileName", "getFileName", "()Ljava/lang/String;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "log4jLogger", "Lorg/apache/log4j/Logger;", "migrationTaskMetadata", "Lcom/atlassian/jira/migration/common/MigrationTaskMetadata;", "getMigrationTaskMetadata", "()Lcom/atlassian/jira/migration/common/MigrationTaskMetadata;", "plan", "Lcom/atlassian/jira/migration/plan/Plan;", "getPlan", "()Lcom/atlassian/jira/migration/plan/Plan;", "progressUpdater", "getProgressUpdater", "()Lcom/atlassian/jira/migration/workers/PrcProgressUpdater;", "progressUpdater$delegate", "Lkotlin/Lazy;", "taskName", "getTaskName", "userKey", "getUserKey", "dataFilterContext", "Lcom/atlassian/jira/migration/datafilters/model/DataFilterContext;", "generateCrossProjectReport", "Lcom/atlassian/jira/migration/export/ReportExportOutcome;", "generateReport", "migrationTask", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/V4ProjectMigrationTask;", "process", "", "sendFinalStatusAsFailed", "sendFinalStatusAsSuccess", "writeToFile", "reportExportOutcome", "setHeartbeat", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nDryRunReportProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DryRunReportProcessor.kt\ncom/atlassian/jira/migration/workers/DryRunReportProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,222:1\n1#2:223\n1#2:234\n1603#3,9:224\n1855#3:233\n1856#3:235\n1612#3:236\n1549#3:237\n1620#3,3:238\n*S KotlinDebug\n*F\n+ 1 DryRunReportProcessor.kt\ncom/atlassian/jira/migration/workers/DryRunReportProcessor\n*L\n121#1:234\n121#1:224,9\n121#1:233\n121#1:235\n121#1:236\n121#1:237\n121#1:238,3\n*E\n"})
public final class DryRunReportProcessor {
    @NotNull
    private final ExportFacade exportFacade;
    @NotNull
    private final DryRunWriteService dryRunWriteService;
    @NotNull
    private final JiraThreadLocalUtil jiraThreadLocalUtil;
    @NotNull
    private final PrcStatusUpdateService prcStatusUpdateService;
    @NotNull
    private final PrcTask task;
    @NotNull
    private final LocalFileDataOutput localFileDataOutput;
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final DataFiltersContextService dataFiltersContextService;
    @NotNull
    private final Function1<String, ScheduledExecutorService> heartbeatSchedulerProvider;
    @NotNull
    private final Function1<MigrationId, PrcProgressUpdater> progressUpdaterProvider;
    private final Logger log;
    private final org.apache.log4j.Logger log4jLogger;
    @NotNull
    private final Plan plan;
    @NotNull
    private final CloudSite cloudSite;
    @NotNull
    private final String userKey;
    @NotNull
    private final ApplicationUser applicationUser;
    @NotNull
    private final MigrationTaskMetadata migrationTaskMetadata;
    @NotNull
    private final Lazy progressUpdater$delegate;

    public DryRunReportProcessor(@NotNull ExportFacade exportFacade, @NotNull DryRunWriteService dryRunWriteService, @NotNull JiraThreadLocalUtil jiraThreadLocalUtil, @NotNull PrcStatusUpdateService prcStatusUpdateService, @NotNull PrcTask task, @NotNull LocalFileDataOutput localFileDataOutput, @NotNull ProjectManager projectManager, @NotNull DataFiltersContextService dataFiltersContextService, @NotNull DryRunMigrationRepository dryRunMigrationRepository, @NotNull MigrationCommandService migrationCommandService, @NotNull InProgressMigrationIds migrationIds, @NotNull DiscoveryService discoveryService, @NotNull UserManager userManager, @NotNull Function1<? super String, ? extends ScheduledExecutorService> heartbeatSchedulerProvider, @NotNull Function1<? super MigrationId, PrcProgressUpdater> progressUpdaterProvider) {
        Intrinsics.checkNotNullParameter((Object)exportFacade, (String)"exportFacade");
        Intrinsics.checkNotNullParameter((Object)dryRunWriteService, (String)"dryRunWriteService");
        Intrinsics.checkNotNullParameter((Object)jiraThreadLocalUtil, (String)"jiraThreadLocalUtil");
        Intrinsics.checkNotNullParameter((Object)prcStatusUpdateService, (String)"prcStatusUpdateService");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)localFileDataOutput), (String)"localFileDataOutput");
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)dataFiltersContextService, (String)"dataFiltersContextService");
        Intrinsics.checkNotNullParameter((Object)dryRunMigrationRepository, (String)"dryRunMigrationRepository");
        Intrinsics.checkNotNullParameter((Object)migrationCommandService, (String)"migrationCommandService");
        Intrinsics.checkNotNullParameter((Object)migrationIds, (String)"migrationIds");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)userManager, (String)"userManager");
        Intrinsics.checkNotNullParameter(heartbeatSchedulerProvider, (String)"heartbeatSchedulerProvider");
        Intrinsics.checkNotNullParameter(progressUpdaterProvider, (String)"progressUpdaterProvider");
        this.exportFacade = exportFacade;
        this.dryRunWriteService = dryRunWriteService;
        this.jiraThreadLocalUtil = jiraThreadLocalUtil;
        this.prcStatusUpdateService = prcStatusUpdateService;
        this.task = task;
        this.localFileDataOutput = localFileDataOutput;
        this.projectManager = projectManager;
        this.dataFiltersContextService = dataFiltersContextService;
        this.heartbeatSchedulerProvider = heartbeatSchedulerProvider;
        this.progressUpdaterProvider = progressUpdaterProvider;
        this.log = LoggerFactory.getLogger(DryRunReportProcessor.class);
        this.log4jLogger = org.apache.log4j.Logger.getLogger(DryRunReportProcessor.class);
        this.plan = discoveryService.retrievePlanFor(this.task, true);
        CloudSite cloudSite2 = discoveryService.retrieveCloudSiteForCloudId(this.plan.getCloudId());
        Intrinsics.checkNotNull((Object)cloudSite2);
        this.cloudSite = cloudSite2;
        DryRunMigration dryRunMigration = dryRunMigrationRepository.findByMigrationId(this.task.getMigrationId());
        Intrinsics.checkNotNull((Object)dryRunMigration);
        this.userKey = dryRunMigration.getStartedBy();
        ApplicationUser applicationUser = userManager.getUserByKey(this.userKey);
        Intrinsics.checkNotNull((Object)applicationUser);
        this.applicationUser = applicationUser;
        String string = this.plan.getPreflightCheckExecutionId();
        String string2 = this.plan.getCloudId();
        URI uRI = URI.create(this.plan.getCloudUrl());
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
        this.migrationTaskMetadata = new MigrationTaskMetadata(string, this.applicationUser, string2, uRI, this.task.getTaskId(), this.cloudSite.getContainerToken(), true);
        this.progressUpdater$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PrcProgressUpdater>(this){
            final /* synthetic */ DryRunReportProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final PrcProgressUpdater invoke() {
                return (PrcProgressUpdater)DryRunReportProcessor.access$getProgressUpdaterProvider$p(this.this$0).invoke((Object)new MigrationId(DryRunReportProcessor.access$getTask$p(this.this$0).getMigrationId()));
            }
        }));
    }

    public /* synthetic */ DryRunReportProcessor(ExportFacade exportFacade, DryRunWriteService dryRunWriteService, JiraThreadLocalUtil jiraThreadLocalUtil, final PrcStatusUpdateService prcStatusUpdateService, PrcTask prcTask, LocalFileDataOutput localFileDataOutput, ProjectManager projectManager, DataFiltersContextService dataFiltersContextService, DryRunMigrationRepository dryRunMigrationRepository, final MigrationCommandService migrationCommandService, final InProgressMigrationIds inProgressMigrationIds, DiscoveryService discoveryService, UserManager userManager, Function1 function1, Function1 function12, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x2000) != 0) {
            function1 = 1.INSTANCE;
        }
        if ((n & 0x4000) != 0) {
            function12 = (Function1)new Function1<MigrationId, PrcProgressUpdater>(){

                @NotNull
                public final PrcProgressUpdater invoke(@NotNull MigrationId it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return new PrcProgressUpdater(prcStatusUpdateService, it, migrationCommandService, inProgressMigrationIds, null, null, 48, null);
                }
            };
        }
        this(exportFacade, dryRunWriteService, jiraThreadLocalUtil, prcStatusUpdateService, prcTask, localFileDataOutput, projectManager, dataFiltersContextService, dryRunMigrationRepository, migrationCommandService, inProgressMigrationIds, discoveryService, userManager, (Function1<? super String, ? extends ScheduledExecutorService>)function1, (Function1<? super MigrationId, PrcProgressUpdater>)function12);
    }

    @NotNull
    public final Plan getPlan() {
        return this.plan;
    }

    @NotNull
    public final CloudSite getCloudSite() {
        return this.cloudSite;
    }

    @NotNull
    public final String getUserKey() {
        return this.userKey;
    }

    @NotNull
    public final ApplicationUser getApplicationUser() {
        return this.applicationUser;
    }

    @NotNull
    public final MigrationTaskMetadata getMigrationTaskMetadata() {
        return this.migrationTaskMetadata;
    }

    @NotNull
    public final PrcProgressUpdater getProgressUpdater() {
        Lazy lazy = this.progressUpdater$delegate;
        return (PrcProgressUpdater)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void process() {
        ScheduledExecutorService heartbeatScheduler = (ScheduledExecutorService)this.heartbeatSchedulerProvider.invoke((Object)this.task.getMigrationId());
        try {
            ReportExportOutcome reportExportOutcome2;
            ScheduledExecutorService $this$process_u24lambda_u240 = heartbeatScheduler;
            boolean bl = false;
            this.setHeartbeat($this$process_u24lambda_u240);
            MigrationTask task = this.task.getMigrationTask();
            if (task instanceof V4ProjectMigrationTask) {
                reportExportOutcome2 = this.generateReport((V4ProjectMigrationTask)task);
            } else if (task instanceof V4CrossProjectMigrationTask) {
                reportExportOutcome2 = this.generateCrossProjectReport();
            } else {
                throw new IllegalStateException("Invalid migration task type".toString());
            }
            ReportExportOutcome reportExportOutcome3 = reportExportOutcome2;
            this.writeToFile(reportExportOutcome3);
            if (reportExportOutcome3.getExportErrors().values().contains(true)) {
                this.sendFinalStatusAsFailed();
            } else {
                this.sendFinalStatusAsSuccess();
            }
        }
        catch (Throwable e) {
            this.log.error("Error occurred while executing dry run export: " + this.getTaskName(), e);
            ReportExportOutcome outcome = new ReportExportOutcome(CollectionsKt.emptyList(), CollectionsKt.emptyList(), SetsKt.emptySet(), SetsKt.emptySet(), MapsKt.emptyMap(), CollectionsKt.emptyList(), CollectionsKt.listOf((Object)e.toString()));
            this.writeToFile(outcome);
            this.sendFinalStatusAsFailed();
        }
        finally {
            heartbeatScheduler.shutdownNow();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ReportExportOutcome generateCrossProjectReport() {
        void $this$mapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.plan.getProjectKeys();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Project project = $this$forEach$iv$iv$iv.iterator();
        while (project.hasNext()) {
            Project it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = project.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.projectManager.getProjectObjByKeyIgnoreCase(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            project = (Project)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        List projectIds = (List)destination$iv$iv;
        org.apache.log4j.Logger logger2 = this.log4jLogger;
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"log4jLogger");
        ReportExportOutcome reportExportOutcome2 = (ReportExportOutcome)JiraExtensionsKt.wrap(this.jiraThreadLocalUtil, logger2, (Function0)new Function0<ReportExportOutcome>(this, (List<Long>)projectIds){
            final /* synthetic */ DryRunReportProcessor this$0;
            final /* synthetic */ List<Long> $projectIds;
            {
                this.this$0 = $receiver;
                this.$projectIds = $projectIds;
                super(0);
            }

            @NotNull
            public final ReportExportOutcome invoke() {
                return ExportFacade.exportCrossProjectReportData$default(DryRunReportProcessor.access$getExportFacade$p(this.this$0), this.$projectIds, this.this$0.getMigrationTaskMetadata(), this.this$0.getPlan().getUsersGroupsMigrationOption(), this.this$0.getPlan().getAdvancedRoadmapsPlanIds(), new CrossProjectConfig(new CrossProjectExportConfig(this.this$0.getPlan().getCrossProjectBoardsAndFiltersMigrationOption(), this.this$0.getPlan().getDashboardsMigrationMode())), this.this$0.getPlan().getMigrateArchivedIssues(), null, DryRunReportProcessor.access$dataFilterContext(this.this$0), 64, null);
            }
        });
        this.dryRunWriteService.postDryRunCleanup(reportExportOutcome2);
        return reportExportOutcome2;
    }

    private final ReportExportOutcome generateReport(V4ProjectMigrationTask migrationTask) {
        Project project = this.projectManager.getProjectObj(Long.valueOf(Long.parseLong(migrationTask.getProjectId())));
        Intrinsics.checkNotNull((Object)project);
        Project project2 = project;
        org.apache.log4j.Logger logger2 = this.log4jLogger;
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"log4jLogger");
        ReportExportOutcome reportExportOutcome2 = (ReportExportOutcome)JiraExtensionsKt.wrap(this.jiraThreadLocalUtil, logger2, (Function0)new Function0<ReportExportOutcome>(this, project2){
            final /* synthetic */ DryRunReportProcessor this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                super(0);
            }

            @NotNull
            public final ReportExportOutcome invoke() {
                ExportFacade exportFacade = DryRunReportProcessor.access$getExportFacade$p(this.this$0);
                MigrationTaskMetadata migrationTaskMetadata2 = this.this$0.getMigrationTaskMetadata();
                UsersGroupsMigrationOption usersGroupsMigrationOption = this.this$0.getPlan().getUsersGroupsMigrationOption();
                ProjectDataMigrationMode projectDataMigrationMode = this.this$0.getPlan().getProjectDataMigrationMode();
                MigrationType migrationType = this.this$0.getPlan().getMigrationType();
                Boolean bl = this.this$0.getPlan().getMigrateArchivedIssues();
                Set set = this.this$0.getPlan().getAppsMigrationOption().getIncludedApps();
                if (set == null || (set = CollectionsKt.toSet((Iterable)set)) == null) {
                    set = SetsKt.emptySet();
                }
                return ExportFacade.exportProjectReportData$default(exportFacade, this.$project, migrationTaskMetadata2, usersGroupsMigrationOption, projectDataMigrationMode, migrationType, null, bl, false, set, DryRunReportProcessor.access$dataFilterContext(this.this$0), 128, null);
            }
        });
        this.dryRunWriteService.postDryRunCleanup(reportExportOutcome2);
        return reportExportOutcome2;
    }

    private final void writeToFile(ReportExportOutcome reportExportOutcome2) {
        Path path = this.localFileDataOutput.migrationDryRunReportDirectory(this.task.getMigrationId());
        File file2 = path.resolve(this.getFileName()).toFile();
        file2.getParentFile().mkdirs();
        Intrinsics.checkNotNull((Object)file2);
        FilesKt.writeText$default((File)file2, (String)ReportExportOutcomeSerializer.INSTANCE.serializeToJsonArray(reportExportOutcome2), null, (int)2, null);
    }

    private final String getFileName() {
        String string;
        MigrationTask task = this.task.getMigrationTask();
        if (task instanceof V4ProjectMigrationTask) {
            string = ((V4ProjectMigrationTask)task).getProjectId() + "-report-outcome.json";
        } else if (task instanceof V4CrossProjectMigrationTask) {
            string = "cross-project-report-outcome.json";
        } else {
            throw new IllegalStateException("Invalid migration task type".toString());
        }
        return string;
    }

    private final String getTaskName() {
        MigrationTask task = this.task.getMigrationTask();
        return task instanceof V4ProjectMigrationTask ? "project task for id " + ((V4ProjectMigrationTask)task).getProjectId() : (task instanceof V4CrossProjectMigrationTask ? "cross-project task" : "unknown task");
    }

    private final void sendFinalStatusAsFailed() {
        PrcProgressUpdater.sendFinalStatus$default(this.getProgressUpdater(), TransferStatus.FAILED, null, "DryRun: Error occurred while executing dry run export: " + this.getTaskName(), this.task, 2, null);
    }

    private final void sendFinalStatusAsSuccess() {
        PrcProgressUpdater.sendFinalStatus$default(this.getProgressUpdater(), TransferStatus.SUCCESS, null, "DryRun: " + this.getTaskName() + " has been processed successfully", this.task, 2, null);
    }

    private final void setHeartbeat(ScheduledExecutorService $this$setHeartbeat) {
        $this$setHeartbeat.scheduleAtFixedRate(PlatformUtilKt.createHeartbeatRunnable((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ DryRunReportProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                DryRunReportProcessor.access$getPrcStatusUpdateService$p(this.this$0).sendHeartbeat(DryRunReportProcessor.access$getTask$p(this.this$0));
            }
        }), this.task, MigrationProtocol.V4), 0L, 1L, PlatformUtilKt.getHEARTBEAT_TIME_UNIT());
    }

    private final DataFilterContext dataFilterContext() {
        return this.dataFiltersContextService.getDataFilterContext(this.plan.getProjectDataMigrationMode(), this.plan.getIssueFilters(), this.plan.getAttachmentFilters());
    }

    @VisibleForTesting
    @NotNull
    public final Function1<MigrationId, PrcProgressUpdater> getProgressUpdater() {
        return this.progressUpdaterProvider;
    }

    public static final /* synthetic */ ExportFacade access$getExportFacade$p(DryRunReportProcessor $this) {
        return $this.exportFacade;
    }

    public static final /* synthetic */ DataFilterContext access$dataFilterContext(DryRunReportProcessor $this) {
        return $this.dataFilterContext();
    }

    public static final /* synthetic */ PrcStatusUpdateService access$getPrcStatusUpdateService$p(DryRunReportProcessor $this) {
        return $this.prcStatusUpdateService;
    }

    public static final /* synthetic */ PrcTask access$getTask$p(DryRunReportProcessor $this) {
        return $this.task;
    }

    public static final /* synthetic */ Function1 access$getProgressUpdaterProvider$p(DryRunReportProcessor $this) {
        return $this.progressUpdaterProvider;
    }
}

