/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers;

import com.atlassian.jira.migration.common.MigrationTaskMetadata;
import com.atlassian.jira.migration.migration.Migration;
import com.atlassian.jira.migration.migration.MigrationRepository;
import com.atlassian.jira.migration.tracking.tasks.Task;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/jira/migration/workers/MigrationTaskMetadataProvider;", "", "userManager", "Lcom/atlassian/jira/user/util/UserManager;", "migrationRepository", "Lcom/atlassian/jira/migration/migration/MigrationRepository;", "(Lcom/atlassian/jira/user/util/UserManager;Lcom/atlassian/jira/migration/migration/MigrationRepository;)V", "get", "Lcom/atlassian/jira/migration/common/MigrationTaskMetadata;", "task", "Lcom/atlassian/jira/migration/tracking/tasks/Task;", "getStartedUser", "Lcom/atlassian/jira/user/ApplicationUser;", "migrationId", "", "jira-migration-plugin"})
public final class MigrationTaskMetadataProvider {
    @NotNull
    private final UserManager userManager;
    @NotNull
    private final MigrationRepository migrationRepository;

    @Inject
    public MigrationTaskMetadataProvider(@NotNull UserManager userManager, @NotNull MigrationRepository migrationRepository) {
        Intrinsics.checkNotNullParameter((Object)userManager, (String)"userManager");
        Intrinsics.checkNotNullParameter((Object)migrationRepository, (String)"migrationRepository");
        this.userManager = userManager;
        this.migrationRepository = migrationRepository;
    }

    @NotNull
    public final MigrationTaskMetadata get(@NotNull Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        String string = task.getMigrationId();
        URI uRI = task.getCloudSite().getCloudUrl();
        String string2 = task.getCloudSite().getCloudId();
        String string3 = task.getCloudSite().getContainerToken();
        String string4 = task.getMigrationTask().getTaskId();
        ApplicationUser applicationUser = this.getStartedUser(task.getMigrationId());
        return new MigrationTaskMetadata(string, applicationUser, string2, uRI, string4, string3, false, 64, null);
    }

    private final ApplicationUser getStartedUser(String migrationId) {
        Migration migration = this.migrationRepository.findByMigrationId(migrationId);
        String startedBy = migration != null ? migration.getStartedBy() : null;
        ApplicationUser applicationUser = this.userManager.getUserByKey(startedBy);
        Intrinsics.checkNotNull((Object)applicationUser);
        return applicationUser;
    }
}

