/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers;

import com.atlassian.jira.migration.platform.PlatformService;
import com.atlassian.migration.api.ContainerToken;
import java.net.URI;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/jira/migration/workers/PlatformHeartbeater;", "", "platformService", "Lcom/atlassian/jira/migration/platform/PlatformService;", "containerToken", "Lcom/atlassian/migration/api/ContainerToken;", "heartbeatURI", "Ljava/net/URI;", "reportingPeriod", "Ljava/time/Duration;", "ticker", "Lkotlin/Function0;", "", "(Lcom/atlassian/jira/migration/platform/PlatformService;Lcom/atlassian/migration/api/ContainerToken;Ljava/net/URI;Ljava/time/Duration;Lkotlin/jvm/functions/Function0;)V", "lastReportedAt", "getReportingPeriod", "()Ljava/time/Duration;", "sendHeartbeat", "", "jira-migration-plugin"})
public final class PlatformHeartbeater {
    @NotNull
    private final PlatformService platformService;
    @NotNull
    private final ContainerToken containerToken;
    @NotNull
    private final URI heartbeatURI;
    @NotNull
    private final Duration reportingPeriod;
    @NotNull
    private final Function0<Long> ticker;
    private long lastReportedAt;

    public PlatformHeartbeater(@NotNull PlatformService platformService, @NotNull ContainerToken containerToken, @NotNull URI heartbeatURI, @NotNull Duration reportingPeriod, @NotNull Function0<Long> ticker) {
        Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)heartbeatURI, (String)"heartbeatURI");
        Intrinsics.checkNotNullParameter((Object)reportingPeriod, (String)"reportingPeriod");
        Intrinsics.checkNotNullParameter(ticker, (String)"ticker");
        this.platformService = platformService;
        this.containerToken = containerToken;
        this.heartbeatURI = heartbeatURI;
        this.reportingPeriod = reportingPeriod;
        this.ticker = ticker;
    }

    public /* synthetic */ PlatformHeartbeater(PlatformService platformService, ContainerToken containerToken, URI uRI, Duration duration, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            Duration duration2 = Duration.ofSeconds(10L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
            duration = duration2;
        }
        if ((n & 0x10) != 0) {
            function0 = 1.INSTANCE;
        }
        this(platformService, containerToken, uRI, duration, (Function0<Long>)function0);
    }

    @NotNull
    public final Duration getReportingPeriod() {
        return this.reportingPeriod;
    }

    public final void sendHeartbeat() {
        long now = ((Number)this.ticker.invoke()).longValue();
        Duration elapsed = Duration.ofNanos(now - this.lastReportedAt);
        if (elapsed.compareTo(this.reportingPeriod) >= 0) {
            this.platformService.heartbeat(this.containerToken, this.heartbeatURI);
            this.lastReportedAt = now;
        }
    }
}

