/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers;

import com.atlassian.jira.migration.platform.PlatformService;
import com.atlassian.jira.migration.platform.TransferResultRequest;
import com.atlassian.jira.migration.platform.TransferStatus;
import com.atlassian.jira.migration.progress.v3.ConvertorHelpers;
import com.atlassian.jira.migration.workers.ProgressUpdate;
import com.atlassian.migration.api.ContainerToken;
import com.atlassian.migration.api.MigrationId;
import com.atlassian.migration.api.TransferId;
import java.time.Duration;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 &2\u00020\u0001:\u0001&B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u0013\u001a\u00020\u0011J\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016J2\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0016\b\u0002\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u0016J\u000e\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u0011JE\u0010\u001e\u001a\u00020\u00182\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u00162\u0016\b\u0002\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u001c2\b\b\u0002\u0010#\u001a\u00020$\u00a2\u0006\u0002\u0010%R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/atlassian/jira/migration/workers/PlatformProgressUpdater;", "", "platformService", "Lcom/atlassian/jira/migration/platform/PlatformService;", "migrationId", "Lcom/atlassian/migration/api/MigrationId;", "transferId", "Lcom/atlassian/migration/api/TransferId;", "containerToken", "Lcom/atlassian/migration/api/ContainerToken;", "reportingPeriod", "Ljava/time/Duration;", "ticker", "Lkotlin/Function0;", "", "(Lcom/atlassian/jira/migration/platform/PlatformService;Lcom/atlassian/migration/api/MigrationId;Lcom/atlassian/migration/api/TransferId;Lcom/atlassian/migration/api/ContainerToken;Ljava/time/Duration;Lkotlin/jvm/functions/Function0;)V", "lastReported", "Lcom/atlassian/jira/migration/workers/ProgressUpdate;", "lastReportedAt", "getLastReported", "getProgressEntityCount", "key", "", "sendFinalStatus", "", "status", "Lcom/atlassian/jira/migration/platform/TransferStatus;", "outputProperties", "", "message", "sendProgressUpdate", "update", "percentage", "", "properties", "completed", "", "(Ljava/lang/Integer;Ljava/lang/String;Ljava/util/Map;Z)V", "Companion", "jira-migration-plugin"})
public final class PlatformProgressUpdater {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PlatformService platformService;
    @NotNull
    private final MigrationId migrationId;
    @NotNull
    private final TransferId transferId;
    @NotNull
    private final ContainerToken containerToken;
    @NotNull
    private final Duration reportingPeriod;
    @NotNull
    private final Function0<Long> ticker;
    @NotNull
    private ProgressUpdate lastReported;
    private long lastReportedAt;
    private static final Logger log = LoggerFactory.getLogger(PlatformProgressUpdater.class);

    public PlatformProgressUpdater(@NotNull PlatformService platformService, @NotNull MigrationId migrationId, @NotNull TransferId transferId, @NotNull ContainerToken containerToken, @NotNull Duration reportingPeriod, @NotNull Function0<Long> ticker) {
        Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)transferId, (String)"transferId");
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)reportingPeriod, (String)"reportingPeriod");
        Intrinsics.checkNotNullParameter(ticker, (String)"ticker");
        this.platformService = platformService;
        this.migrationId = migrationId;
        this.transferId = transferId;
        this.containerToken = containerToken;
        this.reportingPeriod = reportingPeriod;
        this.ticker = ticker;
        this.lastReported = new ProgressUpdate(null, null, null, false, 15, null);
    }

    public /* synthetic */ PlatformProgressUpdater(PlatformService platformService, MigrationId migrationId, TransferId transferId, ContainerToken containerToken, Duration duration, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            Duration duration2 = Duration.ofSeconds(10L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
            duration = duration2;
        }
        if ((n & 0x20) != 0) {
            function0 = 1.INSTANCE;
        }
        this(platformService, migrationId, transferId, containerToken, duration, (Function0<Long>)function0);
    }

    public final void sendProgressUpdate(@NotNull ProgressUpdate update) {
        Intrinsics.checkNotNullParameter((Object)update, (String)"update");
        long now = ((Number)this.ticker.invoke()).longValue();
        this.lastReported = update;
        Duration elapsed = Duration.ofNanos(now - this.lastReportedAt);
        if (elapsed.compareTo(this.reportingPeriod) >= 0 || update.isCompleted()) {
            this.platformService.transferProgress(this.containerToken, this.migrationId, this.transferId, update.toTransferProgressRequest());
            log.debug("Sent status to Platform migrationId[" + this.migrationId + "] transferId[" + this.transferId + ']');
            this.lastReportedAt = now;
        }
    }

    public final void sendProgressUpdate(@Nullable Integer percentage, @Nullable String message, @Nullable Map<String, ? extends Object> properties, boolean completed) {
        this.sendProgressUpdate(new ProgressUpdate(percentage, message, properties, completed));
    }

    public static /* synthetic */ void sendProgressUpdate$default(PlatformProgressUpdater platformProgressUpdater, Integer n, String string, Map map, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            string = null;
        }
        if ((n2 & 4) != 0) {
            map = null;
        }
        if ((n2 & 8) != 0) {
            bl = false;
        }
        platformProgressUpdater.sendProgressUpdate(n, string, map, bl);
    }

    @NotNull
    public final ProgressUpdate getLastReported() {
        return this.lastReported;
    }

    public final long getProgressEntityCount(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Map<String, Object> map = this.getLastReported().getProperties();
        Long l = ConvertorHelpers.Companion.asLongOrNull(map != null ? map.get(key) : null);
        return l != null ? l : 0L;
    }

    public final void sendFinalStatus(@NotNull TransferStatus status, @Nullable Map<String, ? extends Object> outputProperties, @Nullable String message) {
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        this.platformService.transferResult(this.containerToken, this.migrationId, this.transferId, new TransferResultRequest(status, null, message, outputProperties, 2, null));
    }

    public static /* synthetic */ void sendFinalStatus$default(PlatformProgressUpdater platformProgressUpdater, TransferStatus transferStatus, Map map, String string, int n, Object object) {
        if ((n & 2) != 0) {
            map = null;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        platformProgressUpdater.sendFinalStatus(transferStatus, map, string);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/workers/PlatformProgressUpdater$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

