/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers;

import com.atlassian.jira.migration.migration.MigrationProtocol;
import com.atlassian.jira.migration.tracking.tasks.Task;
import com.atlassian.jira.migration.workers.PlatformUtilKt;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\n\u001a\u00020\u000b2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"HEARTBEAT_FAILURE_THRESHOLD", "", "HEARTBEAT_TIME_UNIT", "Ljava/util/concurrent/TimeUnit;", "getHEARTBEAT_TIME_UNIT", "()Ljava/util/concurrent/TimeUnit;", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "createHeartbeatRunnable", "Ljava/lang/Runnable;", "sendHeartbeat", "Lkotlin/Function0;", "", "task", "Lcom/atlassian/jira/migration/tracking/tasks/Task;", "migrationProtocol", "Lcom/atlassian/jira/migration/migration/MigrationProtocol;", "jira-migration-plugin"})
public final class PlatformUtilKt {
    @NotNull
    private static final Logger log;
    @NotNull
    private static final TimeUnit HEARTBEAT_TIME_UNIT;
    public static final int HEARTBEAT_FAILURE_THRESHOLD = 5;

    @NotNull
    public static final Logger getLog() {
        return log;
    }

    @NotNull
    public static final TimeUnit getHEARTBEAT_TIME_UNIT() {
        return HEARTBEAT_TIME_UNIT;
    }

    @NotNull
    public static final Runnable createHeartbeatRunnable(@NotNull Function0<Unit> sendHeartbeat, @NotNull Task task, @NotNull MigrationProtocol migrationProtocol) {
        Intrinsics.checkNotNullParameter(sendHeartbeat, (String)"sendHeartbeat");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)migrationProtocol), (String)"migrationProtocol");
        AtomicInteger failureCounter = new AtomicInteger(0);
        return () -> PlatformUtilKt.createHeartbeatRunnable$lambda$0(task, sendHeartbeat, failureCounter, migrationProtocol);
    }

    public static /* synthetic */ Runnable createHeartbeatRunnable$default(Function0 function0, Task task, MigrationProtocol migrationProtocol, int n, Object object) {
        if ((n & 1) != 0) {
            function0 = createHeartbeatRunnable.1.INSTANCE;
        }
        return PlatformUtilKt.createHeartbeatRunnable((Function0<Unit>)function0, task, migrationProtocol);
    }

    private static final void createHeartbeatRunnable$lambda$0(Task $task, Function0 $sendHeartbeat, AtomicInteger $failureCounter, MigrationProtocol $migrationProtocol) {
        Intrinsics.checkNotNullParameter((Object)$task, (String)"$task");
        Intrinsics.checkNotNullParameter((Object)$sendHeartbeat, (String)"$sendHeartbeat");
        Intrinsics.checkNotNullParameter((Object)$failureCounter, (String)"$failureCounter");
        Intrinsics.checkNotNullParameter((Object)((Object)$migrationProtocol), (String)"$migrationProtocol");
        try {
            log.info($task.getMigrationId() + '-' + $task.getTaskId() + ": sending heartbeat from scheduled thread");
            $sendHeartbeat.invoke();
            if ($failureCounter.get() > 0) {
                log.info($task.getMigrationId() + '-' + $task.getTaskId() + ": heartbeat sent successfully after " + $failureCounter.get() + " attempts");
                $failureCounter.set(0);
            }
        }
        catch (Exception e) {
            if ($migrationProtocol == MigrationProtocol.V3) {
                log.error($task.getMigrationId() + '-' + $task.getTaskId() + ": failed to send heartbeat from the scheduler thread", (Throwable)e);
                if ($failureCounter.incrementAndGet() >= 5) {
                    log.error($task.getMigrationId() + '-' + $task.getTaskId() + ": failed to send heartbeat from the scheduler thread 5 times, propagating the exception");
                    throw e;
                }
            }
            log.debug("Failed to send heartbeat from the scheduler thread to PRC. Will retry after 1");
        }
    }

    static {
        Logger logger2 = LoggerFactory.getLogger((String)"PlatformUtil");
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
        HEARTBEAT_TIME_UNIT = TimeUnit.MINUTES;
    }
}

