/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers;

import com.atlassian.jira.migration.migration.MigrationCommand;
import com.atlassian.jira.migration.migration.MigrationCommandService;
import com.atlassian.jira.migration.migration.MigrationProtocol;
import com.atlassian.jira.migration.platform.TransferResultRequest;
import com.atlassian.jira.migration.platform.TransferStatus;
import com.atlassian.jira.migration.prc.PrcStatusUpdateService;
import com.atlassian.jira.migration.prc.exception.CommandCancelledException;
import com.atlassian.jira.migration.progress.v3.ConvertorHelpers;
import com.atlassian.jira.migration.tracking.polling.InProgressMigration;
import com.atlassian.jira.migration.tracking.polling.InProgressMigrationIds;
import com.atlassian.jira.migration.tracking.tasks.PrcTask;
import com.atlassian.jira.migration.workers.ProgressUpdate;
import com.atlassian.migration.api.MigrationId;
import com.atlassian.migration.statusrouter.model.CommandStatus;
import java.time.Duration;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 +2\u00020\u0001:\u0001+B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u0015\u001a\u00020\u0011J\u000e\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018J:\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0016\b\u0002\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u001e2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u00182\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!J\u0016\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!JM\u0010#\u001a\u00020\u001a2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u00182\u0016\b\u0002\u0010'\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u001e2\b\b\u0002\u0010(\u001a\u00020)2\u0006\u0010 \u001a\u00020!\u00a2\u0006\u0002\u0010*R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/atlassian/jira/migration/workers/PrcProgressUpdater;", "", "prcStatusUpdateService", "Lcom/atlassian/jira/migration/prc/PrcStatusUpdateService;", "migrationId", "Lcom/atlassian/migration/api/MigrationId;", "migrationCommandService", "Lcom/atlassian/jira/migration/migration/MigrationCommandService;", "migrationIds", "Lcom/atlassian/jira/migration/tracking/polling/InProgressMigrationIds;", "reportingPeriod", "Ljava/time/Duration;", "ticker", "Lkotlin/Function0;", "", "(Lcom/atlassian/jira/migration/prc/PrcStatusUpdateService;Lcom/atlassian/migration/api/MigrationId;Lcom/atlassian/jira/migration/migration/MigrationCommandService;Lcom/atlassian/jira/migration/tracking/polling/InProgressMigrationIds;Ljava/time/Duration;Lkotlin/jvm/functions/Function0;)V", "lastReported", "Lcom/atlassian/jira/migration/workers/ProgressUpdate;", "lastReportedAt", "getMigrationCommandService", "()Lcom/atlassian/jira/migration/migration/MigrationCommandService;", "getLastReported", "getProgressEntityCount", "key", "", "sendFinalStatus", "", "status", "Lcom/atlassian/jira/migration/platform/TransferStatus;", "outputProperties", "", "message", "task", "Lcom/atlassian/jira/migration/tracking/tasks/PrcTask;", "sendHeartbeat", "sendProgressUpdate", "update", "percentage", "", "properties", "completed", "", "(Ljava/lang/Integer;Ljava/lang/String;Ljava/util/Map;ZLcom/atlassian/jira/migration/tracking/tasks/PrcTask;)V", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPrcProgressUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrcProgressUpdater.kt\ncom/atlassian/jira/migration/workers/PrcProgressUpdater\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,93:1\n1247#2,2:94\n*S KotlinDebug\n*F\n+ 1 PrcProgressUpdater.kt\ncom/atlassian/jira/migration/workers/PrcProgressUpdater\n*L\n42#1:94,2\n*E\n"})
public final class PrcProgressUpdater {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PrcStatusUpdateService prcStatusUpdateService;
    @NotNull
    private final MigrationId migrationId;
    @NotNull
    private final MigrationCommandService migrationCommandService;
    @NotNull
    private final InProgressMigrationIds migrationIds;
    @NotNull
    private final Duration reportingPeriod;
    @NotNull
    private final Function0<Long> ticker;
    @NotNull
    private ProgressUpdate lastReported;
    private long lastReportedAt;
    private static final Logger log = LoggerFactory.getLogger(PrcProgressUpdater.class);
    private static final long REPORTING_PERIOD = 30L;

    public PrcProgressUpdater(@NotNull PrcStatusUpdateService prcStatusUpdateService, @NotNull MigrationId migrationId, @NotNull MigrationCommandService migrationCommandService, @NotNull InProgressMigrationIds migrationIds, @NotNull Duration reportingPeriod, @NotNull Function0<Long> ticker) {
        Intrinsics.checkNotNullParameter((Object)prcStatusUpdateService, (String)"prcStatusUpdateService");
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)migrationCommandService, (String)"migrationCommandService");
        Intrinsics.checkNotNullParameter((Object)migrationIds, (String)"migrationIds");
        Intrinsics.checkNotNullParameter((Object)reportingPeriod, (String)"reportingPeriod");
        Intrinsics.checkNotNullParameter(ticker, (String)"ticker");
        this.prcStatusUpdateService = prcStatusUpdateService;
        this.migrationId = migrationId;
        this.migrationCommandService = migrationCommandService;
        this.migrationIds = migrationIds;
        this.reportingPeriod = reportingPeriod;
        this.ticker = ticker;
        this.lastReported = new ProgressUpdate(null, null, null, false, 15, null);
    }

    public /* synthetic */ PrcProgressUpdater(PrcStatusUpdateService prcStatusUpdateService, MigrationId migrationId, MigrationCommandService migrationCommandService, InProgressMigrationIds inProgressMigrationIds, Duration duration, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            Duration duration2 = Duration.ofSeconds(30L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
            duration = duration2;
        }
        if ((n & 0x20) != 0) {
            function0 = 1.INSTANCE;
        }
        this(prcStatusUpdateService, migrationId, migrationCommandService, inProgressMigrationIds, duration, (Function0<Long>)function0);
    }

    @NotNull
    public final MigrationCommandService getMigrationCommandService() {
        return this.migrationCommandService;
    }

    @NotNull
    public final ProgressUpdate getLastReported() {
        return this.lastReported;
    }

    public final long getProgressEntityCount(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Map<String, Object> map = this.getLastReported().getProperties();
        Long l = ConvertorHelpers.Companion.asLongOrNull(map != null ? map.get(key) : null);
        return l != null ? l : 0L;
    }

    public final void sendProgressUpdate(@NotNull ProgressUpdate update, @NotNull PrcTask task) {
        Intrinsics.checkNotNullParameter((Object)update, (String)"update");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        long now = ((Number)this.ticker.invoke()).longValue();
        this.lastReported = update;
        Duration elapsed = Duration.ofNanos(now - this.lastReportedAt);
        if (elapsed.compareTo(this.reportingPeriod) >= 0 || update.isCompleted()) {
            boolean isMigrationInProgress;
            block4: {
                boolean bl;
                MigrationCommand migrationCommand = this.migrationCommandService.find(task.getMigrationId(), task.getPrcCommandId());
                if (migrationCommand != null && migrationCommand.getVersion() != task.getVersion()) {
                    throw new CommandCancelledException("Current migration [" + this.migrationId + "] command : [" + task.getPrcCommandId() + "] is not the latest command");
                }
                Sequence<InProgressMigration> $this$any$iv = this.migrationIds.sequence();
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    InProgressMigration inProgressMigration = (InProgressMigration)element$iv;
                    boolean bl2 = false;
                    boolean bl3 = Intrinsics.areEqual((Object)inProgressMigration.getMigrationId(), (Object)this.migrationId.toString()) && inProgressMigration.getMigrationProtocol() == MigrationProtocol.V4;
                    if (!bl3) continue;
                    bl = true;
                    break block4;
                }
                bl = isMigrationInProgress = false;
            }
            if (!isMigrationInProgress) {
                throw new CommandCancelledException("Current migration [" + this.migrationId + "] is not in InProgressMigrationIds");
            }
            this.prcStatusUpdateService.publishProgress(task, update.toTransferProgressRequest());
            log.debug("Sent progress for migrationId[" + this.migrationId + "] prcCommandId[" + task.getPrcCommandId() + "] lioTaskId[" + task.getTaskId() + ']');
            this.lastReportedAt = now;
        }
    }

    public final void sendProgressUpdate(@Nullable Integer percentage, @Nullable String message, @Nullable Map<String, ? extends Object> properties, boolean completed, @NotNull PrcTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.sendProgressUpdate(new ProgressUpdate(percentage, message, properties, completed), task);
    }

    public static /* synthetic */ void sendProgressUpdate$default(PrcProgressUpdater prcProgressUpdater, Integer n, String string, Map map, boolean bl, PrcTask prcTask, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            string = null;
        }
        if ((n2 & 4) != 0) {
            map = null;
        }
        if ((n2 & 8) != 0) {
            bl = false;
        }
        prcProgressUpdater.sendProgressUpdate(n, string, map, bl, prcTask);
    }

    public final void sendFinalStatus(@NotNull TransferStatus status, @Nullable Map<String, ? extends Object> outputProperties, @Nullable String message, @NotNull PrcTask task) {
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        CommandStatus commandStatus = status.toCommandStatus();
        Intrinsics.checkNotNull((Object)commandStatus);
        this.prcStatusUpdateService.publishFinalStatus(task, commandStatus, new TransferResultRequest(status, message, null, outputProperties, 4, null));
    }

    public static /* synthetic */ void sendFinalStatus$default(PrcProgressUpdater prcProgressUpdater, TransferStatus transferStatus, Map map, String string, PrcTask prcTask, int n, Object object) {
        if ((n & 2) != 0) {
            map = null;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        prcProgressUpdater.sendFinalStatus(transferStatus, map, string, prcTask);
    }

    public final void sendHeartbeat(@NotNull PrcTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.prcStatusUpdateService.sendHeartbeat(task);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/workers/PrcProgressUpdater$Companion;", "", "()V", "REPORTING_PERIOD", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

