/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers;

import com.atlassian.analytics.api.services.AnalyticsConfigService;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.PlanCompletionEvent;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.jiraservice.JiraExtensionsKt;
import com.atlassian.jira.migration.legal.LegalService;
import com.atlassian.jira.migration.orchestratorclient.tasks.MigrationTaskType;
import com.atlassian.jira.migration.progress.TaskListStatus;
import com.atlassian.jira.migration.workers.ShadowProjectsProcessor;
import com.atlassian.jira.util.thread.JiraThreadLocalUtil;
import com.google.common.eventbus.Subscribe;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B7\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0007J\b\u0010\u0013\u001a\u00020\u0012H\u0007J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/atlassian/jira/migration/workers/ShadowExportEventHandler;", "", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "jiraThreadLocalUtil", "Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "projectProcessor", "Lcom/atlassian/jira/migration/workers/ShadowProjectsProcessor;", "legalService", "Lcom/atlassian/jira/migration/legal/LegalService;", "analyticsConfigService", "Lcom/atlassian/analytics/api/services/AnalyticsConfigService;", "(Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/workers/ShadowProjectsProcessor;Lcom/atlassian/jira/migration/legal/LegalService;Lcom/atlassian/analytics/api/services/AnalyticsConfigService;)V", "isUserAgreed", "", "postConstruct", "", "preDestroy", "receive", "event", "Lcom/atlassian/jira/migration/events/PlanCompletionEvent;", "shouldProcessShadowExport", "Companion", "jira-migration-plugin"})
public final class ShadowExportEventHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final JiraThreadLocalUtil jiraThreadLocalUtil;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final ShadowProjectsProcessor projectProcessor;
    @NotNull
    private final LegalService legalService;
    @NotNull
    private final AnalyticsConfigService analyticsConfigService;
    private static final Logger log4jLogger = Logger.getLogger(ShadowExportEventHandler.class);

    @Inject
    public ShadowExportEventHandler(@NotNull MigrationEventBus migrationEventBus, @NotNull JiraThreadLocalUtil jiraThreadLocalUtil, @NotNull MigrationFeatures migrationFeatures, @NotNull ShadowProjectsProcessor projectProcessor, @NotNull LegalService legalService, @NotNull AnalyticsConfigService analyticsConfigService) {
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)jiraThreadLocalUtil, (String)"jiraThreadLocalUtil");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)projectProcessor, (String)"projectProcessor");
        Intrinsics.checkNotNullParameter((Object)legalService, (String)"legalService");
        Intrinsics.checkNotNullParameter((Object)analyticsConfigService, (String)"analyticsConfigService");
        this.migrationEventBus = migrationEventBus;
        this.jiraThreadLocalUtil = jiraThreadLocalUtil;
        this.migrationFeatures = migrationFeatures;
        this.projectProcessor = projectProcessor;
        this.legalService = legalService;
        this.analyticsConfigService = analyticsConfigService;
    }

    private final boolean shouldProcessShadowExport(PlanCompletionEvent event) {
        return Intrinsics.areEqual((Object)event.getOverallPlanStatus(), (Object)TaskListStatus.COMPLETED_SUCCESSFULLY.toString()) && (event.getMigrationTaskTypeToStatusMap().containsKey((Object)MigrationTaskType.JIRA_PROJECT_UPLOAD) || event.getMigrationTaskTypeToStatusMap().containsKey((Object)MigrationTaskType.PROJECT_DATA_UPLOAD)) && this.migrationFeatures.getEnableShadowProjectExport() && this.isUserAgreed();
    }

    @PostConstruct
    public final void postConstruct() {
        this.migrationEventBus.register(this);
    }

    @Subscribe
    public final void receive(@NotNull PlanCompletionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Logger logger2 = log4jLogger;
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"log4jLogger");
        JiraExtensionsKt.wrap(this.jiraThreadLocalUtil, logger2, (Function0)new Function0<Unit>(this, event){
            final /* synthetic */ ShadowExportEventHandler this$0;
            final /* synthetic */ PlanCompletionEvent $event;
            {
                this.this$0 = $receiver;
                this.$event = $event;
                super(0);
            }

            public final void invoke() {
                if (ShadowExportEventHandler.access$shouldProcessShadowExport(this.this$0, this.$event)) {
                    ShadowExportEventHandler.access$getProjectProcessor$p(this.this$0).process(this.$event);
                }
            }
        });
    }

    @PreDestroy
    public final void preDestroy() {
        this.migrationEventBus.unregister(this);
    }

    private final boolean isUserAgreed() {
        return this.analyticsConfigService.canCollectAnalytics() | this.legalService.isLegalOptIn();
    }

    public static final /* synthetic */ boolean access$shouldProcessShadowExport(ShadowExportEventHandler $this, PlanCompletionEvent event) {
        return $this.shouldProcessShadowExport(event);
    }

    public static final /* synthetic */ ShadowProjectsProcessor access$getProjectProcessor$p(ShadowExportEventHandler $this) {
        return $this.projectProcessor;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/workers/ShadowExportEventHandler$Companion;", "", "()V", "log4jLogger", "Lorg/apache/log4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

