/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.migration.analytics.AnalyticsEventService;
import com.atlassian.jira.migration.common.MigrationTaskMetadata;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.events.PlanCompletionEvent;
import com.atlassian.jira.migration.events.ShadowExportCompletionEvent;
import com.atlassian.jira.migration.events.ShadowExportFailedEvent;
import com.atlassian.jira.migration.export.DataExportOutcome;
import com.atlassian.jira.migration.export.ExportFacade;
import com.atlassian.jira.migration.export.framework.ExportMode;
import com.atlassian.jira.migration.migration.Migration;
import com.atlassian.jira.migration.plan.MigrationType;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.platform.PlatformService;
import com.atlassian.jira.migration.platform.PlatformUploadServiceInterface;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.migration.api.ContainerToken;
import com.atlassian.migration.api.MigrationId;
import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.Random;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 /2\u00020\u0001:\u0001/B?\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J$\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00140\u001e2\u0006\u0010!\u001a\u00020\u001cH\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u000e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)J \u0010&\u001a\u00020'2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u001fH\u0002J \u0010+\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010,\u001a\u00020\u001cH\u0002J\"\u0010-\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00142\b\u0010.\u001a\u0004\u0018\u00010\u0014H\u0002R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/atlassian/jira/migration/workers/ShadowProjectsProcessor;", "", "export", "Lcom/atlassian/jira/migration/export/ExportFacade;", "platformService", "Lcom/atlassian/jira/migration/platform/PlatformService;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "userManager", "Lcom/atlassian/jira/user/util/UserManager;", "issueManager", "Lcom/atlassian/jira/issue/IssueManager;", "analyticsEventService", "Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;", "(Lcom/atlassian/jira/migration/export/ExportFacade;Lcom/atlassian/jira/migration/platform/PlatformService;Lcom/atlassian/jira/migration/discovery/DiscoveryService;Lcom/atlassian/jira/project/ProjectManager;Lcom/atlassian/jira/user/util/UserManager;Lcom/atlassian/jira/issue/IssueManager;Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;)V", "projectProcessedCount", "", "createFileMultipart", "", "file", "Ljava/io/File;", "containerToken", "Lcom/atlassian/migration/api/ContainerToken;", "migrationId", "Lcom/atlassian/migration/api/MigrationId;", "projectId", "", "filterProjectsForShadowExport", "", "Lcom/atlassian/jira/project/Project;", "projectKeys", "seed", "isPlanEligibleForExport", "", "plan", "Lcom/atlassian/jira/migration/plan/Plan;", "process", "", "event", "Lcom/atlassian/jira/migration/events/PlanCompletionEvent;", "project", "sendShadowExportCompletionEvent", "exportTime", "sendShadowExportFailedEvent", "failedReason", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nShadowProjectsProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShadowProjectsProcessor.kt\ncom/atlassian/jira/migration/workers/ShadowProjectsProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,218:1\n1855#2,2:219\n*S KotlinDebug\n*F\n+ 1 ShadowProjectsProcessor.kt\ncom/atlassian/jira/migration/workers/ShadowProjectsProcessor\n*L\n60#1:219,2\n*E\n"})
public final class ShadowProjectsProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExportFacade export;
    @NotNull
    private final PlatformService platformService;
    @NotNull
    private final DiscoveryService discoveryService;
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final UserManager userManager;
    @NotNull
    private final IssueManager issueManager;
    @NotNull
    private final AnalyticsEventService analyticsEventService;
    private int projectProcessedCount;
    public static final int MAX_SHADOW_EXPORTS_PER_PLAN = 1;
    public static final int MAX_ISSUE_PER_PROJECT = 10000;
    public static final int MIN_ISSUE_PER_PROJECT = 1000;
    private static final Logger logger = LoggerFactory.getLogger(ShadowProjectsProcessor.class);
    public static final int MAX_PROJECTS_PER_CUSTOMER = 2;

    @Inject
    public ShadowProjectsProcessor(@NotNull ExportFacade export2, @NotNull PlatformService platformService, @NotNull DiscoveryService discoveryService, @NotNull ProjectManager projectManager, @NotNull UserManager userManager, @NotNull IssueManager issueManager, @NotNull AnalyticsEventService analyticsEventService) {
        Intrinsics.checkNotNullParameter((Object)export2, (String)"export");
        Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)userManager, (String)"userManager");
        Intrinsics.checkNotNullParameter((Object)issueManager, (String)"issueManager");
        Intrinsics.checkNotNullParameter((Object)analyticsEventService, (String)"analyticsEventService");
        this.export = export2;
        this.platformService = platformService;
        this.discoveryService = discoveryService;
        this.projectManager = projectManager;
        this.userManager = userManager;
        this.issueManager = issueManager;
        this.analyticsEventService = analyticsEventService;
    }

    public final void process(@NotNull PlanCompletionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Plan plan2 = DiscoveryService.retrievePlanFor$default(this.discoveryService, event.getMigrationId(), false, 2, null);
        Intrinsics.checkNotNull((Object)plan2);
        Plan plan3 = plan2;
        if (!this.isPlanEligibleForExport(plan3) || this.projectProcessedCount >= 2) {
            return;
        }
        Iterable $this$forEach$iv = this.filterProjectsForShadowExport(plan3.getProjectKeys(), plan3.getCreatedTimestamp());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object $this$process_u24lambda_u243_u24lambda_u240;
            Project project = (Project)element$iv;
            boolean bl = false;
            Object object = this;
            try {
                $this$process_u24lambda_u243_u24lambda_u240 = object;
                boolean bl2 = false;
                super.process(plan3, event.getMigrationId(), project);
                $this$process_u24lambda_u243_u24lambda_u240 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl2) {
                $this$process_u24lambda_u243_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object = $this$process_u24lambda_u243_u24lambda_u240;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Object it = $this$process_u24lambda_u243_u24lambda_u240 = throwable;
                boolean bl3 = false;
                logger.warn(event.getMigrationId() + " : " + project.getKey() + " : exporting project failed", (Throwable)it);
                this.sendShadowExportFailedEvent(event.getMigrationId(), String.valueOf(project.getId()), ((Throwable)it).getMessage());
            }
            if (!Result.isSuccess-impl((Object)object)) continue;
            Unit it = (Unit)object;
            boolean bl4 = false;
            ++this.projectProcessedCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void process(Plan plan2, String migrationId, Project project) {
        logger.info(' ' + migrationId + " : " + project.getKey() + " : Staring export");
        Object object = this.discoveryService.retrieveCloudSiteForCloudId(plan2.getCloudId());
        if (object == null || (object = object.getContainerToken()) == null) {
            throw new IllegalArgumentException("cloud site not found for plan:" + plan2.getId());
        }
        Object containerToken = object;
        long startTime = System.currentTimeMillis();
        Object object2 = new URI(plan2.getCloudUrl());
        Object object3 = plan2.getCloudId();
        Migration migration = this.discoveryService.findByMigrationId(migrationId);
        Intrinsics.checkNotNull((Object)migration);
        ApplicationUser applicationUser = this.userManager.getUserByKey(migration.getStartedBy());
        Intrinsics.checkNotNull((Object)applicationUser);
        ApplicationUser applicationUser2 = applicationUser;
        object2 = ExportFacade.exportProjectData$default(this.export, project, new MigrationTaskMetadata(migrationId, applicationUser2, (String)object3, (URI)object2, "shadow_export", (String)containerToken, false, 64, null), plan2.getUsersGroupsMigrationOption(), plan2.getProjectDataMigrationMode(), plan2.getId(), MigrationType.CLASSIC, plan2.getMigrateArchivedIssues(), null, null, ExportMode.SHADOW_PROJECT_DATA, null, null, 3456, null);
        object3 = null;
        try {
            DataExportOutcome outcome = (DataExportOutcome)object2;
            boolean bl = false;
            long totalShadowExportTime = System.currentTimeMillis() - startTime;
            File file2 = outcome.getFile();
            ContainerToken containerToken2 = new ContainerToken((String)containerToken);
            MigrationId migrationId2 = new MigrationId(migrationId);
            Long l = project.getId();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
            this.createFileMultipart(file2, containerToken2, migrationId2, ((Number)l).longValue());
            this.sendShadowExportCompletionEvent(migrationId, String.valueOf(project.getId()), totalShadowExportTime);
            logger.info(' ' + migrationId + " : " + project.getKey() + " : completed export");
            applicationUser2 = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object3 = throwable;
            throw throwable;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object2, (Throwable)object3);
        }
    }

    private final boolean isPlanEligibleForExport(Plan plan2) {
        return !plan2.isLegacyAttachmentsOnly() && plan2.getMigrationType() == MigrationType.CLASSIC;
    }

    private final List<Project> filterProjectsForShadowExport(List<String> projectKeys, long seed) {
        return SequencesKt.toList((Sequence)SequencesKt.take((Sequence)SequencesKt.take((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)CollectionsKt.shuffled((Iterable)projectKeys, (Random)new Random(seed))), (Function1)((Function1)new Function1<String, Project>(this){
            final /* synthetic */ ShadowProjectsProcessor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Project invoke(@NotNull String pkey) {
                Project project;
                Intrinsics.checkNotNullParameter((Object)pkey, (String)"pkey");
                Project it = project = ShadowProjectsProcessor.access$getProjectManager$p(this.this$0).getProjectObjByKey(pkey);
                boolean bl = false;
                if (it == null) {
                    ShadowProjectsProcessor.Companion.getLogger().warn("Project not found for key " + pkey);
                }
                return project;
            }
        })), (Function1)((Function1)new Function1<Project, Boolean>(this){
            final /* synthetic */ ShadowProjectsProcessor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Project it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                long issueCount = ShadowProjectsProcessor.access$getIssueManager$p(this.this$0).getIssueCountForProject(it.getId());
                return 1000L <= issueCount ? issueCount < 10001L : false;
            }
        })), (int)1), (int)(2 - this.projectProcessedCount)));
    }

    private final String createFileMultipart(File file2, ContainerToken containerToken, MigrationId migrationId, long projectId) {
        return PlatformUploadServiceInterface.DefaultImpls.uploadMultiPart$default(this.platformService, containerToken, migrationId, "project-export_shadow", String.valueOf(projectId), file2, 0, null, 96, null);
    }

    private final void sendShadowExportCompletionEvent(String migrationId, String projectId, long exportTime) {
        ShadowExportCompletionEvent shadowExportCompletionEvent = new ShadowExportCompletionEvent(migrationId, projectId, exportTime);
        AnalyticsEventService.saveAnalyticsEvent$default(this.analyticsEventService, (EventDto)shadowExportCompletionEvent.asOperationalEvent(), null, 2, null);
    }

    private final void sendShadowExportFailedEvent(String migrationId, String projectId, String failedReason) {
        ShadowExportFailedEvent shadowExportFailedEvent = new ShadowExportFailedEvent(migrationId, projectId, failedReason);
        AnalyticsEventService.saveAnalyticsEvent$default(this.analyticsEventService, (EventDto)shadowExportFailedEvent.asOperationalEvent(), null, 2, null);
    }

    public static final /* synthetic */ ProjectManager access$getProjectManager$p(ShadowProjectsProcessor $this) {
        return $this.projectManager;
    }

    public static final /* synthetic */ IssueManager access$getIssueManager$p(ShadowProjectsProcessor $this) {
        return $this.issueManager;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/atlassian/jira/migration/workers/ShadowProjectsProcessor$Companion;", "", "()V", "MAX_ISSUE_PER_PROJECT", "", "MAX_PROJECTS_PER_CUSTOMER", "MAX_SHADOW_EXPORTS_PER_PLAN", "MIN_ISSUE_PER_PROJECT", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

