/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers;

import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.lio.model.Migration;
import com.atlassian.jira.migration.orchestratorclient.tasks.AssetMigrationTask;
import com.atlassian.jira.migration.orchestratorclient.tasks.MigrationTask;
import com.atlassian.jira.migration.orchestratorclient.tasks.V4AppDataPreloadNotificationTask;
import com.atlassian.jira.migration.orchestratorclient.tasks.V4AppDataPreloadTask;
import com.atlassian.jira.migration.orchestratorclient.tasks.V4AttachmentsMigrationTask;
import com.atlassian.jira.migration.orchestratorclient.tasks.V4CrossProjectMigrationTask;
import com.atlassian.jira.migration.orchestratorclient.tasks.V4CustomersMigrationTask;
import com.atlassian.jira.migration.orchestratorclient.tasks.V4ProjectMigrationTask;
import com.atlassian.jira.migration.orchestratorclient.tasks.V4UsersGroupsMigrationTask;
import com.atlassian.jira.migration.plan.ExecutionType;
import com.atlassian.jira.migration.prc.model.AppDataPreloadMigrationPayload;
import com.atlassian.jira.migration.prc.model.AppDataPreloadNotificationMigrationPayload;
import com.atlassian.jira.migration.prc.model.AssetMigrationPayload;
import com.atlassian.jira.migration.prc.model.AttachmentMigrationPayload;
import com.atlassian.jira.migration.prc.model.CrossProjectMigrationPayload;
import com.atlassian.jira.migration.prc.model.CustomersGroupsMigrationPayload;
import com.atlassian.jira.migration.prc.model.MigrationPayload;
import com.atlassian.jira.migration.prc.model.PrcCommandPayload;
import com.atlassian.jira.migration.prc.model.ProjectMigrationPayload;
import com.atlassian.jira.migration.prc.model.UsersGroupsMigrationPayload;
import com.atlassian.jira.migration.tracking.tasks.PrcTask;
import com.atlassian.migration.prc.model.Command;
import com.atlassian.migration.prc.model.CommandName;
import com.atlassian.migration.prc.model.CommandSource;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 !2\u00020\u0001:\u0001!B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u00172\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cJ\u001e\u0010\u001d\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020 R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\""}, d2={"Lcom/atlassian/jira/migration/workers/WorkerDataConvertor;", "", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "(Lcom/atlassian/jira/migration/common/ObjectMapperFactory;Lcom/atlassian/jira/migration/discovery/DiscoveryService;)V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "createPrcTask", "Lcom/atlassian/jira/migration/tracking/tasks/PrcTask;", "payload", "Lcom/atlassian/jira/migration/prc/model/MigrationPayload;", "prcCommandId", "", "commandName", "getCloudSite", "Lcom/atlassian/jira/migration/cloud/CloudSite;", "migration", "Lcom/atlassian/jira/migration/lio/model/Migration;", "getMigrationPayloadType", "Ljava/lang/Class;", "getMigrationTask", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/MigrationTask;", "toPrcTask", "command", "Lcom/atlassian/migration/prc/model/Command;", "toPrcTaskFromMigrationPayload", "Lcom/atlassian/jira/migration/prc/model/PrcCommandPayload;", "", "Lcom/atlassian/migration/prc/model/CommandName;", "Companion", "jira-migration-plugin"})
public final class WorkerDataConvertor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DiscoveryService discoveryService;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private static final Logger log;

    @Inject
    public WorkerDataConvertor(@NotNull ObjectMapperFactory objectMapperFactory, @NotNull DiscoveryService discoveryService) {
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        this.discoveryService = discoveryService;
        this.objectMapper = objectMapperFactory.createObjectMapper();
    }

    @NotNull
    public final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @NotNull
    public final PrcTask toPrcTask(@NotNull Command command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        try {
            MigrationPayload payload = (MigrationPayload)this.objectMapper.readValue(command.getPayload(), this.getMigrationPayloadType(command.getName()));
            Intrinsics.checkNotNull((Object)payload);
            return this.createPrcTask(payload, String.valueOf(command.getId()), command.getName());
        }
        catch (Exception e) {
            log.error("Failed to deserialize PRC command into Migration command for " + command.getId());
            throw e;
        }
    }

    @NotNull
    public final PrcTask toPrcTaskFromMigrationPayload(@NotNull PrcCommandPayload payload, long prcCommandId, @NotNull CommandName commandName) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)commandName, (String)"commandName");
        if (payload instanceof MigrationPayload) {
            return this.createPrcTask((MigrationPayload)payload, String.valueOf(prcCommandId), commandName.name());
        }
        throw new IllegalArgumentException("Invalid payload type for command id: " + prcCommandId);
    }

    private final PrcTask createPrcTask(MigrationPayload payload, String prcCommandId, String commandName) {
        String string = payload.getMigration().getId().toString();
        CommandSource commandSource = payload.getCommandSource();
        MigrationTask migrationTask = this.getMigrationTask(commandName, payload);
        CloudSite cloudSite2 = this.getCloudSite(payload.getMigration());
        ExecutionType executionType = payload.getMigration().getExecutionType();
        Intrinsics.checkNotNull((Object)string);
        return new PrcTask(string, migrationTask, cloudSite2, prcCommandId, commandSource, 0, executionType, 32, null);
    }

    private final Class<? extends MigrationPayload> getMigrationPayloadType(String commandName) {
        Class clazz;
        switch (WhenMappings.$EnumSwitchMapping$0[CommandName.Companion.get(commandName).ordinal()]) {
            case 1: {
                clazz = UsersGroupsMigrationPayload.class;
                break;
            }
            case 2: {
                clazz = CustomersGroupsMigrationPayload.class;
                break;
            }
            case 3: {
                clazz = ProjectMigrationPayload.class;
                break;
            }
            case 4: {
                clazz = AttachmentMigrationPayload.class;
                break;
            }
            case 5: {
                clazz = CrossProjectMigrationPayload.class;
                break;
            }
            case 6: {
                clazz = AppDataPreloadMigrationPayload.class;
                break;
            }
            case 7: {
                clazz = AppDataPreloadNotificationMigrationPayload.class;
                break;
            }
            case 8: {
                clazz = AssetMigrationPayload.class;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid command " + commandName + " supplied for payload conversion");
            }
        }
        return clazz;
    }

    private final MigrationTask getMigrationTask(String commandName, MigrationPayload payload) {
        MigrationTask migrationTask;
        switch (WhenMappings.$EnumSwitchMapping$0[CommandName.Companion.get(commandName).ordinal()]) {
            case 1: {
                Intrinsics.checkNotNull((Object)payload, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.prc.model.UsersGroupsMigrationPayload");
                UsersGroupsMigrationPayload cfr_ignored_0 = (UsersGroupsMigrationPayload)payload;
                migrationTask = new V4UsersGroupsMigrationTask(payload.getSourceCommandId());
                break;
            }
            case 2: {
                Intrinsics.checkNotNull((Object)payload, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.prc.model.CustomersGroupsMigrationPayload");
                CustomersGroupsMigrationPayload cfr_ignored_1 = (CustomersGroupsMigrationPayload)payload;
                migrationTask = new V4CustomersMigrationTask(payload.getSourceCommandId());
                break;
            }
            case 3: {
                Intrinsics.checkNotNull((Object)payload, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.prc.model.ProjectMigrationPayload");
                ProjectMigrationPayload cfr_ignored_2 = (ProjectMigrationPayload)payload;
                migrationTask = new V4ProjectMigrationTask(payload.getSourceCommandId(), ((ProjectMigrationPayload)payload).getProjectId());
                break;
            }
            case 4: {
                Intrinsics.checkNotNull((Object)payload, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.prc.model.AttachmentMigrationPayload");
                AttachmentMigrationPayload cfr_ignored_3 = (AttachmentMigrationPayload)payload;
                migrationTask = new V4AttachmentsMigrationTask(payload.getSourceCommandId(), ((AttachmentMigrationPayload)payload).getProjectId());
                break;
            }
            case 5: {
                Intrinsics.checkNotNull((Object)payload, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.prc.model.CrossProjectMigrationPayload");
                CrossProjectMigrationPayload cfr_ignored_4 = (CrossProjectMigrationPayload)payload;
                migrationTask = new V4CrossProjectMigrationTask(payload.getSourceCommandId());
                break;
            }
            case 6: {
                Intrinsics.checkNotNull((Object)payload, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.prc.model.AppDataPreloadMigrationPayload");
                AppDataPreloadMigrationPayload cfr_ignored_5 = (AppDataPreloadMigrationPayload)payload;
                migrationTask = new V4AppDataPreloadTask(payload.getSourceCommandId(), ((AppDataPreloadMigrationPayload)payload).getProjectId(), ((AppDataPreloadMigrationPayload)payload).getPreloadableApps());
                break;
            }
            case 7: {
                Intrinsics.checkNotNull((Object)payload, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.prc.model.AppDataPreloadNotificationMigrationPayload");
                AppDataPreloadNotificationMigrationPayload cfr_ignored_6 = (AppDataPreloadNotificationMigrationPayload)payload;
                migrationTask = new V4AppDataPreloadNotificationTask(payload.getSourceCommandId(), ((AppDataPreloadNotificationMigrationPayload)payload).getPreloadableApps());
                break;
            }
            case 8: {
                Intrinsics.checkNotNull((Object)payload, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.prc.model.AssetMigrationPayload");
                AssetMigrationPayload cfr_ignored_7 = (AssetMigrationPayload)payload;
                migrationTask = new AssetMigrationTask(payload.getSourceCommandId());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid command name supplied for payload conversion");
            }
        }
        return migrationTask;
    }

    private final CloudSite getCloudSite(Migration migration) {
        String string = migration.getId().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        CloudSite cloudSite2 = this.discoveryService.retrieveCloudSiteFor(string, true);
        if (cloudSite2 == null) {
            throw new IllegalStateException(("Cloud site not found for migrationId: " + migration.getId()).toString());
        }
        return cloudSite2;
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(WorkerDataConvertor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/workers/WorkerDataConvertor$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CommandName.values().length];
            try {
                nArray[CommandName.ALL_USER_UPLOAD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CommandName.ALL_CUSTOMER_UPLOAD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CommandName.JIRA_PROJECT_UPLOAD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CommandName.JIRA_ATTACHMENT_UPLOAD.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CommandName.JIRA_CROSS_PROJECT_UPLOAD.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CommandName.APP_DATA_PRELOAD.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CommandName.APP_DATA_PRELOAD_NOTIFICATION.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CommandName.ASSETS_DATA_UPLOAD.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

