/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.app;

import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.app.AppEntitiesUploadCompletedEvent;
import com.atlassian.jira.migration.events.app.AppEntitiesUploadFailedEvent;
import com.atlassian.jira.migration.events.app.AppEntitiesUploadStartedEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H&J\u0016\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\"\u0010\u000b\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\n\u0010\f\u001a\u00060\rj\u0002`\u000eJ\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\tH&J\b\u0010\u0011\u001a\u00020\u0006H&J\u0016\u0010\u0012\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/jira/migration/workers/app/AbstractAppEntitiesDataProcessor;", "", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "(Lcom/atlassian/jira/migration/events/MigrationEventBus;)V", "process", "", "sendCompletionEvent", "cloudId", "", "migrationId", "sendFailedEvent", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "sendFinalStatus", "fileId", "sendHeartbeat", "sendStartedEvent", "jira-migration-plugin"})
public abstract class AbstractAppEntitiesDataProcessor {
    @NotNull
    private final MigrationEventBus migrationEventBus;

    public AbstractAppEntitiesDataProcessor(@NotNull MigrationEventBus migrationEventBus) {
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        this.migrationEventBus = migrationEventBus;
    }

    public abstract void process();

    public abstract void sendHeartbeat();

    public abstract void sendFinalStatus(@NotNull String var1);

    public final void sendStartedEvent(@NotNull String cloudId2, @NotNull String migrationId) {
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        this.migrationEventBus.post(new AppEntitiesUploadStartedEvent(cloudId2, migrationId));
    }

    public final void sendCompletionEvent(@NotNull String cloudId2, @NotNull String migrationId) {
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        this.migrationEventBus.post(new AppEntitiesUploadCompletedEvent(cloudId2, migrationId));
    }

    public final void sendFailedEvent(@NotNull String cloudId2, @NotNull String migrationId, @NotNull Exception ex) {
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        this.migrationEventBus.post(new AppEntitiesUploadFailedEvent(cloudId2, migrationId, ex.getMessage()));
    }
}

