/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.app;

import com.atlassian.jira.migration.jiraservice.JiraExtensionsKt;
import com.atlassian.jira.migration.tracking.tasks.PrcTask;
import com.atlassian.jira.migration.tracking.tasks.V4Worker;
import com.atlassian.jira.migration.workers.WorkerDataConvertor;
import com.atlassian.jira.util.thread.JiraThreadLocalUtil;
import com.atlassian.migration.prc.model.Command;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B/\b\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ(\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0014\u0010\u0013\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0004\u0012\u00020\u00160\u0014J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0018\u001a\u00020\u0016H\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/atlassian/jira/migration/workers/app/PRCMigrationCommandWorkerHandler;", "", "workers", "", "Lcom/atlassian/jira/migration/tracking/tasks/V4Worker;", "jiraThreadLocalUtil", "Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;", "workerDataConvertor", "Lcom/atlassian/jira/migration/workers/WorkerDataConvertor;", "executorService", "Ljava/util/concurrent/ExecutorService;", "(Ljava/util/List;Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;Lcom/atlassian/jira/migration/workers/WorkerDataConvertor;Ljava/util/concurrent/ExecutorService;)V", "workerMap", "", "", "execute", "Ljava/util/concurrent/Future;", "command", "Lcom/atlassian/migration/prc/model/Command;", "onComplete", "Lkotlin/Function1;", "", "", "getWorkerByCommand", "preDestroy", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPRCMigrationCommandWorkerHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PRCMigrationCommandWorkerHandler.kt\ncom/atlassian/jira/migration/workers/app/PRCMigrationCommandWorkerHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,56:1\n1194#2,2:57\n1222#2,4:59\n*S KotlinDebug\n*F\n+ 1 PRCMigrationCommandWorkerHandler.kt\ncom/atlassian/jira/migration/workers/app/PRCMigrationCommandWorkerHandler\n*L\n23#1:57,2\n23#1:59,4\n*E\n"})
public final class PRCMigrationCommandWorkerHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JiraThreadLocalUtil jiraThreadLocalUtil;
    @NotNull
    private final WorkerDataConvertor workerDataConvertor;
    @NotNull
    private final ExecutorService executorService;
    @NotNull
    private final Map<String, V4Worker> workerMap;
    private static final Logger log = Logger.getLogger((String)PRCMigrationCommandWorkerHandler.class.getName());

    /*
     * WARNING - void declaration
     */
    @Inject
    public PRCMigrationCommandWorkerHandler(@NotNull List<? extends V4Worker> workers, @NotNull JiraThreadLocalUtil jiraThreadLocalUtil, @NotNull WorkerDataConvertor workerDataConvertor, @NotNull ExecutorService executorService) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter(workers, (String)"workers");
        Intrinsics.checkNotNullParameter((Object)jiraThreadLocalUtil, (String)"jiraThreadLocalUtil");
        Intrinsics.checkNotNullParameter((Object)workerDataConvertor, (String)"workerDataConvertor");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        this.jiraThreadLocalUtil = jiraThreadLocalUtil;
        this.workerDataConvertor = workerDataConvertor;
        this.executorService = executorService;
        Iterable iterable = workers;
        PRCMigrationCommandWorkerHandler pRCMigrationCommandWorkerHandler = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var8_9 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            V4Worker v4Worker = (V4Worker)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getCommandName().getValue(), element$iv$iv);
        }
        pRCMigrationCommandWorkerHandler.workerMap = destination$iv$iv;
    }

    public /* synthetic */ PRCMigrationCommandWorkerHandler(List list, JiraThreadLocalUtil jiraThreadLocalUtil, WorkerDataConvertor workerDataConvertor, ExecutorService executorService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            ExecutorService executorService2 = PRCMigrationCommandWorkerHandler.Companion.getExecutorPool();
            Intrinsics.checkNotNullExpressionValue((Object)executorService2, (String)"access$getExecutorPool(...)");
            executorService = executorService2;
        }
        this(list, jiraThreadLocalUtil, workerDataConvertor, executorService);
    }

    @PreDestroy
    public final void preDestroy() {
        this.executorService.shutdownNow();
    }

    @NotNull
    public final Future<?> execute(@NotNull Command command, @NotNull Function1<? super Throwable, Unit> onComplete) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter(onComplete, (String)"onComplete");
        Future<?> future = this.executorService.submit(() -> PRCMigrationCommandWorkerHandler.execute$lambda$4(this, command, onComplete));
        Intrinsics.checkNotNullExpressionValue(future, (String)"submit(...)");
        return future;
    }

    private final V4Worker getWorkerByCommand(Command command) {
        V4Worker v4Worker = this.workerMap.get(command.getName());
        if (v4Worker == null) {
            throw new IllegalArgumentException("No worker found for command: " + command.getName());
        }
        return v4Worker;
    }

    private static final void execute$lambda$4(PRCMigrationCommandWorkerHandler this$0, Command $command, Function1 $onComplete) {
        block3: {
            Throwable throwable;
            Object $this$execute_u24lambda_u244_u24lambda_u241;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$command, (String)"$command");
            Intrinsics.checkNotNullParameter((Object)$onComplete, (String)"$onComplete");
            Object object = this$0;
            try {
                $this$execute_u24lambda_u244_u24lambda_u241 = object;
                boolean bl = false;
                JiraThreadLocalUtil jiraThreadLocalUtil = ((PRCMigrationCommandWorkerHandler)$this$execute_u24lambda_u244_u24lambda_u241).jiraThreadLocalUtil;
                Logger logger2 = log;
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"log");
                JiraExtensionsKt.wrap(jiraThreadLocalUtil, logger2, (Function0)new Function0<Unit>((PRCMigrationCommandWorkerHandler)$this$execute_u24lambda_u244_u24lambda_u241, $command){
                    final /* synthetic */ PRCMigrationCommandWorkerHandler $this_runCatching;
                    final /* synthetic */ Command $command;
                    {
                        this.$this_runCatching = $receiver;
                        this.$command = $command;
                        super(0);
                    }

                    public final void invoke() {
                        PrcTask task = PRCMigrationCommandWorkerHandler.access$getWorkerDataConvertor$p(this.$this_runCatching).toPrcTask(this.$command);
                        V4Worker worker = PRCMigrationCommandWorkerHandler.access$getWorkerByCommand(this.$this_runCatching, this.$command);
                        worker.process(task);
                    }
                });
                $this$execute_u24lambda_u244_u24lambda_u241 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                $this$execute_u24lambda_u244_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = $this$execute_u24lambda_u244_u24lambda_u241;
            if (Result.isSuccess-impl((Object)object)) {
                Unit it = (Unit)object;
                boolean bl = false;
                $onComplete.invoke(null);
            }
            Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
            if (throwable2 == null) break block3;
            Throwable e = throwable = throwable2;
            boolean bl = false;
            log.error((Object)("Failed to execute command: " + $command.getName()), e);
            $onComplete.invoke((Object)e);
        }
    }

    public static final /* synthetic */ WorkerDataConvertor access$getWorkerDataConvertor$p(PRCMigrationCommandWorkerHandler $this) {
        return $this.workerDataConvertor;
    }

    public static final /* synthetic */ V4Worker access$getWorkerByCommand(PRCMigrationCommandWorkerHandler $this, Command command) {
        return $this.getWorkerByCommand(command);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/workers/app/PRCMigrationCommandWorkerHandler$Companion;", "", "()V", "log", "Lorg/apache/log4j/Logger;", "kotlin.jvm.PlatformType", "getExecutorPool", "Ljava/util/concurrent/ExecutorService;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        private final ExecutorService getExecutorPool() {
            return Executors.newCachedThreadPool();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

