/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.app;

import com.atlassian.jira.migration.app.preload.AppDataPreloadTrigger;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.migration.MigrationCommand;
import com.atlassian.jira.migration.migration.MigrationCommandService;
import com.atlassian.jira.migration.migration.MigrationProtocol;
import com.atlassian.jira.migration.orchestratorclient.tasks.MigrationTask;
import com.atlassian.jira.migration.orchestratorclient.tasks.ProgressUnit;
import com.atlassian.jira.migration.orchestratorclient.tasks.V4AppDataPreloadNotificationTask;
import com.atlassian.jira.migration.platform.TransferResultRequest;
import com.atlassian.jira.migration.platform.TransferStatus;
import com.atlassian.jira.migration.prc.PrcCommandExecutor;
import com.atlassian.jira.migration.prc.PrcStatusUpdateService;
import com.atlassian.jira.migration.prc.model.AppDataPreloadNotificationMigrationPayload;
import com.atlassian.jira.migration.prc.model.PrcCommandPayload;
import com.atlassian.jira.migration.tracking.tasks.PrcTask;
import com.atlassian.jira.migration.tracking.tasks.V4Worker;
import com.atlassian.jira.migration.workers.WorkerDataConvertor;
import com.atlassian.jira.migration.workers.app.V4AppPreloadNotificationWorkerKt;
import com.atlassian.jira.migration.workers.attachments.FixedDelayCloseableRunner;
import com.atlassian.jira.migration.workers.attachments.FixedDelayCloseableRunnerFactory;
import com.atlassian.migration.prc.model.CommandName;
import com.atlassian.migration.statusrouter.model.CommandStatus;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B7\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020$2\u0006\u0010/\u001a\u00020\u0015H\u0016J\u0010\u00100\u001a\u00020-2\u0006\u00101\u001a\u000202H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\n \u0016*\u0004\u0018\u00010\u001d0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001c\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020$0#X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/atlassian/jira/migration/workers/app/V4AppPreloadNotificationWorker;", "Lcom/atlassian/jira/migration/tracking/tasks/V4Worker;", "Lcom/atlassian/jira/migration/prc/PrcCommandExecutor;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "prcStatusUpdateService", "Lcom/atlassian/jira/migration/prc/PrcStatusUpdateService;", "appDataPreloadTrigger", "Lcom/atlassian/jira/migration/app/preload/AppDataPreloadTrigger;", "fixedDelayCloseableRunnerFactory", "Lcom/atlassian/jira/migration/workers/attachments/FixedDelayCloseableRunnerFactory;", "workerDataConvertor", "Lcom/atlassian/jira/migration/workers/WorkerDataConvertor;", "migrationCommandService", "Lcom/atlassian/jira/migration/migration/MigrationCommandService;", "(Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/prc/PrcStatusUpdateService;Lcom/atlassian/jira/migration/app/preload/AppDataPreloadTrigger;Lcom/atlassian/jira/migration/workers/attachments/FixedDelayCloseableRunnerFactory;Lcom/atlassian/jira/migration/workers/WorkerDataConvertor;Lcom/atlassian/jira/migration/migration/MigrationCommandService;)V", "commandName", "Lcom/atlassian/migration/prc/model/CommandName;", "getCommandName", "()Lcom/atlassian/migration/prc/model/CommandName;", "heartbeatInterval", "", "kotlin.jvm.PlatformType", "Ljava/lang/Long;", "id", "", "getId", "()Ljava/lang/String;", "logger", "Lorg/slf4j/Logger;", "migrationProtocol", "Lcom/atlassian/jira/migration/migration/MigrationProtocol;", "getMigrationProtocol", "()Lcom/atlassian/jira/migration/migration/MigrationProtocol;", "payloadClassType", "Lkotlin/reflect/KClass;", "Lcom/atlassian/jira/migration/prc/model/PrcCommandPayload;", "getPayloadClassType", "()Lkotlin/reflect/KClass;", "supportedUnits", "", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/ProgressUnit;", "getSupportedUnits", "()Ljava/util/List;", "executeTask", "", "commandPayload", "prcCommandId", "process", "task", "Lcom/atlassian/jira/migration/tracking/tasks/PrcTask;", "jira-migration-plugin"})
public final class V4AppPreloadNotificationWorker
implements V4Worker,
PrcCommandExecutor {
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final PrcStatusUpdateService prcStatusUpdateService;
    @NotNull
    private final AppDataPreloadTrigger appDataPreloadTrigger;
    @NotNull
    private final FixedDelayCloseableRunnerFactory fixedDelayCloseableRunnerFactory;
    @NotNull
    private final WorkerDataConvertor workerDataConvertor;
    @NotNull
    private final MigrationCommandService migrationCommandService;
    private final Logger logger;
    @NotNull
    private final String id;
    @NotNull
    private final List<ProgressUnit> supportedUnits;
    @NotNull
    private final CommandName commandName;
    @NotNull
    private final KClass<? extends PrcCommandPayload> payloadClassType;
    @NotNull
    private final MigrationProtocol migrationProtocol;
    private final Long heartbeatInterval;

    @Inject
    public V4AppPreloadNotificationWorker(@NotNull MigrationFeatures migrationFeatures, @NotNull PrcStatusUpdateService prcStatusUpdateService, @NotNull AppDataPreloadTrigger appDataPreloadTrigger, @NotNull FixedDelayCloseableRunnerFactory fixedDelayCloseableRunnerFactory, @NotNull WorkerDataConvertor workerDataConvertor, @NotNull MigrationCommandService migrationCommandService) {
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)prcStatusUpdateService, (String)"prcStatusUpdateService");
        Intrinsics.checkNotNullParameter((Object)appDataPreloadTrigger, (String)"appDataPreloadTrigger");
        Intrinsics.checkNotNullParameter((Object)fixedDelayCloseableRunnerFactory, (String)"fixedDelayCloseableRunnerFactory");
        Intrinsics.checkNotNullParameter((Object)workerDataConvertor, (String)"workerDataConvertor");
        Intrinsics.checkNotNullParameter((Object)migrationCommandService, (String)"migrationCommandService");
        this.migrationFeatures = migrationFeatures;
        this.prcStatusUpdateService = prcStatusUpdateService;
        this.appDataPreloadTrigger = appDataPreloadTrigger;
        this.fixedDelayCloseableRunnerFactory = fixedDelayCloseableRunnerFactory;
        this.workerDataConvertor = workerDataConvertor;
        this.migrationCommandService = migrationCommandService;
        this.logger = LoggerFactory.getLogger(V4AppPreloadNotificationWorker.class);
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.id = string;
        this.supportedUnits = CollectionsKt.listOf((Object)((Object)ProgressUnit.ATTACHMENT));
        this.commandName = CommandName.APP_DATA_PRELOAD_NOTIFICATION;
        this.payloadClassType = Reflection.getOrCreateKotlinClass(AppDataPreloadNotificationMigrationPayload.class);
        this.migrationProtocol = MigrationProtocol.V4;
        this.heartbeatInterval = Long.getLong("jcma.app.preload.notification.heartbeat-interval-seconds", V4AppPreloadNotificationWorkerKt.access$getDEFAULT_HEARTBEAT_INTERVAL$p().getSeconds());
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public List<ProgressUnit> getSupportedUnits() {
        return this.supportedUnits;
    }

    @Override
    @NotNull
    public CommandName getCommandName() {
        return this.commandName;
    }

    @Override
    @NotNull
    public KClass<? extends PrcCommandPayload> getPayloadClassType() {
        return this.payloadClassType;
    }

    @Override
    @NotNull
    public MigrationProtocol getMigrationProtocol() {
        return this.migrationProtocol;
    }

    @Override
    public void executeTask(@NotNull PrcCommandPayload commandPayload, long prcCommandId) {
        Intrinsics.checkNotNullParameter((Object)commandPayload, (String)"commandPayload");
        PrcTask task = this.workerDataConvertor.toPrcTaskFromMigrationPayload(commandPayload, prcCommandId, this.getCommandName());
        MigrationCommand migrationCommand = this.migrationCommandService.upsertVersion(task.getMigrationId(), String.valueOf(prcCommandId));
        task.setVersion(migrationCommand.getVersion());
        this.process(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(@NotNull PrcTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (!this.migrationFeatures.getAppDataPreloadEnabledGA()) {
            this.logger.info("App data preload notification is skipped because feature is disable. migrationId = " + task.getMigrationId() + ", task = " + task);
            return;
        }
        Function0 function0 = (Function0)new Function0<Unit>(this, task){
            final /* synthetic */ V4AppPreloadNotificationWorker this$0;
            final /* synthetic */ PrcTask $task;
            {
                this.this$0 = $receiver;
                this.$task = $task;
                super(0);
            }

            public final void invoke() {
                V4AppPreloadNotificationWorker.access$getPrcStatusUpdateService$p(this.this$0).sendHeartbeat(this.$task);
                V4AppPreloadNotificationWorkerKt.access$getPreloaderHeartbeaterCounter$p().inc();
            }
        };
        Long l = this.heartbeatInterval;
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"heartbeatInterval");
        AutoCloseable autoCloseable = FixedDelayCloseableRunnerFactory.create$default(this.fixedDelayCloseableRunnerFactory, function0, ((Number)l).longValue(), TimeUnit.SECONDS, 0L, 8, null);
        Throwable throwable = null;
        try {
            FixedDelayCloseableRunner it = (FixedDelayCloseableRunner)autoCloseable;
            boolean bl = false;
            V4AppPreloadNotificationWorkerKt.access$getTimingHistogram$p().time(() -> V4AppPreloadNotificationWorker.process$lambda$1$lambda$0(task, this));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private static final void process$lambda$1$lambda$0(PrcTask $task, V4AppPreloadNotificationWorker this$0) {
        Intrinsics.checkNotNullParameter((Object)$task, (String)"$task");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        MigrationTask migrationTask = $task.getMigrationTask();
        Intrinsics.checkNotNull((Object)migrationTask, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.orchestratorclient.tasks.V4AppDataPreloadNotificationTask");
        V4AppDataPreloadNotificationTask migrationTask2 = (V4AppDataPreloadNotificationTask)migrationTask;
        List<String> preloadableApps = migrationTask2.getPreloadableApps();
        this$0.logger.info("Processing app data preload notification. migrationId = " + $task.getMigrationId() + ", task = " + $task + ", preloadableApps = " + preloadableApps);
        this$0.appDataPreloadTrigger.sendAppDataPreloadedNotification($task.getCloudId(), $task.getMigrationId());
        this$0.prcStatusUpdateService.publishFinalStatus($task, CommandStatus.SUCCESS, new TransferResultRequest(TransferStatus.SUCCESS, "App data preload notification completed successfully", null, null, 12, null));
        this$0.logger.info("App data preload notification is processed. " + $task.getMigrationId());
        V4AppPreloadNotificationWorkerKt.access$getPreloaderNotificationCounter$p().inc();
    }

    public static final /* synthetic */ PrcStatusUpdateService access$getPrcStatusUpdateService$p(V4AppPreloadNotificationWorker $this) {
        return $this.prcStatusUpdateService;
    }
}

