/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.app;

import com.atlassian.jira.migration.app.preload.AppDataPreloadStatusRepository;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.migration.MigrationCommand;
import com.atlassian.jira.migration.migration.MigrationCommandService;
import com.atlassian.jira.migration.migration.MigrationProtocol;
import com.atlassian.jira.migration.orchestratorclient.tasks.MigrationTask;
import com.atlassian.jira.migration.orchestratorclient.tasks.ProgressUnit;
import com.atlassian.jira.migration.orchestratorclient.tasks.V4AppDataPreloadTask;
import com.atlassian.jira.migration.platform.TransferStatus;
import com.atlassian.jira.migration.prc.PrcCommandExecutor;
import com.atlassian.jira.migration.prc.model.AppDataPreloadMigrationPayload;
import com.atlassian.jira.migration.prc.model.PrcCommandPayload;
import com.atlassian.jira.migration.tracking.tasks.PrcTask;
import com.atlassian.jira.migration.tracking.tasks.Task;
import com.atlassian.jira.migration.tracking.tasks.V4Worker;
import com.atlassian.jira.migration.workers.PrcProgressUpdater;
import com.atlassian.jira.migration.workers.ProgressUpdate;
import com.atlassian.jira.migration.workers.WorkerDataConvertor;
import com.atlassian.jira.migration.workers.app.ProgressUpdaterFactory;
import com.atlassian.jira.migration.workers.attachments.MediaUploadProgress;
import com.atlassian.jira.migration.workers.attachments.preload.AppDataPreloadProcessor;
import com.atlassian.jira.migration.workers.attachments.preload.PreloadDataSizeCalculator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.migration.prc.model.CommandName;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u00013B?\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020#2\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020,2\u0006\u00101\u001a\u000202H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001c\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020#0\"X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/atlassian/jira/migration/workers/app/V4AppPreloadWorker;", "Lcom/atlassian/jira/migration/tracking/tasks/V4Worker;", "Lcom/atlassian/jira/migration/prc/PrcCommandExecutor;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "progressUpdaterFactory", "Lcom/atlassian/jira/migration/workers/app/ProgressUpdaterFactory;", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "appDataPreloadProcessor", "Lcom/atlassian/jira/migration/workers/attachments/preload/AppDataPreloadProcessor;", "appDataPreloadDataSizeCalculator", "Lcom/atlassian/jira/migration/workers/attachments/preload/PreloadDataSizeCalculator;", "workerDataConvertor", "Lcom/atlassian/jira/migration/workers/WorkerDataConvertor;", "migrationCommandService", "Lcom/atlassian/jira/migration/migration/MigrationCommandService;", "(Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/workers/app/ProgressUpdaterFactory;Lcom/atlassian/jira/project/ProjectManager;Lcom/atlassian/jira/migration/workers/attachments/preload/AppDataPreloadProcessor;Lcom/atlassian/jira/migration/workers/attachments/preload/PreloadDataSizeCalculator;Lcom/atlassian/jira/migration/workers/WorkerDataConvertor;Lcom/atlassian/jira/migration/migration/MigrationCommandService;)V", "commandName", "Lcom/atlassian/migration/prc/model/CommandName;", "getCommandName", "()Lcom/atlassian/migration/prc/model/CommandName;", "id", "", "getId", "()Ljava/lang/String;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "migrationProtocol", "Lcom/atlassian/jira/migration/migration/MigrationProtocol;", "getMigrationProtocol", "()Lcom/atlassian/jira/migration/migration/MigrationProtocol;", "payloadClassType", "Lkotlin/reflect/KClass;", "Lcom/atlassian/jira/migration/prc/model/PrcCommandPayload;", "getPayloadClassType", "()Lkotlin/reflect/KClass;", "supportedUnits", "", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/ProgressUnit;", "getSupportedUnits", "()Ljava/util/List;", "executeTask", "", "commandPayload", "prcCommandId", "", "process", "task", "Lcom/atlassian/jira/migration/tracking/tasks/PrcTask;", "PreloadProgressUpdater", "jira-migration-plugin"})
public final class V4AppPreloadWorker
implements V4Worker,
PrcCommandExecutor {
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final ProgressUpdaterFactory progressUpdaterFactory;
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final AppDataPreloadProcessor appDataPreloadProcessor;
    @NotNull
    private final PreloadDataSizeCalculator appDataPreloadDataSizeCalculator;
    @NotNull
    private final WorkerDataConvertor workerDataConvertor;
    @NotNull
    private final MigrationCommandService migrationCommandService;
    private final Logger logger;
    @NotNull
    private final String id;
    @NotNull
    private final List<ProgressUnit> supportedUnits;
    @NotNull
    private final CommandName commandName;
    @NotNull
    private final KClass<? extends PrcCommandPayload> payloadClassType;
    @NotNull
    private final MigrationProtocol migrationProtocol;

    @Inject
    public V4AppPreloadWorker(@NotNull MigrationFeatures migrationFeatures, @NotNull ProgressUpdaterFactory progressUpdaterFactory, @NotNull ProjectManager projectManager, @NotNull AppDataPreloadProcessor appDataPreloadProcessor, @NotNull PreloadDataSizeCalculator appDataPreloadDataSizeCalculator, @NotNull WorkerDataConvertor workerDataConvertor, @NotNull MigrationCommandService migrationCommandService) {
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)progressUpdaterFactory, (String)"progressUpdaterFactory");
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)appDataPreloadProcessor, (String)"appDataPreloadProcessor");
        Intrinsics.checkNotNullParameter((Object)appDataPreloadDataSizeCalculator, (String)"appDataPreloadDataSizeCalculator");
        Intrinsics.checkNotNullParameter((Object)workerDataConvertor, (String)"workerDataConvertor");
        Intrinsics.checkNotNullParameter((Object)migrationCommandService, (String)"migrationCommandService");
        this.migrationFeatures = migrationFeatures;
        this.progressUpdaterFactory = progressUpdaterFactory;
        this.projectManager = projectManager;
        this.appDataPreloadProcessor = appDataPreloadProcessor;
        this.appDataPreloadDataSizeCalculator = appDataPreloadDataSizeCalculator;
        this.workerDataConvertor = workerDataConvertor;
        this.migrationCommandService = migrationCommandService;
        this.logger = LoggerFactory.getLogger(V4AppPreloadWorker.class);
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.id = string;
        this.supportedUnits = CollectionsKt.listOf((Object)((Object)ProgressUnit.ATTACHMENT));
        this.commandName = CommandName.APP_DATA_PRELOAD;
        this.payloadClassType = Reflection.getOrCreateKotlinClass(AppDataPreloadMigrationPayload.class);
        this.migrationProtocol = MigrationProtocol.V4;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public List<ProgressUnit> getSupportedUnits() {
        return this.supportedUnits;
    }

    @Override
    @NotNull
    public CommandName getCommandName() {
        return this.commandName;
    }

    @Override
    @NotNull
    public KClass<? extends PrcCommandPayload> getPayloadClassType() {
        return this.payloadClassType;
    }

    @Override
    public void executeTask(@NotNull PrcCommandPayload commandPayload, long prcCommandId) {
        Intrinsics.checkNotNullParameter((Object)commandPayload, (String)"commandPayload");
        PrcTask task = this.workerDataConvertor.toPrcTaskFromMigrationPayload(commandPayload, prcCommandId, this.getCommandName());
        MigrationCommand migrationCommand = this.migrationCommandService.upsertVersion(task.getMigrationId(), String.valueOf(prcCommandId));
        task.setVersion(migrationCommand.getVersion());
        this.process(task);
    }

    @Override
    @NotNull
    public MigrationProtocol getMigrationProtocol() {
        return this.migrationProtocol;
    }

    @Override
    public void process(@NotNull PrcTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (!this.migrationFeatures.getAppDataPreloadEnabledGA()) {
            this.logger.info("App data preload is skipped because feature is disable. migrationId = " + task.getMigrationId() + ", task = " + task);
            return;
        }
        MigrationTask migrationTask = task.getMigrationTask();
        Intrinsics.checkNotNull((Object)migrationTask, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.orchestratorclient.tasks.V4AppDataPreloadTask");
        V4AppDataPreloadTask migrationTask2 = (V4AppDataPreloadTask)migrationTask;
        long projectId = Long.parseLong(migrationTask2.getProjectId());
        List<String> preloadableApps = migrationTask2.getPreloadableApps();
        this.logger.info("App data preload is processing. migrationId = " + task.getMigrationId() + ", projectId = " + projectId);
        try {
            Project project = this.projectManager.getProjectObj(Long.valueOf(projectId));
            if (project == null) {
                throw new IllegalArgumentException("Project with ID " + projectId + " not found");
            }
            Project project2 = project;
            PrcProgressUpdater heartbeater = this.progressUpdaterFactory.createPrcProgressUpdater(task.getMigrationId());
            Task task2 = task;
            String string = project2.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
            long totalDataSize2 = this.appDataPreloadDataSizeCalculator.calculateTotalDataSize(preloadableApps, task2, string, (Function0<Unit>)((Function0)new Function0<Unit>(heartbeater, task){
                final /* synthetic */ PrcProgressUpdater $heartbeater;
                final /* synthetic */ PrcTask $task;
                {
                    this.$heartbeater = $heartbeater;
                    this.$task = $task;
                    super(0);
                }

                public final void invoke() {
                    this.$heartbeater.sendHeartbeat(this.$task);
                }
            }));
            PreloadProgressUpdater progressUpdater2 = this.progressUpdaterFactory.createPreloadProgressUpdater(task, totalDataSize2);
            Task task3 = task;
            String string2 = project2.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getKey(...)");
            this.appDataPreloadProcessor.process(preloadableApps, task3, string2, (Function1<? super MediaUploadProgress, Unit>)((Function1)new Function1<MediaUploadProgress, Unit>((Object)progressUpdater2){

                public final void invoke(@NotNull MediaUploadProgress p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((PreloadProgressUpdater)this.receiver).reportProgress(p0);
                }
            }));
            progressUpdater2.reportFinalStatus(projectId);
            this.logger.info("App data preload is processed. " + task.getMigrationId() + ", projectId = " + projectId);
        }
        catch (Exception e) {
            this.logger.error("Error processing app data preload. migrationId = " + task.getMigrationId() + ", projectId = " + projectId, (Throwable)e);
            throw e;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001c\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00070\u00102\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0007J\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0013R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/atlassian/jira/migration/workers/app/V4AppPreloadWorker$PreloadProgressUpdater;", "", "progressUpdater", "Lcom/atlassian/jira/migration/workers/PrcProgressUpdater;", "task", "Lcom/atlassian/jira/migration/tracking/tasks/PrcTask;", "totalDataSize", "", "appDataPreloadStatusRepository", "Lcom/atlassian/jira/migration/app/preload/AppDataPreloadStatusRepository;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/workers/PrcProgressUpdater;Lcom/atlassian/jira/migration/tracking/tasks/PrcTask;JLcom/atlassian/jira/migration/app/preload/AppDataPreloadStatusRepository;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "migratedBytes", "Ljava/util/concurrent/atomic/AtomicLong;", "getProgress", "", "", "reportFinalStatus", "", "projectId", "reportProgress", "progress", "Lcom/atlassian/jira/migration/workers/attachments/MediaUploadProgress;", "sendHeartbeat", "jira-migration-plugin"})
    public static final class PreloadProgressUpdater {
        @NotNull
        private final PrcProgressUpdater progressUpdater;
        @NotNull
        private final PrcTask task;
        private final long totalDataSize;
        @NotNull
        private final AppDataPreloadStatusRepository appDataPreloadStatusRepository;
        @NotNull
        private final MigrationFeatures migrationFeatures;
        @NotNull
        private final AtomicLong migratedBytes;

        public PreloadProgressUpdater(@NotNull PrcProgressUpdater progressUpdater2, @NotNull PrcTask task, long totalDataSize2, @NotNull AppDataPreloadStatusRepository appDataPreloadStatusRepository, @NotNull MigrationFeatures migrationFeatures) {
            Intrinsics.checkNotNullParameter((Object)progressUpdater2, (String)"progressUpdater");
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            Intrinsics.checkNotNullParameter((Object)appDataPreloadStatusRepository, (String)"appDataPreloadStatusRepository");
            Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
            this.progressUpdater = progressUpdater2;
            this.task = task;
            this.totalDataSize = totalDataSize2;
            this.appDataPreloadStatusRepository = appDataPreloadStatusRepository;
            this.migrationFeatures = migrationFeatures;
            this.migratedBytes = new AtomicLong();
        }

        public final void reportProgress(@NotNull MediaUploadProgress progress) {
            Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
            if (progress instanceof MediaUploadProgress.UploadedChunkSizeProgress) {
                long newMigratedBytes = this.migratedBytes.addAndGet(((MediaUploadProgress.UploadedChunkSizeProgress)progress).getChunkSizeAsLong());
                Map<String, Long> properties = this.getProgress(newMigratedBytes);
                this.progressUpdater.sendProgressUpdate(new ProgressUpdate((int)((float)newMigratedBytes / (float)this.totalDataSize * (float)100), "App data preload in progress", properties, newMigratedBytes >= this.totalDataSize), this.task);
            } else if (progress instanceof MediaUploadProgress.NoChangeProgress) {
                this.sendHeartbeat();
            }
        }

        public final void reportFinalStatus(long projectId) {
            TransferStatus transferStatus;
            Map<Boolean, Long> stats = this.appDataPreloadStatusRepository.statusStats(this.task.getMigrationId(), projectId);
            boolean bl = false;
            Long l = stats.get(false);
            long l2 = 0L;
            if (l != null && l == l2) {
                transferStatus = TransferStatus.SUCCESS;
            } else {
                Long l3 = stats.get(true);
                l2 = 0L;
                transferStatus = l3 != null && l3 == l2 ? TransferStatus.FAILED : TransferStatus.INCOMPLETE;
            }
            TransferStatus status = transferStatus;
            PrcProgressUpdater prcProgressUpdater = this.progressUpdater;
            TransferStatus transferStatus2 = this.migrationFeatures.getEnableIncompleteProjectAttachmentCalculation() ? status : TransferStatus.SUCCESS;
            String string = "App data preload completed with status " + (Object)((Object)status);
            Map<String, Long> map = this.getProgress(this.migratedBytes.get());
            PrcTask prcTask = this.task;
            prcProgressUpdater.sendFinalStatus(transferStatus2, map, string, prcTask);
        }

        public final void sendHeartbeat() {
            this.progressUpdater.sendHeartbeat(this.task);
        }

        private final Map<String, Long> getProgress(long migratedBytes) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"successfullyMigratedBytes", (Object)migratedBytes), TuplesKt.to((Object)"totalProjectAppDataSize", (Object)this.totalDataSize)};
            return MapsKt.mapOf((Pair[])pairArray);
        }
    }
}

