/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.app.preload;

import com.atlassian.jira.migration.migration.MigrationCommandService;
import com.atlassian.jira.migration.platform.TransferStatus;
import com.atlassian.jira.migration.prc.PrcStatusUpdateService;
import com.atlassian.jira.migration.tracking.polling.InProgressMigrationIds;
import com.atlassian.jira.migration.tracking.tasks.PrcTask;
import com.atlassian.jira.migration.workers.PrcProgressUpdater;
import com.atlassian.jira.migration.workers.ProgressUpdate;
import com.atlassian.migration.api.MigrationId;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/jira/migration/workers/app/preload/PreloadStubProcessor;", "", "prcStatusUpdateService", "Lcom/atlassian/jira/migration/prc/PrcStatusUpdateService;", "migrationCommandService", "Lcom/atlassian/jira/migration/migration/MigrationCommandService;", "migrationIds", "Lcom/atlassian/jira/migration/tracking/polling/InProgressMigrationIds;", "(Lcom/atlassian/jira/migration/prc/PrcStatusUpdateService;Lcom/atlassian/jira/migration/migration/MigrationCommandService;Lcom/atlassian/jira/migration/tracking/polling/InProgressMigrationIds;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "threads", "Ljava/util/concurrent/ExecutorService;", "getThreads", "()Ljava/util/concurrent/ExecutorService;", "process", "", "task", "Lcom/atlassian/jira/migration/tracking/tasks/PrcTask;", "jira-migration-plugin"})
public final class PreloadStubProcessor {
    @NotNull
    private final PrcStatusUpdateService prcStatusUpdateService;
    @NotNull
    private final MigrationCommandService migrationCommandService;
    @NotNull
    private final InProgressMigrationIds migrationIds;
    private final Logger logger;
    @NotNull
    private final ExecutorService threads;

    @Inject
    public PreloadStubProcessor(@NotNull PrcStatusUpdateService prcStatusUpdateService, @NotNull MigrationCommandService migrationCommandService, @NotNull InProgressMigrationIds migrationIds) {
        Intrinsics.checkNotNullParameter((Object)prcStatusUpdateService, (String)"prcStatusUpdateService");
        Intrinsics.checkNotNullParameter((Object)migrationCommandService, (String)"migrationCommandService");
        Intrinsics.checkNotNullParameter((Object)migrationIds, (String)"migrationIds");
        this.prcStatusUpdateService = prcStatusUpdateService;
        this.migrationCommandService = migrationCommandService;
        this.migrationIds = migrationIds;
        this.logger = LoggerFactory.getLogger(PreloadStubProcessor.class);
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        Intrinsics.checkNotNull((Object)executorService);
        this.threads = executorService;
    }

    @NotNull
    public final ExecutorService getThreads() {
        return this.threads;
    }

    public final void process(@NotNull PrcTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        PrcProgressUpdater progressUpdater2 = new PrcProgressUpdater(this.prcStatusUpdateService, new MigrationId(task.getMigrationId()), this.migrationCommandService, this.migrationIds, null, null, 48, null);
        long totalUploadBytes = 123456789L;
        this.threads.submit(() -> PreloadStubProcessor.process$lambda$0(this, task, totalUploadBytes, progressUpdater2));
    }

    private static final void process$lambda$0(PreloadStubProcessor this$0, PrcTask $task, long $totalUploadBytes, PrcProgressUpdater $progressUpdater) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$task, (String)"$task");
        Intrinsics.checkNotNullParameter((Object)$progressUpdater, (String)"$progressUpdater");
        for (int i = 1; i < 101; ++i) {
            this$0.logger.info("App data preload is processing. " + $task.getMigrationId() + ": " + i + '%');
            long progressBytes = $totalUploadBytes / (long)100 * (long)i;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"successfullyMigratedBytes", (Object)progressBytes), TuplesKt.to((Object)"totalProjectAppDataSize", (Object)$totalUploadBytes)};
            $progressUpdater.sendProgressUpdate(new ProgressUpdate(i, "App data preload: " + i + '%', MapsKt.mapOf((Pair[])pairArray), i == 100), $task);
            Thread.sleep(Duration.ofSeconds(1L).toMillis());
        }
        this$0.logger.info("App data preload is complete. " + $task.getMigrationId());
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"successfullyMigratedBytes", (Object)$totalUploadBytes), TuplesKt.to((Object)"totalProjectAppDataSize", (Object)$totalUploadBytes)};
        PrcProgressUpdater.sendFinalStatus$default($progressUpdater, TransferStatus.SUCCESS, MapsKt.mapOf((Pair[])pairArray), null, $task, 4, null);
    }
}

