/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.assets;

import com.atlassian.jira.migration.analytics.MigAssetStatsService;
import com.atlassian.jira.migration.common.MigrationTaskMetadata;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.events.AssetDataUploadFailed;
import com.atlassian.jira.migration.events.AssetDataUploadInitialState;
import com.atlassian.jira.migration.events.AssetDataUploadStarted;
import com.atlassian.jira.migration.events.MigAssetStats;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.export.DataExportOutcome;
import com.atlassian.jira.migration.export.ExportFacade;
import com.atlassian.jira.migration.httpclient.exceptions.UnexpectedStatusCodeException;
import com.atlassian.jira.migration.migration.MigrationCommandService;
import com.atlassian.jira.migration.migration.MigrationProtocol;
import com.atlassian.jira.migration.orchestratorclient.tasks.MigrationTaskType;
import com.atlassian.jira.migration.plan.AssetsDataMigrationMode;
import com.atlassian.jira.migration.plan.AssetsSchemaKey;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.platform.CreateFileMpResponse;
import com.atlassian.jira.migration.platform.PlatformService;
import com.atlassian.jira.migration.platform.TransferStatus;
import com.atlassian.jira.migration.prc.PrcStatusUpdateService;
import com.atlassian.jira.migration.prc.exception.CommandCancelledException;
import com.atlassian.jira.migration.scope.MigrationScopeManager;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UserInfo;
import com.atlassian.jira.migration.shadow.db.AssetExportFinalStatus;
import com.atlassian.jira.migration.shadow.db.MigrationFinalStatus;
import com.atlassian.jira.migration.shadow.db.MigrationFinalStatusRepository;
import com.atlassian.jira.migration.tracking.polling.InProgressMigrationIds;
import com.atlassian.jira.migration.tracking.tasks.PrcTask;
import com.atlassian.jira.migration.usersmigrationservice.TombstoneUser;
import com.atlassian.jira.migration.usersmigrationservice.UsersMigrationServiceClient;
import com.atlassian.jira.migration.utility.FileChunkUtility;
import com.atlassian.jira.migration.workers.MigrationTaskMetadataProvider;
import com.atlassian.jira.migration.workers.PlatformUtilKt;
import com.atlassian.jira.migration.workers.PrcProgressUpdater;
import com.atlassian.jira.migration.workers.assets.V4AssetsProcessor;
import com.atlassian.jira.migration.workers.tombstone.TombstoneAccountManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.migration.api.ContainerToken;
import com.atlassian.migration.api.MigrationId;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.PreDestroy;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00d8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0085\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u0012\u0006\u0010\u001e\u001a\u00020\u001f\u0012\u0006\u0010 \u001a\u00020!\u00a2\u0006\u0002\u0010\"J\u0010\u0010D\u001a\u00020?2\u0006\u0010E\u001a\u00020$H\u0002J\u0010\u0010F\u001a\u00020$2\u0006\u0010G\u001a\u00020HH\u0002J\u0010\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020LH\u0002J\u0006\u0010M\u001a\u00020NJ\u0010\u0010O\u001a\u00020N2\u0006\u0010P\u001a\u00020JH\u0002J\u001e\u0010Q\u001a\u00020N2\u0006\u0010R\u001a\u00020$2\f\u0010S\u001a\b\u0012\u0004\u0012\u00020$0TH\u0002J\u0014\u0010U\u001a\u00020N2\n\u0010V\u001a\u00060Wj\u0002`XH\u0002J\u0006\u0010Y\u001a\u00020NJ\u0010\u0010Z\u001a\u00020N2\u0006\u00102\u001a\u00020$H\u0002J\b\u0010[\u001a\u00020NH\u0002J\u0010\u0010\\\u001a\u00020N2\u0006\u0010K\u001a\u00020LH\u0002J\u0010\u0010]\u001a\u00020N2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010^\u001a\u00020NH\u0007J\u000e\u0010_\u001a\u00020N2\u0006\u0010P\u001a\u00020JJ\u001c\u0010`\u001a\u00020N2\u0006\u0010R\u001a\u00020$2\f\u0010a\u001a\b\u0012\u0004\u0012\u00020b0TR\u001a\u0010#\u001a\u00020$X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010-\u001a\n /*\u0004\u0018\u00010.0.\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00102\u001a\u000203\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00106\u001a\u000207\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010:\u001a\u00020;\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010>\u001a\u00020?8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bB\u0010C\u001a\u0004\b@\u0010AR\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006c"}, d2={"Lcom/atlassian/jira/migration/workers/assets/V4AssetsProcessor;", "", "task", "Lcom/atlassian/jira/migration/tracking/tasks/PrcTask;", "heartbeatScheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "prcStatusUpdateService", "Lcom/atlassian/jira/migration/prc/PrcStatusUpdateService;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "migrationTaskMetadataProvider", "Lcom/atlassian/jira/migration/workers/MigrationTaskMetadataProvider;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "exportFacade", "Lcom/atlassian/jira/migration/export/ExportFacade;", "migrationScopeManager", "Lcom/atlassian/jira/migration/scope/MigrationScopeManager;", "platformService", "Lcom/atlassian/jira/migration/platform/PlatformService;", "tombstoneAccountManager", "Lcom/atlassian/jira/migration/workers/tombstone/TombstoneAccountManager;", "usersMigrationServiceClient", "Lcom/atlassian/jira/migration/usersmigrationservice/UsersMigrationServiceClient;", "migrationFinalStatusRepository", "Lcom/atlassian/jira/migration/shadow/db/MigrationFinalStatusRepository;", "migrationCommandService", "Lcom/atlassian/jira/migration/migration/MigrationCommandService;", "migrationIds", "Lcom/atlassian/jira/migration/tracking/polling/InProgressMigrationIds;", "migAssetStatsService", "Lcom/atlassian/jira/migration/analytics/MigAssetStatsService;", "(Lcom/atlassian/jira/migration/tracking/tasks/PrcTask;Ljava/util/concurrent/ScheduledExecutorService;Lcom/atlassian/jira/migration/prc/PrcStatusUpdateService;Lcom/atlassian/jira/migration/discovery/DiscoveryService;Lcom/atlassian/jira/migration/workers/MigrationTaskMetadataProvider;Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/project/ProjectManager;Lcom/atlassian/jira/migration/export/ExportFacade;Lcom/atlassian/jira/migration/scope/MigrationScopeManager;Lcom/atlassian/jira/migration/platform/PlatformService;Lcom/atlassian/jira/migration/workers/tombstone/TombstoneAccountManager;Lcom/atlassian/jira/migration/usersmigrationservice/UsersMigrationServiceClient;Lcom/atlassian/jira/migration/shadow/db/MigrationFinalStatusRepository;Lcom/atlassian/jira/migration/migration/MigrationCommandService;Lcom/atlassian/jira/migration/tracking/polling/InProgressMigrationIds;Lcom/atlassian/jira/migration/analytics/MigAssetStatsService;)V", "assetDataExportFileId", "", "getAssetDataExportFileId", "()Ljava/lang/String;", "setAssetDataExportFileId", "(Ljava/lang/String;)V", "containerToken", "Lcom/atlassian/migration/api/ContainerToken;", "getContainerToken", "()Lcom/atlassian/migration/api/ContainerToken;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "migrationId", "Lcom/atlassian/migration/api/MigrationId;", "getMigrationId", "()Lcom/atlassian/migration/api/MigrationId;", "migrationMetadata", "Lcom/atlassian/jira/migration/common/MigrationTaskMetadata;", "getMigrationMetadata", "()Lcom/atlassian/jira/migration/common/MigrationTaskMetadata;", "progressUpdater", "Lcom/atlassian/jira/migration/workers/PrcProgressUpdater;", "getProgressUpdater", "()Lcom/atlassian/jira/migration/workers/PrcProgressUpdater;", "tombstoneUsersFile", "Lcom/atlassian/jira/migration/platform/CreateFileMpResponse;", "getTombstoneUsersFile", "()Lcom/atlassian/jira/migration/platform/CreateFileMpResponse;", "tombstoneUsersFile$delegate", "Lkotlin/Lazy;", "createFile", "filename", "createFileMultipart", "file", "Ljava/io/File;", "exportAssetData", "Lcom/atlassian/jira/migration/export/DataExportOutcome;", "plan", "Lcom/atlassian/jira/migration/plan/Plan;", "process", "", "processExportedFile", "outcome", "publishTombstoneUsers", "migrationScopeId", "deletedUserKeys", "", "sendFailedEvent", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "sendFinalStatus", "sendFinalStatusForShadowMigration", "sendStartEvent", "sendStartEventInitialState", "setHeartbeatScheduler", "shutdown", "uploadExportedFile", "uploadTombStoneMappings", "tombstoneUsers", "Lcom/atlassian/jira/migration/usersmigrationservice/TombstoneUser;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nV4AssetsProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 V4AssetsProcessor.kt\ncom/atlassian/jira/migration/workers/assets/V4AssetsProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,268:1\n1#2:269\n1#2:284\n1549#3:270\n1620#3,3:271\n1603#3,9:274\n1855#3:283\n1856#3:285\n1612#3:286\n1549#3:287\n1620#3,3:288\n1549#3:291\n1620#3,3:292\n*S KotlinDebug\n*F\n+ 1 V4AssetsProcessor.kt\ncom/atlassian/jira/migration/workers/assets/V4AssetsProcessor\n*L\n253#1:284\n161#1:270\n161#1:271,3\n253#1:274,9\n253#1:283\n253#1:285\n253#1:286\n254#1:287\n254#1:288,3\n257#1:291\n257#1:292,3\n*E\n"})
public final class V4AssetsProcessor {
    @NotNull
    private final PrcTask task;
    @NotNull
    private final ScheduledExecutorService heartbeatScheduler;
    @NotNull
    private final PrcStatusUpdateService prcStatusUpdateService;
    @NotNull
    private final DiscoveryService discoveryService;
    @NotNull
    private final MigrationTaskMetadataProvider migrationTaskMetadataProvider;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final ExportFacade exportFacade;
    @NotNull
    private final MigrationScopeManager migrationScopeManager;
    @NotNull
    private final PlatformService platformService;
    @NotNull
    private final TombstoneAccountManager tombstoneAccountManager;
    @NotNull
    private final UsersMigrationServiceClient usersMigrationServiceClient;
    @NotNull
    private final MigrationFinalStatusRepository migrationFinalStatusRepository;
    @NotNull
    private final MigrationCommandService migrationCommandService;
    @NotNull
    private final InProgressMigrationIds migrationIds;
    @NotNull
    private final MigAssetStatsService migAssetStatsService;
    private final Logger log;
    @NotNull
    private final MigrationTaskMetadata migrationMetadata;
    public String assetDataExportFileId;
    @NotNull
    private final ContainerToken containerToken;
    @NotNull
    private final MigrationId migrationId;
    @NotNull
    private final Lazy tombstoneUsersFile$delegate;
    @NotNull
    private final PrcProgressUpdater progressUpdater;

    public V4AssetsProcessor(@NotNull PrcTask task, @NotNull ScheduledExecutorService heartbeatScheduler, @NotNull PrcStatusUpdateService prcStatusUpdateService, @NotNull DiscoveryService discoveryService, @NotNull MigrationTaskMetadataProvider migrationTaskMetadataProvider, @NotNull MigrationEventBus migrationEventBus, @NotNull ProjectManager projectManager, @NotNull ExportFacade exportFacade, @NotNull MigrationScopeManager migrationScopeManager, @NotNull PlatformService platformService, @NotNull TombstoneAccountManager tombstoneAccountManager, @NotNull UsersMigrationServiceClient usersMigrationServiceClient, @NotNull MigrationFinalStatusRepository migrationFinalStatusRepository, @NotNull MigrationCommandService migrationCommandService, @NotNull InProgressMigrationIds migrationIds, @NotNull MigAssetStatsService migAssetStatsService) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)heartbeatScheduler, (String)"heartbeatScheduler");
        Intrinsics.checkNotNullParameter((Object)prcStatusUpdateService, (String)"prcStatusUpdateService");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)migrationTaskMetadataProvider, (String)"migrationTaskMetadataProvider");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)exportFacade, (String)"exportFacade");
        Intrinsics.checkNotNullParameter((Object)migrationScopeManager, (String)"migrationScopeManager");
        Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
        Intrinsics.checkNotNullParameter((Object)tombstoneAccountManager, (String)"tombstoneAccountManager");
        Intrinsics.checkNotNullParameter((Object)usersMigrationServiceClient, (String)"usersMigrationServiceClient");
        Intrinsics.checkNotNullParameter((Object)migrationFinalStatusRepository, (String)"migrationFinalStatusRepository");
        Intrinsics.checkNotNullParameter((Object)migrationCommandService, (String)"migrationCommandService");
        Intrinsics.checkNotNullParameter((Object)migrationIds, (String)"migrationIds");
        Intrinsics.checkNotNullParameter((Object)migAssetStatsService, (String)"migAssetStatsService");
        this.task = task;
        this.heartbeatScheduler = heartbeatScheduler;
        this.prcStatusUpdateService = prcStatusUpdateService;
        this.discoveryService = discoveryService;
        this.migrationTaskMetadataProvider = migrationTaskMetadataProvider;
        this.migrationEventBus = migrationEventBus;
        this.projectManager = projectManager;
        this.exportFacade = exportFacade;
        this.migrationScopeManager = migrationScopeManager;
        this.platformService = platformService;
        this.tombstoneAccountManager = tombstoneAccountManager;
        this.usersMigrationServiceClient = usersMigrationServiceClient;
        this.migrationFinalStatusRepository = migrationFinalStatusRepository;
        this.migrationCommandService = migrationCommandService;
        this.migrationIds = migrationIds;
        this.migAssetStatsService = migAssetStatsService;
        this.log = LoggerFactory.getLogger(V4AssetsProcessor.class);
        this.migrationMetadata = this.migrationTaskMetadataProvider.get(this.task);
        this.containerToken = new ContainerToken(this.task.getCloudSite().getContainerToken());
        this.migrationId = new MigrationId(this.task.getMigrationId());
        this.tombstoneUsersFile$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<CreateFileMpResponse>(this){
            final /* synthetic */ V4AssetsProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final CreateFileMpResponse invoke() {
                return V4AssetsProcessor.access$createFile(this.this$0, "tombstone-users");
            }
        }));
        this.progressUpdater = new PrcProgressUpdater(this.prcStatusUpdateService, this.migrationId, this.migrationCommandService, this.migrationIds, null, null, 48, null);
    }

    public final Logger getLog() {
        return this.log;
    }

    @NotNull
    public final MigrationTaskMetadata getMigrationMetadata() {
        return this.migrationMetadata;
    }

    @NotNull
    public final String getAssetDataExportFileId() {
        String string = this.assetDataExportFileId;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"assetDataExportFileId");
        return null;
    }

    public final void setAssetDataExportFileId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.assetDataExportFileId = string;
    }

    @NotNull
    public final ContainerToken getContainerToken() {
        return this.containerToken;
    }

    @NotNull
    public final MigrationId getMigrationId() {
        return this.migrationId;
    }

    @NotNull
    public final CreateFileMpResponse getTombstoneUsersFile() {
        Lazy lazy = this.tombstoneUsersFile$delegate;
        return (CreateFileMpResponse)lazy.getValue();
    }

    @NotNull
    public final PrcProgressUpdater getProgressUpdater() {
        return this.progressUpdater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void process() {
        try {
            this.setHeartbeatScheduler(this.task);
            this.log.info("Assets processing started " + this.task.getMigrationId() + "} prcCommandId: " + this.task.getPrcCommandId() + '}');
            Plan plan2 = DiscoveryService.retrievePlanFor$default(this.discoveryService, this.task, false, 2, null);
            if (Intrinsics.areEqual((Object)plan2.isShadowPlan(), (Object)true)) {
                if (!(plan2.getOriginalMigrationId() != null)) {
                    boolean bl = false;
                    String string = "Shadow Plan should have an originalMigrationId";
                    throw new IllegalArgumentException(string.toString());
                }
                this.sendFinalStatusForShadowMigration(plan2.getOriginalMigrationId());
                return;
            }
            this.sendStartEvent();
            this.log.info(this.task.getMigrationId() + '-' + this.task.getTaskId() + ": exporting assets data as " + this.migrationMetadata.getStartedUser());
            AutoCloseable autoCloseable = this.exportAssetData(plan2);
            Throwable throwable = null;
            try {
                DataExportOutcome outcome = (DataExportOutcome)autoCloseable;
                boolean bl = false;
                String migrationScopeId2 = this.migrationScopeManager.getMigrationScope(this.task.getCloudSite());
                this.log.info(this.task.getMigrationId() + '-' + this.task.getMigrationTask().getTaskId() + ": migration scope id " + migrationScopeId2);
                this.log.info("File created with name : " + outcome.getFile().getName() + " at path : " + outcome.getFile().getPath());
                this.publishTombstoneUsers(migrationScopeId2, outcome.getDeletedUserKeys());
                this.processExportedFile(outcome);
                MigAssetStatsService.publishProjectAssetMetrics$default(this.migAssetStatsService, this.task.getMigrationId(), migrationScopeId2, outcome.getFile(), MigAssetStats.StatsType.ASSET_DATA, null, null, null, 112, null);
                this.sendFinalStatus();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (CommandCancelledException ex) {
            this.log.warn(ex.getMessage());
        }
        catch (UnexpectedStatusCodeException ex) {
            if (ex.getStatusCode() != 409) {
                this.log.error(this.task.getMigrationId() + '-' + this.task.getTaskId() + ": exporting assets failed");
                this.sendFailedEvent(ex);
                throw ex;
            }
            this.log.info(this.task.getMigrationId() + '-' + this.task.getTaskId() + ": ignoring " + ex.getStatusCode() + " for asset data");
        }
        catch (Exception ex) {
            this.log.error(this.task.getMigrationId() + '-' + this.task.getTaskId() + ": exporting assets failed");
            this.sendFailedEvent(ex);
            throw ex;
        }
        finally {
            this.heartbeatScheduler.shutdown();
        }
    }

    @PreDestroy
    public final void shutdown() {
        this.heartbeatScheduler.shutdown();
    }

    private final void processExportedFile(DataExportOutcome outcome) {
        this.uploadExportedFile(outcome);
    }

    public final void uploadExportedFile(@NotNull DataExportOutcome outcome) {
        Intrinsics.checkNotNullParameter((Object)outcome, (String)"outcome");
        this.setAssetDataExportFileId(this.createFileMultipart(outcome.getFile()));
    }

    private final CreateFileMpResponse createFile(String filename) {
        return this.platformService.generateFile(this.containerToken, this.migrationId, filename, "assets-data");
    }

    private final String createFileMultipart(File file2) {
        return this.platformService.uploadMultiPart(this.containerToken, this.migrationId, "assets-export", "assets-data", file2, FileChunkUtility.INSTANCE.calculateChunkSize(file2.length()), (Function0<Unit>)((Function0)createFileMultipart.1.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    private final void publishTombstoneUsers(String migrationScopeId2, Set<String> deletedUserKeys2) {
        List<UserInfo> deletedUsersInfo2 = TombstoneAccountManager.buildDeleteUserMappings$default(this.tombstoneAccountManager, this.task, CollectionsKt.toList((Iterable)deletedUserKeys2), false, publishTombstoneUsers.deletedUsersInfo.1.INSTANCE, 4, null).getDeletedUsersInfo();
        if (!((Collection)deletedUsersInfo2).isEmpty()) {
            Collection<TombstoneUser> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = deletedUsersInfo2;
            String string = migrationScopeId2;
            V4AssetsProcessor v4AssetsProcessor = this;
            boolean $i$f$map = false;
            void var6_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                UserInfo userInfo = (UserInfo)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                String string2 = it.getAaid();
                Intrinsics.checkNotNull((Object)string2);
                collection.add(new TombstoneUser(string2, it.getUserName(), it.getUserKey(), it.getDisplayName()));
            }
            collection = (List)destination$iv$iv;
            v4AssetsProcessor.uploadTombStoneMappings(string, CollectionsKt.toSet((Iterable)collection));
        }
    }

    public final void uploadTombStoneMappings(@NotNull String migrationScopeId2, @NotNull Set<TombstoneUser> tombstoneUsers) {
        Intrinsics.checkNotNullParameter((Object)migrationScopeId2, (String)"migrationScopeId");
        Intrinsics.checkNotNullParameter(tombstoneUsers, (String)"tombstoneUsers");
        this.usersMigrationServiceClient.publishTombstoneUsers(migrationScopeId2, this.task.getCloudSite().getContainerToken(), tombstoneUsers);
        this.platformService.uploadDataToUrl(this.getTombstoneUsersFile(), this.containerToken, this.migrationId, tombstoneUsers, "tombstone-users", (Function0<Unit>)((Function0)uploadTombStoneMappings.1.INSTANCE));
    }

    private final void setHeartbeatScheduler(PrcTask task) {
        this.heartbeatScheduler.scheduleAtFixedRate(PlatformUtilKt.createHeartbeatRunnable((Function0<Unit>)((Function0)new Function0<Unit>(this, task){
            final /* synthetic */ V4AssetsProcessor this$0;
            final /* synthetic */ PrcTask $task;
            {
                this.this$0 = $receiver;
                this.$task = $task;
                super(0);
            }

            public final void invoke() {
                V4AssetsProcessor.access$getPrcStatusUpdateService$p(this.this$0).sendHeartbeat(this.$task);
            }
        }), task, MigrationProtocol.V4), 0L, 1L, PlatformUtilKt.getHEARTBEAT_TIME_UNIT());
    }

    private final void sendStartEvent() {
        this.migrationEventBus.post(new AssetDataUploadStarted(this.task.getCloudId(), this.task.getMigrationId()));
    }

    private final void sendStartEventInitialState(Plan plan2) {
        String string = this.task.getCloudId();
        String string2 = this.task.getMigrationId();
        int n = plan2.getProjectKeys().size();
        List list = plan2.getAssetsSchemaKeys();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        this.migrationEventBus.post(new AssetDataUploadInitialState(string, string2, n, list.size(), plan2.getAssetsDataMigrationMode()));
    }

    private final void sendFailedEvent(Exception ex) {
        this.migrationEventBus.post(new AssetDataUploadFailed(this.task.getCloudId(), this.task.getMigrationId(), ex.getMessage()));
    }

    public final void sendFinalStatus() {
        String string = ((UUID)this.migrationId.getValue()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        MigrationFinalStatusRepository.create$default(this.migrationFinalStatusRepository, string, new AssetExportFinalStatus(this.getAssetDataExportFileId(), this.getTombstoneUsersFile().getFileId()), null, 4, null);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"dataExport", (Object)this.getAssetDataExportFileId()), TuplesKt.to((Object)"tombstoneUsers", (Object)this.getTombstoneUsersFile().getFileId())};
        PrcProgressUpdater.sendFinalStatus$default(this.progressUpdater, TransferStatus.SUCCESS, MapsKt.mapOf((Pair[])pairArray), null, this.task, 4, null);
    }

    private final void sendFinalStatusForShadowMigration(String migrationId) {
        MigrationFinalStatus migrationFinalStatus = MigrationFinalStatusRepository.getShadowMigrationMetadata$default(this.migrationFinalStatusRepository, migrationId, MigrationTaskType.ASSETS_DATA_UPLOAD, null, 4, null);
        if (migrationFinalStatus == null) {
            PrcProgressUpdater.sendFinalStatus$default(this.progressUpdater, TransferStatus.FAILED, null, "No cached data for this migration", this.task, 2, null);
            return;
        }
        MigrationFinalStatus finalStatus = migrationFinalStatus;
        AssetExportFinalStatus cfr_ignored_0 = (AssetExportFinalStatus)finalStatus;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"dataExport", (Object)((AssetExportFinalStatus)finalStatus).getDataExportFile()), TuplesKt.to((Object)"tombstoneUsers", (Object)((AssetExportFinalStatus)finalStatus).getTombstoneUserFile())};
        PrcProgressUpdater.sendFinalStatus$default(this.progressUpdater, TransferStatus.SUCCESS, MapsKt.mapOf((Pair[])pairArray), null, this.task, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    private final DataExportOutcome exportAssetData(Plan plan2) {
        AssetsDataMigrationMode assetsDataMigrationMode;
        List list;
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        this.sendStartEventInitialState(plan2);
        this.log.info(this.task.getMigrationId() + '-' + this.task.getTaskId() + ": Asset data export started");
        Iterable $this$mapNotNull$iv = plan2.getProjectKeys();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Project project = $this$forEach$iv$iv$iv.iterator();
        while (project.hasNext()) {
            Project it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = project.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.projectManager.getProjectObjByKeyIgnoreCase(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            project = (Project)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it.getId());
        }
        List projectIds = (List)destination$iv$iv;
        Object object2 = this.exportFacade;
        List list2 = projectIds;
        List<AssetsSchemaKey> list3 = plan2.getAssetsSchemaKeys();
        if (list3 != null) {
            Collection<String> collection;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            destination$iv$iv = list3;
            List list4 = list2;
            object = object2;
            boolean $i$f$map2 = false;
            $this$forEach$iv$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                AssetsSchemaKey bl = (AssetsSchemaKey)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl4 = false;
                collection.add(it.getSchemaKey());
            }
            collection = (List)destination$iv$iv2;
            object2 = object;
            list2 = list4;
            list = collection;
        } else {
            list = CollectionsKt.emptyList();
        }
        if ((assetsDataMigrationMode = plan2.getAssetsDataMigrationMode()) == null) {
            assetsDataMigrationMode = AssetsDataMigrationMode.NONE;
        }
        DataExportOutcome exportOutcome2 = ExportFacade.exportAssetsData$default((ExportFacade)object2, list2, list, assetsDataMigrationMode, this.migrationMetadata, plan2.getUsersGroupsMigrationOption(), null, this.task, plan2.getId(), 32, null);
        this.log.info(this.task.getMigrationId() + '-' + this.task.getTaskId() + ": generated export file for asset data");
        return exportOutcome2;
    }

    public static final /* synthetic */ PrcStatusUpdateService access$getPrcStatusUpdateService$p(V4AssetsProcessor $this) {
        return $this.prcStatusUpdateService;
    }

    public static final /* synthetic */ CreateFileMpResponse access$createFile(V4AssetsProcessor $this, String filename) {
        return $this.createFile(filename);
    }
}

