/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.assets;

import com.atlassian.jira.migration.GroupedThreadFactory;
import com.atlassian.jira.migration.analytics.MigAssetStatsService;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.export.ExportFacade;
import com.atlassian.jira.migration.migration.MigrationCommand;
import com.atlassian.jira.migration.migration.MigrationCommandService;
import com.atlassian.jira.migration.migration.MigrationProtocol;
import com.atlassian.jira.migration.orchestratorclient.tasks.ProgressUnit;
import com.atlassian.jira.migration.platform.PlatformService;
import com.atlassian.jira.migration.prc.PrcCommandExecutor;
import com.atlassian.jira.migration.prc.PrcStatusUpdateService;
import com.atlassian.jira.migration.prc.model.AssetMigrationPayload;
import com.atlassian.jira.migration.prc.model.PrcCommandPayload;
import com.atlassian.jira.migration.scope.MigrationScopeManager;
import com.atlassian.jira.migration.shadow.db.MigrationFinalStatusRepository;
import com.atlassian.jira.migration.tracking.polling.InProgressMigrationIds;
import com.atlassian.jira.migration.tracking.tasks.PrcTask;
import com.atlassian.jira.migration.tracking.tasks.V4Worker;
import com.atlassian.jira.migration.usersmigrationservice.UsersMigrationServiceClient;
import com.atlassian.jira.migration.workers.MigrationTaskMetadataProvider;
import com.atlassian.jira.migration.workers.WorkerDataConvertor;
import com.atlassian.jira.migration.workers.assets.V4AssetsProcessor;
import com.atlassian.jira.migration.workers.tombstone.TombstoneAccountManager;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.migration.prc.model.CommandName;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u007f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\u0006\u0010\u0019\u001a\u00020\u001a\u0012\u0006\u0010\u001b\u001a\u00020\u001c\u0012\u0006\u0010\u001d\u001a\u00020\u001e\u0012\u0006\u0010\u001f\u001a\u00020 \u00a2\u0006\u0002\u0010!J\u0018\u00108\u001a\u0002092\u0006\u0010:\u001a\u0002002\u0006\u0010;\u001a\u00020<H\u0016J\u0010\u0010=\u001a\u0002092\u0006\u0010>\u001a\u00020?H\u0016R\u0014\u0010\"\u001a\u00020#X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\u00020'X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\u00020+X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010.\u001a\n\u0012\u0006\b\u0001\u0012\u0002000/X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00103\u001a\b\u0012\u0004\u0012\u00020504X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/atlassian/jira/migration/workers/assets/V4AssetsWorker;", "Lcom/atlassian/jira/migration/tracking/tasks/V4Worker;", "Lcom/atlassian/jira/migration/prc/PrcCommandExecutor;", "migrationCommandService", "Lcom/atlassian/jira/migration/migration/MigrationCommandService;", "workerDataConvertor", "Lcom/atlassian/jira/migration/workers/WorkerDataConvertor;", "prcStatusUpdateService", "Lcom/atlassian/jira/migration/prc/PrcStatusUpdateService;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "migrationTaskMetadataProvider", "Lcom/atlassian/jira/migration/workers/MigrationTaskMetadataProvider;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "exportFacade", "Lcom/atlassian/jira/migration/export/ExportFacade;", "migrationScopeManager", "Lcom/atlassian/jira/migration/scope/MigrationScopeManager;", "platformService", "Lcom/atlassian/jira/migration/platform/PlatformService;", "tombstoneAccountManager", "Lcom/atlassian/jira/migration/workers/tombstone/TombstoneAccountManager;", "usersMigrationServiceClient", "Lcom/atlassian/jira/migration/usersmigrationservice/UsersMigrationServiceClient;", "migrationFinalStatusRepository", "Lcom/atlassian/jira/migration/shadow/db/MigrationFinalStatusRepository;", "migrationIds", "Lcom/atlassian/jira/migration/tracking/polling/InProgressMigrationIds;", "migAssetStatsService", "Lcom/atlassian/jira/migration/analytics/MigAssetStatsService;", "(Lcom/atlassian/jira/migration/migration/MigrationCommandService;Lcom/atlassian/jira/migration/workers/WorkerDataConvertor;Lcom/atlassian/jira/migration/prc/PrcStatusUpdateService;Lcom/atlassian/jira/migration/discovery/DiscoveryService;Lcom/atlassian/jira/migration/workers/MigrationTaskMetadataProvider;Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/project/ProjectManager;Lcom/atlassian/jira/migration/export/ExportFacade;Lcom/atlassian/jira/migration/scope/MigrationScopeManager;Lcom/atlassian/jira/migration/platform/PlatformService;Lcom/atlassian/jira/migration/workers/tombstone/TombstoneAccountManager;Lcom/atlassian/jira/migration/usersmigrationservice/UsersMigrationServiceClient;Lcom/atlassian/jira/migration/shadow/db/MigrationFinalStatusRepository;Lcom/atlassian/jira/migration/tracking/polling/InProgressMigrationIds;Lcom/atlassian/jira/migration/analytics/MigAssetStatsService;)V", "commandName", "Lcom/atlassian/migration/prc/model/CommandName;", "getCommandName", "()Lcom/atlassian/migration/prc/model/CommandName;", "id", "", "getId", "()Ljava/lang/String;", "migrationProtocol", "Lcom/atlassian/jira/migration/migration/MigrationProtocol;", "getMigrationProtocol", "()Lcom/atlassian/jira/migration/migration/MigrationProtocol;", "payloadClassType", "Lkotlin/reflect/KClass;", "Lcom/atlassian/jira/migration/prc/model/PrcCommandPayload;", "getPayloadClassType", "()Lkotlin/reflect/KClass;", "supportedUnits", "", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/ProgressUnit;", "getSupportedUnits", "()Ljava/util/List;", "executeTask", "", "commandPayload", "prcCommandId", "", "process", "task", "Lcom/atlassian/jira/migration/tracking/tasks/PrcTask;", "jira-migration-plugin"})
public final class V4AssetsWorker
implements V4Worker,
PrcCommandExecutor {
    @NotNull
    private final MigrationCommandService migrationCommandService;
    @NotNull
    private final WorkerDataConvertor workerDataConvertor;
    @NotNull
    private final PrcStatusUpdateService prcStatusUpdateService;
    @NotNull
    private final DiscoveryService discoveryService;
    @NotNull
    private final MigrationTaskMetadataProvider migrationTaskMetadataProvider;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final ExportFacade exportFacade;
    @NotNull
    private final MigrationScopeManager migrationScopeManager;
    @NotNull
    private final PlatformService platformService;
    @NotNull
    private final TombstoneAccountManager tombstoneAccountManager;
    @NotNull
    private final UsersMigrationServiceClient usersMigrationServiceClient;
    @NotNull
    private final MigrationFinalStatusRepository migrationFinalStatusRepository;
    @NotNull
    private final InProgressMigrationIds migrationIds;
    @NotNull
    private final MigAssetStatsService migAssetStatsService;
    @NotNull
    private final String id;
    @NotNull
    private final MigrationProtocol migrationProtocol;
    @NotNull
    private final List<ProgressUnit> supportedUnits;
    @NotNull
    private final CommandName commandName;
    @NotNull
    private final KClass<? extends PrcCommandPayload> payloadClassType;

    @Inject
    public V4AssetsWorker(@NotNull MigrationCommandService migrationCommandService, @NotNull WorkerDataConvertor workerDataConvertor, @NotNull PrcStatusUpdateService prcStatusUpdateService, @NotNull DiscoveryService discoveryService, @NotNull MigrationTaskMetadataProvider migrationTaskMetadataProvider, @NotNull MigrationEventBus migrationEventBus, @NotNull ProjectManager projectManager, @NotNull ExportFacade exportFacade, @NotNull MigrationScopeManager migrationScopeManager, @NotNull PlatformService platformService, @NotNull TombstoneAccountManager tombstoneAccountManager, @NotNull UsersMigrationServiceClient usersMigrationServiceClient, @NotNull MigrationFinalStatusRepository migrationFinalStatusRepository, @NotNull InProgressMigrationIds migrationIds, @NotNull MigAssetStatsService migAssetStatsService) {
        Intrinsics.checkNotNullParameter((Object)migrationCommandService, (String)"migrationCommandService");
        Intrinsics.checkNotNullParameter((Object)workerDataConvertor, (String)"workerDataConvertor");
        Intrinsics.checkNotNullParameter((Object)prcStatusUpdateService, (String)"prcStatusUpdateService");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)migrationTaskMetadataProvider, (String)"migrationTaskMetadataProvider");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)exportFacade, (String)"exportFacade");
        Intrinsics.checkNotNullParameter((Object)migrationScopeManager, (String)"migrationScopeManager");
        Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
        Intrinsics.checkNotNullParameter((Object)tombstoneAccountManager, (String)"tombstoneAccountManager");
        Intrinsics.checkNotNullParameter((Object)usersMigrationServiceClient, (String)"usersMigrationServiceClient");
        Intrinsics.checkNotNullParameter((Object)migrationFinalStatusRepository, (String)"migrationFinalStatusRepository");
        Intrinsics.checkNotNullParameter((Object)migrationIds, (String)"migrationIds");
        Intrinsics.checkNotNullParameter((Object)migAssetStatsService, (String)"migAssetStatsService");
        this.migrationCommandService = migrationCommandService;
        this.workerDataConvertor = workerDataConvertor;
        this.prcStatusUpdateService = prcStatusUpdateService;
        this.discoveryService = discoveryService;
        this.migrationTaskMetadataProvider = migrationTaskMetadataProvider;
        this.migrationEventBus = migrationEventBus;
        this.projectManager = projectManager;
        this.exportFacade = exportFacade;
        this.migrationScopeManager = migrationScopeManager;
        this.platformService = platformService;
        this.tombstoneAccountManager = tombstoneAccountManager;
        this.usersMigrationServiceClient = usersMigrationServiceClient;
        this.migrationFinalStatusRepository = migrationFinalStatusRepository;
        this.migrationIds = migrationIds;
        this.migAssetStatsService = migAssetStatsService;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.id = string;
        this.migrationProtocol = MigrationProtocol.V4;
        this.supportedUnits = CollectionsKt.listOf((Object)((Object)ProgressUnit.ASSETS_DATA_ENTITY));
        this.commandName = CommandName.ASSETS_DATA_UPLOAD;
        this.payloadClassType = Reflection.getOrCreateKotlinClass(AssetMigrationPayload.class);
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public MigrationProtocol getMigrationProtocol() {
        return this.migrationProtocol;
    }

    @Override
    @NotNull
    public List<ProgressUnit> getSupportedUnits() {
        return this.supportedUnits;
    }

    @Override
    @NotNull
    public CommandName getCommandName() {
        return this.commandName;
    }

    @Override
    @NotNull
    public KClass<? extends PrcCommandPayload> getPayloadClassType() {
        return this.payloadClassType;
    }

    @Override
    public void executeTask(@NotNull PrcCommandPayload commandPayload, long prcCommandId) {
        Intrinsics.checkNotNullParameter((Object)commandPayload, (String)"commandPayload");
        PrcTask task = this.workerDataConvertor.toPrcTaskFromMigrationPayload(commandPayload, prcCommandId, this.getCommandName());
        MigrationCommand migrationCommand = this.migrationCommandService.upsertVersion(task.getMigrationId(), String.valueOf(prcCommandId));
        task.setVersion(migrationCommand.getVersion());
        this.process(task);
    }

    @Override
    public void process(@NotNull PrcTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new GroupedThreadFactory("AssetsWorker"));
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"newSingleThreadScheduledExecutor(...)");
        new V4AssetsProcessor(task, scheduledExecutorService, this.prcStatusUpdateService, this.discoveryService, this.migrationTaskMetadataProvider, this.migrationEventBus, this.projectManager, this.exportFacade, this.migrationScopeManager, this.platformService, this.tombstoneAccountManager, this.usersMigrationServiceClient, this.migrationFinalStatusRepository, this.migrationCommandService, this.migrationIds, this.migAssetStatsService).process();
    }
}

