/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.attachments;

import com.atlassian.jira.migration.httpclient.exceptions.UnexpectedStatusCodeException;
import com.atlassian.jira.migration.plan.ProjectDataMigrationMode;
import com.atlassian.jira.migration.tracking.tasks.Task;
import com.atlassian.jira.migration.workers.attachments.MediaUploadProgress;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001eH&J\u0010\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!H&J\u0014\u0010\"\u001a\u00020\u00112\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$H&J\u0018\u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u0003H&R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u00020\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\r\u00a8\u0006("}, d2={"Lcom/atlassian/jira/migration/workers/attachments/AbstractMediaWorkProgressHandler;", "", "totalUploadDataSize", "", "task", "Lcom/atlassian/jira/migration/tracking/tasks/Task;", "(JLcom/atlassian/jira/migration/tracking/tasks/Task;)V", "atomicFailedItemCount", "Ljava/util/concurrent/atomic/AtomicLong;", "atomicSuccessfullyMigratedBytes", "atomicUploadItemCount", "failedItemCount", "getFailedItemCount", "()J", "handleProgress", "Lkotlin/Function1;", "Lcom/atlassian/jira/migration/workers/attachments/MediaUploadProgress;", "", "getHandleProgress", "()Lkotlin/jvm/functions/Function1;", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "successfullyMigratedBytes", "getSuccessfullyMigratedBytes", "uploadItemCount", "getUploadItemCount", "sendFailedStatusUpdate", "ex", "", "sendFinishedStatusUpdate", "projectDataMigrationMode", "Lcom/atlassian/jira/migration/plan/ProjectDataMigrationMode;", "sendHeartbeat", "msg", "", "sendProgressUpdate", "successfullyCompleted", "total", "jira-migration-plugin"})
public abstract class AbstractMediaWorkProgressHandler {
    private final long totalUploadDataSize;
    @NotNull
    private final Task task;
    @NotNull
    private final AtomicLong atomicSuccessfullyMigratedBytes;
    @NotNull
    private final AtomicLong atomicUploadItemCount;
    @NotNull
    private final AtomicLong atomicFailedItemCount;
    @NotNull
    private final Function1<MediaUploadProgress, Unit> handleProgress;

    public AbstractMediaWorkProgressHandler(long totalUploadDataSize, @NotNull Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.totalUploadDataSize = totalUploadDataSize;
        this.task = task;
        this.atomicSuccessfullyMigratedBytes = new AtomicLong(0L);
        this.atomicUploadItemCount = new AtomicLong(0L);
        this.atomicFailedItemCount = new AtomicLong(0L);
        this.handleProgress = (Function1)new Function1<MediaUploadProgress, Unit>(this){
            final /* synthetic */ AbstractMediaWorkProgressHandler this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull MediaUploadProgress progress) {
                Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
                try {
                    MediaUploadProgress mediaUploadProgress = progress;
                    if (mediaUploadProgress instanceof MediaUploadProgress.UploadedItemCountProgress) {
                        AbstractMediaWorkProgressHandler.access$getAtomicUploadItemCount$p(this.this$0).addAndGet(((MediaUploadProgress.UploadedItemCountProgress)progress).getCount());
                    } else if (mediaUploadProgress instanceof MediaUploadProgress.FailedItemCountProgress) {
                        AbstractMediaWorkProgressHandler.access$getAtomicFailedItemCount$p(this.this$0).addAndGet(((MediaUploadProgress.FailedItemCountProgress)progress).getCount());
                    } else if (mediaUploadProgress instanceof MediaUploadProgress.UploadedChunkSizeProgress) {
                        this.this$0.sendProgressUpdate(AbstractMediaWorkProgressHandler.access$getAtomicSuccessfullyMigratedBytes$p(this.this$0).addAndGet(((MediaUploadProgress.UploadedChunkSizeProgress)progress).getChunkSizeAsLong()), AbstractMediaWorkProgressHandler.access$getTotalUploadDataSize$p(this.this$0));
                    } else if (mediaUploadProgress instanceof MediaUploadProgress.NoChangeProgress) {
                        AbstractMediaWorkProgressHandler.sendHeartbeat$default(this.this$0, null, 1, null);
                    }
                }
                catch (Throwable ex) {
                    String errorPrefix = AbstractMediaWorkProgressHandler.access$getTask$p(this.this$0).getMigrationId() + '-' + AbstractMediaWorkProgressHandler.access$getTask$p(this.this$0).getTaskId() + ": couldn't update media upload status";
                    Throwable cause = ex.getCause();
                    if (cause instanceof UnexpectedStatusCodeException) {
                        this.this$0.getLog().warn(errorPrefix + " due to unexpected status code: " + ((UnexpectedStatusCodeException)cause).getStatusCode());
                    } else {
                        this.this$0.getLog().warn(errorPrefix, ex);
                    }
                    throw ex;
                }
            }
        };
    }

    @NotNull
    public abstract Logger getLog();

    public final long getSuccessfullyMigratedBytes() {
        return this.atomicSuccessfullyMigratedBytes.longValue();
    }

    public final long getUploadItemCount() {
        return this.atomicUploadItemCount.longValue();
    }

    public final long getFailedItemCount() {
        return this.atomicFailedItemCount.longValue();
    }

    @NotNull
    public final Function1<MediaUploadProgress, Unit> getHandleProgress() {
        return this.handleProgress;
    }

    public abstract void sendProgressUpdate(long var1, long var3);

    public abstract void sendHeartbeat(@Nullable String var1);

    public static /* synthetic */ void sendHeartbeat$default(AbstractMediaWorkProgressHandler abstractMediaWorkProgressHandler, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sendHeartbeat");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        abstractMediaWorkProgressHandler.sendHeartbeat(string);
    }

    public abstract void sendFinishedStatusUpdate(@NotNull ProjectDataMigrationMode var1);

    public abstract void sendFailedStatusUpdate(@NotNull Throwable var1);

    public static final /* synthetic */ AtomicLong access$getAtomicUploadItemCount$p(AbstractMediaWorkProgressHandler $this) {
        return $this.atomicUploadItemCount;
    }

    public static final /* synthetic */ AtomicLong access$getAtomicFailedItemCount$p(AbstractMediaWorkProgressHandler $this) {
        return $this.atomicFailedItemCount;
    }

    public static final /* synthetic */ AtomicLong access$getAtomicSuccessfullyMigratedBytes$p(AbstractMediaWorkProgressHandler $this) {
        return $this.atomicSuccessfullyMigratedBytes;
    }

    public static final /* synthetic */ long access$getTotalUploadDataSize$p(AbstractMediaWorkProgressHandler $this) {
        return $this.totalUploadDataSize;
    }

    public static final /* synthetic */ Task access$getTask$p(AbstractMediaWorkProgressHandler $this) {
        return $this.task;
    }
}

