/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.attachments;

import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.AttachmentReadException;
import com.atlassian.jira.issue.attachment.NoAttachmentDataException;
import com.atlassian.jira.migration.analytics.MetricsEventService;
import com.atlassian.jira.migration.datafilters.model.DataFilterContext;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.log.AttachmentExportMessage;
import com.atlassian.jira.migration.log.ExportLog;
import com.atlassian.jira.migration.log.ExportMessageDetails;
import com.atlassian.jira.migration.log.ExportMessageSeverity;
import com.atlassian.jira.migration.mediaclient.MediaClient;
import com.atlassian.jira.migration.migration.MigratedFileEntity;
import com.atlassian.jira.migration.migration.MigratedFileRepository;
import com.atlassian.jira.migration.orchestratorclient.tasks.AdaptedTransferProjectTask;
import com.atlassian.jira.migration.orchestratorclient.tasks.MigrationTask;
import com.atlassian.jira.migration.plan.ProjectDataMigrationMode;
import com.atlassian.jira.migration.serverdataextractors.attachments.JiraAttachmentsService;
import com.atlassian.jira.migration.tracking.tasks.Task;
import com.atlassian.jira.migration.workers.attachments.AbstractMediaProcessorKt;
import com.atlassian.jira.migration.workers.attachments.AttachmentExportMessageGenerator;
import com.atlassian.jira.migration.workers.attachments.AttachmentMigrator;
import com.atlassian.jira.migration.workers.attachments.MediaMigrator;
import com.atlassian.jira.migration.workers.attachments.MediaUploadLogger;
import com.atlassian.jira.migration.workers.attachments.MediaUploadProgress;
import com.atlassian.jira.migration.workers.attachments.MediaUploadRequest;
import com.atlassian.jira.migration.workers.attachments.MediaUploader;
import com.atlassian.jira.migration.workers.attachments.UploadRequestType;
import com.atlassian.jira.migration.workers.attachments.UploadableAttachment;
import com.atlassian.jira.migration.workers.attachments.UploadableItem;
import com.atlassian.jira.migration.workers.attachments.VirtualAttachmentFileService;
import com.atlassian.jira.util.io.InputStreamConsumer;
import java.io.Closeable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 E2\u00020\u0001:\u0001EBc\b\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J&\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0016Jz\u0010!\u001a2\u0012\u0013\u0012\u00110#\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(&\u0012\u0013\u0012\u00110'\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b((\u0012\u0004\u0012\u00020 0\"2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00040,2\u0006\u0010-\u001a\u00020.2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020 00H\u0002JH\u00102\u001a2\u0012\u0013\u0012\u00110#\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(&\u0012\u0013\u0012\u00110\u001d\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(3\u0012\u0004\u0012\u00020 0\"2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u00104\u001a\u00020\u001dH\u0002J \u00105\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020#2\u0006\u00106\u001a\u00020\u001dH\u0002J:\u00107\u001a\b\u0012\u0004\u0012\u000209082\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020 002\u0006\u0010:\u001a\u00020;H\u0002J\u001a\u0010<\u001a\u0004\u0018\u00010=2\u0006\u0010>\u001a\u0002092\u0006\u00104\u001a\u00020\u001dH\u0002J\u0012\u0010?\u001a\u0004\u0018\u00010\u001d2\u0006\u0010@\u001a\u00020AH\u0002J4\u0010B\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020 002\u0006\u0010:\u001a\u00020;H\u0016J<\u0010C\u001a\u00020 2\u0006\u00104\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020 002\u0006\u0010:\u001a\u00020;H\u0002J4\u0010D\u001a\u00020 2\u0006\u00104\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020 00H\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/atlassian/jira/migration/workers/attachments/AttachmentMigrator;", "Lcom/atlassian/jira/migration/workers/attachments/MediaMigrator;", "mediaUploader", "Lcom/atlassian/jira/migration/workers/attachments/MediaUploader;", "Lcom/atlassian/jira/migration/workers/attachments/UploadableAttachment;", "attachmentManager", "Lcom/atlassian/jira/issue/AttachmentManager;", "attachmentsService", "Lcom/atlassian/jira/migration/serverdataextractors/attachments/JiraAttachmentsService;", "migratedFileRepository", "Lcom/atlassian/jira/migration/migration/MigratedFileRepository;", "mediaUploadLogger", "Lcom/atlassian/jira/migration/workers/attachments/MediaUploadLogger;", "attachmentExportMessageGenerator", "Lcom/atlassian/jira/migration/workers/attachments/AttachmentExportMessageGenerator;", "mediaClient", "Lcom/atlassian/jira/migration/mediaclient/MediaClient;", "virtualAttachmentFileService", "Lcom/atlassian/jira/migration/workers/attachments/VirtualAttachmentFileService;", "metricsEventService", "Lcom/atlassian/jira/migration/analytics/MetricsEventService;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "(Lcom/atlassian/jira/migration/workers/attachments/MediaUploader;Lcom/atlassian/jira/issue/AttachmentManager;Lcom/atlassian/jira/migration/serverdataextractors/attachments/JiraAttachmentsService;Lcom/atlassian/jira/migration/migration/MigratedFileRepository;Lcom/atlassian/jira/migration/workers/attachments/MediaUploadLogger;Lcom/atlassian/jira/migration/workers/attachments/AttachmentExportMessageGenerator;Lcom/atlassian/jira/migration/mediaclient/MediaClient;Lcom/atlassian/jira/migration/workers/attachments/VirtualAttachmentFileService;Lcom/atlassian/jira/migration/analytics/MetricsEventService;Lcom/atlassian/jira/migration/discovery/DiscoveryService;)V", "calculateTotalDataSize", "", "task", "Lcom/atlassian/jira/migration/tracking/tasks/Task;", "projectKey", "", "heartbeat", "Lkotlin/Function0;", "", "doOnItemFailure", "Lkotlin/Function2;", "Lcom/atlassian/jira/migration/workers/attachments/UploadableItem;", "Lkotlin/ParameterName;", "name", "uploadableItem", "", "e", "exportLog", "Lcom/atlassian/jira/migration/log/ExportLog;", "uploadRequest", "Lcom/atlassian/jira/migration/workers/attachments/MediaUploadRequest;", "missingAttachmentCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "uploadProgress", "Lkotlin/Function1;", "Lcom/atlassian/jira/migration/workers/attachments/MediaUploadProgress;", "doOnItemSuccess", "uploadId", "mediaClientId", "generateErrorMessage", "cause", "getAttachments", "Lkotlin/sequences/Sequence;", "Lcom/atlassian/jira/issue/attachment/Attachment;", "dataFilterContext", "Lcom/atlassian/jira/migration/datafilters/model/DataFilterContext;", "getMigratedFileFor", "Lcom/atlassian/jira/migration/migration/MigratedFileEntity;", "attachment", "getTransferIdForMigrationTask", "migrationTask", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/MigrationTask;", "process", "processAttachments", "processVirtualAttachments", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAttachmentMigrator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttachmentMigrator.kt\ncom/atlassian/jira/migration/workers/attachments/AttachmentMigrator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,267:1\n1#2:268\n*E\n"})
public final class AttachmentMigrator
implements MediaMigrator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MediaUploader<UploadableAttachment> mediaUploader;
    @NotNull
    private final AttachmentManager attachmentManager;
    @NotNull
    private final JiraAttachmentsService attachmentsService;
    @NotNull
    private final MigratedFileRepository migratedFileRepository;
    @NotNull
    private final MediaUploadLogger<UploadableAttachment> mediaUploadLogger;
    @NotNull
    private final AttachmentExportMessageGenerator attachmentExportMessageGenerator;
    @NotNull
    private final MediaClient mediaClient;
    @NotNull
    private final VirtualAttachmentFileService virtualAttachmentFileService;
    @NotNull
    private final MetricsEventService metricsEventService;
    @NotNull
    private final DiscoveryService discoveryService;
    private static final Logger log = LoggerFactory.getLogger(AttachmentMigrator.class);
    @NotNull
    private static final String FILE_DOES_NOT_EXIST = "file does not exist";
    @NotNull
    private static final String NO_READ_PERMISSIONS = "file does not have read permissions";
    @NotNull
    private static final String SUCCESS = "Success";
    @NotNull
    private static final String FAILED = "Failed";

    @Inject
    public AttachmentMigrator(@NotNull MediaUploader<UploadableAttachment> mediaUploader, @NotNull AttachmentManager attachmentManager, @NotNull JiraAttachmentsService attachmentsService, @NotNull MigratedFileRepository migratedFileRepository, @NotNull MediaUploadLogger<UploadableAttachment> mediaUploadLogger, @NotNull AttachmentExportMessageGenerator attachmentExportMessageGenerator, @NotNull MediaClient mediaClient, @NotNull VirtualAttachmentFileService virtualAttachmentFileService, @NotNull MetricsEventService metricsEventService, @NotNull DiscoveryService discoveryService) {
        Intrinsics.checkNotNullParameter(mediaUploader, (String)"mediaUploader");
        Intrinsics.checkNotNullParameter((Object)attachmentManager, (String)"attachmentManager");
        Intrinsics.checkNotNullParameter((Object)attachmentsService, (String)"attachmentsService");
        Intrinsics.checkNotNullParameter((Object)migratedFileRepository, (String)"migratedFileRepository");
        Intrinsics.checkNotNullParameter(mediaUploadLogger, (String)"mediaUploadLogger");
        Intrinsics.checkNotNullParameter((Object)attachmentExportMessageGenerator, (String)"attachmentExportMessageGenerator");
        Intrinsics.checkNotNullParameter((Object)mediaClient, (String)"mediaClient");
        Intrinsics.checkNotNullParameter((Object)virtualAttachmentFileService, (String)"virtualAttachmentFileService");
        Intrinsics.checkNotNullParameter((Object)metricsEventService, (String)"metricsEventService");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        this.mediaUploader = mediaUploader;
        this.attachmentManager = attachmentManager;
        this.attachmentsService = attachmentsService;
        this.migratedFileRepository = migratedFileRepository;
        this.mediaUploadLogger = mediaUploadLogger;
        this.attachmentExportMessageGenerator = attachmentExportMessageGenerator;
        this.mediaClient = mediaClient;
        this.virtualAttachmentFileService = virtualAttachmentFileService;
        this.metricsEventService = metricsEventService;
        this.discoveryService = discoveryService;
    }

    @Override
    public long calculateTotalDataSize(@NotNull Task task, @NotNull String projectKey, @NotNull Function0<Unit> heartbeat2) {
        long l;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        Intrinsics.checkNotNullParameter(heartbeat2, (String)"heartbeat");
        log.info(task.getMigrationId() + '-' + task.getTaskId() + ": calculating total attachments size for project key " + projectKey);
        long it = l = this.attachmentsService.getTotalAttachmentsSizeByProject(projectKey);
        boolean bl = false;
        log.info(task.getMigrationId() + '-' + task.getTaskId() + ": calculating total attachments size(" + it + ") for project key " + projectKey + " complete");
        return l;
    }

    @Override
    public void process(@NotNull Task task, @NotNull String projectKey, @NotNull Function1<? super MediaUploadProgress, Unit> uploadProgress, @NotNull DataFilterContext dataFilterContext) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        Intrinsics.checkNotNullParameter(uploadProgress, (String)"uploadProgress");
        Intrinsics.checkNotNullParameter((Object)dataFilterContext, (String)"dataFilterContext");
        try {
            log.info(task.getMigrationId() + '-' + task.getTaskId() + ": Uploading attachments for project key " + projectKey);
            String mediaClientId = this.mediaClient.getMediaClientId(AbstractMediaProcessorKt.getContainerToken(task));
            this.processAttachments(mediaClientId, task, projectKey, uploadProgress, dataFilterContext);
            this.processVirtualAttachments(mediaClientId, task, projectKey, uploadProgress);
            log.info(task.getMigrationId() + '-' + task.getTaskId() + ": uploaded attachments for project key " + projectKey);
        }
        catch (Exception ex) {
            log.warn(task.getMigrationId() + '-' + task.getTaskId() + ": error in attachments upload task for project key " + projectKey, (Throwable)ex);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processVirtualAttachments(String mediaClientId, Task task, String projectKey, Function1<? super MediaUploadProgress, Unit> uploadProgress) {
        MediaUploadRequest<UploadableAttachment> virtualAttachmentUploadRequest = new MediaUploadRequest<UploadableAttachment>(AbstractMediaProcessorKt.getContainerToken(task), task.getMigrationId(), projectKey, CollectionsKt.asSequence((Iterable)this.virtualAttachmentFileService.getAttachmentsForUpload(mediaClientId)), UploadRequestType.VIRTUAL_ATTACHMENT);
        Closeable closeable = this.mediaUploadLogger.getLog(virtualAttachmentUploadRequest);
        Throwable throwable = null;
        try {
            ExportLog exportLog = (ExportLog)closeable;
            boolean bl = false;
            this.mediaUploader.uploadMediaInParallel(virtualAttachmentUploadRequest, uploadProgress, this.doOnItemSuccess(task, mediaClientId), (Function2<UploadableAttachment, Throwable, Unit>)((Function2)new Function2<UploadableAttachment, Throwable, Unit>(exportLog, this, virtualAttachmentUploadRequest){
                final /* synthetic */ ExportLog $exportLog;
                final /* synthetic */ AttachmentMigrator this$0;
                final /* synthetic */ MediaUploadRequest<UploadableAttachment> $virtualAttachmentUploadRequest;
                {
                    this.$exportLog = $exportLog;
                    this.this$0 = $receiver;
                    this.$virtualAttachmentUploadRequest = $virtualAttachmentUploadRequest;
                    super(2);
                }

                public final void invoke(@NotNull UploadableAttachment uploadableItem, @NotNull Throwable e) {
                    Intrinsics.checkNotNullParameter((Object)uploadableItem, (String)"uploadableItem");
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    AttachmentMigrator.access$getLog$cp().error("creating file in Media failed for attachment = " + uploadableItem.getId());
                    AttachmentExportMessageGenerator attachmentExportMessageGenerator = AttachmentMigrator.access$getAttachmentExportMessageGenerator$p(this.this$0);
                    Attachment attachment = AttachmentMigrator.access$getAttachmentManager$p(this.this$0).getAttachment(Long.valueOf(uploadableItem.getId()));
                    Intrinsics.checkNotNullExpressionValue((Object)attachment, (String)"getAttachment(...)");
                    this.$exportLog.putExportMessage(attachmentExportMessageGenerator.generate(this.$virtualAttachmentUploadRequest, attachment, e));
                    throw e;
                }
            }));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processAttachments(String mediaClientId, Task task, String projectKey, Function1<? super MediaUploadProgress, Unit> uploadProgress, DataFilterContext dataFilterContext) {
        MediaUploadRequest<UploadableAttachment> uploadRequest2 = new MediaUploadRequest<UploadableAttachment>(AbstractMediaProcessorKt.getContainerToken(task), task.getMigrationId(), projectKey, SequencesKt.map((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filterNot(this.getAttachments(task, projectKey, uploadProgress, dataFilterContext), (Function1)processAttachments.uploadRequest.1.INSTANCE), (Function1)((Function1)new Function1<Attachment, Pair<? extends Attachment, ? extends MigratedFileEntity>>(this, mediaClientId){
            final /* synthetic */ AttachmentMigrator this$0;
            final /* synthetic */ String $mediaClientId;
            {
                this.this$0 = $receiver;
                this.$mediaClientId = $mediaClientId;
                super(1);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Pair<Attachment, MigratedFileEntity> invoke(@NotNull Attachment attachment) {
                MigratedFileEntity migratedFileEntity;
                Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
                MigratedFileEntity migratedFileEntity2 = AttachmentMigrator.access$getMigratedFileFor(this.this$0, attachment, this.$mediaClientId);
                if (migratedFileEntity2 == null) return null;
                MigratedFileEntity it = migratedFileEntity = migratedFileEntity2;
                boolean bl = false;
                if (it.getMigrated()) return null;
                boolean bl2 = true;
                if (!bl2) return null;
                MigratedFileEntity migratedFileEntity3 = migratedFileEntity;
                MigratedFileEntity migratedFileEntity4 = migratedFileEntity3;
                if (migratedFileEntity4 == null) return null;
                it = migratedFileEntity4;
                boolean bl3 = false;
                Pair pair = TuplesKt.to((Object)attachment, (Object)it);
                return pair;
            }
        })), (Function1)((Function1)new Function1<Pair<? extends Attachment, ? extends MigratedFileEntity>, UploadableAttachment>(this){
            final /* synthetic */ AttachmentMigrator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final UploadableAttachment invoke(@NotNull Pair<? extends Attachment, MigratedFileEntity> pair) {
                Intrinsics.checkNotNullParameter(pair, (String)"<name for destructuring parameter 0>");
                Attachment attachment = (Attachment)pair.component1();
                MigratedFileEntity migratedFile = (MigratedFileEntity)pair.component2();
                Long l = attachment.getId();
                Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
                long l2 = ((Number)l).longValue();
                String string = migratedFile.getFileMediaId();
                String string2 = attachment.getFilename();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFilename(...)");
                Long l3 = attachment.getFilesize();
                Intrinsics.checkNotNullExpressionValue((Object)l3, (String)"getFilesize(...)");
                return new UploadableAttachment(l2, string, string2, ((Number)l3).longValue(), (Function1<? super InputStreamConsumer<Unit>, Unit>)((Function1)new Function1<InputStreamConsumer<Unit>, Unit>(this.this$0, attachment){
                    final /* synthetic */ AttachmentMigrator this$0;
                    final /* synthetic */ Attachment $attachment;
                    {
                        this.this$0 = $receiver;
                        this.$attachment = $attachment;
                        super(1);
                    }

                    public final void invoke(@NotNull InputStreamConsumer<Unit> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        AttachmentMigrator.access$getAttachmentManager$p(this.this$0).streamAttachmentContent(this.$attachment, it);
                    }
                }));
            }
        })), null, 16, null);
        Closeable closeable = this.mediaUploadLogger.getLog(uploadRequest2);
        Throwable throwable = null;
        try {
            ExportLog exportLog = (ExportLog)closeable;
            boolean bl = false;
            AtomicInteger missingAttachmentCount = new AtomicInteger(0);
            this.mediaUploader.uploadMediaInParallel(uploadRequest2, uploadProgress, this.doOnItemSuccess(task, mediaClientId), this.doOnItemFailure(task, projectKey, exportLog, uploadRequest2, missingAttachmentCount, uploadProgress));
            if (missingAttachmentCount.get() > 0) {
                exportLog.putExportMessage(new AttachmentExportMessage(null, uploadRequest2.getProjectKey(), new ExportMessageDetails("Found " + missingAttachmentCount + " missing attachments.", ExportErrorCode.MISSING_ATTACHMENTS_FOUND.getValue(), "Run the Instance Health check and fix all errors before migrating.", null, 8, null), ExportMessageSeverity.WARNING));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final Function2<UploadableItem, Throwable, Unit> doOnItemFailure(Task task, String projectKey, ExportLog exportLog, MediaUploadRequest<UploadableAttachment> uploadRequest2, AtomicInteger missingAttachmentCount, Function1<? super MediaUploadProgress, Unit> uploadProgress) {
        return (Function2)new Function2<UploadableItem, Throwable, Unit>(missingAttachmentCount, this, task, projectKey, uploadProgress, exportLog, uploadRequest2){
            final /* synthetic */ AtomicInteger $missingAttachmentCount;
            final /* synthetic */ AttachmentMigrator this$0;
            final /* synthetic */ Task $task;
            final /* synthetic */ String $projectKey;
            final /* synthetic */ Function1<MediaUploadProgress, Unit> $uploadProgress;
            final /* synthetic */ ExportLog $exportLog;
            final /* synthetic */ MediaUploadRequest<UploadableAttachment> $uploadRequest;
            {
                this.$missingAttachmentCount = $missingAttachmentCount;
                this.this$0 = $receiver;
                this.$task = $task;
                this.$projectKey = $projectKey;
                this.$uploadProgress = $uploadProgress;
                this.$exportLog = $exportLog;
                this.$uploadRequest = $uploadRequest;
                super(2);
            }

            public final void invoke(@NotNull UploadableItem uploadableItem, @NotNull Throwable e) {
                Intrinsics.checkNotNullParameter((Object)uploadableItem, (String)"uploadableItem");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Throwable throwable = e;
                if (throwable instanceof NoAttachmentDataException) {
                    this.$missingAttachmentCount.incrementAndGet();
                    AttachmentMigrator.access$getLog$cp().info("no data for attachment " + uploadableItem.getId() + ", ignoring");
                    AttachmentMigrator.access$getMediaUploadLogger$p(this.this$0).storeErrorLog(this.$task, AttachmentMigrator.access$generateErrorMessage(this.this$0, this.$projectKey, uploadableItem, "file does not exist"));
                } else if (throwable instanceof AttachmentReadException) {
                    this.$missingAttachmentCount.incrementAndGet();
                    AttachmentMigrator.access$getLog$cp().info("no read permissions for attachment " + uploadableItem.getId() + ", ignoring");
                    AttachmentMigrator.access$getMediaUploadLogger$p(this.this$0).storeErrorLog(this.$task, AttachmentMigrator.access$generateErrorMessage(this.this$0, this.$projectKey, uploadableItem, "file does not have read permissions"));
                } else {
                    AttachmentMigrator.access$getLog$cp().warn("creating file in Media failed for attachment = " + uploadableItem.getId());
                    this.$uploadProgress.invoke((Object)new MediaUploadProgress.FailedItemCountProgress(1L));
                    AttachmentExportMessageGenerator attachmentExportMessageGenerator = AttachmentMigrator.access$getAttachmentExportMessageGenerator$p(this.this$0);
                    Attachment attachment = AttachmentMigrator.access$getAttachmentManager$p(this.this$0).getAttachment(Long.valueOf(uploadableItem.getId()));
                    Intrinsics.checkNotNullExpressionValue((Object)attachment, (String)"getAttachment(...)");
                    this.$exportLog.putExportMessage(attachmentExportMessageGenerator.generate(this.$uploadRequest, attachment, e));
                    MetricsEventService.sendEventForAttachmentUploadStatus$default(AttachmentMigrator.access$getMetricsEventService$p(this.this$0), this.$task.getMigrationTask().getMigrationTaskType(), "Failed", this.$task.getCloudId(), this.$task.getMigrationId(), AttachmentMigrator.access$getTransferIdForMigrationTask(this.this$0, this.$task.getMigrationTask()), 0.0, 32, null);
                    throw e;
                }
            }
        };
    }

    private final String getTransferIdForMigrationTask(MigrationTask migrationTask) {
        return migrationTask instanceof AdaptedTransferProjectTask ? ((AdaptedTransferProjectTask)migrationTask).getTransferId() : null;
    }

    private final String generateErrorMessage(String projectKey, UploadableItem uploadableItem, String cause) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd hh-mm-ss");
        String dateTime = formatter.format(LocalDateTime.now());
        return dateTime + " Missing attachment " + uploadableItem.getId() + " for project " + projectKey + ". File name: " + uploadableItem.getFileName() + ". Media ID: " + uploadableItem.getFileMediaId() + ". Cause: " + cause;
    }

    private final Function2<UploadableItem, String, Unit> doOnItemSuccess(Task task, String mediaClientId) {
        return (Function2)new Function2<UploadableItem, String, Unit>(this, mediaClientId, task){
            final /* synthetic */ AttachmentMigrator this$0;
            final /* synthetic */ String $mediaClientId;
            final /* synthetic */ Task $task;
            {
                this.this$0 = $receiver;
                this.$mediaClientId = $mediaClientId;
                this.$task = $task;
                super(2);
            }

            public final void invoke(@NotNull UploadableItem uploadableItem, @NotNull String uploadId) {
                Intrinsics.checkNotNullParameter((Object)uploadableItem, (String)"uploadableItem");
                Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
                MigratedFileEntity migratedFileEntity = AttachmentMigrator.access$getMigratedFileRepository$p(this.this$0).findMigratedFile(uploadableItem.getId(), this.$mediaClientId);
                if (migratedFileEntity != null) {
                    MigratedFileEntity migratedFileEntity2;
                    MigratedFileEntity it = migratedFileEntity2 = migratedFileEntity;
                    boolean bl = false;
                    AttachmentMigrator.access$getLog$cp().debug("found migrated file entry for attachment " + uploadableItem.getId() + " in DB");
                    AttachmentMigrator attachmentMigrator = this.this$0;
                    MigratedFileEntity it2 = migratedFileEntity2;
                    boolean bl2 = false;
                    AttachmentMigrator.access$getMigratedFileRepository$p(attachmentMigrator).recordMigration(it2.getFileServerId(), it2.getFileMediaId(), it2.getMediaClientId(), true, uploadId);
                }
                AttachmentMigrator.access$getLog$cp().debug("created file in Media for attachment " + uploadableItem.getId());
                MetricsEventService.sendEventForAttachmentUploadStatus$default(AttachmentMigrator.access$getMetricsEventService$p(this.this$0), this.$task.getMigrationTask().getMigrationTaskType(), "Success", this.$task.getCloudId(), this.$task.getMigrationId(), AttachmentMigrator.access$getTransferIdForMigrationTask(this.this$0, this.$task.getMigrationTask()), 0.0, 32, null);
            }
        };
    }

    private final MigratedFileEntity getMigratedFileFor(Attachment attachment, String mediaClientId) {
        MigratedFileEntity migratedFileEntity;
        Long l = attachment.getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        MigratedFileEntity migratedFileEntity2 = this.migratedFileRepository.findMigratedFile(((Number)l).longValue(), mediaClientId);
        if (migratedFileEntity2 != null) {
            MigratedFileEntity migratedFileEntity3;
            MigratedFileEntity it = migratedFileEntity3 = migratedFileEntity2;
            boolean bl = false;
            log.debug("found migrated file entry for attachment " + attachment.getId() + " in DB");
            migratedFileEntity = migratedFileEntity3;
        } else {
            migratedFileEntity = null;
        }
        return migratedFileEntity;
    }

    private final Sequence<Attachment> getAttachments(Task task, String projectKey, Function1<? super MediaUploadProgress, Unit> uploadProgress, DataFilterContext dataFilterContext) {
        Sequence<Attachment> sequence;
        log.info(task.getMigrationId() + '-' + task.getTaskId() + ": initiating attachments sequence for project key " + projectKey);
        ProjectDataMigrationMode projectDataMode = DiscoveryService.retrievePlanFor$default(this.discoveryService, task, false, 2, null).getProjectDataMigrationMode();
        Sequence<Attachment> it = sequence = this.attachmentsService.getAttachmentsByProject(projectKey, (Function0<Unit>)((Function0)new Function0<Unit>(uploadProgress){
            final /* synthetic */ Function1<MediaUploadProgress, Unit> $uploadProgress;
            {
                this.$uploadProgress = $uploadProgress;
                super(0);
            }

            public final void invoke() {
                this.$uploadProgress.invoke((Object)MediaUploadProgress.NoChangeProgress.INSTANCE);
            }
        }), dataFilterContext, task.getMigrationId(), task.getCloudId(), projectDataMode);
        boolean bl = false;
        log.info(task.getMigrationId() + '-' + task.getTaskId() + ": initiating attachments sequence for project key " + projectKey + " complete");
        return sequence;
    }

    public static final /* synthetic */ MigratedFileEntity access$getMigratedFileFor(AttachmentMigrator $this, Attachment attachment, String mediaClientId) {
        return $this.getMigratedFileFor(attachment, mediaClientId);
    }

    public static final /* synthetic */ AttachmentManager access$getAttachmentManager$p(AttachmentMigrator $this) {
        return $this.attachmentManager;
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    public static final /* synthetic */ MediaUploadLogger access$getMediaUploadLogger$p(AttachmentMigrator $this) {
        return $this.mediaUploadLogger;
    }

    public static final /* synthetic */ String access$generateErrorMessage(AttachmentMigrator $this, String projectKey, UploadableItem uploadableItem, String cause) {
        return $this.generateErrorMessage(projectKey, uploadableItem, cause);
    }

    public static final /* synthetic */ AttachmentExportMessageGenerator access$getAttachmentExportMessageGenerator$p(AttachmentMigrator $this) {
        return $this.attachmentExportMessageGenerator;
    }

    public static final /* synthetic */ MetricsEventService access$getMetricsEventService$p(AttachmentMigrator $this) {
        return $this.metricsEventService;
    }

    public static final /* synthetic */ String access$getTransferIdForMigrationTask(AttachmentMigrator $this, MigrationTask migrationTask) {
        return $this.getTransferIdForMigrationTask(migrationTask);
    }

    public static final /* synthetic */ MigratedFileRepository access$getMigratedFileRepository$p(AttachmentMigrator $this) {
        return $this.migratedFileRepository;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/workers/attachments/AttachmentMigrator$Companion;", "", "()V", "FAILED", "", "FILE_DOES_NOT_EXIST", "NO_READ_PERMISSIONS", "SUCCESS", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

