/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.attachments;

import com.atlassian.jira.migration.avatar.Avatar;
import com.atlassian.jira.migration.avatar.MediaUploadInfo;
import com.atlassian.jira.migration.datafilters.model.DataFilterContext;
import com.atlassian.jira.migration.log.ExportLog;
import com.atlassian.jira.migration.mediaclient.MediaClient;
import com.atlassian.jira.migration.tracking.tasks.Task;
import com.atlassian.jira.migration.workers.attachments.AbstractMediaProcessorKt;
import com.atlassian.jira.migration.workers.attachments.AvatarExportMessageGenerator;
import com.atlassian.jira.migration.workers.attachments.AvatarMigrator;
import com.atlassian.jira.migration.workers.attachments.MediaMigrator;
import com.atlassian.jira.migration.workers.attachments.MediaUploadLogger;
import com.atlassian.jira.migration.workers.attachments.MediaUploadProgress;
import com.atlassian.jira.migration.workers.attachments.MediaUploadRequest;
import com.atlassian.jira.migration.workers.attachments.MediaUploader;
import com.atlassian.jira.migration.workers.attachments.UploadRequestType;
import com.atlassian.jira.migration.workers.attachments.UploadableAvatar;
import com.atlassian.jira.project.ProjectManager;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 32\u00020\u0001:\u00013BC\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ&\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0015H\u0002J\u0018\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0015H\u0002JN\u0010\u001f\u001a2\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(#\u0012\u0013\u0012\u00110$\u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(%\u0012\u0004\u0012\u00020\u00180 2\u0006\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00060)H\u0002J@\u0010*\u001a2\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(+\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(,\u0012\u0004\u0012\u00020\u00180 2\u0006\u0010\u001d\u001a\u00020\u0015H\u0007J4\u0010-\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\u00180/2\u0006\u00101\u001a\u000202H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/atlassian/jira/migration/workers/attachments/AvatarMigrator;", "Lcom/atlassian/jira/migration/workers/attachments/MediaMigrator;", "avatarFacade", "Lcom/atlassian/jira/migration/avatar/Avatar$Facade;", "mediaUploader", "Lcom/atlassian/jira/migration/workers/attachments/MediaUploader;", "Lcom/atlassian/jira/migration/workers/attachments/UploadableAvatar;", "mediaUploadLogger", "Lcom/atlassian/jira/migration/workers/attachments/MediaUploadLogger;", "avatarExportMessageGenerator", "Lcom/atlassian/jira/migration/workers/attachments/AvatarExportMessageGenerator;", "mediaClient", "Lcom/atlassian/jira/migration/mediaclient/MediaClient;", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "(Lcom/atlassian/jira/migration/avatar/Avatar$Facade;Lcom/atlassian/jira/migration/workers/attachments/MediaUploader;Lcom/atlassian/jira/migration/workers/attachments/MediaUploadLogger;Lcom/atlassian/jira/migration/workers/attachments/AvatarExportMessageGenerator;Lcom/atlassian/jira/migration/mediaclient/MediaClient;Lcom/atlassian/jira/project/ProjectManager;)V", "calculateTotalDataSize", "", "task", "Lcom/atlassian/jira/migration/tracking/tasks/Task;", "projectKey", "", "heartbeat", "Lkotlin/Function0;", "", "createMigrationFileIfNotExists", "Lcom/atlassian/jira/migration/avatar/Avatar$MigratedInfo;", "avatar", "Lcom/atlassian/jira/migration/avatar/Avatar$Info;", "mediaClientId", "createMigrationFileWithFileMediaId", "doOnItemFailure", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "uploadableItem", "", "e", "exportLog", "Lcom/atlassian/jira/migration/log/ExportLog;", "uploadRequest", "Lcom/atlassian/jira/migration/workers/attachments/MediaUploadRequest;", "doOnItemSuccess", "uploadableAvatar", "uploadId", "process", "uploadProgress", "Lkotlin/Function1;", "Lcom/atlassian/jira/migration/workers/attachments/MediaUploadProgress;", "dataFilterContext", "Lcom/atlassian/jira/migration/datafilters/model/DataFilterContext;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAvatarMigrator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AvatarMigrator.kt\ncom/atlassian/jira/migration/workers/attachments/AvatarMigrator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,155:1\n1#2:156\n*E\n"})
public final class AvatarMigrator
implements MediaMigrator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Avatar.Facade avatarFacade;
    @NotNull
    private final MediaUploader<UploadableAvatar> mediaUploader;
    @NotNull
    private final MediaUploadLogger<UploadableAvatar> mediaUploadLogger;
    @NotNull
    private final AvatarExportMessageGenerator avatarExportMessageGenerator;
    @NotNull
    private final MediaClient mediaClient;
    @NotNull
    private final ProjectManager projectManager;
    private static final Logger log = LoggerFactory.getLogger(AvatarMigrator.class);

    @Inject
    public AvatarMigrator(@NotNull Avatar.Facade avatarFacade, @NotNull MediaUploader<UploadableAvatar> mediaUploader, @NotNull MediaUploadLogger<UploadableAvatar> mediaUploadLogger, @NotNull AvatarExportMessageGenerator avatarExportMessageGenerator, @NotNull MediaClient mediaClient, @NotNull ProjectManager projectManager) {
        Intrinsics.checkNotNullParameter((Object)avatarFacade, (String)"avatarFacade");
        Intrinsics.checkNotNullParameter(mediaUploader, (String)"mediaUploader");
        Intrinsics.checkNotNullParameter(mediaUploadLogger, (String)"mediaUploadLogger");
        Intrinsics.checkNotNullParameter((Object)avatarExportMessageGenerator, (String)"avatarExportMessageGenerator");
        Intrinsics.checkNotNullParameter((Object)mediaClient, (String)"mediaClient");
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        this.avatarFacade = avatarFacade;
        this.mediaUploader = mediaUploader;
        this.mediaUploadLogger = mediaUploadLogger;
        this.avatarExportMessageGenerator = avatarExportMessageGenerator;
        this.mediaClient = mediaClient;
        this.projectManager = projectManager;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long calculateTotalDataSize(@NotNull Task task, @NotNull String projectKey, @NotNull Function0<Unit> heartbeat2) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        Intrinsics.checkNotNullParameter(heartbeat2, (String)"heartbeat");
        Avatar.Facade.Query query = this.avatarFacade.getQuery();
        Long l = this.projectManager.getProjectObjByKey(projectKey).getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        Sequence<Avatar.Info> sequence = query.findProjectAvatarsIncludingDifferentSizes(((Number)l).longValue());
        long l2 = 0L;
        for (Object e : sequence) {
            void it;
            Avatar.Info info = (Avatar.Info)e;
            long l3 = l2;
            boolean bl = false;
            long l4 = it.getFilePath().length();
            l2 = l3 + l4;
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(@NotNull Task task, @NotNull String projectKey, @NotNull Function1<? super MediaUploadProgress, Unit> uploadProgress, @NotNull DataFilterContext dataFilterContext) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        Intrinsics.checkNotNullParameter(uploadProgress, (String)"uploadProgress");
        Intrinsics.checkNotNullParameter((Object)dataFilterContext, (String)"dataFilterContext");
        log.info(task.getMigrationId() + '-' + task.getTaskId() + ": uploading avatars for project key " + projectKey);
        String mediaClientId = this.mediaClient.getMediaClientId(AbstractMediaProcessorKt.getContainerToken(task));
        Long projectId = this.projectManager.getProjectObjByKey(projectKey).getId();
        try {
            String string = AbstractMediaProcessorKt.getContainerToken(task);
            String string2 = task.getMigrationId();
            Avatar.Facade.Query query = this.avatarFacade.getQuery();
            Intrinsics.checkNotNull((Object)projectId);
            MediaUploadRequest<UploadableAvatar> uploadRequest2 = new MediaUploadRequest<UploadableAvatar>(string, string2, projectKey, SequencesKt.map((Sequence)SequencesKt.mapNotNull(query.findProjectAvatarsIncludingDifferentSizes(projectId), (Function1)((Function1)new Function1<Avatar.Info, Pair<? extends Avatar.Info, ? extends Avatar.MigratedInfo>>(this, mediaClientId){
                final /* synthetic */ AvatarMigrator this$0;
                final /* synthetic */ String $mediaClientId;
                {
                    this.this$0 = $receiver;
                    this.$mediaClientId = $mediaClientId;
                    super(1);
                }

                @Nullable
                public final Pair<Avatar.Info, Avatar.MigratedInfo> invoke(@NotNull Avatar.Info avatar) {
                    Pair pair;
                    Avatar.MigratedInfo migratedInfo;
                    Avatar.MigratedInfo migratedInfo2;
                    Intrinsics.checkNotNullParameter((Object)avatar, (String)"avatar");
                    Avatar.MigratedInfo it = migratedInfo2 = AvatarMigrator.access$createMigrationFileIfNotExists(this.this$0, avatar, this.$mediaClientId);
                    boolean bl = false;
                    Avatar.MigratedInfo migratedInfo3 = migratedInfo = !it.getMigrated() ? migratedInfo2 : null;
                    if (migratedInfo != null) {
                        it = migratedInfo;
                        boolean bl2 = false;
                        pair = TuplesKt.to((Object)avatar, (Object)it);
                    } else {
                        pair = null;
                    }
                    return pair;
                }
            })), (Function1)process.uploadRequest.2.INSTANCE), UploadRequestType.AVATARS);
            Closeable closeable = this.mediaUploadLogger.getLog(uploadRequest2);
            Throwable throwable = null;
            try {
                ExportLog exportLog = (ExportLog)closeable;
                boolean bl = false;
                this.mediaUploader.uploadMediaInParallel(uploadRequest2, uploadProgress, this.doOnItemSuccess(mediaClientId), this.doOnItemFailure(exportLog, uploadRequest2));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            log.info(task.getMigrationId() + '-' + task.getTaskId() + ": uploaded avatars for project key " + projectKey);
            log.info(task.getMigrationId() + '-' + task.getTaskId() + ": notified MO complete for project avatars " + projectKey);
        }
        catch (Exception ex) {
            log.warn(task.getMigrationId() + '-' + task.getTaskId() + ": error in avatars upload task for project key " + projectKey, (Throwable)ex);
        }
    }

    private final Function2<UploadableAvatar, Throwable, Unit> doOnItemFailure(ExportLog exportLog, MediaUploadRequest<UploadableAvatar> uploadRequest2) {
        return (Function2)new Function2<UploadableAvatar, Throwable, Unit>(this, exportLog, uploadRequest2){
            final /* synthetic */ AvatarMigrator this$0;
            final /* synthetic */ ExportLog $exportLog;
            final /* synthetic */ MediaUploadRequest<UploadableAvatar> $uploadRequest;
            {
                this.this$0 = $receiver;
                this.$exportLog = $exportLog;
                this.$uploadRequest = $uploadRequest;
                super(2);
            }

            public final void invoke(@NotNull UploadableAvatar uploadableItem, @NotNull Throwable e) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)uploadableItem, (String)"uploadableItem");
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    AvatarMigrator.access$getLog$cp().warn("creating  avatar in Media failed for avatar = " + uploadableItem.getId() + " with size " + uploadableItem.getAvatarSize());
                    Avatar avatar = AvatarMigrator.access$getAvatarFacade$p(this.this$0).getQuery().findById(uploadableItem.getId());
                    if (avatar == null) break block0;
                    Avatar avatar2 = avatar;
                    ExportLog exportLog = this.$exportLog;
                    AvatarMigrator avatarMigrator = this.this$0;
                    MediaUploadRequest<UploadableAvatar> mediaUploadRequest = this.$uploadRequest;
                    Avatar it = avatar2;
                    boolean bl = false;
                    exportLog.putExportMessage(AvatarMigrator.access$getAvatarExportMessageGenerator$p(avatarMigrator).generate(mediaUploadRequest, it, e));
                }
                throw e;
            }
        };
    }

    @VisibleForTesting
    @NotNull
    public final Function2<UploadableAvatar, String, Unit> doOnItemSuccess(@NotNull String mediaClientId) {
        Intrinsics.checkNotNullParameter((Object)mediaClientId, (String)"mediaClientId");
        return (Function2)new Function2<UploadableAvatar, String, Unit>(this, mediaClientId){
            final /* synthetic */ AvatarMigrator this$0;
            final /* synthetic */ String $mediaClientId;
            {
                this.this$0 = $receiver;
                this.$mediaClientId = $mediaClientId;
                super(2);
            }

            public final void invoke(@NotNull UploadableAvatar uploadableAvatar, @NotNull String uploadId) {
                Intrinsics.checkNotNullParameter((Object)uploadableAvatar, (String)"uploadableAvatar");
                Intrinsics.checkNotNullParameter((Object)uploadId, (String)"uploadId");
                Avatar.MigratedInfo migratedInfo = AvatarMigrator.access$getAvatarFacade$p(this.this$0).getQuery().findMigratedInfo(uploadableAvatar.getId(), uploadableAvatar.getAvatarSize(), this.$mediaClientId);
                if (migratedInfo != null) {
                    Avatar.MigratedInfo migratedInfo2;
                    Avatar.MigratedInfo it = migratedInfo2 = migratedInfo;
                    boolean bl = false;
                    AvatarMigrator.access$getLog$cp().debug("found migrated file entry for avatar " + uploadableAvatar.getId() + " in DB");
                    AvatarMigrator avatarMigrator = this.this$0;
                    Avatar.MigratedInfo it2 = migratedInfo2;
                    boolean bl2 = false;
                    Avatar.MigratedInfo updated = Avatar.MigratedInfo.copy$default(it2, 0L, null, null, null, uploadId, true, 15, null);
                    Avatar.Facade.Command.DefaultImpls.updateMigratedInfo$default(AvatarMigrator.access$getAvatarFacade$p(avatarMigrator).getCommand(), updated, null, 2, null);
                }
                AvatarMigrator.access$getLog$cp().debug("created file in Media for avatar " + uploadableAvatar.getId());
            }
        };
    }

    private final synchronized Avatar.MigratedInfo createMigrationFileIfNotExists(Avatar.Info avatar, String mediaClientId) {
        Avatar.MigratedInfo migratedInfo = this.avatarFacade.getQuery().findMigratedInfo(avatar.getId(), avatar.getSize(), mediaClientId);
        if (migratedInfo == null) {
            migratedInfo = this.createMigrationFileWithFileMediaId(avatar, mediaClientId);
        }
        return migratedInfo;
    }

    private final Avatar.MigratedInfo createMigrationFileWithFileMediaId(Avatar.Info avatar, String mediaClientId) {
        log.warn("Had to create avatar " + avatar.getId() + " during avatar upload");
        Avatar.Facade.Command command = this.avatarFacade.getCommand();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return Avatar.Facade.Command.DefaultImpls.recordMigratedInfo$default(command, avatar, new MediaUploadInfo(string, mediaClientId, null, 4, null), false, 4, null);
    }

    public static final /* synthetic */ Avatar.MigratedInfo access$createMigrationFileIfNotExists(AvatarMigrator $this, Avatar.Info avatar, String mediaClientId) {
        return $this.createMigrationFileIfNotExists(avatar, mediaClientId);
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    public static final /* synthetic */ Avatar.Facade access$getAvatarFacade$p(AvatarMigrator $this) {
        return $this.avatarFacade;
    }

    public static final /* synthetic */ AvatarExportMessageGenerator access$getAvatarExportMessageGenerator$p(AvatarMigrator $this) {
        return $this.avatarExportMessageGenerator;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/workers/attachments/AvatarMigrator$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

