/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.attachments;

import com.atlassian.jira.migration.log.ExportLog;
import com.atlassian.jira.migration.tracking.tasks.Task;
import com.atlassian.jira.migration.workers.attachments.AbstractMediaProcessorKt;
import com.atlassian.jira.migration.workers.attachments.FileExportMessageGenerator;
import com.atlassian.jira.migration.workers.attachments.FileMigrator;
import com.atlassian.jira.migration.workers.attachments.MediaUploadLogger;
import com.atlassian.jira.migration.workers.attachments.MediaUploadProgress;
import com.atlassian.jira.migration.workers.attachments.MediaUploadRequest;
import com.atlassian.jira.migration.workers.attachments.MediaUploader;
import com.atlassian.jira.migration.workers.attachments.UploadableFile;
import com.atlassian.jira.util.io.InputStreamConsumer;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 &2\u00020\u0001:\u0001&B+\b\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJT\u0010\u0010\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u00170\u00112\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ8\u0010\u001e\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u001f\u0012\u0013\u0012\u00110 \u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(!\u0012\u0004\u0012\u00020\u00170\u0011H\u0007J\"\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u000b0#2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001c\u001a\u00020\u001dR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006'"}, d2={"Lcom/atlassian/jira/migration/workers/attachments/FileMigrator;", "", "mediaUploader", "Lcom/atlassian/jira/migration/workers/attachments/MediaUploader;", "Lcom/atlassian/jira/migration/workers/attachments/UploadableFile;", "mediaUploadLogger", "Lcom/atlassian/jira/migration/workers/attachments/MediaUploadLogger;", "fileExportMessageGenerator", "Lcom/atlassian/jira/migration/workers/attachments/FileExportMessageGenerator;", "(Lcom/atlassian/jira/migration/workers/attachments/MediaUploader;Lcom/atlassian/jira/migration/workers/attachments/MediaUploadLogger;Lcom/atlassian/jira/migration/workers/attachments/FileExportMessageGenerator;)V", "uploadSuccess", "", "getUploadSuccess", "()Z", "setUploadSuccess", "(Z)V", "doOnItemFailure", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "uploadableItem", "", "e", "", "exportLog", "Lcom/atlassian/jira/migration/log/ExportLog;", "uploadRequest", "Lcom/atlassian/jira/migration/workers/attachments/MediaUploadRequest;", "file", "Ljava/io/File;", "doOnItemSuccess", "uploadableFile", "", "uploadId", "process", "Lkotlin/Pair;", "task", "Lcom/atlassian/jira/migration/tracking/tasks/Task;", "Companion", "jira-migration-plugin"})
public final class FileMigrator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MediaUploader<UploadableFile> mediaUploader;
    @NotNull
    private final MediaUploadLogger<UploadableFile> mediaUploadLogger;
    @NotNull
    private final FileExportMessageGenerator fileExportMessageGenerator;
    private boolean uploadSuccess;
    private static final Logger log = LoggerFactory.getLogger(FileMigrator.class);

    @Inject
    public FileMigrator(@NotNull MediaUploader<UploadableFile> mediaUploader, @NotNull MediaUploadLogger<UploadableFile> mediaUploadLogger, @NotNull FileExportMessageGenerator fileExportMessageGenerator) {
        Intrinsics.checkNotNullParameter(mediaUploader, (String)"mediaUploader");
        Intrinsics.checkNotNullParameter(mediaUploadLogger, (String)"mediaUploadLogger");
        Intrinsics.checkNotNullParameter((Object)fileExportMessageGenerator, (String)"fileExportMessageGenerator");
        this.mediaUploader = mediaUploader;
        this.mediaUploadLogger = mediaUploadLogger;
        this.fileExportMessageGenerator = fileExportMessageGenerator;
    }

    public final boolean getUploadSuccess() {
        return this.uploadSuccess;
    }

    public final void setUploadSuccess(boolean bl) {
        this.uploadSuccess = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Pair<String, Boolean> process(@NotNull Task task, @NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        log.info(task.getMigrationId() + '-' + task.getTaskId() + ": uploading file to media");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String mediaFileId = string;
        try {
            String string2 = file2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            UploadableFile uploadableFileObj2 = new UploadableFile(1L, mediaFileId, string2, Files.size(file2.toPath()), (Function1<? super InputStreamConsumer<Unit>, Unit>)((Function1)new Function1<InputStreamConsumer<Unit>, Unit>(file2){
                final /* synthetic */ File $file;
                {
                    this.$file = $file;
                    super(1);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke(@NotNull InputStreamConsumer<Unit> consumer) {
                    Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
                    Closeable closeable = new FileInputStream(this.$file);
                    Throwable throwable = null;
                    try {
                        FileInputStream it = (FileInputStream)closeable;
                        boolean bl = false;
                        consumer.withInputStream((InputStream)it);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
            }));
            Object object = new UploadableFile[]{uploadableFileObj2};
            MediaUploadRequest<UploadableFile> uploadRequest2 = new MediaUploadRequest<UploadableFile>(AbstractMediaProcessorKt.getContainerToken(task), task.getMigrationId(), "Site-Backup", SequencesKt.sequenceOf((Object[])object), null, 16, null);
            object = this.mediaUploadLogger.getLog(uploadRequest2);
            Throwable throwable = null;
            try {
                ExportLog exportLog = (ExportLog)object;
                boolean bl = false;
                this.mediaUploader.uploadMediaInParallel(uploadRequest2, (Function1<MediaUploadProgress, Unit>)((Function1)process.1.1.INSTANCE), this.doOnItemSuccess(), this.doOnItemFailure(exportLog, uploadRequest2, file2));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        catch (Exception ex) {
            log.warn(task.getMigrationId() + '-' + task.getTaskId() + ": error in file upload during Site Import", (Throwable)ex);
            throw ex;
        }
        return TuplesKt.to((Object)mediaFileId, (Object)this.uploadSuccess);
    }

    @NotNull
    public final Function2<UploadableFile, Throwable, Unit> doOnItemFailure(@NotNull ExportLog exportLog, @NotNull MediaUploadRequest<UploadableFile> uploadRequest2, @NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)exportLog, (String)"exportLog");
        Intrinsics.checkNotNullParameter(uploadRequest2, (String)"uploadRequest");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return (Function2)new Function2<UploadableFile, Throwable, Unit>(exportLog, this, uploadRequest2, file2){
            final /* synthetic */ ExportLog $exportLog;
            final /* synthetic */ FileMigrator this$0;
            final /* synthetic */ MediaUploadRequest<UploadableFile> $uploadRequest;
            final /* synthetic */ File $file;
            {
                this.$exportLog = $exportLog;
                this.this$0 = $receiver;
                this.$uploadRequest = $uploadRequest;
                this.$file = $file;
                super(2);
            }

            public final void invoke(@NotNull UploadableFile uploadableItem, @NotNull Throwable e) {
                Intrinsics.checkNotNullParameter((Object)uploadableItem, (String)"uploadableItem");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FileMigrator.access$getLog$cp().warn("Creating site backup in Media failed for file = " + uploadableItem.getId() + " with size " + uploadableItem.getFileSize());
                this.$exportLog.putExportMessage(FileMigrator.access$getFileExportMessageGenerator$p(this.this$0).generate(this.$uploadRequest, this.$file, e));
                this.this$0.setUploadSuccess(false);
                throw e;
            }
        };
    }

    @VisibleForTesting
    @NotNull
    public final Function2<UploadableFile, String, Unit> doOnItemSuccess() {
        return (Function2)new Function2<UploadableFile, String, Unit>(this){
            final /* synthetic */ FileMigrator this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull UploadableFile uploadableFile, @NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)uploadableFile, (String)"uploadableFile");
                Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 1>");
                FileMigrator.access$getLog$cp().debug("Created site backup in Media for file " + uploadableFile.getId());
                this.this$0.setUploadSuccess(true);
            }
        };
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    public static final /* synthetic */ FileExportMessageGenerator access$getFileExportMessageGenerator$p(FileMigrator $this) {
        return $this.fileExportMessageGenerator;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/workers/attachments/FileMigrator$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

