/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.attachments;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B3\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0016\u001a\u00020\u0005H\u0016J\b\u0010\u0017\u001a\u00020\u0005H\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lcom/atlassian/jira/migration/workers/attachments/FixedDelayCloseableRunner;", "Ljava/lang/AutoCloseable;", "Ljava/lang/Runnable;", "func", "Lkotlin/Function0;", "", "initialDelay", "", "delay", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "(Lkotlin/jvm/functions/Function0;JJLjava/util/concurrent/TimeUnit;Ljava/util/concurrent/ScheduledExecutorService;)V", "getExecutor", "()Ljava/util/concurrent/ScheduledExecutorService;", "future", "Ljava/util/concurrent/ScheduledFuture;", "getFuture", "()Ljava/util/concurrent/ScheduledFuture;", "setFuture", "(Ljava/util/concurrent/ScheduledFuture;)V", "close", "run", "jira-migration-plugin"})
public final class FixedDelayCloseableRunner
implements AutoCloseable,
Runnable {
    @NotNull
    private final Function0<Unit> func;
    @NotNull
    private final ScheduledExecutorService executor;
    @NotNull
    private ScheduledFuture<?> future;

    public FixedDelayCloseableRunner(@NotNull Function0<Unit> func, long initialDelay, long delay, @NotNull TimeUnit timeUnit, @NotNull ScheduledExecutorService executor) {
        Intrinsics.checkNotNullParameter(func, (String)"func");
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.func = func;
        this.executor = executor;
        ScheduledFuture<?> scheduledFuture = this.executor.scheduleWithFixedDelay(this, initialDelay, delay, timeUnit);
        Intrinsics.checkNotNullExpressionValue(scheduledFuture, (String)"scheduleWithFixedDelay(...)");
        this.future = scheduledFuture;
    }

    @NotNull
    public final ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    @NotNull
    public final ScheduledFuture<?> getFuture() {
        return this.future;
    }

    public final void setFuture(@NotNull ScheduledFuture<?> scheduledFuture) {
        Intrinsics.checkNotNullParameter(scheduledFuture, (String)"<set-?>");
        this.future = scheduledFuture;
    }

    @Override
    public void close() {
        this.executor.shutdownNow();
    }

    @Override
    public void run() {
        try {
            this.func.invoke();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

