/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.attachments;

import com.atlassian.jira.migration.analytics.errordispatcher.ExportErrorDto;
import com.atlassian.jira.migration.analytics.errordispatcher.ExportErrorRepository;
import com.atlassian.jira.migration.log.ExportLog;
import com.atlassian.jira.migration.log.MigrationLogsService;
import com.atlassian.jira.migration.orchestratorclient.tasks.MigrationTaskType;
import com.atlassian.jira.migration.orchestratorclient.tasks.ProgressUnit;
import com.atlassian.jira.migration.tracking.tasks.Task;
import com.atlassian.jira.migration.workers.attachments.MediaUploadRequest;
import com.atlassian.jira.migration.workers.attachments.UploadableItem;
import java.nio.file.Path;
import java.time.Instant;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0017\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/jira/migration/workers/attachments/MediaUploadLogger;", "T", "Lcom/atlassian/jira/migration/workers/attachments/UploadableItem;", "", "migrationLogsService", "Lcom/atlassian/jira/migration/log/MigrationLogsService;", "exportErrorRepository", "Lcom/atlassian/jira/migration/analytics/errordispatcher/ExportErrorRepository;", "(Lcom/atlassian/jira/migration/log/MigrationLogsService;Lcom/atlassian/jira/migration/analytics/errordispatcher/ExportErrorRepository;)V", "getLog", "Lcom/atlassian/jira/migration/log/ExportLog;", "uploadRequest", "Lcom/atlassian/jira/migration/workers/attachments/MediaUploadRequest;", "storeErrorLog", "", "task", "Lcom/atlassian/jira/migration/tracking/tasks/Task;", "errorMessage", "", "jira-migration-plugin"})
public final class MediaUploadLogger<T extends UploadableItem> {
    @NotNull
    private final MigrationLogsService migrationLogsService;
    @NotNull
    private final ExportErrorRepository exportErrorRepository;

    @Inject
    public MediaUploadLogger(@NotNull MigrationLogsService migrationLogsService, @NotNull ExportErrorRepository exportErrorRepository) {
        Intrinsics.checkNotNullParameter((Object)migrationLogsService, (String)"migrationLogsService");
        Intrinsics.checkNotNullParameter((Object)exportErrorRepository, (String)"exportErrorRepository");
        this.migrationLogsService = migrationLogsService;
        this.exportErrorRepository = exportErrorRepository;
    }

    @NotNull
    public final ExportLog getLog(@NotNull MediaUploadRequest<T> uploadRequest2) {
        Intrinsics.checkNotNullParameter(uploadRequest2, (String)"uploadRequest");
        Path logLocation = this.migrationLogsService.logFileLocation(uploadRequest2.getMigrationId(), MigrationTaskType.ATTACHMENTS_UPLOAD, ProgressUnit.ATTACHMENT, uploadRequest2.getProjectKey());
        return new ExportLog(logLocation);
    }

    public final void storeErrorLog(@NotNull Task task, @NotNull String errorMessage2) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)errorMessage2, (String)"errorMessage");
        this.exportErrorRepository.save(new ExportErrorDto(Instant.now().toEpochMilli(), task.getCloudId(), task.getMigrationId(), null, StringsKt.substringBefore((String)task.getTaskId(), (String)"#", (String)"unknown_Task"), errorMessage2, 8, null));
    }
}

