/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.attachments;

import com.atlassian.jira.migration.GroupedThreadFactory;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.httpclient.exceptions.UnexpectedStatusCodeException;
import com.atlassian.jira.migration.mediaclient.CreateWithFilesRequestItem;
import com.atlassian.jira.migration.mediaclient.CreateWithFilesResponseItem;
import com.atlassian.jira.migration.mediaclient.ETag;
import com.atlassian.jira.migration.mediaclient.MediaClient;
import com.atlassian.jira.migration.mediaclient.MediaClientErrorException;
import com.atlassian.jira.migration.mediaclient.Upload;
import com.atlassian.jira.migration.utility.FileChunkUtility;
import com.atlassian.jira.migration.workers.attachments.MediaUploadConflictException;
import com.atlassian.jira.migration.workers.attachments.MediaUploadException;
import com.atlassian.jira.migration.workers.attachments.MediaUploadProgress;
import com.atlassian.jira.migration.workers.attachments.MediaUploadRequest;
import com.atlassian.jira.migration.workers.attachments.MediaUploader;
import com.atlassian.jira.migration.workers.attachments.UploadableItem;
import com.google.common.annotations.VisibleForTesting;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 .*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001.B\u0017\b\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB?\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0001\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u000e\b\u0001\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u000e\b\u0001\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\u000eJ\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017H\u0007J\u0098\u0001\u0010\u0018\u001a\u00020\u00192\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00172\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00190\u001b26\u0010\u001d\u001a2\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(!\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(\"\u0012\u0004\u0012\u00020\u00190\u001e26\u0010#\u001a2\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(!\u0012\u0013\u0012\u00110$\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(%\u0012\u0004\u0012\u00020\u00190\u001eJ\u00a7\u0001\u0010&\u001a\u00020\u00192\u0006\u0010!\u001a\u00028\u00002\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00172\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00190\u001b26\u0010'\u001a2\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(!\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(\"\u0012\u0004\u0012\u00020\u00190\u001e26\u0010#\u001a2\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(!\u0012\u0013\u0012\u00110$\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(%\u0012\u0004\u0012\u00020\u00190\u001eH\u0002\u00a2\u0006\u0002\u0010(J9\u0010)\u001a\u00020\u00192\u0006\u0010!\u001a\u00028\u00002\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00142\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00190\u001bH\u0002\u00a2\u0006\u0002\u0010-R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006/"}, d2={"Lcom/atlassian/jira/migration/workers/attachments/MediaUploader;", "T", "Lcom/atlassian/jira/migration/workers/attachments/UploadableItem;", "", "mediaClient", "Lcom/atlassian/jira/migration/mediaclient/MediaClient;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/mediaclient/MediaClient;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "numberOfConcurrentSubmissionsSupplier", "Lkotlin/Function0;", "", "threadsPerPoolSupplier", "chunkSizeSupplier", "(Lcom/atlassian/jira/migration/mediaclient/MediaClient;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "getChunkSizeSupplier", "()Lkotlin/jvm/functions/Function0;", "getNumberOfConcurrentSubmissionsSupplier", "getThreadsPerPoolSupplier", "createUploadIdForFile", "", "fileMediaId", "uploadRequest", "Lcom/atlassian/jira/migration/workers/attachments/MediaUploadRequest;", "uploadMediaInParallel", "", "progressHandler", "Lkotlin/Function1;", "Lcom/atlassian/jira/migration/workers/attachments/MediaUploadProgress;", "onItemSuccess", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "uploadableItem", "uploadId", "onItemFailure", "", "e", "uploadMediaItem", "onSuccess", "(Lcom/atlassian/jira/migration/workers/attachments/UploadableItem;Lcom/atlassian/jira/migration/workers/attachments/MediaUploadRequest;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;)V", "uploadMediaItemContent", "upload", "Lcom/atlassian/jira/migration/mediaclient/Upload;", "containerToken", "(Lcom/atlassian/jira/migration/workers/attachments/UploadableItem;Lcom/atlassian/jira/migration/mediaclient/Upload;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nMediaUploader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MediaUploader.kt\ncom/atlassian/jira/migration/workers/attachments/MediaUploader\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,230:1\n1324#2,3:231\n*S KotlinDebug\n*F\n+ 1 MediaUploader.kt\ncom/atlassian/jira/migration/workers/attachments/MediaUploader\n*L\n187#1:231,3\n*E\n"})
public final class MediaUploader<T extends UploadableItem> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MediaClient mediaClient;
    @NotNull
    private final Function0<Integer> numberOfConcurrentSubmissionsSupplier;
    @NotNull
    private final Function0<Integer> threadsPerPoolSupplier;
    @NotNull
    private final Function0<Integer> chunkSizeSupplier;
    private static final Logger log = LoggerFactory.getLogger(MediaUploader.class);

    @VisibleForTesting
    public MediaUploader(@NotNull MediaClient mediaClient, @VisibleForTesting @NotNull Function0<Integer> numberOfConcurrentSubmissionsSupplier, @VisibleForTesting @NotNull Function0<Integer> threadsPerPoolSupplier, @VisibleForTesting @NotNull Function0<Integer> chunkSizeSupplier) {
        Intrinsics.checkNotNullParameter((Object)mediaClient, (String)"mediaClient");
        Intrinsics.checkNotNullParameter(numberOfConcurrentSubmissionsSupplier, (String)"numberOfConcurrentSubmissionsSupplier");
        Intrinsics.checkNotNullParameter(threadsPerPoolSupplier, (String)"threadsPerPoolSupplier");
        Intrinsics.checkNotNullParameter(chunkSizeSupplier, (String)"chunkSizeSupplier");
        this.mediaClient = mediaClient;
        this.numberOfConcurrentSubmissionsSupplier = numberOfConcurrentSubmissionsSupplier;
        this.threadsPerPoolSupplier = threadsPerPoolSupplier;
        this.chunkSizeSupplier = chunkSizeSupplier;
    }

    @NotNull
    public final Function0<Integer> getNumberOfConcurrentSubmissionsSupplier() {
        return this.numberOfConcurrentSubmissionsSupplier;
    }

    @NotNull
    public final Function0<Integer> getThreadsPerPoolSupplier() {
        return this.threadsPerPoolSupplier;
    }

    @NotNull
    public final Function0<Integer> getChunkSizeSupplier() {
        return this.chunkSizeSupplier;
    }

    @Inject
    public MediaUploader(@NotNull MediaClient mediaClient, final @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)mediaClient, (String)"mediaClient");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this(mediaClient, (Function0<Integer>)((Function0)new Function0<Integer>(){

            @NotNull
            public final Integer invoke() {
                return migrationFeatures.getGetThreadCountForAttachmentUpload() + 5;
            }
        }), (Function0<Integer>)((Function0)new Function0<Integer>(){

            @NotNull
            public final Integer invoke() {
                return migrationFeatures.getGetThreadCountForAttachmentUpload();
            }
        }), (Function0<Integer>)((Function0)3.INSTANCE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void uploadMediaInParallel(@NotNull MediaUploadRequest<T> uploadRequest2, @NotNull Function1<? super MediaUploadProgress, Unit> progressHandler, @NotNull Function2<? super T, ? super String, Unit> onItemSuccess, @NotNull Function2<? super T, ? super Throwable, Unit> onItemFailure) {
        Intrinsics.checkNotNullParameter(uploadRequest2, (String)"uploadRequest");
        Intrinsics.checkNotNullParameter(progressHandler, (String)"progressHandler");
        Intrinsics.checkNotNullParameter(onItemSuccess, (String)"onItemSuccess");
        Intrinsics.checkNotNullParameter(onItemFailure, (String)"onItemFailure");
        Semaphore semaphore = new Semaphore(((Number)this.numberOfConcurrentSubmissionsSupplier.invoke()).intValue());
        ExecutorService executor = Executors.newFixedThreadPool(((Number)this.threadsPerPoolSupplier.invoke()).intValue(), new GroupedThreadFactory("MediaUploader"));
        try {
            int count2 = SequencesKt.count((Sequence)SequencesKt.mapIndexed(uploadRequest2.getItems(), (Function2)new Function2<Integer, T, Unit>(uploadRequest2, semaphore, executor, this, progressHandler, onItemSuccess, onItemFailure){
                final /* synthetic */ MediaUploadRequest<T> $uploadRequest;
                final /* synthetic */ Semaphore $semaphore;
                final /* synthetic */ ExecutorService $executor;
                final /* synthetic */ MediaUploader<T> this$0;
                final /* synthetic */ Function1<MediaUploadProgress, Unit> $progressHandler;
                final /* synthetic */ Function2<T, String, Unit> $onItemSuccess;
                final /* synthetic */ Function2<T, Throwable, Unit> $onItemFailure;
                {
                    this.$uploadRequest = $uploadRequest;
                    this.$semaphore = $semaphore;
                    this.$executor = $executor;
                    this.this$0 = $receiver;
                    this.$progressHandler = $progressHandler;
                    this.$onItemSuccess = $onItemSuccess;
                    this.$onItemFailure = $onItemFailure;
                    super(2);
                }

                public final void invoke(int index, @NotNull T item) {
                    Intrinsics.checkNotNullParameter(item, (String)"item");
                    if (index % 1000 == 0) {
                        MediaUploader.access$getLog$cp().info("Uploading " + (Object)((Object)this.$uploadRequest.getUploadRequestType()) + " for project key=" + this.$uploadRequest.getProjectKey() + ", count=" + index);
                    }
                    this.$semaphore.acquire();
                    this.$executor.execute(() -> uploadMediaInParallel.count.1.invoke$lambda$0(this.this$0, item, this.$uploadRequest, this.$progressHandler, this.$onItemSuccess, this.$onItemFailure, this.$semaphore));
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private static final void invoke$lambda$0(MediaUploader this$0, UploadableItem $item, MediaUploadRequest $uploadRequest, Function1 $progressHandler, Function2 $onItemSuccess, Function2 $onItemFailure, Semaphore $semaphore) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)$item, (String)"$item");
                    Intrinsics.checkNotNullParameter((Object)$uploadRequest, (String)"$uploadRequest");
                    Intrinsics.checkNotNullParameter((Object)$progressHandler, (String)"$progressHandler");
                    Intrinsics.checkNotNullParameter((Object)$onItemSuccess, (String)"$onItemSuccess");
                    Intrinsics.checkNotNullParameter((Object)$onItemFailure, (String)"$onItemFailure");
                    Intrinsics.checkNotNullParameter((Object)$semaphore, (String)"$semaphore");
                    try {
                        MediaUploader.access$uploadMediaItem(this$0, $item, $uploadRequest, $progressHandler, $onItemSuccess, $onItemFailure);
                    }
                    finally {
                        $semaphore.release();
                    }
                }
            }));
            log.info("Uploading " + (Object)((Object)uploadRequest2.getUploadRequestType()) + " for project key=" + uploadRequest2.getProjectKey() + ", total count=" + count2);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MediaUploadException("media upload task was interrupted", e);
        }
        finally {
            executor.shutdown();
            executor.awaitTermination(60L, TimeUnit.MINUTES);
        }
        log.info("Uploading " + (Object)((Object)uploadRequest2.getUploadRequestType()) + " done projectKey=" + uploadRequest2.getProjectKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void uploadMediaItem(T uploadableItem, MediaUploadRequest<T> uploadRequest2, Function1<? super MediaUploadProgress, Unit> progressHandler, Function2<? super T, ? super String, Unit> onSuccess, Function2<? super T, ? super Throwable, Unit> onItemFailure) {
        try {
            String uploadId = this.createUploadIdForFile(uploadableItem.getFileMediaId(), uploadRequest2);
            Upload upload = new Upload(uploadId);
            Object object = uploadRequest2.getContainerToken();
            this.uploadMediaItemContent(uploadableItem, upload, (String)object, progressHandler);
            object = this.mediaClient;
            String string = uploadRequest2.getContainerToken();
            String string2 = uploadableItem.getFileMediaId();
            String string3 = uploadableItem.getFileName();
            ((MediaClient)object).createFileFromUpload(string, upload, string3, string2);
            onSuccess.invoke(uploadableItem, (Object)uploadId);
        }
        catch (Throwable e) {
            if (e instanceof MediaUploadConflictException) {
                log.warn(e.getMessage(), e);
            } else {
                onItemFailure.invoke(uploadableItem, (Object)e);
            }
        }
        finally {
            progressHandler.invoke((Object)new MediaUploadProgress.UploadedItemCountProgress(1L));
        }
    }

    @VisibleForTesting
    @NotNull
    public final String createUploadIdForFile(@NotNull String fileMediaId, @NotNull MediaUploadRequest<T> uploadRequest2) {
        Intrinsics.checkNotNullParameter((Object)fileMediaId, (String)"fileMediaId");
        Intrinsics.checkNotNullParameter(uploadRequest2, (String)"uploadRequest");
        int n = 3;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            try {
                CreateWithFilesResponseItem createWithFilesRequestItem = (CreateWithFilesResponseItem)CollectionsKt.first(this.mediaClient.createUploadWithFiles(uploadRequest2.getContainerToken(), CollectionsKt.listOf((Object)new CreateWithFilesRequestItem(fileMediaId))));
                return createWithFilesRequestItem.getUploadId();
            }
            catch (MediaClientErrorException e) {
                MediaClientErrorException $this$createUploadIdForFile_u24lambda_u241_u24lambda_u240;
                block9: {
                    block8: {
                        $this$createUploadIdForFile_u24lambda_u241_u24lambda_u240 = e;
                        boolean bl2 = false;
                        if (!($this$createUploadIdForFile_u24lambda_u241_u24lambda_u240.getCause() instanceof UnexpectedStatusCodeException)) break block8;
                        Throwable throwable = $this$createUploadIdForFile_u24lambda_u241_u24lambda_u240.getCause();
                        Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.httpclient.exceptions.UnexpectedStatusCodeException");
                        if (((UnexpectedStatusCodeException)throwable).getStatusCode() == 400) break block9;
                    }
                    if ($this$createUploadIdForFile_u24lambda_u241_u24lambda_u240.getCause() instanceof UnexpectedStatusCodeException) {
                        Throwable throwable = $this$createUploadIdForFile_u24lambda_u241_u24lambda_u240.getCause();
                        Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.httpclient.exceptions.UnexpectedStatusCodeException");
                        if (((UnexpectedStatusCodeException)throwable).getStatusCode() == 409) {
                            throw new MediaUploadConflictException(fileMediaId, uploadRequest2.getMigrationId(), uploadRequest2.getProjectKey(), e);
                        }
                    }
                    log.warn("FileMediaId = " + fileMediaId + ", Upload token creation failed", (Throwable)e);
                    throw e;
                }
                StringBuilder stringBuilder = new StringBuilder().append("FileMediaId = ").append(fileMediaId).append(", Retrying upload creation, Media error: ");
                Throwable throwable = $this$createUploadIdForFile_u24lambda_u241_u24lambda_u240.getCause();
                Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.httpclient.exceptions.UnexpectedStatusCodeException");
                log.info(stringBuilder.append(((UnexpectedStatusCodeException)throwable).getMessage()).toString());
            }
        }
        throw new RuntimeException("Failed to generate Media FileIds for upload item after 3 retries");
    }

    private final void uploadMediaItemContent(T uploadableItem, Upload upload, String containerToken, Function1<? super MediaUploadProgress, Unit> progressHandler) {
        uploadableItem.getInputStreamConsumer().invoke(arg_0 -> MediaUploader.uploadMediaItemContent$lambda$3(uploadableItem, this, containerToken, upload, progressHandler, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit uploadMediaItemContent$lambda$3(UploadableItem $uploadableItem, MediaUploader this$0, String $containerToken, Upload $upload, Function1 $progressHandler, InputStream it) {
        void $this$forEachIndexed$iv;
        Intrinsics.checkNotNullParameter((Object)$uploadableItem, (String)"$uploadableItem");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$containerToken, (String)"$containerToken");
        Intrinsics.checkNotNullParameter((Object)$upload, (String)"$upload");
        Intrinsics.checkNotNullParameter((Object)$progressHandler, (String)"$progressHandler");
        Intrinsics.checkNotNull((Object)it);
        Sequence sequence = SequencesKt.chunked((Sequence)SequencesKt.onEach((Sequence)SequencesKt.map(FileChunkUtility.INSTANCE.toChunks(it, $uploadableItem.getFileSize() < (long)((Number)this$0.chunkSizeSupplier.invoke()).intValue() ? (int)$uploadableItem.getFileSize() : ((Number)this$0.chunkSizeSupplier.invoke()).intValue()), (Function1)((Function1)new Function1<IndexedValue<? extends byte[]>, ETag>(this$0, $containerToken, $upload){
            final /* synthetic */ MediaUploader<T> this$0;
            final /* synthetic */ String $containerToken;
            final /* synthetic */ Upload $upload;
            {
                this.this$0 = $receiver;
                this.$containerToken = $containerToken;
                this.$upload = $upload;
                super(1);
            }

            @NotNull
            public final ETag invoke(@NotNull IndexedValue<byte[]> chunk) {
                Intrinsics.checkNotNullParameter(chunk, (String)"chunk");
                return MediaUploader.access$getMediaClient$p(this.this$0).uploadChunk(this.$containerToken, (byte[])chunk.getValue(), this.$upload.getId(), chunk.getIndex() + 1);
            }
        })), (Function1)((Function1)new Function1<ETag, Unit>(this$0, (Function1<? super MediaUploadProgress, Unit>)$progressHandler){
            final /* synthetic */ MediaUploader<T> this$0;
            final /* synthetic */ Function1<MediaUploadProgress, Unit> $progressHandler;
            {
                this.this$0 = $receiver;
                this.$progressHandler = $progressHandler;
                super(1);
            }

            public final void invoke(@NotNull ETag etag) {
                block2: {
                    Object $this$invoke_u24lambda_u240;
                    Intrinsics.checkNotNullParameter((Object)etag, (String)"etag");
                    Object object = this.this$0;
                    Object object2 = this.$progressHandler;
                    try {
                        $this$invoke_u24lambda_u240 = object;
                        boolean bl = false;
                        object2.invoke((Object)new MediaUploadProgress.UploadedChunkSizeProgress(etag.getSize()));
                        $this$invoke_u24lambda_u240 = Result.constructor-impl((Object)Unit.INSTANCE);
                    }
                    catch (Throwable bl) {
                        $this$invoke_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                    }
                    object = $this$invoke_u24lambda_u240;
                    Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                    if (throwable == null) break block2;
                    Object it = object2 = throwable;
                    boolean bl = false;
                    MediaUploader.access$getLog$cp().warn("Failure while updating media upload progress for chunk with etag: " + etag.getSha256Hex() + ".Continuing with media upload...");
                }
            }
        })), (int)100);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void chunksBatch;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv;
            int index = n;
            boolean bl = false;
            this$0.mediaClient.updateUpload($containerToken, $upload, index * 100, (List<ETag>)chunksBatch);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    public static final /* synthetic */ void access$uploadMediaItem(MediaUploader $this, UploadableItem uploadableItem, MediaUploadRequest uploadRequest2, Function1 progressHandler, Function2 onSuccess, Function2 onItemFailure) {
        $this.uploadMediaItem(uploadableItem, uploadRequest2, (Function1<MediaUploadProgress, Unit>)progressHandler, onSuccess, onItemFailure);
    }

    public static final /* synthetic */ MediaClient access$getMediaClient$p(MediaUploader $this) {
        return $this.mediaClient;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/workers/attachments/MediaUploader$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

