/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.attachments;

import com.atlassian.jira.migration.app.preload.AppDataPreloadStatusRepository;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.plan.ProjectDataMigrationMode;
import com.atlassian.jira.migration.platform.TransferStatus;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J%\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000eJ\u0016\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/jira/migration/workers/attachments/StatusUtil;", "", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "appDataPreloadStatusRepository", "Lcom/atlassian/jira/migration/app/preload/AppDataPreloadStatusRepository;", "(Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/app/preload/AppDataPreloadStatusRepository;)V", "appDataPreloadStatus", "Lcom/atlassian/jira/migration/platform/TransferStatus;", "projectDataMigrationMode", "Lcom/atlassian/jira/migration/plan/ProjectDataMigrationMode;", "migrationId", "", "projectId", "", "(Lcom/atlassian/jira/migration/plan/ProjectDataMigrationMode;Ljava/lang/String;Ljava/lang/Long;)Lcom/atlassian/jira/migration/platform/TransferStatus;", "attachmentMigrationStatus", "", "failedUploadCount", "joinStatuses", "jira-migration-plugin"})
public final class StatusUtil {
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final AppDataPreloadStatusRepository appDataPreloadStatusRepository;

    public StatusUtil(@NotNull MigrationFeatures migrationFeatures, @NotNull AppDataPreloadStatusRepository appDataPreloadStatusRepository) {
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)appDataPreloadStatusRepository, (String)"appDataPreloadStatusRepository");
        this.migrationFeatures = migrationFeatures;
        this.appDataPreloadStatusRepository = appDataPreloadStatusRepository;
    }

    public final boolean attachmentMigrationStatus(long failedUploadCount) {
        return this.migrationFeatures.getEnableIncompleteStatusForFailedAttachUpload() && failedUploadCount > 0L;
    }

    @NotNull
    public final TransferStatus appDataPreloadStatus(@NotNull ProjectDataMigrationMode projectDataMigrationMode, @NotNull String migrationId, @Nullable Long projectId) {
        TransferStatus transferStatus;
        Intrinsics.checkNotNullParameter((Object)((Object)projectDataMigrationMode), (String)"projectDataMigrationMode");
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        if (this.migrationFeatures.getEnableIncompleteProjectAttachmentCalculation() && (projectDataMigrationMode == ProjectDataMigrationMode.ATTACHMENTS_ONLY || projectDataMigrationMode == ProjectDataMigrationMode.ATTACHMENTS_ONLY_V2)) {
            Map<Boolean, Long> stats = this.appDataPreloadStatusRepository.statusStats(migrationId, projectId);
            boolean bl = false;
            Long l = stats.get(false);
            long l2 = 0L;
            if (l != null && l == l2) {
                transferStatus = TransferStatus.SUCCESS;
            } else {
                Long l3 = stats.get(true);
                l2 = 0L;
                transferStatus = l3 != null && l3 == l2 ? TransferStatus.FAILED : TransferStatus.INCOMPLETE;
            }
        } else {
            transferStatus = TransferStatus.SUCCESS;
        }
        return transferStatus;
    }

    @NotNull
    public final TransferStatus joinStatuses(boolean attachmentMigrationStatus, @NotNull TransferStatus appDataPreloadStatus) {
        Intrinsics.checkNotNullParameter((Object)((Object)appDataPreloadStatus), (String)"appDataPreloadStatus");
        return attachmentMigrationStatus ? TransferStatus.INCOMPLETE : (this.migrationFeatures.getEnableAppDataPreload() ? appDataPreloadStatus : TransferStatus.SUCCESS);
    }
}

