/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.attachments;

import com.atlassian.jira.migration.export.core.attachment.AttachmentForMedia;
import com.atlassian.jira.migration.export.core.attachment.AttachmentMetadata;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.service.ExportOrThrow;
import com.atlassian.jira.migration.export.service.ExportService;
import com.atlassian.jira.migration.workers.attachments.VirtualAttachmentFileService;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/workers/attachments/TextFieldConverterService;", "", "virtualAttachmentFileService", "Lcom/atlassian/jira/migration/workers/attachments/VirtualAttachmentFileService;", "exportService", "Lcom/atlassian/jira/migration/export/service/ExportService;", "(Lcom/atlassian/jira/migration/workers/attachments/VirtualAttachmentFileService;Lcom/atlassian/jira/migration/export/service/ExportService;)V", "convertToAttachment", "", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "content", "issueId", "", "textFieldName", "Companion", "jira-migration-plugin"})
public final class TextFieldConverterService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VirtualAttachmentFileService virtualAttachmentFileService;
    @NotNull
    private final ExportService exportService;
    private static final Logger log = LoggerFactory.getLogger(TextFieldConverterService.class);

    @Inject
    public TextFieldConverterService(@NotNull VirtualAttachmentFileService virtualAttachmentFileService, @NotNull ExportService exportService) {
        Intrinsics.checkNotNullParameter((Object)virtualAttachmentFileService, (String)"virtualAttachmentFileService");
        Intrinsics.checkNotNullParameter((Object)exportService, (String)"exportService");
        this.virtualAttachmentFileService = virtualAttachmentFileService;
        this.exportService = exportService;
    }

    @NotNull
    public final String convertToAttachment(@NotNull ExportContext ctx, @NotNull String content, long issueId, @NotNull String textFieldName) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)textFieldName, (String)"textFieldName");
        if (content.length() > Short.MAX_VALUE) {
            StringBuilder stringBuilder = new StringBuilder().append("Converting to attachment for text \"");
            String string = content.substring(0, 20);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            log.info(StringsKt.trimMargin$default((String)stringBuilder.append(string).append("...\"\n                    | to cloud limit of 32767\n                    |  chars for ").append(textFieldName).append(" on issue Id ").append(issueId).toString(), null, (int)1, null));
            String string2 = ctx.getStartedBy().getKey();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getKey(...)");
            AttachmentMetadata att = this.virtualAttachmentFileService.saveAttachment(content, issueId, string2);
            AttachmentForMedia mediaAtt = new AttachmentForMedia(att.getId());
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, att, false, 4, null);
            ExportOrThrow.DefaultImpls.exportOrThrow$default(this.exportService, ctx, mediaAtt, false, 4, null);
            return this.virtualAttachmentFileService.generateNewTextFieldContent(textFieldName, att.getId());
        }
        return content;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/workers/attachments/TextFieldConverterService$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

