/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.attachments;

import com.atlassian.jira.migration.app.preload.AppDataPreloadStatusRepository;
import com.atlassian.jira.migration.common.LongExtensionsKt;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.orchestratorclient.tasks.MigrationTaskType;
import com.atlassian.jira.migration.orchestratorclient.tasks.ProgressItem;
import com.atlassian.jira.migration.plan.ProjectDataMigrationMode;
import com.atlassian.jira.migration.platform.TransferStatus;
import com.atlassian.jira.migration.shadow.db.AttachmentExportFinalStatus;
import com.atlassian.jira.migration.shadow.db.MigrationFinalStatusRepository;
import com.atlassian.jira.migration.tracking.tasks.Task;
import com.atlassian.jira.migration.workers.PlatformHeartbeater;
import com.atlassian.jira.migration.workers.PlatformProgressUpdater;
import com.atlassian.jira.migration.workers.attachments.AbstractMediaWorkProgressHandler;
import com.atlassian.jira.migration.workers.attachments.StatusUtil;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001dH\u0002J\u0010\u0010!\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010\"\u001a\u00020\u001d2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J\u0018\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u0007H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/atlassian/jira/migration/workers/attachments/V3MediaWorkProgressHandler;", "Lcom/atlassian/jira/migration/workers/attachments/AbstractMediaWorkProgressHandler;", "heartbeater", "Lcom/atlassian/jira/migration/workers/PlatformHeartbeater;", "progressUpdater", "Lcom/atlassian/jira/migration/workers/PlatformProgressUpdater;", "totalUploadDataSize", "", "migrationFinalStatusRepository", "Lcom/atlassian/jira/migration/shadow/db/MigrationFinalStatusRepository;", "task", "Lcom/atlassian/jira/migration/tracking/tasks/Task;", "appDataPreloadStatusRepository", "Lcom/atlassian/jira/migration/app/preload/AppDataPreloadStatusRepository;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "projectId", "(Lcom/atlassian/jira/migration/workers/PlatformHeartbeater;Lcom/atlassian/jira/migration/workers/PlatformProgressUpdater;JLcom/atlassian/jira/migration/shadow/db/MigrationFinalStatusRepository;Lcom/atlassian/jira/migration/tracking/tasks/Task;Lcom/atlassian/jira/migration/app/preload/AppDataPreloadStatusRepository;Lcom/atlassian/jira/migration/features/MigrationFeatures;Ljava/lang/Long;)V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "Ljava/lang/Long;", "getFinalPublishStatus", "Lcom/atlassian/jira/migration/platform/TransferStatus;", "projectDataMigrationMode", "Lcom/atlassian/jira/migration/plan/ProjectDataMigrationMode;", "failedUploadCount", "sendFailedStatusUpdate", "", "ex", "", "sendFinalProgress", "sendFinishedStatusUpdate", "sendHeartbeat", "msg", "", "sendProgressUpdate", "successfullyCompleted", "total", "jira-migration-plugin"})
public final class V3MediaWorkProgressHandler
extends AbstractMediaWorkProgressHandler {
    @NotNull
    private final PlatformHeartbeater heartbeater;
    @NotNull
    private final PlatformProgressUpdater progressUpdater;
    private final long totalUploadDataSize;
    @NotNull
    private final MigrationFinalStatusRepository migrationFinalStatusRepository;
    @NotNull
    private final Task task;
    @NotNull
    private final AppDataPreloadStatusRepository appDataPreloadStatusRepository;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @Nullable
    private final Long projectId;
    @NotNull
    private final Logger log;

    public V3MediaWorkProgressHandler(@NotNull PlatformHeartbeater heartbeater, @NotNull PlatformProgressUpdater progressUpdater2, long totalUploadDataSize, @NotNull MigrationFinalStatusRepository migrationFinalStatusRepository, @NotNull Task task, @NotNull AppDataPreloadStatusRepository appDataPreloadStatusRepository, @NotNull MigrationFeatures migrationFeatures, @Nullable Long projectId) {
        Intrinsics.checkNotNullParameter((Object)heartbeater, (String)"heartbeater");
        Intrinsics.checkNotNullParameter((Object)progressUpdater2, (String)"progressUpdater");
        Intrinsics.checkNotNullParameter((Object)migrationFinalStatusRepository, (String)"migrationFinalStatusRepository");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)appDataPreloadStatusRepository, (String)"appDataPreloadStatusRepository");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        super(totalUploadDataSize, task);
        this.heartbeater = heartbeater;
        this.progressUpdater = progressUpdater2;
        this.totalUploadDataSize = totalUploadDataSize;
        this.migrationFinalStatusRepository = migrationFinalStatusRepository;
        this.task = task;
        this.appDataPreloadStatusRepository = appDataPreloadStatusRepository;
        this.migrationFeatures = migrationFeatures;
        this.projectId = projectId;
        Logger logger2 = LoggerFactory.getLogger(V3MediaWorkProgressHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        this.log = logger2;
    }

    public /* synthetic */ V3MediaWorkProgressHandler(PlatformHeartbeater platformHeartbeater, PlatformProgressUpdater platformProgressUpdater, long l, MigrationFinalStatusRepository migrationFinalStatusRepository, Task task, AppDataPreloadStatusRepository appDataPreloadStatusRepository, MigrationFeatures migrationFeatures, Long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x80) != 0) {
            l2 = null;
        }
        this(platformHeartbeater, platformProgressUpdater, l, migrationFinalStatusRepository, task, appDataPreloadStatusRepository, migrationFeatures, l2);
    }

    @Override
    @NotNull
    public Logger getLog() {
        return this.log;
    }

    @Override
    public void sendProgressUpdate(long successfullyCompleted, long total) {
        AbstractMediaWorkProgressHandler.sendHeartbeat$default(this, null, 1, null);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"successfullyMigratedBytes", (Object)successfullyCompleted), TuplesKt.to((Object)"totalProjectAttachmentSize", (Object)total), TuplesKt.to((Object)"totalProjectAttachments", (Object)this.getUploadItemCount()), TuplesKt.to((Object)"failedProjectAttachments", (Object)this.getFailedItemCount())};
        PlatformProgressUpdater.sendProgressUpdate$default(this.progressUpdater, LongExtensionsKt.rangedPercentOf$default(successfullyCompleted, total, 0, 0, 6, null), null, MapsKt.mapOf((Pair[])pairArray), false, 10, null);
    }

    @Override
    public void sendHeartbeat(@Nullable String msg) {
        this.heartbeater.sendHeartbeat();
    }

    @Override
    public void sendFinishedStatusUpdate(@NotNull ProjectDataMigrationMode projectDataMigrationMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)projectDataMigrationMode), (String)"projectDataMigrationMode");
        this.sendFinalProgress();
        if (this.task.getMigrationTask().getMigrationTaskType() == MigrationTaskType.JIRA_ATTACHMENT_UPLOAD && this.projectId != null) {
            this.migrationFinalStatusRepository.create(this.task.getMigrationId(), new AttachmentExportFinalStatus(this.getSuccessfullyMigratedBytes(), this.totalUploadDataSize, this.getUploadItemCount(), this.getFailedItemCount()), this.projectId);
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"successfullyMigratedBytes", (Object)this.getSuccessfullyMigratedBytes()), TuplesKt.to((Object)"totalProjectAttachmentSize", (Object)this.totalUploadDataSize), TuplesKt.to((Object)"totalProjectAttachments", (Object)this.getUploadItemCount()), TuplesKt.to((Object)"failedProjectAttachments", (Object)this.getFailedItemCount())};
        PlatformProgressUpdater.sendFinalStatus$default(this.progressUpdater, this.getFinalPublishStatus(projectDataMigrationMode, this.getFailedItemCount()), MapsKt.mapOf((Pair[])pairArray), null, 4, null);
    }

    private final TransferStatus getFinalPublishStatus(ProjectDataMigrationMode projectDataMigrationMode, long failedUploadCount) {
        StatusUtil statusUtil = new StatusUtil(this.migrationFeatures, this.appDataPreloadStatusRepository);
        boolean attachmentMigrationStatus = statusUtil.attachmentMigrationStatus(failedUploadCount);
        TransferStatus appDataPreloadStatus = statusUtil.appDataPreloadStatus(projectDataMigrationMode, this.task.getMigrationId(), this.projectId);
        return statusUtil.joinStatuses(attachmentMigrationStatus, appDataPreloadStatus);
    }

    @Override
    public void sendFailedStatusUpdate(@NotNull Throwable ex) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        this.sendFinalProgress();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"successfullyMigratedBytes", (Object)this.getSuccessfullyMigratedBytes()), TuplesKt.to((Object)"totalProjectAttachmentSize", (Object)this.totalUploadDataSize), TuplesKt.to((Object)"totalProjectAttachments", (Object)this.getUploadItemCount()), TuplesKt.to((Object)"failedProjectAttachments", (Object)this.getFailedItemCount())};
        this.progressUpdater.sendFinalStatus(TransferStatus.FAILED, MapsKt.mapOf((Pair[])pairArray), ProgressItem.Companion.throwableToDetailsMessage(ex));
    }

    private final void sendFinalProgress() {
        PlatformProgressUpdater platformProgressUpdater = this.progressUpdater;
        int n = LongExtensionsKt.rangedPercentOf$default(this.getSuccessfullyMigratedBytes(), this.totalUploadDataSize, 0, 0, 6, null);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"successfullyMigratedBytes", (Object)this.getSuccessfullyMigratedBytes()), TuplesKt.to((Object)"totalProjectAttachmentSize", (Object)this.totalUploadDataSize), TuplesKt.to((Object)"totalProjectAttachments", (Object)this.getUploadItemCount()), TuplesKt.to((Object)"failedProjectAttachments", (Object)this.getFailedItemCount())};
        Map map = MapsKt.mapOf((Pair[])pairArray);
        PlatformProgressUpdater.sendProgressUpdate$default(platformProgressUpdater, n, null, map, true, 2, null);
    }
}

