/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.attachments;

import com.atlassian.jira.migration.app.preload.AppDataPreloadStatusRepository;
import com.atlassian.jira.migration.common.LongExtensionsKt;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.orchestratorclient.tasks.MigrationTaskType;
import com.atlassian.jira.migration.orchestratorclient.tasks.ProgressItem;
import com.atlassian.jira.migration.plan.ProjectDataMigrationMode;
import com.atlassian.jira.migration.platform.TransferStatus;
import com.atlassian.jira.migration.shadow.db.AttachmentExportFinalStatus;
import com.atlassian.jira.migration.shadow.db.MigrationFinalStatusRepository;
import com.atlassian.jira.migration.tracking.tasks.PrcTask;
import com.atlassian.jira.migration.workers.PrcProgressUpdater;
import com.atlassian.jira.migration.workers.attachments.AbstractMediaWorkProgressHandler;
import com.atlassian.jira.migration.workers.attachments.StatusUtil;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001bH\u0002J\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010 \u001a\u00020\u001b2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\u0018\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u0005H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/atlassian/jira/migration/workers/attachments/V4MediaWorkProgressHandler;", "Lcom/atlassian/jira/migration/workers/attachments/AbstractMediaWorkProgressHandler;", "progressUpdater", "Lcom/atlassian/jira/migration/workers/PrcProgressUpdater;", "totalUploadDataSize", "", "migrationFinalStatusRepository", "Lcom/atlassian/jira/migration/shadow/db/MigrationFinalStatusRepository;", "task", "Lcom/atlassian/jira/migration/tracking/tasks/PrcTask;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "appDataPreloadStatusRepository", "Lcom/atlassian/jira/migration/app/preload/AppDataPreloadStatusRepository;", "projectId", "(Lcom/atlassian/jira/migration/workers/PrcProgressUpdater;JLcom/atlassian/jira/migration/shadow/db/MigrationFinalStatusRepository;Lcom/atlassian/jira/migration/tracking/tasks/PrcTask;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/app/preload/AppDataPreloadStatusRepository;Ljava/lang/Long;)V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "Ljava/lang/Long;", "getFinalPublishStatus", "Lcom/atlassian/jira/migration/platform/TransferStatus;", "projectDataMigrationMode", "Lcom/atlassian/jira/migration/plan/ProjectDataMigrationMode;", "failedUploadCount", "sendFailedStatusUpdate", "", "ex", "", "sendFinalProgress", "sendFinishedStatusUpdate", "sendHeartbeat", "msg", "", "sendProgressUpdate", "successfullyCompleted", "total", "jira-migration-plugin"})
public final class V4MediaWorkProgressHandler
extends AbstractMediaWorkProgressHandler {
    @NotNull
    private final PrcProgressUpdater progressUpdater;
    private final long totalUploadDataSize;
    @NotNull
    private final MigrationFinalStatusRepository migrationFinalStatusRepository;
    @NotNull
    private final PrcTask task;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final AppDataPreloadStatusRepository appDataPreloadStatusRepository;
    @Nullable
    private final Long projectId;
    @NotNull
    private final Logger log;

    public V4MediaWorkProgressHandler(@NotNull PrcProgressUpdater progressUpdater2, long totalUploadDataSize, @NotNull MigrationFinalStatusRepository migrationFinalStatusRepository, @NotNull PrcTask task, @NotNull MigrationFeatures migrationFeatures, @NotNull AppDataPreloadStatusRepository appDataPreloadStatusRepository, @Nullable Long projectId) {
        Intrinsics.checkNotNullParameter((Object)progressUpdater2, (String)"progressUpdater");
        Intrinsics.checkNotNullParameter((Object)migrationFinalStatusRepository, (String)"migrationFinalStatusRepository");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)appDataPreloadStatusRepository, (String)"appDataPreloadStatusRepository");
        super(totalUploadDataSize, task);
        this.progressUpdater = progressUpdater2;
        this.totalUploadDataSize = totalUploadDataSize;
        this.migrationFinalStatusRepository = migrationFinalStatusRepository;
        this.task = task;
        this.migrationFeatures = migrationFeatures;
        this.appDataPreloadStatusRepository = appDataPreloadStatusRepository;
        this.projectId = projectId;
        Logger logger2 = LoggerFactory.getLogger(V4MediaWorkProgressHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        this.log = logger2;
    }

    public /* synthetic */ V4MediaWorkProgressHandler(PrcProgressUpdater prcProgressUpdater, long l, MigrationFinalStatusRepository migrationFinalStatusRepository, PrcTask prcTask, MigrationFeatures migrationFeatures, AppDataPreloadStatusRepository appDataPreloadStatusRepository, Long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            l2 = null;
        }
        this(prcProgressUpdater, l, migrationFinalStatusRepository, prcTask, migrationFeatures, appDataPreloadStatusRepository, l2);
    }

    @Override
    @NotNull
    public Logger getLog() {
        return this.log;
    }

    @Override
    public void sendProgressUpdate(long successfullyCompleted, long total) {
        AbstractMediaWorkProgressHandler.sendHeartbeat$default(this, null, 1, null);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"successfullyMigratedBytes", (Object)successfullyCompleted), TuplesKt.to((Object)"totalProjectAttachmentSize", (Object)total), TuplesKt.to((Object)"totalProjectAttachments", (Object)this.getUploadItemCount()), TuplesKt.to((Object)"failedProjectAttachments", (Object)this.getFailedItemCount())};
        PrcProgressUpdater.sendProgressUpdate$default(this.progressUpdater, LongExtensionsKt.rangedPercentOf$default(successfullyCompleted, total, 0, 0, 6, null), null, MapsKt.mapOf((Pair[])pairArray), false, this.task, 10, null);
    }

    @Override
    public void sendHeartbeat(@Nullable String msg) {
    }

    @Override
    public void sendFinishedStatusUpdate(@NotNull ProjectDataMigrationMode projectDataMigrationMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)projectDataMigrationMode), (String)"projectDataMigrationMode");
        this.sendFinalProgress();
        if (this.task.getMigrationTask().getMigrationTaskType() == MigrationTaskType.JIRA_ATTACHMENT_UPLOAD && this.projectId != null) {
            this.migrationFinalStatusRepository.create(this.task.getMigrationId(), new AttachmentExportFinalStatus(this.getSuccessfullyMigratedBytes(), this.totalUploadDataSize, this.getUploadItemCount(), this.getFailedItemCount()), this.projectId);
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"successfullyMigratedBytes", (Object)this.getSuccessfullyMigratedBytes()), TuplesKt.to((Object)"totalProjectAttachmentSize", (Object)this.totalUploadDataSize), TuplesKt.to((Object)"totalProjectAttachments", (Object)this.getUploadItemCount()), TuplesKt.to((Object)"failedProjectAttachments", (Object)this.getFailedItemCount())};
        PrcProgressUpdater.sendFinalStatus$default(this.progressUpdater, this.getFinalPublishStatus(projectDataMigrationMode, this.getFailedItemCount()), MapsKt.mapOf((Pair[])pairArray), null, this.task, 4, null);
    }

    private final TransferStatus getFinalPublishStatus(ProjectDataMigrationMode projectDataMigrationMode, long failedUploadCount) {
        StatusUtil statusUtil = new StatusUtil(this.migrationFeatures, this.appDataPreloadStatusRepository);
        boolean attachmentMigrationStatus = statusUtil.attachmentMigrationStatus(failedUploadCount);
        TransferStatus appDataPreloadStatus = statusUtil.appDataPreloadStatus(projectDataMigrationMode, this.task.getMigrationId(), this.projectId);
        return statusUtil.joinStatuses(attachmentMigrationStatus, appDataPreloadStatus);
    }

    @Override
    public void sendFailedStatusUpdate(@NotNull Throwable ex) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        this.sendFinalProgress();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"successfullyMigratedBytes", (Object)this.getSuccessfullyMigratedBytes()), TuplesKt.to((Object)"totalProjectAttachmentSize", (Object)this.totalUploadDataSize), TuplesKt.to((Object)"totalProjectAttachments", (Object)this.getUploadItemCount()), TuplesKt.to((Object)"failedProjectAttachments", (Object)this.getFailedItemCount())};
        this.progressUpdater.sendFinalStatus(TransferStatus.FAILED, MapsKt.mapOf((Pair[])pairArray), ProgressItem.Companion.throwableToDetailsMessage(ex), this.task);
    }

    private final void sendFinalProgress() {
        PrcProgressUpdater prcProgressUpdater = this.progressUpdater;
        int n = LongExtensionsKt.rangedPercentOf$default(this.getSuccessfullyMigratedBytes(), this.totalUploadDataSize, 0, 0, 6, null);
        Object object = new Pair[]{TuplesKt.to((Object)"successfullyMigratedBytes", (Object)this.getSuccessfullyMigratedBytes()), TuplesKt.to((Object)"totalProjectAttachmentSize", (Object)this.totalUploadDataSize), TuplesKt.to((Object)"totalProjectAttachments", (Object)this.getUploadItemCount()), TuplesKt.to((Object)"failedProjectAttachments", (Object)this.getFailedItemCount())};
        Map map = MapsKt.mapOf((Pair[])object);
        object = this.task;
        PrcProgressUpdater.sendProgressUpdate$default(prcProgressUpdater, n, null, map, true, (PrcTask)object, 2, null);
    }
}

