/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.attachments;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.migration.export.core.attachment.AttachmentMetadata;
import com.atlassian.jira.migration.migration.MigratedFileEntity;
import com.atlassian.jira.migration.migration.MigratedFileRepository;
import com.atlassian.jira.migration.migration.VirtualAttachmentRepository;
import com.atlassian.jira.migration.workers.attachments.UploadableAttachment;
import com.atlassian.jira.util.io.InputStreamConsumer;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\nJ\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\fH\u0007J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\fH\u0002J\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\nR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/atlassian/jira/migration/workers/attachments/VirtualAttachmentFileService;", "", "migratedFileRepository", "Lcom/atlassian/jira/migration/migration/MigratedFileRepository;", "virtualAttachmentRepository", "Lcom/atlassian/jira/migration/migration/VirtualAttachmentRepository;", "jiraHome", "Lcom/atlassian/jira/config/util/JiraHome;", "(Lcom/atlassian/jira/migration/migration/MigratedFileRepository;Lcom/atlassian/jira/migration/migration/VirtualAttachmentRepository;Lcom/atlassian/jira/config/util/JiraHome;)V", "convertIdToFilename", "", "virtualAttachmentId", "", "generateNewTextFieldContent", "textFieldName", "getAttachmentsForUpload", "", "Lcom/atlassian/jira/migration/workers/attachments/UploadableAttachment;", "mediaClientId", "getTempAttachmentsDirectory", "Ljava/io/File;", "hashByteArray", "bytes", "", "issueId", "longToByteArray", "value", "saveAttachment", "Lcom/atlassian/jira/migration/export/core/attachment/AttachmentMetadata;", "content", "authorKey", "Companion", "jira-migration-plugin"})
public final class VirtualAttachmentFileService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigratedFileRepository migratedFileRepository;
    @NotNull
    private final VirtualAttachmentRepository virtualAttachmentRepository;
    @NotNull
    private final JiraHome jiraHome;
    private static final Logger log = LoggerFactory.getLogger(VirtualAttachmentFileService.class);

    @Inject
    public VirtualAttachmentFileService(@NotNull MigratedFileRepository migratedFileRepository, @NotNull VirtualAttachmentRepository virtualAttachmentRepository, @NotNull JiraHome jiraHome) {
        Intrinsics.checkNotNullParameter((Object)migratedFileRepository, (String)"migratedFileRepository");
        Intrinsics.checkNotNullParameter((Object)virtualAttachmentRepository, (String)"virtualAttachmentRepository");
        Intrinsics.checkNotNullParameter((Object)jiraHome, (String)"jiraHome");
        this.migratedFileRepository = migratedFileRepository;
        this.virtualAttachmentRepository = virtualAttachmentRepository;
        this.jiraHome = jiraHome;
    }

    @NotNull
    public final File getTempAttachmentsDirectory() {
        String[] stringArray = new String[]{"attachments"};
        Path attachmentsPath = Paths.get(this.jiraHome.getHome().getAbsolutePath(), stringArray);
        File tempAttachments = new File(attachmentsPath.toFile(), "temp");
        log.debug("Temporary attachments directory {}", (Object)tempAttachments);
        if (tempAttachments.mkdirs()) {
            log.info("Created directory " + tempAttachments);
        }
        return tempAttachments;
    }

    private final String convertIdToFilename(long virtualAttachmentId) {
        return virtualAttachmentId + ".txt";
    }

    private final byte[] longToByteArray(long value) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(value);
        byte[] byArray = buffer.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
        return byArray;
    }

    @VisibleForTesting
    public final long hashByteArray(@NotNull byte[] bytes, long issueId) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        CRC32 crc32 = new CRC32();
        crc32.update(bytes);
        byte[] issueIdBytes = this.longToByteArray(issueId);
        crc32.update(issueIdBytes);
        return crc32.getValue();
    }

    @NotNull
    public final String generateNewTextFieldContent(@NotNull String textFieldName, long virtualAttachmentId) {
        Intrinsics.checkNotNullParameter((Object)textFieldName, (String)"textFieldName");
        String timestamp = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneOffset.UTC).format(Instant.now());
        String link = "[^" + this.convertIdToFilename(virtualAttachmentId) + ']';
        return textFieldName + " moved to attachment for Cloud Migration by Jira Cloud Migration Assistant, on " + timestamp + '\n' + link;
    }

    @NotNull
    public final AttachmentMetadata saveAttachment(@NotNull String content, long issueId, @NotNull String authorKey) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)authorKey, (String)"authorKey");
        String string = content;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] bytes = byArray;
        long id = this.hashByteArray(bytes, issueId);
        String filename = this.convertIdToFilename(id);
        File tempAttachments = this.getTempAttachmentsDirectory();
        File file2 = new File(tempAttachments, filename);
        FilesKt.writeBytes((File)file2, (byte[])bytes);
        Path path = file2.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        long l = Files.size(path);
        AttachmentMetadata att = new AttachmentMetadata(id, issueId, authorKey, "text/plain", filename, null, l, null, null);
        this.virtualAttachmentRepository.saveVirtualAttachment(id);
        return att;
    }

    @NotNull
    public final List<UploadableAttachment> getAttachmentsForUpload(@NotNull String mediaClientId) {
        Intrinsics.checkNotNullParameter((Object)mediaClientId, (String)"mediaClientId");
        List<Long> virtualAttachmentIds = this.virtualAttachmentRepository.getVirtualAttachmentIdsForUpload(mediaClientId);
        File tempAttachmentsDir = this.getTempAttachmentsDirectory();
        List uploadbleAttachments = new ArrayList();
        Iterator<Long> iterator2 = virtualAttachmentIds.iterator();
        while (iterator2.hasNext()) {
            String fileMediaId;
            long id = ((Number)iterator2.next()).longValue();
            String filename = this.convertIdToFilename(id);
            File file2 = new File(tempAttachmentsDir, filename);
            if (!file2.exists()) {
                log.error("virtual attachment does not exist in: " + file2.getAbsoluteFile());
                continue;
            }
            MigratedFileEntity migratedFileEntity = this.migratedFileRepository.findMigratedFile(id, mediaClientId);
            String string = fileMediaId = migratedFileEntity != null ? migratedFileEntity.getFileMediaId() : null;
            if (fileMediaId == null) {
                log.error("fileMediaId not found for fileServerId: " + id + " and mediaClientId: " + mediaClientId);
                continue;
            }
            Path path = file2.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            UploadableAttachment cur2 = new UploadableAttachment(id, fileMediaId, filename, Files.size(path), (Function1<? super InputStreamConsumer<Unit>, Unit>)((Function1)new Function1<InputStreamConsumer<Unit>, Unit>(file2){
                final /* synthetic */ File $file;
                {
                    this.$file = $file;
                    super(1);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke(@NotNull InputStreamConsumer<Unit> consumer) {
                    Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
                    Closeable closeable = new FileInputStream(this.$file);
                    Throwable throwable = null;
                    try {
                        FileInputStream it = (FileInputStream)closeable;
                        boolean bl = false;
                        consumer.withInputStream((InputStream)it);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
            }));
            uploadbleAttachments.add(cur2);
        }
        return uploadbleAttachments;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/workers/attachments/VirtualAttachmentFileService$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

