/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.attachments.csvgenerator;

import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.common.LocalFileDataOutput;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.core.StreamingOutput;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.io.CsvBeanWriter;
import org.supercsv.prefs.CsvPreference;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b&\u0018\u0000 '*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001'B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001dJ\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001d2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020!H$J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\bH\u0002R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0016\u001a\u00020\u0017X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006("}, d2={"Lcom/atlassian/jira/migration/workers/attachments/csvgenerator/AbstractCsvExporter;", "T", "", "localFileDataOutput", "Lcom/atlassian/jira/migration/common/LocalFileDataOutput;", "(Lcom/atlassian/jira/migration/common/LocalFileDataOutput;)V", "csvColumns", "", "", "getCsvColumns", "()[Ljava/lang/String;", "fileNamePrefix", "getFileNamePrefix", "()Ljava/lang/String;", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "processors", "Lorg/supercsv/cellprocessor/ift/CellProcessor;", "getProcessors", "()[Lorg/supercsv/cellprocessor/ift/CellProcessor;", "writeHeaders", "", "getWriteHeaders", "()Z", "exportToCsv", "Ljava/nio/file/Path;", "allAttachments", "Lkotlin/sequences/Sequence;", "findAll", "mediaClientId", "cloudSite", "Lcom/atlassian/jira/migration/cloud/CloudSite;", "logProgress", "", "processing", "", "fileName", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAbstractCsvExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractCsvExporter.kt\ncom/atlassian/jira/migration/workers/attachments/csvgenerator/AbstractCsvExporter\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n1313#2:78\n1314#2:81\n1855#3,2:79\n*S KotlinDebug\n*F\n+ 1 AbstractCsvExporter.kt\ncom/atlassian/jira/migration/workers/attachments/csvgenerator/AbstractCsvExporter\n*L\n42#1:78\n42#1:81\n48#1:79,2\n*E\n"})
public abstract class AbstractCsvExporter<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LocalFileDataOutput localFileDataOutput;
    public static final int CSV_WRITE_BATCH_SIZE = 1000;
    public static final int CSV_LOG_PROGRESS_BATCH_SIZE = 1000;

    public AbstractCsvExporter(@NotNull LocalFileDataOutput localFileDataOutput) {
        Intrinsics.checkNotNullParameter((Object)((Object)localFileDataOutput), (String)"localFileDataOutput");
        this.localFileDataOutput = localFileDataOutput;
    }

    @NotNull
    public abstract String getFileNamePrefix();

    @NotNull
    public abstract String[] getCsvColumns();

    @NotNull
    public abstract CellProcessor[] getProcessors();

    public abstract boolean getWriteHeaders();

    @NotNull
    public abstract Logger getLog();

    @Nullable
    public final Path exportToCsv(@NotNull Sequence<? extends T> allAttachments) {
        Intrinsics.checkNotNullParameter(allAttachments, (String)"allAttachments");
        Path attachmentsFilePath = null;
        try {
            Ref.IntRef processingCount = new Ref.IntRef();
            attachmentsFilePath = this.localFileDataOutput.exportDirectory().resolve(this.getFileNamePrefix() + '-' + System.currentTimeMillis() + ".csv");
            Files.deleteIfExists(attachmentsFilePath);
            Path attachmentsFile = Files.createFile(attachmentsFilePath, new FileAttribute[0]);
            StreamingOutput attachmentCsvStreamingOutput = arg_0 -> AbstractCsvExporter.exportToCsv$lambda$3(this, allAttachments, processingCount, attachmentsFile, arg_0);
            OpenOption[] openOptionArray = new OpenOption[]{};
            OutputStream outputStream = Files.newOutputStream(attachmentsFilePath, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
            attachmentCsvStreamingOutput.write(outputStream);
            this.getLog().info("Finished writing attachments csv " + attachmentsFilePath);
            if (processingCount.element == 0) {
                Files.deleteIfExists(attachmentsFile);
            }
            return processingCount.element != 0 ? attachmentsFilePath : null;
        }
        catch (Exception e) {
            this.getLog().error("Failed to create media link csv file: " + attachmentsFilePath, (Throwable)e);
            throw e;
        }
    }

    @NotNull
    protected abstract Sequence<T> findAll(@NotNull String var1, @NotNull CloudSite var2);

    private final void logProgress(int processing, String fileName) {
        String progress = "Writing media id csv file for " + fileName + " - Processing " + processing + " rows";
        if (processing % 1000 == 0) {
            this.getLog().info(progress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final void exportToCsv$lambda$3(AbstractCsvExporter this$0, Sequence $allAttachments, Ref.IntRef $processingCount, Path $attachmentsFile, OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$allAttachments, (String)"$allAttachments");
        Intrinsics.checkNotNullParameter((Object)$processingCount, (String)"$processingCount");
        Closeable closeable = (Closeable)new CsvBeanWriter((Writer)new OutputStreamWriter(output, StandardCharsets.UTF_8), CsvPreference.STANDARD_PREFERENCE);
        Throwable throwable = null;
        try {
            void $this$forEach$iv;
            Sequence sequence;
            CsvBeanWriter writer = (CsvBeanWriter)closeable;
            boolean bl = false;
            if (this$0.getWriteHeaders()) {
                sequence = this$0.getCsvColumns();
                writer.writeHeader((String[])Arrays.copyOf(sequence, ((Sequence)sequence).length));
            }
            sequence = SequencesKt.chunked((Sequence)$allAttachments, (int)1000);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                List chunk = (List)element$iv;
                boolean bl2 = false;
                $processingCount.element += chunk.size();
                this$0.logProgress($processingCount.element, ((Object)$attachmentsFile.getFileName()).toString());
                Iterable $this$forEach$iv2 = chunk;
                boolean $i$f$forEach2 = false;
                Iterator iterator2 = $this$forEach$iv2.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv2;
                    Object it = element$iv2 = iterator2.next();
                    boolean bl3 = false;
                    writer.write(it, this$0.getCsvColumns(), this$0.getProcessors());
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/workers/attachments/csvgenerator/AbstractCsvExporter$Companion;", "", "()V", "CSV_LOG_PROGRESS_BATCH_SIZE", "", "CSV_WRITE_BATCH_SIZE", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

