/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.attachments.csvgenerator;

import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.common.LocalFileDataOutput;
import com.atlassian.jira.migration.mediaclient.MediaClient;
import com.atlassian.jira.migration.migration.MigratedFileEntity;
import com.atlassian.jira.migration.migration.MigratedFileRepository;
import com.atlassian.jira.migration.workers.attachments.csvgenerator.AbstractCsvExporter;
import java.nio.file.Path;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.supercsv.cellprocessor.ift.CellProcessor;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020!2\u0006\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020$H\u0014J\u0010\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010#\u001a\u00020$R\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0010\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u000bX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u001b\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001c\u001a\u00020\u001dX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006'"}, d2={"Lcom/atlassian/jira/migration/workers/attachments/csvgenerator/AttachmentIdMappingsCsvExporter;", "Lcom/atlassian/jira/migration/workers/attachments/csvgenerator/AbstractCsvExporter;", "Lcom/atlassian/jira/migration/migration/MigratedFileEntity;", "migratedFileRepository", "Lcom/atlassian/jira/migration/migration/MigratedFileRepository;", "mediaClient", "Lcom/atlassian/jira/migration/mediaclient/MediaClient;", "localFileDataOutput", "Lcom/atlassian/jira/migration/common/LocalFileDataOutput;", "(Lcom/atlassian/jira/migration/migration/MigratedFileRepository;Lcom/atlassian/jira/migration/mediaclient/MediaClient;Lcom/atlassian/jira/migration/common/LocalFileDataOutput;)V", "csvColumns", "", "", "getCsvColumns", "()[Ljava/lang/String;", "[Ljava/lang/String;", "fileNamePrefix", "getFileNamePrefix", "()Ljava/lang/String;", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "processors", "Lorg/supercsv/cellprocessor/ift/CellProcessor;", "getProcessors", "()[Lorg/supercsv/cellprocessor/ift/CellProcessor;", "[Lorg/supercsv/cellprocessor/ift/CellProcessor;", "writeHeaders", "", "getWriteHeaders", "()Z", "findAll", "Lkotlin/sequences/Sequence;", "mediaClientId", "cloudSite", "Lcom/atlassian/jira/migration/cloud/CloudSite;", "getAttachmentsAndExportToCsv", "Ljava/nio/file/Path;", "jira-migration-plugin"})
public final class AttachmentIdMappingsCsvExporter
extends AbstractCsvExporter<MigratedFileEntity> {
    @NotNull
    private final MigratedFileRepository migratedFileRepository;
    @NotNull
    private final MediaClient mediaClient;
    @NotNull
    private final String fileNamePrefix;
    @NotNull
    private final String[] csvColumns;
    @NotNull
    private final CellProcessor[] processors;
    private final boolean writeHeaders;
    @NotNull
    private final Logger log;

    @Inject
    public AttachmentIdMappingsCsvExporter(@NotNull MigratedFileRepository migratedFileRepository, @NotNull MediaClient mediaClient, @NotNull LocalFileDataOutput localFileDataOutput) {
        Intrinsics.checkNotNullParameter((Object)migratedFileRepository, (String)"migratedFileRepository");
        Intrinsics.checkNotNullParameter((Object)mediaClient, (String)"mediaClient");
        Intrinsics.checkNotNullParameter((Object)((Object)localFileDataOutput), (String)"localFileDataOutput");
        super(localFileDataOutput);
        this.migratedFileRepository = migratedFileRepository;
        this.mediaClient = mediaClient;
        this.fileNamePrefix = "attachments";
        String[] stringArray = new String[]{"fileServerId", "fileMediaId"};
        this.csvColumns = stringArray;
        stringArray = new CellProcessor[]{null, null};
        this.processors = stringArray;
        Logger logger2 = LoggerFactory.getLogger(AttachmentIdMappingsCsvExporter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        this.log = logger2;
    }

    @Override
    @NotNull
    public String getFileNamePrefix() {
        return this.fileNamePrefix;
    }

    @Override
    @NotNull
    public String[] getCsvColumns() {
        return this.csvColumns;
    }

    @Override
    @NotNull
    public CellProcessor[] getProcessors() {
        return this.processors;
    }

    @Override
    public boolean getWriteHeaders() {
        return this.writeHeaders;
    }

    @Override
    @NotNull
    public Logger getLog() {
        return this.log;
    }

    @Override
    @NotNull
    protected Sequence<MigratedFileEntity> findAll(@NotNull String mediaClientId, @NotNull CloudSite cloudSite2) {
        Intrinsics.checkNotNullParameter((Object)mediaClientId, (String)"mediaClientId");
        Intrinsics.checkNotNullParameter((Object)cloudSite2, (String)"cloudSite");
        return this.migratedFileRepository.findAllFilesToMigrate(mediaClientId);
    }

    @Nullable
    public final Path getAttachmentsAndExportToCsv(@NotNull CloudSite cloudSite2) {
        Intrinsics.checkNotNullParameter((Object)cloudSite2, (String)"cloudSite");
        String mediaClientId = this.mediaClient.getMediaClientId(cloudSite2.getContainerToken());
        Sequence<MigratedFileEntity> allAttachments = this.findAll(mediaClientId, cloudSite2);
        return this.exportToCsv(allAttachments);
    }
}

