/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.attachments.csvgenerator;

import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.common.LocalFileDataOutput;
import com.atlassian.jira.migration.email.IncorrectEmailService;
import com.atlassian.jira.migration.email.InvalidAndDuplicateEmailFix;
import com.atlassian.jira.migration.workers.attachments.csvgenerator.AbstractCsvExporter;
import com.atlassian.jira.migration.workers.attachments.csvgenerator.InvalidAndDuplicateEmailFixCsvExporter;
import com.atlassian.migration.udc.common.model.EmailCheckType;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.supercsv.cellprocessor.ift.CellProcessor;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020#2\u0006\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020&H\u0014J\u0018\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020\n2\u0006\u0010%\u001a\u00020&R\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u000e\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\tX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u001d\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001e\u001a\u00020\u001fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006*"}, d2={"Lcom/atlassian/jira/migration/workers/attachments/csvgenerator/InvalidAndDuplicateEmailFixCsvExporter;", "Lcom/atlassian/jira/migration/workers/attachments/csvgenerator/AbstractCsvExporter;", "Lcom/atlassian/jira/migration/email/InvalidAndDuplicateEmailFix;", "localFileDataOutput", "Lcom/atlassian/jira/migration/common/LocalFileDataOutput;", "incorrectEmailService", "Lcom/atlassian/jira/migration/email/IncorrectEmailService;", "(Lcom/atlassian/jira/migration/common/LocalFileDataOutput;Lcom/atlassian/jira/migration/email/IncorrectEmailService;)V", "csvColumns", "", "", "getCsvColumns", "()[Ljava/lang/String;", "[Ljava/lang/String;", "fileNamePrefix", "getFileNamePrefix", "()Ljava/lang/String;", "getIncorrectEmailService", "()Lcom/atlassian/jira/migration/email/IncorrectEmailService;", "getLocalFileDataOutput", "()Lcom/atlassian/jira/migration/common/LocalFileDataOutput;", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "processors", "Lorg/supercsv/cellprocessor/ift/CellProcessor;", "getProcessors", "()[Lorg/supercsv/cellprocessor/ift/CellProcessor;", "[Lorg/supercsv/cellprocessor/ift/CellProcessor;", "writeHeaders", "", "getWriteHeaders", "()Z", "findAll", "Lkotlin/sequences/Sequence;", "executionId", "cloudSite", "Lcom/atlassian/jira/migration/cloud/CloudSite;", "getIncorrectEmailsAndExportToCsv", "Ljava/nio/file/Path;", "token", "jira-migration-plugin"})
public final class InvalidAndDuplicateEmailFixCsvExporter
extends AbstractCsvExporter<InvalidAndDuplicateEmailFix> {
    @NotNull
    private final LocalFileDataOutput localFileDataOutput;
    @NotNull
    private final IncorrectEmailService incorrectEmailService;
    @NotNull
    private final String fileNamePrefix;
    @NotNull
    private final String[] csvColumns;
    @NotNull
    private final CellProcessor[] processors;
    private final boolean writeHeaders;
    @NotNull
    private final Logger log;

    @Inject
    public InvalidAndDuplicateEmailFixCsvExporter(@NotNull LocalFileDataOutput localFileDataOutput, @NotNull IncorrectEmailService incorrectEmailService) {
        Intrinsics.checkNotNullParameter((Object)((Object)localFileDataOutput), (String)"localFileDataOutput");
        Intrinsics.checkNotNullParameter((Object)incorrectEmailService, (String)"incorrectEmailService");
        super(localFileDataOutput);
        this.localFileDataOutput = localFileDataOutput;
        this.incorrectEmailService = incorrectEmailService;
        this.fileNamePrefix = "fixedUsers";
        String[] stringArray = new String[]{"UserName", "OldEmail", "NewEmail", "Tombstone", "AccountType"};
        this.csvColumns = stringArray;
        stringArray = new CellProcessor[]{null, null, null, null, null};
        this.processors = stringArray;
        this.writeHeaders = true;
        Logger logger2 = LoggerFactory.getLogger(InvalidAndDuplicateEmailFixCsvExporter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        this.log = logger2;
    }

    @NotNull
    public final LocalFileDataOutput getLocalFileDataOutput() {
        return this.localFileDataOutput;
    }

    @NotNull
    public final IncorrectEmailService getIncorrectEmailService() {
        return this.incorrectEmailService;
    }

    @Override
    @NotNull
    public String getFileNamePrefix() {
        return this.fileNamePrefix;
    }

    @Override
    @NotNull
    public String[] getCsvColumns() {
        return this.csvColumns;
    }

    @Override
    @NotNull
    public CellProcessor[] getProcessors() {
        return this.processors;
    }

    @Override
    public boolean getWriteHeaders() {
        return this.writeHeaders;
    }

    @Override
    @NotNull
    public Logger getLog() {
        return this.log;
    }

    @Override
    @NotNull
    protected Sequence<InvalidAndDuplicateEmailFix> findAll(@NotNull String executionId, @NotNull CloudSite cloudSite2) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)cloudSite2, (String)"cloudSite");
        return SequencesKt.plus((Sequence)SequencesKt.plus(this.incorrectEmailService.getIncorrectEmailsSequence(executionId, cloudSite2.getCloudId(), EmailCheckType.INV), (Sequence)SequencesKt.filter(this.incorrectEmailService.getIncorrectEmailsSequence(executionId, cloudSite2.getCloudId(), EmailCheckType.DUP), (Function1)findAll.1.INSTANCE)), this.incorrectEmailService.getModifiedValidEmailsSequence());
    }

    @Nullable
    public final Path getIncorrectEmailsAndExportToCsv(@NotNull String token, @NotNull CloudSite cloudSite2) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)cloudSite2, (String)"cloudSite");
        long startTime = System.nanoTime();
        Sequence<InvalidAndDuplicateEmailFix> allIncorrectEmails = this.findAll(token, cloudSite2);
        Path path = this.exportToCsv(allIncorrectEmails);
        this.getLog().info("fixedUsers.csv generated in " + TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - startTime) + 's');
        return path;
    }
}

