/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.attachments.csvgenerator;

import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.common.LocalFileDataOutput;
import com.atlassian.jira.migration.common.liftandshift.UserMetadataRecord;
import com.atlassian.jira.migration.common.liftandshift.UsersMetadataExtractor;
import com.atlassian.jira.migration.plan.UsersGroupsMigrationOption;
import com.atlassian.jira.migration.workers.attachments.csvgenerator.AbstractCsvExporter;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.supercsv.cellprocessor.ift.CellProcessor;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u001f2\u0006\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\"H\u0014J\u0010\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010!\u001a\u00020\"R\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u000e\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\tX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0019\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u001bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006%"}, d2={"Lcom/atlassian/jira/migration/workers/attachments/csvgenerator/UsersMetadataCSVExporter;", "Lcom/atlassian/jira/migration/workers/attachments/csvgenerator/AbstractCsvExporter;", "Lcom/atlassian/jira/migration/common/liftandshift/UserMetadataRecord;", "localFileDataOutput", "Lcom/atlassian/jira/migration/common/LocalFileDataOutput;", "userMetadataExtractor", "Lcom/atlassian/jira/migration/common/liftandshift/UsersMetadataExtractor;", "(Lcom/atlassian/jira/migration/common/LocalFileDataOutput;Lcom/atlassian/jira/migration/common/liftandshift/UsersMetadataExtractor;)V", "csvColumns", "", "", "getCsvColumns", "()[Ljava/lang/String;", "[Ljava/lang/String;", "fileNamePrefix", "getFileNamePrefix", "()Ljava/lang/String;", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "processors", "Lorg/supercsv/cellprocessor/ift/CellProcessor;", "getProcessors", "()[Lorg/supercsv/cellprocessor/ift/CellProcessor;", "[Lorg/supercsv/cellprocessor/ift/CellProcessor;", "writeHeaders", "", "getWriteHeaders", "()Z", "findAll", "Lkotlin/sequences/Sequence;", "mediaClientId", "cloudSite", "Lcom/atlassian/jira/migration/cloud/CloudSite;", "getUsersMetadataExportToCsv", "Ljava/nio/file/Path;", "jira-migration-plugin"})
public final class UsersMetadataCSVExporter
extends AbstractCsvExporter<UserMetadataRecord> {
    @NotNull
    private final UsersMetadataExtractor userMetadataExtractor;
    @NotNull
    private final String fileNamePrefix;
    @NotNull
    private final String[] csvColumns;
    @NotNull
    private final CellProcessor[] processors;
    private final boolean writeHeaders;
    @NotNull
    private final Logger log;

    @Inject
    public UsersMetadataCSVExporter(@NotNull LocalFileDataOutput localFileDataOutput, @NotNull UsersMetadataExtractor userMetadataExtractor) {
        Intrinsics.checkNotNullParameter((Object)((Object)localFileDataOutput), (String)"localFileDataOutput");
        Intrinsics.checkNotNullParameter((Object)userMetadataExtractor, (String)"userMetadataExtractor");
        super(localFileDataOutput);
        this.userMetadataExtractor = userMetadataExtractor;
        this.fileNamePrefix = "user-meta-data";
        String[] stringArray = new String[]{"UserName", "Email", "UserAccountType"};
        this.csvColumns = stringArray;
        stringArray = new CellProcessor[]{null, null, null};
        this.processors = stringArray;
        this.writeHeaders = true;
        Logger logger2 = LoggerFactory.getLogger(UsersMetadataCSVExporter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        this.log = logger2;
    }

    @Override
    @NotNull
    public String getFileNamePrefix() {
        return this.fileNamePrefix;
    }

    @Override
    @NotNull
    public String[] getCsvColumns() {
        return this.csvColumns;
    }

    @Override
    @NotNull
    public CellProcessor[] getProcessors() {
        return this.processors;
    }

    @Override
    public boolean getWriteHeaders() {
        return this.writeHeaders;
    }

    @Override
    @NotNull
    public Logger getLog() {
        return this.log;
    }

    @Override
    @NotNull
    protected Sequence<UserMetadataRecord> findAll(@NotNull String mediaClientId, @NotNull CloudSite cloudSite2) {
        Intrinsics.checkNotNullParameter((Object)mediaClientId, (String)"mediaClientId");
        Intrinsics.checkNotNullParameter((Object)cloudSite2, (String)"cloudSite");
        return CollectionsKt.asSequence((Iterable)this.userMetadataExtractor.extract(new UsersGroupsMigrationOption(UsersGroupsMigrationOption.MigrationMode.ALL, true, false, false, null, 28, null), cloudSite2.getCloudId()));
    }

    @Nullable
    public final Path getUsersMetadataExportToCsv(@NotNull CloudSite cloudSite2) {
        Intrinsics.checkNotNullParameter((Object)cloudSite2, (String)"cloudSite");
        long startTime = System.nanoTime();
        Sequence<UserMetadataRecord> records = this.findAll("", cloudSite2);
        Path path = this.exportToCsv(records);
        this.getLog().info("user-meta-data.csv generated in " + TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - startTime) + 's');
        return path;
    }
}

