/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.attachments.preload;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.jira.migration.GroupedThreadFactory;
import com.atlassian.jira.migration.app.preload.AppDataPreloadService;
import com.atlassian.jira.migration.app.preload.AppDataPreloadServiceKt;
import com.atlassian.jira.migration.app.preload.AppDataPreloadStatus;
import com.atlassian.jira.migration.app.preload.Sha256Calculator;
import com.atlassian.jira.migration.app.preload.TransferDetails;
import com.atlassian.jira.migration.app.preload.UploadedChunkDetails;
import com.atlassian.jira.migration.common.Sink;
import com.atlassian.jira.migration.migration.MigrationRepository;
import com.atlassian.jira.migration.tracking.tasks.Task;
import com.atlassian.jira.migration.utility.FileChunkUtility;
import com.atlassian.jira.migration.workers.attachments.FixedDelayCloseableRunner;
import com.atlassian.jira.migration.workers.attachments.FixedDelayCloseableRunnerFactory;
import com.atlassian.jira.migration.workers.attachments.MediaUploadProgress;
import com.atlassian.jira.migration.workers.attachments.preload.AppDataPreloadProcessor;
import com.atlassian.jira.migration.workers.attachments.preload.AppDataPreloadProcessorKt;
import com.atlassian.jira.migration.workers.attachments.preload.AppDataPreloaderKt;
import com.atlassian.jira.migration.workers.attachments.preload.PreloadAnalyticEventInfo;
import com.atlassian.jira.migration.workers.attachments.preload.PreloadProjectManager;
import com.atlassian.jira.migration.workers.attachments.preload.PreloadPrometheusMetricsKt;
import com.atlassian.jira.migration.workers.attachments.preload.TaskDetails;
import com.atlassian.migration.app.dto.EnrichedAppDataDetails;
import com.atlassian.migration.app.dto.InitializeUploadResponse;
import io.prometheus.metrics.core.datapoints.CounterDataPoint;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B?\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ4\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J;\u0010%\u001a\u001d\u0012\u0013\u0012\u00110\"\u00a2\u0006\f\b&\u0012\b\b'\u0012\u0004\b\b((\u0012\u0004\u0012\u00020\u001c0\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J8\u0010)\u001a\u00020\u001c2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\"0+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\"2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\u001c0\u001aJ<\u00101\u001a\u00020\u001c2\u0006\u00102\u001a\u0002032\u0006\u0010,\u001a\u00020-2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\u001c0\u001aH\u0002J,\u00104\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\u001c0\u001aH\u0002J$\u00105\u001a\u000206*\u00020\u001e2\u0006\u0010,\u001a\u00020-2\u0006\u00102\u001a\u0002032\u0006\u0010!\u001a\u00020\"H\u0002R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0014\u001a\n \u0012*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0016\u0010\u0017\u001a\n \u0012*\u0004\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/atlassian/jira/migration/workers/attachments/preload/AppDataPreloadProcessor;", "", "appDataPreloadService", "Lcom/atlassian/jira/migration/app/preload/AppDataPreloadService;", "projectManager", "Lcom/atlassian/jira/migration/workers/attachments/preload/PreloadProjectManager;", "migrationRepository", "Lcom/atlassian/jira/migration/migration/MigrationRepository;", "fixedDelayCloseableRunnerFactory", "Lcom/atlassian/jira/migration/workers/attachments/FixedDelayCloseableRunnerFactory;", "analyticSink", "Lcom/atlassian/jira/migration/common/Sink;", "Lcom/atlassian/cmpt/analytics/events/EventDto;", "clock", "Ljava/time/Clock;", "(Lcom/atlassian/jira/migration/app/preload/AppDataPreloadService;Lcom/atlassian/jira/migration/workers/attachments/preload/PreloadProjectManager;Lcom/atlassian/jira/migration/migration/MigrationRepository;Lcom/atlassian/jira/migration/workers/attachments/FixedDelayCloseableRunnerFactory;Lcom/atlassian/jira/migration/common/Sink;Ljava/time/Clock;)V", "checkDbBatchSize", "", "kotlin.jvm.PlatformType", "Ljava/lang/Integer;", "heartbeatInterval", "", "Ljava/lang/Long;", "log", "Lorg/slf4j/Logger;", "onPreloadDataFailure", "Lkotlin/Function1;", "", "", "enrichedAppDataDetails", "Lcom/atlassian/migration/app/dto/EnrichedAppDataDetails;", "transferDetails", "Lcom/atlassian/jira/migration/app/preload/TransferDetails;", "projectId", "", "preloadAnalyticEventInfo", "Lcom/atlassian/jira/migration/workers/attachments/preload/PreloadAnalyticEventInfo;", "onPreloadDataSuccess", "Lkotlin/ParameterName;", "name", "value", "process", "preloadableApps", "", "task", "Lcom/atlassian/jira/migration/tracking/tasks/Task;", "projectKey", "uploadProgress", "Lcom/atlassian/jira/migration/workers/attachments/MediaUploadProgress;", "uploadAndTrack", "taskDetails", "Lcom/atlassian/jira/migration/workers/attachments/preload/TaskDetails;", "uploadData", "handleFileNotFound", "", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAppDataPreloadProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppDataPreloadProcessor.kt\ncom/atlassian/jira/migration/workers/attachments/preload/AppDataPreloadProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,263:1\n1#2:264\n1549#3:265\n1620#3,3:266\n766#3:269\n857#3,2:270\n766#3:272\n857#3,2:273\n1549#3:275\n1620#3,3:276\n1855#3,2:279\n*S KotlinDebug\n*F\n+ 1 AppDataPreloadProcessor.kt\ncom/atlassian/jira/migration/workers/attachments/preload/AppDataPreloadProcessor\n*L\n100#1:265\n100#1:266,3\n105#1:269\n105#1:270,2\n106#1:272\n106#1:273,2\n107#1:275\n107#1:276,3\n119#1:279,2\n*E\n"})
public final class AppDataPreloadProcessor {
    @NotNull
    private final AppDataPreloadService appDataPreloadService;
    @NotNull
    private final PreloadProjectManager projectManager;
    @NotNull
    private final MigrationRepository migrationRepository;
    @NotNull
    private final FixedDelayCloseableRunnerFactory fixedDelayCloseableRunnerFactory;
    @NotNull
    private final Sink<EventDto> analyticSink;
    @NotNull
    private final Clock clock;
    private final Integer checkDbBatchSize;
    private final Logger log;
    private final Long heartbeatInterval;

    @Inject
    public AppDataPreloadProcessor(@NotNull AppDataPreloadService appDataPreloadService, @NotNull PreloadProjectManager projectManager, @NotNull MigrationRepository migrationRepository, @NotNull FixedDelayCloseableRunnerFactory fixedDelayCloseableRunnerFactory, @NotNull Sink<EventDto> analyticSink, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)appDataPreloadService, (String)"appDataPreloadService");
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)migrationRepository, (String)"migrationRepository");
        Intrinsics.checkNotNullParameter((Object)fixedDelayCloseableRunnerFactory, (String)"fixedDelayCloseableRunnerFactory");
        Intrinsics.checkNotNullParameter(analyticSink, (String)"analyticSink");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.appDataPreloadService = appDataPreloadService;
        this.projectManager = projectManager;
        this.migrationRepository = migrationRepository;
        this.fixedDelayCloseableRunnerFactory = fixedDelayCloseableRunnerFactory;
        this.analyticSink = analyticSink;
        this.clock = clock;
        this.checkDbBatchSize = Integer.getInteger("jcma.app.preload.should-upload-db-batch-size", 1000);
        this.log = LoggerFactory.getLogger(AppDataPreloadProcessor.class);
        this.heartbeatInterval = Long.getLong("jcma.app.preload.heartbeat-interval-seconds", AppDataPreloaderKt.getDEFAULT_HEARTBEAT_INTERVAL().getSeconds());
    }

    public /* synthetic */ AppDataPreloadProcessor(AppDataPreloadService appDataPreloadService, PreloadProjectManager preloadProjectManager, MigrationRepository migrationRepository, FixedDelayCloseableRunnerFactory fixedDelayCloseableRunnerFactory, Sink sink, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC(...)");
            clock = clock2;
        }
        this(appDataPreloadService, preloadProjectManager, migrationRepository, fixedDelayCloseableRunnerFactory, sink, clock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void process(@NotNull List<String> preloadableApps, @NotNull Task task, @NotNull String projectKey, @NotNull Function1<? super MediaUploadProgress, Unit> uploadProgress) {
        Intrinsics.checkNotNullParameter(preloadableApps, (String)"preloadableApps");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        Intrinsics.checkNotNullParameter(uploadProgress, (String)"uploadProgress");
        Function0 function0 = (Function0)new Function0<Unit>(uploadProgress){
            final /* synthetic */ Function1<MediaUploadProgress, Unit> $uploadProgress;
            {
                this.$uploadProgress = $uploadProgress;
                super(0);
            }

            public final void invoke() {
                Unit unit;
                this.$uploadProgress.invoke((Object)MediaUploadProgress.NoChangeProgress.INSTANCE);
                Unit it = unit = Unit.INSTANCE;
                boolean bl = false;
                PreloadPrometheusMetricsKt.getPreloaderHeartbeaterCounter().inc();
            }
        };
        Long l = this.heartbeatInterval;
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"heartbeatInterval");
        AutoCloseable autoCloseable = FixedDelayCloseableRunnerFactory.create$default(this.fixedDelayCloseableRunnerFactory, function0, ((Number)l).longValue(), TimeUnit.SECONDS, 0L, 8, null);
        Throwable throwable = null;
        try {
            int n;
            FixedDelayCloseableRunner it = (FixedDelayCloseableRunner)autoCloseable;
            boolean bl = false;
            String string = this.migrationRepository.findPlanIdByMigrationId(task.getMigrationId());
            if (string == null) {
                String string2 = "Required value was null.";
                throw new IllegalArgumentException(string2.toString());
            }
            String planId = string;
            TaskDetails transferDetails = new TaskDetails(planId, projectKey);
            int it2 = n = (int)Long.getLong("jcma.app.preload.threads", 20L).longValue();
            boolean bl2 = false;
            this.log.debug("Number of threads for app preload is " + it2);
            ExecutorService executor = Executors.newFixedThreadPool(n, new GroupedThreadFactory("AppDataPreload-Thread-" + projectKey));
            String string3 = task.getCloudId();
            String string4 = task.getCloudSite().getCloudUrl().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
            PreloadAnalyticEventInfo preloadAnalyticEventInfo = new PreloadAnalyticEventInfo(string3, string4, task.getMigrationId(), planId, task.getTaskId(), projectKey, preloadableApps);
            long processPreloadStartTime = this.clock.millis();
            List futures2 = new ArrayList();
            try {
                Object object;
                for (String preloadableApp : preloadableApps) {
                    this.log.info("processPreload:" + projectKey + " - starting for " + preloadableApp);
                    Sequence sequence = SequencesKt.distinctBy(this.appDataPreloadService.getAppDataForPreloadByProjectKey(CollectionsKt.listOf((Object)preloadableApp), projectKey, () -> AppDataPreloadProcessor.process$lambda$9$lambda$1(uploadProgress)), (Function1)process.2.batches.2.INSTANCE);
                    Integer n2 = this.checkDbBatchSize;
                    Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"checkDbBatchSize");
                    Sequence batches2 = SequencesKt.chunked((Sequence)sequence, (int)((Number)n2).intValue());
                    for (List batch : batches2) {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Iterable $this$filterTo$iv$iv;
                        Iterable $this$filter$iv;
                        Collection collection;
                        void $this$mapTo$iv$iv2;
                        void $this$map$iv2;
                        object = batch;
                        Object object2 = this.appDataPreloadService;
                        boolean $i$f$map22 = false;
                        void var26_36 = $this$map$iv2;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                            void it3;
                            EnrichedAppDataDetails enrichedAppDataDetails = (EnrichedAppDataDetails)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl3 = false;
                            collection.add(it3.getAppDataDetails().getId());
                        }
                        Set shouldUploadFileIds = CollectionsKt.toSet((Iterable)((AppDataPreloadService)object2).shouldUploadByBatch((List)destination$iv$iv, preloadableApp, task.getCloudId()));
                        String projectId = String.valueOf(this.projectManager.getProjectObjByKey(transferDetails.getProjectKey()).getId());
                        Iterable $i$f$map22 = batch;
                        object2 = futures2;
                        boolean $i$f$filter = false;
                        destination$iv$iv = $this$filter$iv;
                        Collection destination$iv$iv2 = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            EnrichedAppDataDetails it4 = (EnrichedAppDataDetails)element$iv$iv;
                            boolean bl4 = false;
                            if (!shouldUploadFileIds.contains(it4.getAppDataDetails().getId())) continue;
                            destination$iv$iv2.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv2;
                        $i$f$filter = false;
                        $this$filterTo$iv$iv = $this$filter$iv;
                        destination$iv$iv2 = new ArrayList();
                        $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            EnrichedAppDataDetails it5 = (EnrichedAppDataDetails)element$iv$iv;
                            boolean bl5 = false;
                            if (!this.handleFileNotFound(it5, task, transferDetails, projectId)) continue;
                            destination$iv$iv2.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv2;
                        boolean $i$f$map = false;
                        $this$filterTo$iv$iv = $this$map$iv;
                        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo2 = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            Future<?> future;
                            EnrichedAppDataDetails it5 = (EnrichedAppDataDetails)item$iv$iv;
                            collection = destination$iv$iv2;
                            boolean bl6 = false;
                            Future<?> it6 = future = executor.submit(() -> AppDataPreloadProcessor.process$lambda$9$lambda$7$lambda$5(this, transferDetails, task, it5, preloadAnalyticEventInfo, uploadProgress));
                            boolean bl7 = false;
                            String[] stringArray = new String[]{projectKey};
                            ((CounterDataPoint)AppDataPreloadProcessorKt.access$getFilesToUpload$p().labelValues(stringArray)).inc();
                            collection.add(future);
                        }
                        object2.addAll((List)destination$iv$iv2);
                    }
                }
                Iterable $this$forEach$iv = futures2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Future future = (Future)element$iv;
                    boolean bl8 = false;
                    try {
                        boolean bl9 = false;
                        object = Result.constructor-impl(future.get());
                    }
                    catch (Throwable throwable2) {
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                    }
                    object = new String[]{projectKey};
                    ((CounterDataPoint)AppDataPreloadProcessorKt.access$getFilesUploaded$p().labelValues(object)).inc();
                }
                this.log.info("processPreload:" + projectKey + " - Finished preloading [" + ((Collection)futures2).size() + "] files in \"" + (this.clock.millis() - processPreloadStartTime) + "\" ms");
                this.analyticSink.put(preloadAnalyticEventInfo.toCompletedProcessProjectEventDto(this.clock.millis(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"totalFiles", (Object)((Collection)futures2).size()))));
            }
            catch (Throwable ex) {
                this.analyticSink.put(preloadAnalyticEventInfo.toFailedProcessProjectEventDto(this.clock.millis(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"reason", (Object)String.valueOf(ex.getMessage())))));
                this.log.error("processPreload:" + projectKey + " - Error while processing app data preload for project " + projectKey, ex);
                throw ex;
            }
            finally {
                executor.shutdown();
                executor.awaitTermination(1L, TimeUnit.HOURS);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final void uploadAndTrack(TaskDetails taskDetails, Task task, EnrichedAppDataDetails enrichedAppDataDetails, PreloadAnalyticEventInfo preloadAnalyticEventInfo, Function1<? super MediaUploadProgress, Unit> uploadProgress) {
        Object $this$uploadAndTrack_u24lambda_u2410;
        TransferDetails transferDetails = new TransferDetails(taskDetails.getFakeTransferId(), task.getMigrationId(), task.getCloudId(), enrichedAppDataDetails.getCloudAppKey());
        String projectId = String.valueOf(this.projectManager.getProjectObjByKey(taskDetails.getProjectKey()).getId());
        Object object = this;
        try {
            $this$uploadAndTrack_u24lambda_u2410 = object;
            boolean bl = false;
            $this$uploadAndTrack_u24lambda_u2410 = Result.constructor-impl((Object)super.uploadData(enrichedAppDataDetails, transferDetails, uploadProgress));
        }
        catch (Throwable bl) {
            $this$uploadAndTrack_u24lambda_u2410 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$uploadAndTrack_u24lambda_u2410;
        $this$uploadAndTrack_u24lambda_u2410 = this.onPreloadDataSuccess(enrichedAppDataDetails, transferDetails, projectId);
        if (Result.isSuccess-impl((Object)object)) {
            $this$uploadAndTrack_u24lambda_u2410.invoke(object);
        }
        $this$uploadAndTrack_u24lambda_u2410 = this.onPreloadDataFailure(enrichedAppDataDetails, transferDetails, projectId, preloadAnalyticEventInfo);
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            bl = throwable;
            $this$uploadAndTrack_u24lambda_u2410.invoke((Object)bl);
        }
        Object it = object;
        boolean bl = false;
        uploadProgress.invoke((Object)new MediaUploadProgress.UploadedItemCountProgress(1L));
        ResultKt.throwOnFailure((Object)object);
    }

    private final Function1<Throwable, Unit> onPreloadDataFailure(EnrichedAppDataDetails enrichedAppDataDetails, TransferDetails transferDetails, String projectId, PreloadAnalyticEventInfo preloadAnalyticEventInfo) {
        return (Function1)new Function1<Throwable, Unit>(this, preloadAnalyticEventInfo, transferDetails, enrichedAppDataDetails, projectId){
            final /* synthetic */ AppDataPreloadProcessor this$0;
            final /* synthetic */ PreloadAnalyticEventInfo $preloadAnalyticEventInfo;
            final /* synthetic */ TransferDetails $transferDetails;
            final /* synthetic */ EnrichedAppDataDetails $enrichedAppDataDetails;
            final /* synthetic */ String $projectId;
            {
                this.this$0 = $receiver;
                this.$preloadAnalyticEventInfo = $preloadAnalyticEventInfo;
                this.$transferDetails = $transferDetails;
                this.$enrichedAppDataDetails = $enrichedAppDataDetails;
                this.$projectId = $projectId;
                super(1);
            }

            public final void invoke(@NotNull Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Object object = new String[]{"other"};
                ((CounterDataPoint)PreloadPrometheusMetricsKt.getFailedPreloadFilesCounter().labelValues(object)).inc();
                AppDataPreloadProcessor.access$getAnalyticSink$p(this.this$0).put(this.$preloadAnalyticEventInfo.toFailedPreloadUploadEventDto(AppDataPreloadProcessor.access$getClock$p(this.this$0).millis(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"reason", (Object)String.valueOf(it.getMessage())))));
                object = AppDataPreloadServiceKt.createAppDataPreloadStatusFrom(this.$transferDetails, this.$enrichedAppDataDetails, this.$projectId);
                String string = it.getMessage();
                AppDataPreloadProcessor.access$getAppDataPreloadService$p(this.this$0).saveAppDataPreloadStatus(AppDataPreloadStatus.copy$default((AppDataPreloadStatus)object, 0L, null, null, null, null, null, null, null, false, string, null, null, null, 7423, null));
                AppDataPreloadProcessor.access$getLog$p(this.this$0).warn("App data under project id: " + this.$projectId + " failed to upload, cloudAppKey: " + this.$enrichedAppDataDetails.getCloudAppKey() + ", vendorFileId: " + this.$enrichedAppDataDetails.getAppDataDetails().getId(), it);
            }
        };
    }

    private final Function1<String, Unit> onPreloadDataSuccess(EnrichedAppDataDetails enrichedAppDataDetails, TransferDetails transferDetails, String projectId) {
        return (Function1)new Function1<String, Unit>(this, transferDetails, enrichedAppDataDetails, projectId){
            final /* synthetic */ AppDataPreloadProcessor this$0;
            final /* synthetic */ TransferDetails $transferDetails;
            final /* synthetic */ EnrichedAppDataDetails $enrichedAppDataDetails;
            final /* synthetic */ String $projectId;
            {
                this.this$0 = $receiver;
                this.$transferDetails = $transferDetails;
                this.$enrichedAppDataDetails = $enrichedAppDataDetails;
                this.$projectId = $projectId;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                PreloadPrometheusMetricsKt.getSuccessPreloadFilesCounter().inc();
                AppDataPreloadProcessor.access$getAppDataPreloadService$p(this.this$0).saveAppDataPreloadStatus(AppDataPreloadStatus.copy$default(AppDataPreloadServiceKt.createAppDataPreloadStatusFrom(this.$transferDetails, this.$enrichedAppDataDetails, this.$projectId), 0L, null, it, null, null, null, null, null, true, null, null, null, this.$enrichedAppDataDetails.getAppDataDetails().getInfo(), 3835, null));
                AppDataPreloadProcessor.access$getLog$p(this.this$0).info("App data under project id: " + this.$projectId + " was uploaded successfully, cloudAppKey: " + this.$enrichedAppDataDetails.getCloudAppKey() + ", vendorFileId: " + this.$enrichedAppDataDetails.getAppDataDetails().getId());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String uploadData(EnrichedAppDataDetails enrichedAppDataDetails, TransferDetails transferDetails, Function1<? super MediaUploadProgress, Unit> uploadProgress) {
        InitializeUploadResponse initPreloadResponse = this.appDataPreloadService.initializePreload(transferDetails);
        Sha256Calculator sha256Calculator = Sha256Calculator.Companion.newInstance();
        Path path = enrichedAppDataDetails.getAppDataDetails().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        Object object = path;
        Object object2 = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream((Path)object, Arrays.copyOf(object2, ((OpenOption[])object2).length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        object = inputStream;
        object2 = null;
        try {
            InputStream it = (InputStream)object;
            boolean bl = false;
            Pair pair = SequencesKt.unzip((Sequence)SequencesKt.map(FileChunkUtility.INSTANCE.toChunks(it, 0x1900000), (Function1)((Function1)new Function1<IndexedValue<? extends byte[]>, Pair<? extends String, ? extends String>>(this, initPreloadResponse, transferDetails, sha256Calculator, uploadProgress){
                final /* synthetic */ AppDataPreloadProcessor this$0;
                final /* synthetic */ InitializeUploadResponse $initPreloadResponse;
                final /* synthetic */ TransferDetails $transferDetails;
                final /* synthetic */ Sha256Calculator $sha256Calculator;
                final /* synthetic */ Function1<MediaUploadProgress, Unit> $uploadProgress;
                {
                    this.this$0 = $receiver;
                    this.$initPreloadResponse = $initPreloadResponse;
                    this.$transferDetails = $transferDetails;
                    this.$sha256Calculator = $sha256Calculator;
                    this.$uploadProgress = $uploadProgress;
                    super(1);
                }

                @NotNull
                public final Pair<String, String> invoke(@NotNull IndexedValue<byte[]> indexedValue) {
                    Intrinsics.checkNotNullParameter(indexedValue, (String)"<name for destructuring parameter 0>");
                    int index = indexedValue.component1();
                    byte[] chunk = (byte[])indexedValue.component2();
                    UploadedChunkDetails uploadedChunkDetails = AppDataPreloadProcessor.access$getAppDataPreloadService$p(this.this$0).uploadChunk(chunk, this.$initPreloadResponse, this.$transferDetails, this.$sha256Calculator.calculateAndEncodeToBase64(chunk), index + 1);
                    String digest = uploadedChunkDetails.component1();
                    String etag = uploadedChunkDetails.component2();
                    PreloadPrometheusMetricsKt.getPreloadedBytesCounter().inc((long)chunk.length);
                    this.$uploadProgress.invoke((Object)new MediaUploadProgress.UploadedChunkSizeProgress(chunk.length));
                    return TuplesKt.to((Object)etag, (Object)digest);
                }
            })));
            List eTags = (List)pair.component1();
            List digests = (List)pair.component2();
            this.appDataPreloadService.finalizePreload(eTags, digests, initPreloadResponse, transferDetails);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        return initPreloadResponse.getS3Key();
    }

    private final boolean handleFileNotFound(EnrichedAppDataDetails $this$handleFileNotFound, Task task, TaskDetails taskDetails, String projectId) {
        if ($this$handleFileNotFound.getAppDataDetails().getPath().toFile().exists()) {
            return true;
        }
        this.log.info("App Data file is missing " + $this$handleFileNotFound.getAppDataDetails());
        String[] stringArray = new String[]{"missing"};
        ((CounterDataPoint)PreloadPrometheusMetricsKt.getFailedPreloadFilesCounter().labelValues(stringArray)).inc();
        this.appDataPreloadService.saveAppDataPreloadStatus(AppDataPreloadStatus.copy$default(AppDataPreloadServiceKt.createAppDataPreloadStatusFrom(new TransferDetails(taskDetails.getFakeTransferId(), task.getMigrationId(), task.getCloudId(), $this$handleFileNotFound.getCloudAppKey()), $this$handleFileNotFound, projectId), 0L, null, null, null, null, null, null, null, false, "File not found", null, null, null, 7423, null));
        return false;
    }

    private static final void process$lambda$9$lambda$1(Function1 $uploadProgress) {
        Intrinsics.checkNotNullParameter((Object)$uploadProgress, (String)"$uploadProgress");
        $uploadProgress.invoke((Object)MediaUploadProgress.NoChangeProgress.INSTANCE);
    }

    private static final void process$lambda$9$lambda$7$lambda$5(AppDataPreloadProcessor this$0, TaskDetails $transferDetails, Task $task, EnrichedAppDataDetails $it, PreloadAnalyticEventInfo $preloadAnalyticEventInfo, Function1 $uploadProgress) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$transferDetails, (String)"$transferDetails");
        Intrinsics.checkNotNullParameter((Object)$task, (String)"$task");
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        Intrinsics.checkNotNullParameter((Object)$preloadAnalyticEventInfo, (String)"$preloadAnalyticEventInfo");
        Intrinsics.checkNotNullParameter((Object)$uploadProgress, (String)"$uploadProgress");
        this$0.uploadAndTrack($transferDetails, $task, $it, $preloadAnalyticEventInfo, (Function1<? super MediaUploadProgress, Unit>)$uploadProgress);
    }

    public static final /* synthetic */ Sink access$getAnalyticSink$p(AppDataPreloadProcessor $this) {
        return $this.analyticSink;
    }

    public static final /* synthetic */ Clock access$getClock$p(AppDataPreloadProcessor $this) {
        return $this.clock;
    }

    public static final /* synthetic */ AppDataPreloadService access$getAppDataPreloadService$p(AppDataPreloadProcessor $this) {
        return $this.appDataPreloadService;
    }

    public static final /* synthetic */ Logger access$getLog$p(AppDataPreloadProcessor $this) {
        return $this.log;
    }
}

