/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.attachments.preload;

import com.atlassian.jira.migration.app.preload.AppDataPreloadStatusRepository;
import com.atlassian.jira.migration.app.preload.PartialAppDataPreloadStatus;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.MigrationStatusUpdatedEvent;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.lock.ExecutionStatus;
import com.atlassian.jira.migration.lock.MigrationClusterLockService;
import com.atlassian.jira.migration.lock.MigrationLockContext;
import com.atlassian.jira.migration.migration.Migration;
import com.atlassian.jira.migration.migration.MigrationRepository;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.plan.PlanRepository;
import com.atlassian.jira.migration.platform.CreateFileMpResponse;
import com.atlassian.jira.migration.platform.PlatformService;
import com.atlassian.jira.migration.platform.PlatformUploadServiceInterface;
import com.atlassian.jira.migration.utils.MigrationModeUtil;
import com.atlassian.migration.api.CloudId;
import com.atlassian.migration.api.ContainerToken;
import com.atlassian.migration.api.MigrationId;
import com.google.common.eventbus.Subscribe;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 %2\u00020\u0001:\u0001%BG\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\b\u0010\u001d\u001a\u00020\u001aH\u0007J\b\u0010\u001e\u001a\u00020\u001aH\u0007J\u0018\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\f\u0010#\u001a\u00020\u0018*\u00020$H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006&"}, d2={"Lcom/atlassian/jira/migration/workers/attachments/preload/AppDataPreloadStatusUploader;", "", "appDataPreloadStatusRepository", "Lcom/atlassian/jira/migration/app/preload/AppDataPreloadStatusRepository;", "platformService", "Lcom/atlassian/jira/migration/platform/PlatformService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "migrationClusterLockService", "Lcom/atlassian/jira/migration/lock/MigrationClusterLockService;", "migrationRepository", "Lcom/atlassian/jira/migration/migration/MigrationRepository;", "planRepository", "Lcom/atlassian/jira/migration/plan/PlanRepository;", "(Lcom/atlassian/jira/migration/app/preload/AppDataPreloadStatusRepository;Lcom/atlassian/jira/migration/platform/PlatformService;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/discovery/DiscoveryService;Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/migration/lock/MigrationClusterLockService;Lcom/atlassian/jira/migration/migration/MigrationRepository;Lcom/atlassian/jira/migration/plan/PlanRepository;)V", "getPlatformService", "()Lcom/atlassian/jira/migration/platform/PlatformService;", "isAppDataPreloadMigration", "", "migrationId", "", "onMigrationStatusUpdate", "", "event", "Lcom/atlassian/jira/migration/events/MigrationStatusUpdatedEvent;", "postConstruct", "preDestroy", "uploadAppDataPreloadStatusToMCS", "Lcom/atlassian/migration/api/MigrationId;", "cloudId", "Lcom/atlassian/migration/api/CloudId;", "toCsv", "Lcom/atlassian/jira/migration/app/preload/PartialAppDataPreloadStatus;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAppDataPreloadStatusUploader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppDataPreloadStatusUploader.kt\ncom/atlassian/jira/migration/workers/attachments/preload/AppDataPreloadStatusUploader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,176:1\n1#2:177\n*E\n"})
public final class AppDataPreloadStatusUploader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AppDataPreloadStatusRepository appDataPreloadStatusRepository;
    @NotNull
    private final PlatformService platformService;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final DiscoveryService discoveryService;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final MigrationClusterLockService migrationClusterLockService;
    @NotNull
    private final MigrationRepository migrationRepository;
    @NotNull
    private final PlanRepository planRepository;
    private static final Logger log = LoggerFactory.getLogger(AppDataPreloadStatusUploader.class);

    @Inject
    public AppDataPreloadStatusUploader(@NotNull AppDataPreloadStatusRepository appDataPreloadStatusRepository, @NotNull PlatformService platformService, @NotNull MigrationFeatures migrationFeatures, @NotNull DiscoveryService discoveryService, @NotNull MigrationEventBus migrationEventBus, @NotNull MigrationClusterLockService migrationClusterLockService, @NotNull MigrationRepository migrationRepository, @NotNull PlanRepository planRepository) {
        Intrinsics.checkNotNullParameter((Object)appDataPreloadStatusRepository, (String)"appDataPreloadStatusRepository");
        Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)migrationClusterLockService, (String)"migrationClusterLockService");
        Intrinsics.checkNotNullParameter((Object)migrationRepository, (String)"migrationRepository");
        Intrinsics.checkNotNullParameter((Object)planRepository, (String)"planRepository");
        this.appDataPreloadStatusRepository = appDataPreloadStatusRepository;
        this.platformService = platformService;
        this.migrationFeatures = migrationFeatures;
        this.discoveryService = discoveryService;
        this.migrationEventBus = migrationEventBus;
        this.migrationClusterLockService = migrationClusterLockService;
        this.migrationRepository = migrationRepository;
        this.planRepository = planRepository;
    }

    @NotNull
    public final PlatformService getPlatformService() {
        return this.platformService;
    }

    @PostConstruct
    public final void postConstruct() {
        this.migrationEventBus.register(this);
    }

    @PreDestroy
    public final void preDestroy() {
        this.migrationEventBus.unregister(this);
    }

    @Subscribe
    public final void onMigrationStatusUpdate(@NotNull MigrationStatusUpdatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.isMigrationCompleted()) {
            if (!this.migrationFeatures.getEnableAppDataPreload() && !this.migrationFeatures.getAppDataPreloadEnabledGA()) {
                log.info("Not performing app data preload stats file upload for migrationId: " + event.getMigrationId() + " (feature flag disabled)");
                return;
            }
            if (!this.isAppDataPreloadMigration(event.getMigrationId())) {
                log.info("Not performing app data preload stats file upload for migrationId: " + event.getMigrationId());
                return;
            }
            log.info("Migration status updated event received for migrationId: " + event.getMigrationId());
            String string = "com.atlassian.migration.app.AppDataPreloadStatusUploader.prefix:" + event.getMigrationId();
            String string2 = event.getMigrationId();
            ExecutionStatus result2 = this.migrationClusterLockService.executeWithLock(new MigrationLockContext(string2, string, 0L, null, 12, null), (Function1)new Function1<MigrationLockContext, Unit>(this, event){
                final /* synthetic */ AppDataPreloadStatusUploader this$0;
                final /* synthetic */ MigrationStatusUpdatedEvent $event;
                {
                    this.this$0 = $receiver;
                    this.$event = $event;
                    super(1);
                }

                public final void invoke(@NotNull MigrationLockContext it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    AppDataPreloadStatusUploader.access$uploadAppDataPreloadStatusToMCS(this.this$0, new MigrationId(this.$event.getMigrationId()), new CloudId(this.$event.getCloudId()));
                }
            });
            if (result2 instanceof ExecutionStatus.Executed && Result.isFailure-impl((Object)((ExecutionStatus.Executed)result2).getResult-d1pmJ48())) {
                log.error("Failed to process migration status update event for migrationId: " + event.getMigrationId(), Result.exceptionOrNull-impl((Object)((ExecutionStatus.Executed)result2).getResult-d1pmJ48()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void uploadAppDataPreloadStatusToMCS(MigrationId migrationId, CloudId cloudId2) {
        Object $this$uploadAppDataPreloadStatusToMCS_u24lambda_u244;
        ContainerToken containerToken;
        if (!this.migrationFeatures.getEnablePreloadStatsUpload()) {
            return;
        }
        try {
            String string = cloudId2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            CloudSite cloudSite2 = this.discoveryService.retrieveCloudSiteForCloudId(string);
            containerToken = new ContainerToken(cloudSite2 != null ? cloudSite2.getContainerToken() : null);
        }
        catch (NullPointerException e) {
            log.error("Error retrieving container token for cloudId: " + cloudId2, (Throwable)e);
            return;
        }
        ContainerToken containerToken2 = containerToken;
        log.info("Uploading app data preload status to MCS for migrationId: " + migrationId);
        try {
            File $this$uploadAppDataPreloadStatusToMCS_u24lambda_u240 = e = File.createTempFile("app-data-preload-status", ".csv");
            boolean bl = false;
            $this$uploadAppDataPreloadStatusToMCS_u24lambda_u240.deleteOnExit();
        }
        catch (IOException e) {
            log.error("Error creating file for app data preload status for migrationId: " + migrationId, (Throwable)e);
            return;
        }
        File file2 = e;
        log.info("Created file for app data preload status: " + file2.getAbsolutePath() + " for migrationId: " + migrationId);
        Intrinsics.checkNotNull((Object)file2);
        File e = file2;
        Object object = Charsets.UTF_8;
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(e), (Charset)object);
        try {
            Appendable appendable = ((Appendable)writer).append("id,vendorFileId,s3Key,failureReason,contextType,contextValue,cloudAppKey,transferId,uploaded,info,createdAt");
            Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append(...)");
        }
        catch (IOException e2) {
            log.error("Error writing headers to file for migrationId: " + migrationId, (Throwable)e2);
            return;
        }
        log.info("Wrote headers to file for app data preload status: migrationId: " + migrationId);
        log.info("Writing app data preload status records to file for migrationId: " + migrationId);
        Ref.LongRef records = new Ref.LongRef();
        object = writer;
        Throwable throwable = null;
        try {
            OutputStreamWriter streamWriter = (OutputStreamWriter)object;
            boolean bl = false;
            AppDataPreloadStatusRepository $this$uploadAppDataPreloadStatusToMCS_u24lambda_u242_u24lambda_u241 = this.appDataPreloadStatusRepository;
            boolean bl2 = false;
            boolean bl3 = this.migrationFeatures.getEnableBatchingOfPreloadStatsUpload();
            if (bl3) {
                String string = migrationId.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                AppDataPreloadStatusRepository.visitEachByMigrationIdOrderByCloudAppKeyBatched$default($this$uploadAppDataPreloadStatusToMCS_u24lambda_u242_u24lambda_u241, string, 0L, (Function1)new Function1<PartialAppDataPreloadStatus, Unit>(streamWriter, this, records, migrationId){
                    final /* synthetic */ OutputStreamWriter $streamWriter;
                    final /* synthetic */ AppDataPreloadStatusUploader this$0;
                    final /* synthetic */ Ref.LongRef $records;
                    final /* synthetic */ MigrationId $migrationId;
                    {
                        this.$streamWriter = $streamWriter;
                        this.this$0 = $receiver;
                        this.$records = $records;
                        this.$migrationId = $migrationId;
                        super(1);
                    }

                    public final void invoke(@NotNull PartialAppDataPreloadStatus it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        try {
                            Appendable appendable = ((Appendable)this.$streamWriter).append(AppDataPreloadStatusUploader.access$toCsv(this.this$0, it));
                            Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
                            Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append(...)");
                            long l = this.$records.element;
                            this.$records.element = l + 1L;
                        }
                        catch (IOException e) {
                            AppDataPreloadStatusUploader.access$getLog$cp().error("Error batch writing record : " + it.getId() + " to file for t:" + it.getTransferId() + " m:" + this.$migrationId, (Throwable)e);
                        }
                    }
                }, 2, null);
            } else if (!bl3) {
                String string = migrationId.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                $this$uploadAppDataPreloadStatusToMCS_u24lambda_u242_u24lambda_u241.visitEachByMigrationIdOrderByCloudAppKeyNoFilter(string, (Function1<? super PartialAppDataPreloadStatus, Unit>)((Function1)new Function1<PartialAppDataPreloadStatus, Unit>(streamWriter, this, records, migrationId){
                    final /* synthetic */ OutputStreamWriter $streamWriter;
                    final /* synthetic */ AppDataPreloadStatusUploader this$0;
                    final /* synthetic */ Ref.LongRef $records;
                    final /* synthetic */ MigrationId $migrationId;
                    {
                        this.$streamWriter = $streamWriter;
                        this.this$0 = $receiver;
                        this.$records = $records;
                        this.$migrationId = $migrationId;
                        super(1);
                    }

                    public final void invoke(@NotNull PartialAppDataPreloadStatus it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        try {
                            Appendable appendable = ((Appendable)this.$streamWriter).append(AppDataPreloadStatusUploader.access$toCsv(this.this$0, it));
                            Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
                            Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append(...)");
                            long l = this.$records.element;
                            this.$records.element = l + 1L;
                        }
                        catch (IOException e) {
                            AppDataPreloadStatusUploader.access$getLog$cp().error("Error writing record : " + it.getId() + " to file for t:" + it.getTransferId() + " m:" + this.$migrationId, (Throwable)e);
                        }
                    }
                }));
            }
            streamWriter = Unit.INSTANCE;
        }
        catch (Throwable streamWriter) {
            throwable = streamWriter;
            throw streamWriter;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        log.info("Wrote " + records.element + " app data preload status records to file for migrationId: " + migrationId);
        if (records.element == 0L) {
            log.info("No app data preload status records found for migrationId: " + migrationId);
            return;
        }
        log.info("Uploading app data preload status file to MCS for migrationId: " + migrationId);
        object = this;
        try {
            $this$uploadAppDataPreloadStatusToMCS_u24lambda_u244 = (AppDataPreloadStatusUploader)object;
            boolean bl = false;
            CreateFileMpResponse $this$uploadAppDataPreloadStatusToMCS_u24lambda_u244_u24lambda_u243 = PlatformUploadServiceInterface.DefaultImpls.generateFile$default(((AppDataPreloadStatusUploader)$this$uploadAppDataPreloadStatusToMCS_u24lambda_u244).platformService, containerToken2, migrationId, "app-data-preload-status", null, 8, null);
            boolean bl4 = false;
            PlatformUploadServiceInterface.DefaultImpls.uploadFileToUrl$default(((AppDataPreloadStatusUploader)$this$uploadAppDataPreloadStatusToMCS_u24lambda_u244).platformService, $this$uploadAppDataPreloadStatusToMCS_u24lambda_u244_u24lambda_u243, containerToken2, migrationId, file2, "app-data-preload-status", null, 32, null);
            $this$uploadAppDataPreloadStatusToMCS_u24lambda_u244 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            $this$uploadAppDataPreloadStatusToMCS_u24lambda_u244 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$uploadAppDataPreloadStatusToMCS_u24lambda_u244;
        Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
        if (throwable2 != null) {
            Object it = $this$uploadAppDataPreloadStatusToMCS_u24lambda_u244 = throwable2;
            boolean bl = false;
            log.error("Error uploading app data preload status file to MCS for migrationId: " + migrationId, (Throwable)it);
        }
        if (Result.isSuccess-impl((Object)object)) {
            Unit it = (Unit)object;
            boolean bl = false;
            log.info("Uploaded app data preload status file to MCS for migrationId: " + migrationId);
        }
    }

    private final String toCsv(PartialAppDataPreloadStatus $this$toCsv) {
        StringBuilder stringBuilder = new StringBuilder().append($this$toCsv.getId()).append(',').append($this$toCsv.getVendorFileId()).append(',');
        String string = $this$toCsv.getS3Key();
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string).append(',');
        String string2 = $this$toCsv.getFailureReason();
        if (string2 == null) {
            string2 = "";
        }
        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append(',').append((Object)$this$toCsv.getContextType()).append(',').append($this$toCsv.getContextValue()).append(',').append($this$toCsv.getCloudAppKey()).append(',').append($this$toCsv.getTransferId()).append(',').append($this$toCsv.getUploaded()).append(',');
        String string3 = $this$toCsv.getInfo();
        if (string3 == null) {
            string3 = "";
        }
        return stringBuilder3.append(string3).append(',').append($this$toCsv.getCreatedAt()).toString();
    }

    private final boolean isAppDataPreloadMigration(String migrationId) {
        Plan plan2;
        Plan plan3;
        Migration migration = this.migrationRepository.findByMigrationId(migrationId);
        if (migration != null) {
            Migration migration2 = migration;
            boolean bl = false;
            plan3 = this.planRepository.get(migration2.getPlanId());
        } else {
            plan3 = plan2 = null;
        }
        if (plan2 == null) {
            log.error("Plan not found for migrationId: " + migrationId);
            return false;
        }
        return MigrationModeUtil.INSTANCE.isAppDataPreloadMode(plan2.getProjectDataMigrationMode()) || MigrationModeUtil.INSTANCE.isAttachmentsOnlyMode(plan2.getProjectDataMigrationMode());
    }

    public static final /* synthetic */ void access$uploadAppDataPreloadStatusToMCS(AppDataPreloadStatusUploader $this, MigrationId migrationId, CloudId cloudId2) {
        $this.uploadAppDataPreloadStatusToMCS(migrationId, cloudId2);
    }

    public static final /* synthetic */ String access$toCsv(AppDataPreloadStatusUploader $this, PartialAppDataPreloadStatus $receiver) {
        return $this.toCsv($receiver);
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/workers/attachments/preload/AppDataPreloadStatusUploader$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

