/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.attachments.preload;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.jira.migration.app.preload.AppDataPreloadService;
import com.atlassian.jira.migration.common.Sink;
import com.atlassian.jira.migration.migration.MigrationRepository;
import com.atlassian.jira.migration.tracking.tasks.Task;
import com.atlassian.jira.migration.workers.attachments.FixedDelayCloseableRunner;
import com.atlassian.jira.migration.workers.attachments.FixedDelayCloseableRunnerFactory;
import com.atlassian.jira.migration.workers.attachments.preload.AppDataPreloaderKt;
import com.atlassian.jira.migration.workers.attachments.preload.PreloadAnalyticEventInfo;
import com.atlassian.jira.migration.workers.attachments.preload.PreloadDataSizeCalculator;
import com.atlassian.jira.migration.workers.attachments.preload.PreloadPrometheusMetricsKt;
import com.atlassian.migration.app.AppDataDetails;
import com.atlassian.migration.app.dto.EnrichedAppDataDetails;
import java.io.File;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B5\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ2\u0010\u0017\u001a\u00020\u00132\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001a2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fJ\n\u0010!\u001a\u00020\"*\u00020#R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\n \u0010*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0016\u0010\u0015\u001a\n \u0010*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/atlassian/jira/migration/workers/attachments/preload/PreloadDataSizeCalculator;", "", "fixedDelayCloseableRunnerFactory", "Lcom/atlassian/jira/migration/workers/attachments/FixedDelayCloseableRunnerFactory;", "migrationRepository", "Lcom/atlassian/jira/migration/migration/MigrationRepository;", "appDataPreloadService", "Lcom/atlassian/jira/migration/app/preload/AppDataPreloadService;", "analyticSink", "Lcom/atlassian/jira/migration/common/Sink;", "Lcom/atlassian/cmpt/analytics/events/EventDto;", "clock", "Ljava/time/Clock;", "(Lcom/atlassian/jira/migration/workers/attachments/FixedDelayCloseableRunnerFactory;Lcom/atlassian/jira/migration/migration/MigrationRepository;Lcom/atlassian/jira/migration/app/preload/AppDataPreloadService;Lcom/atlassian/jira/migration/common/Sink;Ljava/time/Clock;)V", "checkDbBatchSize", "", "kotlin.jvm.PlatformType", "Ljava/lang/Integer;", "heartbeatInterval", "", "Ljava/lang/Long;", "log", "Lorg/slf4j/Logger;", "calculateTotalDataSize", "preloadableApps", "", "", "task", "Lcom/atlassian/jira/migration/tracking/tasks/Task;", "projectKey", "heartbeat", "Lkotlin/Function0;", "", "hasValidFile", "", "Lcom/atlassian/migration/app/AppDataDetails;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPreloadDataSizeCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreloadDataSizeCalculator.kt\ncom/atlassian/jira/migration/workers/attachments/preload/PreloadDataSizeCalculator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1549#2:106\n1620#2,3:107\n766#2:110\n857#2,2:111\n766#2:113\n857#2,2:114\n1549#2:116\n1620#2,3:117\n1549#2:120\n1620#2,3:121\n*S KotlinDebug\n*F\n+ 1 PreloadDataSizeCalculator.kt\ncom/atlassian/jira/migration/workers/attachments/preload/PreloadDataSizeCalculator\n*L\n72#1:106\n72#1:107,3\n87#1:110\n87#1:111,2\n88#1:113\n88#1:114,2\n89#1:116\n89#1:117,3\n90#1:120\n90#1:121,3\n*E\n"})
public final class PreloadDataSizeCalculator {
    @NotNull
    private final FixedDelayCloseableRunnerFactory fixedDelayCloseableRunnerFactory;
    @NotNull
    private final MigrationRepository migrationRepository;
    @NotNull
    private final AppDataPreloadService appDataPreloadService;
    @NotNull
    private final Sink<EventDto> analyticSink;
    @NotNull
    private final Clock clock;
    private final Integer checkDbBatchSize;
    private final Logger log;
    private final Long heartbeatInterval;

    @Inject
    public PreloadDataSizeCalculator(@NotNull FixedDelayCloseableRunnerFactory fixedDelayCloseableRunnerFactory, @NotNull MigrationRepository migrationRepository, @NotNull AppDataPreloadService appDataPreloadService, @NotNull Sink<EventDto> analyticSink, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)fixedDelayCloseableRunnerFactory, (String)"fixedDelayCloseableRunnerFactory");
        Intrinsics.checkNotNullParameter((Object)migrationRepository, (String)"migrationRepository");
        Intrinsics.checkNotNullParameter((Object)appDataPreloadService, (String)"appDataPreloadService");
        Intrinsics.checkNotNullParameter(analyticSink, (String)"analyticSink");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.fixedDelayCloseableRunnerFactory = fixedDelayCloseableRunnerFactory;
        this.migrationRepository = migrationRepository;
        this.appDataPreloadService = appDataPreloadService;
        this.analyticSink = analyticSink;
        this.clock = clock;
        this.checkDbBatchSize = Integer.getInteger("jcma.app.preload.should-upload-db-batch-size", 1000);
        this.log = LoggerFactory.getLogger(PreloadDataSizeCalculator.class);
        this.heartbeatInterval = Long.getLong("jcma.app.preload.heartbeat-interval-seconds", AppDataPreloaderKt.getDEFAULT_HEARTBEAT_INTERVAL().getSeconds());
    }

    public final boolean hasValidFile(@NotNull AppDataDetails $this$hasValidFile) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$hasValidFile, (String)"<this>");
        boolean it = bl = $this$hasValidFile.getPath().toFile().exists();
        boolean bl2 = false;
        if (!it) {
            this.log.info("App Data file is missing " + $this$hasValidFile);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final long calculateTotalDataSize(@NotNull List<String> preloadableApps, @NotNull Task task, @NotNull String projectKey, @NotNull Function0<Unit> heartbeat2) {
        Intrinsics.checkNotNullParameter(preloadableApps, (String)"preloadableApps");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
        Intrinsics.checkNotNullParameter(heartbeat2, (String)"heartbeat");
        Function0 function0 = (Function0)new Function0<Unit>(heartbeat2){
            final /* synthetic */ Function0<Unit> $heartbeat;
            {
                this.$heartbeat = $heartbeat;
                super(0);
            }

            public final void invoke() {
                Unit unit;
                this.$heartbeat.invoke();
                Unit it = unit = Unit.INSTANCE;
                boolean bl = false;
                PreloadPrometheusMetricsKt.getPreloaderHeartbeaterCounter().inc();
            }
        };
        Long l = this.heartbeatInterval;
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"heartbeatInterval");
        AutoCloseable autoCloseable = FixedDelayCloseableRunnerFactory.create$default(this.fixedDelayCloseableRunnerFactory, function0, ((Number)l).longValue(), TimeUnit.SECONDS, 0L, 8, null);
        Throwable throwable = null;
        try {
            FixedDelayCloseableRunner it = (FixedDelayCloseableRunner)autoCloseable;
            boolean bl = false;
            long totalSize = 0L;
            String string = task.getCloudId();
            String string2 = task.getCloudSite().getCloudUrl().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            String string3 = this.migrationRepository.findPlanIdByMigrationId(task.getMigrationId());
            if (string3 == null) {
                String string4 = "Required value was null.";
                throw new IllegalArgumentException(string4.toString());
            }
            PreloadAnalyticEventInfo preloadAnalyticEventInfo = new PreloadAnalyticEventInfo(string, string2, task.getMigrationId(), string3, task.getTaskId(), projectKey, preloadableApps);
            for (String preloadableApp : preloadableApps) {
                this.log.info("calculateTotalDataSize:" + projectKey + " - starting for " + preloadableApp);
                Sequence sequence = SequencesKt.distinctBy(this.appDataPreloadService.getAppDataForPreloadByProjectKey(CollectionsKt.listOf((Object)preloadableApp), projectKey, () -> PreloadDataSizeCalculator.calculateTotalDataSize$lambda$9$lambda$1(heartbeat2)), (Function1)calculateTotalDataSize.2.batches.1.INSTANCE);
                Integer n = this.checkDbBatchSize;
                Intrinsics.checkNotNullExpressionValue((Object)n, (String)"checkDbBatchSize");
                Sequence batches2 = SequencesKt.chunked((Sequence)sequence, (int)((Number)n).intValue());
                for (List batch : batches2) {
                    Collection collection;
                    Iterable $this$mapTo$iv$iv;
                    Iterable $this$map$iv;
                    Object it2;
                    Iterable $this$filterTo$iv$iv;
                    Object object;
                    Object object2;
                    Object object3 = this;
                    try {
                        void $this$mapTo$iv$iv2;
                        void $this$map$iv2;
                        PreloadDataSizeCalculator $this$calculateTotalDataSize_u24lambda_u249_u24lambda_u243 = object3;
                        boolean bl2 = false;
                        Iterable iterable = batch;
                        object2 = $this$calculateTotalDataSize_u24lambda_u249_u24lambda_u243.appDataPreloadService;
                        boolean $i$f$map = false;
                        void var21_32 = $this$map$iv2;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                            void it3;
                            EnrichedAppDataDetails enrichedAppDataDetails = (EnrichedAppDataDetails)item$iv$iv;
                            Collection collection2 = destination$iv$iv;
                            boolean bl3 = false;
                            collection2.add(it3.getAppDataDetails().getId());
                        }
                        object = Result.constructor-impl((Object)CollectionsKt.toSet((Iterable)((AppDataPreloadService)object2).shouldUploadByBatch((List)destination$iv$iv, preloadableApp, task.getCloudId())));
                    }
                    catch (Throwable bl2) {
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
                    }
                    object3 = object;
                    Throwable throwable2 = Result.exceptionOrNull-impl((Object)object3);
                    if (throwable2 != null) {
                        Object it4 = object = throwable2;
                        boolean bl4 = false;
                        object2 = new Pair[]{TuplesKt.to((Object)"totalSize", (Object)totalSize), TuplesKt.to((Object)"reason", (Object)String.valueOf(((Throwable)it4).getMessage()))};
                        this.analyticSink.put(preloadAnalyticEventInfo.toFailedCalculatePreloadSizeEventDto(this.clock.millis(), MapsKt.mapOf((Pair[])object2)));
                        this.log.error("calculateTotalDataSize:" + projectKey + " - Error while processing app data preload for project " + projectKey, (Throwable)it4);
                    }
                    ResultKt.throwOnFailure((Object)object3);
                    Set shouldUploadFileIds = (Set)object3;
                    Iterable $this$filter$iv = batch;
                    boolean $i$f$filter = false;
                    object2 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        it2 = (EnrichedAppDataDetails)element$iv$iv;
                        boolean bl5 = false;
                        if (!shouldUploadFileIds.contains(it2.getAppDataDetails().getId())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    $i$f$filter = false;
                    $this$filterTo$iv$iv = $this$filter$iv;
                    destination$iv$iv = new ArrayList();
                    $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        it2 = (EnrichedAppDataDetails)element$iv$iv;
                        boolean bl6 = false;
                        if (!this.hasValidFile(it2.getAppDataDetails())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$map = false;
                    $this$filterTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        it2 = (EnrichedAppDataDetails)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl7 = false;
                        collection.add(it2.getAppDataDetails().getPath().toFile());
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        it2 = (File)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl8 = false;
                        collection.add(((File)it2).length());
                    }
                    long totalForApp = CollectionsKt.sumOfLong((Iterable)((List)destination$iv$iv));
                    totalSize += totalForApp;
                }
            }
            this.log.info("calculateTotalDataSize:" + projectKey + " Total data size of " + totalSize + " app data was provided ");
            this.analyticSink.put(preloadAnalyticEventInfo.toCompletedCalculatePreloadSizeEventDto(this.clock.millis(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"totalSize", (Object)totalSize))));
            long l2 = totalSize;
            return l2;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private static final void calculateTotalDataSize$lambda$9$lambda$1(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }
}

