/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.cpd;

import com.atlassian.jira.migration.analytics.MetricsEventService;
import com.atlassian.jira.migration.analytics.MigAssetStatsService;
import com.atlassian.jira.migration.common.MigrationTaskMetadata;
import com.atlassian.jira.migration.datafilters.DataFiltersContextService;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.events.CrossProjectDataUploadFailed;
import com.atlassian.jira.migration.events.CrossProjectDataUploadInitialState;
import com.atlassian.jira.migration.events.CrossProjectDataUploadStarted;
import com.atlassian.jira.migration.events.MigAssetStats;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.export.DataExportOutcome;
import com.atlassian.jira.migration.export.ExportFacade;
import com.atlassian.jira.migration.httpclient.exceptions.UnexpectedStatusCodeException;
import com.atlassian.jira.migration.plan.CrossProjectBoardsAndFiltersMigrationOption;
import com.atlassian.jira.migration.plan.CrossProjectConfig;
import com.atlassian.jira.migration.plan.CrossProjectExportConfig;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.prc.exception.CommandCancelledException;
import com.atlassian.jira.migration.scope.MigrationScopeManager;
import com.atlassian.jira.migration.serverdataextractors.usergroup.DeletedUserMapping;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UserInfo;
import com.atlassian.jira.migration.tracking.tasks.Task;
import com.atlassian.jira.migration.usersmigrationservice.TombstoneUser;
import com.atlassian.jira.migration.workers.MigrationTaskMetadataProvider;
import com.atlassian.jira.migration.workers.tombstone.TombstoneAccountManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@VisibleForTesting
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u0000 H2\u00020\u0001:\u0001HB]\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020*H&J\b\u0010+\u001a\u00020,H\u0016J\u001e\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u00020/01H\u0002J \u00102\u001a\u00020,2\u0006\u0010.\u001a\u00020/2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00103\u001a\u00020&H\u0002J\u001e\u00104\u001a\u00020,2\u0006\u0010.\u001a\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u00020/01H\u0002J\u0014\u00105\u001a\u00020,2\n\u00106\u001a\u000607j\u0002`8H\u0002J\b\u00109\u001a\u00020,H&J\u0014\u0010:\u001a\u00020,2\n\b\u0002\u0010;\u001a\u0004\u0018\u00010/H&J\u0010\u0010<\u001a\u00020,2\u0006\u0010'\u001a\u00020(H\u0002J\b\u0010=\u001a\u00020,H\u0002J\u0010\u0010>\u001a\u00020,2\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u0010?\u001a\u00020,2\u0006\u0010.\u001a\u00020/2\u0006\u0010@\u001a\u00020AH&J\u0018\u0010B\u001a\u00020,2\u0006\u0010.\u001a\u00020/2\u0006\u00103\u001a\u00020&H&J\u001e\u0010C\u001a\u00020,2\u0006\u0010.\u001a\u00020/2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020E01H&J\f\u0010F\u001a\u00020E*\u00020GH\u0002R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001b\u001a\u00020\u001cX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001f\u001a\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b!\u0010\"R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lcom/atlassian/jira/migration/workers/cpd/AbstractCrossProjectDataProcessor;", "", "task", "Lcom/atlassian/jira/migration/tracking/tasks/Task;", "migrationTaskMetadataProvider", "Lcom/atlassian/jira/migration/workers/MigrationTaskMetadataProvider;", "exportFacade", "Lcom/atlassian/jira/migration/export/ExportFacade;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "migrationScopeManager", "Lcom/atlassian/jira/migration/scope/MigrationScopeManager;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "tombstoneAccountManager", "Lcom/atlassian/jira/migration/workers/tombstone/TombstoneAccountManager;", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "metricsEventService", "Lcom/atlassian/jira/migration/analytics/MetricsEventService;", "migAssetStatsService", "Lcom/atlassian/jira/migration/analytics/MigAssetStatsService;", "dataFiltersContextService", "Lcom/atlassian/jira/migration/datafilters/DataFiltersContextService;", "(Lcom/atlassian/jira/migration/tracking/tasks/Task;Lcom/atlassian/jira/migration/workers/MigrationTaskMetadataProvider;Lcom/atlassian/jira/migration/export/ExportFacade;Lcom/atlassian/jira/migration/discovery/DiscoveryService;Lcom/atlassian/jira/migration/scope/MigrationScopeManager;Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/migration/workers/tombstone/TombstoneAccountManager;Lcom/atlassian/jira/project/ProjectManager;Lcom/atlassian/jira/migration/analytics/MetricsEventService;Lcom/atlassian/jira/migration/analytics/MigAssetStatsService;Lcom/atlassian/jira/migration/datafilters/DataFiltersContextService;)V", "getDiscoveryService", "()Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "migrationMetadata", "Lcom/atlassian/jira/migration/common/MigrationTaskMetadata;", "getMigrationMetadata", "()Lcom/atlassian/jira/migration/common/MigrationTaskMetadata;", "migrationMetadata$delegate", "Lkotlin/Lazy;", "exportCrossProjectData", "Lcom/atlassian/jira/migration/export/DataExportOutcome;", "plan", "Lcom/atlassian/jira/migration/plan/Plan;", "getHeartbeatFrequency", "", "process", "", "processDeletedUserMappings", "migrationScopeId", "", "deletedUserKeys", "", "processExportedFile", "dataExportOutcome", "publishTombstoneUsers", "sendFailedEvent", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "sendFinalStatus", "sendHeartbeat", "msg", "sendMetricsAboutARPlans", "sendStartEvent", "sendStartEventInitialState", "uploadDeletedUserMappings", "deletedUserMapping", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/DeletedUserMapping;", "uploadExportedFile", "uploadTombStoneMappings", "tombstoneUsers", "Lcom/atlassian/jira/migration/usersmigrationservice/TombstoneUser;", "toTombstoneUser", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UserInfo;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAbstractCrossProjectDataProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractCrossProjectDataProcessor.kt\ncom/atlassian/jira/migration/workers/cpd/AbstractCrossProjectDataProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,187:1\n1603#2,9:188\n1855#2:197\n1856#2:199\n1612#2:200\n1549#2:201\n1620#2,3:202\n1549#2:205\n1620#2,3:206\n1#3:198\n*S KotlinDebug\n*F\n+ 1 AbstractCrossProjectDataProcessor.kt\ncom/atlassian/jira/migration/workers/cpd/AbstractCrossProjectDataProcessor\n*L\n94#1:188,9\n94#1:197\n94#1:199\n94#1:200\n95#1:201\n95#1:202,3\n141#1:205\n141#1:206,3\n94#1:198\n*E\n"})
public abstract class AbstractCrossProjectDataProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Task task;
    @NotNull
    private final ExportFacade exportFacade;
    @NotNull
    private final DiscoveryService discoveryService;
    @NotNull
    private final MigrationScopeManager migrationScopeManager;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final TombstoneAccountManager tombstoneAccountManager;
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final MetricsEventService metricsEventService;
    @NotNull
    private final MigAssetStatsService migAssetStatsService;
    @NotNull
    private final DataFiltersContextService dataFiltersContextService;
    @NotNull
    private final Lazy migrationMetadata$delegate;
    public static final int IGNORED_ERROR_CODE = 409;

    public AbstractCrossProjectDataProcessor(@NotNull Task task, @NotNull MigrationTaskMetadataProvider migrationTaskMetadataProvider, @NotNull ExportFacade exportFacade, @NotNull DiscoveryService discoveryService, @NotNull MigrationScopeManager migrationScopeManager, @NotNull MigrationEventBus migrationEventBus, @NotNull TombstoneAccountManager tombstoneAccountManager, @NotNull ProjectManager projectManager, @NotNull MetricsEventService metricsEventService, @NotNull MigAssetStatsService migAssetStatsService, @NotNull DataFiltersContextService dataFiltersContextService) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)migrationTaskMetadataProvider, (String)"migrationTaskMetadataProvider");
        Intrinsics.checkNotNullParameter((Object)exportFacade, (String)"exportFacade");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)migrationScopeManager, (String)"migrationScopeManager");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)tombstoneAccountManager, (String)"tombstoneAccountManager");
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)metricsEventService, (String)"metricsEventService");
        Intrinsics.checkNotNullParameter((Object)migAssetStatsService, (String)"migAssetStatsService");
        Intrinsics.checkNotNullParameter((Object)dataFiltersContextService, (String)"dataFiltersContextService");
        this.task = task;
        this.exportFacade = exportFacade;
        this.discoveryService = discoveryService;
        this.migrationScopeManager = migrationScopeManager;
        this.migrationEventBus = migrationEventBus;
        this.tombstoneAccountManager = tombstoneAccountManager;
        this.projectManager = projectManager;
        this.metricsEventService = metricsEventService;
        this.migAssetStatsService = migAssetStatsService;
        this.dataFiltersContextService = dataFiltersContextService;
        this.migrationMetadata$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<MigrationTaskMetadata>(migrationTaskMetadataProvider, this){
            final /* synthetic */ MigrationTaskMetadataProvider $migrationTaskMetadataProvider;
            final /* synthetic */ AbstractCrossProjectDataProcessor this$0;
            {
                this.$migrationTaskMetadataProvider = $migrationTaskMetadataProvider;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final MigrationTaskMetadata invoke() {
                return this.$migrationTaskMetadataProvider.get(AbstractCrossProjectDataProcessor.access$getTask$p(this.this$0));
            }
        }));
    }

    @NotNull
    public final DiscoveryService getDiscoveryService() {
        return this.discoveryService;
    }

    private final MigrationTaskMetadata getMigrationMetadata() {
        Lazy lazy = this.migrationMetadata$delegate;
        return (MigrationTaskMetadata)lazy.getValue();
    }

    @NotNull
    public abstract Logger getLog();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        this.sendStartEvent();
        this.getLog().info(this.task.getMigrationId() + '-' + this.task.getTaskId() + ": exporting cross project data as " + this.getMigrationMetadata().getStartedUser());
        try {
            Plan plan2 = DiscoveryService.retrievePlanFor$default(this.discoveryService, this.task, false, 2, null);
            this.sendStartEventInitialState(plan2);
            AutoCloseable autoCloseable = this.exportCrossProjectData(plan2);
            Throwable throwable = null;
            try {
                DataExportOutcome outcome = (DataExportOutcome)autoCloseable;
                boolean bl = false;
                String migrationScopeId2 = this.migrationScopeManager.getMigrationScope(this.task.getCloudSite());
                this.getLog().info(this.task.getMigrationId() + '-' + this.task.getMigrationTask().getTaskId() + ": migration scope id " + migrationScopeId2);
                this.processDeletedUserMappings(migrationScopeId2, outcome.getDeletedUserKeys());
                this.publishTombstoneUsers(migrationScopeId2, outcome.getDeletedUserKeys());
                AbstractCrossProjectDataProcessor.sendHeartbeat$default(this, null, 1, null);
                this.processExportedFile(migrationScopeId2, this.task, outcome);
                MigAssetStatsService.publishProjectAssetMetrics$default(this.migAssetStatsService, this.task.getMigrationId(), migrationScopeId2, outcome.getFile(), MigAssetStats.StatsType.CROSS_PROJECT, null, null, null, 112, null);
                this.sendMetricsAboutARPlans(plan2);
                this.sendFinalStatus();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (CommandCancelledException ex) {
            throw ex;
        }
        catch (UnexpectedStatusCodeException ex) {
            if (ex.getStatusCode() != 409) {
                this.sendFailedEvent(ex);
                throw ex;
            }
            this.getLog().info(this.task.getMigrationId() + '-' + this.task.getTaskId() + ": ignoring " + ex.getStatusCode() + " for cross project data");
        }
        catch (Exception ex) {
            this.sendFailedEvent(ex);
            throw ex;
        }
        this.getLog().info(this.task.getMigrationId() + '-' + this.task.getTaskId() + ": notified MO complete for cross project data");
    }

    /*
     * WARNING - void declaration
     */
    private final DataExportOutcome exportCrossProjectData(Plan plan2) {
        void $this$mapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        this.getLog().info(this.task.getMigrationId() + '-' + this.task.getTaskId() + ": cross project data export started");
        Iterable $this$mapNotNull$iv = plan2.getProjectKeys();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Project project = $this$forEach$iv$iv$iv.iterator();
        while (project.hasNext()) {
            Project it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = project.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.projectManager.getProjectObjByKeyIgnoreCase(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            project = (Project)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        List projectIds = (List)destination$iv$iv;
        DataExportOutcome exportOutcome2 = this.exportFacade.exportCrossProjectData(projectIds, this.getMigrationMetadata(), plan2.getAdvancedRoadmapsPlanIds(), plan2.getUsersGroupsMigrationOption(), plan2.getMigrateArchivedIssues(), (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ AbstractCrossProjectDataProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                AbstractCrossProjectDataProcessor.sendHeartbeat$default(this.this$0, null, 1, null);
            }
        }), new CrossProjectConfig(new CrossProjectExportConfig(plan2.getCrossProjectBoardsAndFiltersMigrationOption(), plan2.getDashboardsMigrationMode())), this.task, plan2.getAdvancedRoadmapsMigrationOption(), plan2.getId(), DataFiltersContextService.getDataFilterContext$default(this.dataFiltersContextService, plan2.getProjectDataMigrationMode(), plan2.getIssueFilters(), null, 4, null));
        this.getLog().info(this.task.getMigrationId() + '-' + this.task.getTaskId() + ": generated export file for cross project data");
        return exportOutcome2;
    }

    private final void processDeletedUserMappings(String migrationScopeId2, Set<String> deletedUserKeys2) {
        DeletedUserMapping deletedUserMapping2 = TombstoneAccountManager.buildDeleteUserMappings$default(this.tombstoneAccountManager, this.task, CollectionsKt.toList((Iterable)deletedUserKeys2), false, (Function0)new Function0<Unit>(this){
            final /* synthetic */ AbstractCrossProjectDataProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                AbstractCrossProjectDataProcessor.sendHeartbeat$default(this.this$0, null, 1, null);
            }
        }, 4, null);
        this.uploadDeletedUserMappings(migrationScopeId2, deletedUserMapping2);
        this.getLog().info(this.task.getMigrationId() + '-' + this.task.getTaskId() + ": uploaded deleted user keys to AAID mappings CROSS-PROJECT-DATA to MO");
    }

    public abstract void uploadDeletedUserMappings(@NotNull String var1, @NotNull DeletedUserMapping var2);

    private final void processExportedFile(String migrationScopeId2, Task task, DataExportOutcome dataExportOutcome) {
        this.uploadExportedFile(migrationScopeId2, dataExportOutcome);
        this.getLog().info(task.getMigrationId() + '-' + task.getTaskId() + ": uploaded cross project data to MO");
    }

    public abstract void uploadExportedFile(@NotNull String var1, @NotNull DataExportOutcome var2);

    /*
     * WARNING - void declaration
     */
    private final void publishTombstoneUsers(String migrationScopeId2, Set<String> deletedUserKeys2) {
        List<UserInfo> deletedUsersInfo2 = TombstoneAccountManager.buildDeleteUserMappings$default(this.tombstoneAccountManager, this.task, CollectionsKt.toList((Iterable)deletedUserKeys2), false, (Function0)new Function0<Unit>(this){
            final /* synthetic */ AbstractCrossProjectDataProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                AbstractCrossProjectDataProcessor.sendHeartbeat$default(this.this$0, null, 1, null);
            }
        }, 4, null).getDeletedUsersInfo();
        if (!((Collection)deletedUsersInfo2).isEmpty()) {
            Collection<TombstoneUser> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = deletedUsersInfo2;
            String string = migrationScopeId2;
            AbstractCrossProjectDataProcessor abstractCrossProjectDataProcessor = this;
            boolean $i$f$map = false;
            void var6_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                UserInfo userInfo = (UserInfo)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.toTombstoneUser((UserInfo)it));
            }
            collection = (List)destination$iv$iv;
            abstractCrossProjectDataProcessor.uploadTombStoneMappings(string, CollectionsKt.toSet((Iterable)collection));
        }
    }

    public abstract void uploadTombStoneMappings(@NotNull String var1, @NotNull Set<TombstoneUser> var2);

    private final TombstoneUser toTombstoneUser(UserInfo $this$toTombstoneUser) {
        String string = $this$toTombstoneUser.getAaid();
        Intrinsics.checkNotNull((Object)string);
        return new TombstoneUser(string, $this$toTombstoneUser.getUserName(), $this$toTombstoneUser.getUserKey(), $this$toTombstoneUser.getDisplayName());
    }

    private final void sendStartEvent() {
        this.migrationEventBus.post(new CrossProjectDataUploadStarted(this.task.getCloudId(), this.task.getMigrationId()));
    }

    private final void sendStartEventInitialState(Plan plan2) {
        String string = this.task.getCloudId();
        String string2 = this.task.getMigrationId();
        List list = plan2.getAdvancedRoadmapsPlanIds();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        CrossProjectBoardsAndFiltersMigrationOption crossProjectBoardsAndFiltersMigrationOption = plan2.getCrossProjectBoardsAndFiltersMigrationOption();
        CrossProjectBoardsAndFiltersMigrationOption crossProjectBoardsAndFiltersMigrationOption2 = plan2.getCrossProjectBoardsAndFiltersMigrationOption();
        CrossProjectBoardsAndFiltersMigrationOption crossProjectBoardsAndFiltersMigrationOption3 = plan2.getCrossProjectBoardsAndFiltersMigrationOption();
        this.migrationEventBus.post(new CrossProjectDataUploadInitialState(string, string2, list.size(), crossProjectBoardsAndFiltersMigrationOption != null ? Long.valueOf(crossProjectBoardsAndFiltersMigrationOption.getCrossProjectBoardsCount()) : null, crossProjectBoardsAndFiltersMigrationOption2 != null ? Long.valueOf(crossProjectBoardsAndFiltersMigrationOption2.getCrossProjectFiltersCount()) : null, crossProjectBoardsAndFiltersMigrationOption3 != null ? crossProjectBoardsAndFiltersMigrationOption3.getBoardsAndFiltersMigrationMode() : null));
    }

    private final void sendFailedEvent(Exception ex) {
        this.migrationEventBus.post(new CrossProjectDataUploadFailed(this.task.getCloudId(), this.task.getMigrationId(), ex.getMessage()));
    }

    private final void sendMetricsAboutARPlans(Plan plan2) {
        Collection collection = plan2.getAdvancedRoadmapsPlanIds();
        MetricsEventService.sendEventForArPlanIncluded$default(this.metricsEventService, !(collection == null || collection.isEmpty()), 0.0, 2, null);
    }

    public abstract void sendHeartbeat(@Nullable String var1);

    public static /* synthetic */ void sendHeartbeat$default(AbstractCrossProjectDataProcessor abstractCrossProjectDataProcessor, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sendHeartbeat");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        abstractCrossProjectDataProcessor.sendHeartbeat(string);
    }

    public abstract void sendFinalStatus();

    public abstract long getHeartbeatFrequency();

    public static final /* synthetic */ Task access$getTask$p(AbstractCrossProjectDataProcessor $this) {
        return $this.task;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/workers/cpd/AbstractCrossProjectDataProcessor$Companion;", "", "()V", "IGNORED_ERROR_CODE", "", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

