/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.cpd;

import com.atlassian.jira.migration.analytics.MetricsEventService;
import com.atlassian.jira.migration.analytics.MigAssetStatsService;
import com.atlassian.jira.migration.datafilters.DataFiltersContextService;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.export.ExportFacade;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.migration.MigrationProtocol;
import com.atlassian.jira.migration.orchestratorclient.tasks.CrossProjectTransferMigrationTask;
import com.atlassian.jira.migration.orchestratorclient.tasks.MigrationTask;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.platform.PlatformService;
import com.atlassian.jira.migration.platform.TransferStatus;
import com.atlassian.jira.migration.scope.MigrationScopeManager;
import com.atlassian.jira.migration.shadow.db.CrossProjectFinalStatus;
import com.atlassian.jira.migration.shadow.db.MigrationFinalStatus;
import com.atlassian.jira.migration.shadow.db.MigrationFinalStatusRepository;
import com.atlassian.jira.migration.tracking.tasks.Task;
import com.atlassian.jira.migration.usersmigrationservice.UsersMigrationServiceClient;
import com.atlassian.jira.migration.workers.MigrationTaskMetadataProvider;
import com.atlassian.jira.migration.workers.PlatformHeartbeater;
import com.atlassian.jira.migration.workers.PlatformProgressUpdater;
import com.atlassian.jira.migration.workers.PlatformUtilKt;
import com.atlassian.jira.migration.workers.cpd.AbstractCrossProjectDataProcessor;
import com.atlassian.jira.migration.workers.cpd.AbstractPlatformCrossProjectDataProcessor;
import com.atlassian.jira.migration.workers.tombstone.TombstoneAccountManager;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.migration.api.TransferId;
import com.google.common.annotations.VisibleForTesting;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.PreDestroy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForTesting
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0085\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u0012\u0006\u0010\u001e\u001a\u00020\u001f\u0012\u0006\u0010 \u001a\u00020!\u00a2\u0006\u0002\u0010\"J\b\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u000203H\u0016J\u0010\u00105\u001a\u0002032\u0006\u00106\u001a\u000207H\u0002J\u0012\u00108\u001a\u0002032\b\u00109\u001a\u0004\u0018\u000107H\u0016J\b\u0010:\u001a\u000203H\u0002J\b\u0010;\u001a\u000203H\u0007R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010'\u001a\n )*\u0004\u0018\u00010(0(X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/atlassian/jira/migration/workers/cpd/V3CrossProjectDataProcessor;", "Lcom/atlassian/jira/migration/workers/cpd/AbstractPlatformCrossProjectDataProcessor;", "task", "Lcom/atlassian/jira/migration/tracking/tasks/Task;", "migrationTaskMetadataProvider", "Lcom/atlassian/jira/migration/workers/MigrationTaskMetadataProvider;", "exportFacade", "Lcom/atlassian/jira/migration/export/ExportFacade;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "migrationScopeManager", "Lcom/atlassian/jira/migration/scope/MigrationScopeManager;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "tombstoneAccountManager", "Lcom/atlassian/jira/migration/workers/tombstone/TombstoneAccountManager;", "usersMigrationServiceClient", "Lcom/atlassian/jira/migration/usersmigrationservice/UsersMigrationServiceClient;", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "metricsEventService", "Lcom/atlassian/jira/migration/analytics/MetricsEventService;", "platformService", "Lcom/atlassian/jira/migration/platform/PlatformService;", "migAssetStatsService", "Lcom/atlassian/jira/migration/analytics/MigAssetStatsService;", "migrationFinalStatusRepository", "Lcom/atlassian/jira/migration/shadow/db/MigrationFinalStatusRepository;", "dataFiltersContextService", "Lcom/atlassian/jira/migration/datafilters/DataFiltersContextService;", "heartbeatScheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/tracking/tasks/Task;Lcom/atlassian/jira/migration/workers/MigrationTaskMetadataProvider;Lcom/atlassian/jira/migration/export/ExportFacade;Lcom/atlassian/jira/migration/discovery/DiscoveryService;Lcom/atlassian/jira/migration/scope/MigrationScopeManager;Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/migration/workers/tombstone/TombstoneAccountManager;Lcom/atlassian/jira/migration/usersmigrationservice/UsersMigrationServiceClient;Lcom/atlassian/jira/project/ProjectManager;Lcom/atlassian/jira/migration/analytics/MetricsEventService;Lcom/atlassian/jira/migration/platform/PlatformService;Lcom/atlassian/jira/migration/analytics/MigAssetStatsService;Lcom/atlassian/jira/migration/shadow/db/MigrationFinalStatusRepository;Lcom/atlassian/jira/migration/datafilters/DataFiltersContextService;Ljava/util/concurrent/ScheduledExecutorService;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "crossProjectTask", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/CrossProjectTransferMigrationTask;", "heartbeater", "Lcom/atlassian/jira/migration/workers/PlatformHeartbeater;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "progressUpdater", "Lcom/atlassian/jira/migration/workers/PlatformProgressUpdater;", "transferId", "Lcom/atlassian/migration/api/TransferId;", "getHeartbeatFrequency", "", "process", "", "sendFinalStatus", "sendFinalStatusForShadowMigration", "migrationId", "", "sendHeartbeat", "msg", "setHeartbeatScheduler", "shutdown", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nV3CrossProjectDataWorker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 V3CrossProjectDataWorker.kt\ncom/atlassian/jira/migration/workers/cpd/V3CrossProjectDataProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,212:1\n1#2:213\n*E\n"})
public final class V3CrossProjectDataProcessor
extends AbstractPlatformCrossProjectDataProcessor {
    @NotNull
    private final Task task;
    @NotNull
    private final UsersMigrationServiceClient usersMigrationServiceClient;
    @NotNull
    private final PlatformService platformService;
    @NotNull
    private final MigrationFinalStatusRepository migrationFinalStatusRepository;
    @NotNull
    private final ScheduledExecutorService heartbeatScheduler;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    private final Logger log;
    @NotNull
    private final CrossProjectTransferMigrationTask crossProjectTask;
    @NotNull
    private final TransferId transferId;
    @NotNull
    private final PlatformHeartbeater heartbeater;
    @NotNull
    private final PlatformProgressUpdater progressUpdater;

    public V3CrossProjectDataProcessor(@NotNull Task task, @NotNull MigrationTaskMetadataProvider migrationTaskMetadataProvider, @NotNull ExportFacade exportFacade, @NotNull DiscoveryService discoveryService, @NotNull MigrationScopeManager migrationScopeManager, @NotNull MigrationEventBus migrationEventBus, @NotNull TombstoneAccountManager tombstoneAccountManager, @NotNull UsersMigrationServiceClient usersMigrationServiceClient, @NotNull ProjectManager projectManager, @NotNull MetricsEventService metricsEventService, @NotNull PlatformService platformService, @NotNull MigAssetStatsService migAssetStatsService, @NotNull MigrationFinalStatusRepository migrationFinalStatusRepository, @NotNull DataFiltersContextService dataFiltersContextService, @NotNull ScheduledExecutorService heartbeatScheduler, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)migrationTaskMetadataProvider, (String)"migrationTaskMetadataProvider");
        Intrinsics.checkNotNullParameter((Object)exportFacade, (String)"exportFacade");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)migrationScopeManager, (String)"migrationScopeManager");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)tombstoneAccountManager, (String)"tombstoneAccountManager");
        Intrinsics.checkNotNullParameter((Object)usersMigrationServiceClient, (String)"usersMigrationServiceClient");
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)metricsEventService, (String)"metricsEventService");
        Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
        Intrinsics.checkNotNullParameter((Object)migAssetStatsService, (String)"migAssetStatsService");
        Intrinsics.checkNotNullParameter((Object)migrationFinalStatusRepository, (String)"migrationFinalStatusRepository");
        Intrinsics.checkNotNullParameter((Object)dataFiltersContextService, (String)"dataFiltersContextService");
        Intrinsics.checkNotNullParameter((Object)heartbeatScheduler, (String)"heartbeatScheduler");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        super(task, migrationTaskMetadataProvider, exportFacade, discoveryService, migrationScopeManager, migrationEventBus, tombstoneAccountManager, usersMigrationServiceClient, projectManager, metricsEventService, platformService, migAssetStatsService, dataFiltersContextService);
        this.task = task;
        this.usersMigrationServiceClient = usersMigrationServiceClient;
        this.platformService = platformService;
        this.migrationFinalStatusRepository = migrationFinalStatusRepository;
        this.heartbeatScheduler = heartbeatScheduler;
        this.migrationFeatures = migrationFeatures;
        this.log = LoggerFactory.getLogger(V3CrossProjectDataProcessor.class);
        MigrationTask migrationTask = this.task.getMigrationTask();
        Intrinsics.checkNotNull((Object)migrationTask, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.orchestratorclient.tasks.CrossProjectTransferMigrationTask");
        this.crossProjectTask = (CrossProjectTransferMigrationTask)migrationTask;
        this.transferId = new TransferId(this.crossProjectTask.getTransferId());
        this.heartbeater = new PlatformHeartbeater(this.platformService, this.getContainerToken(), this.crossProjectTask.getHeartbeatUrl(), null, null, 24, null);
        this.progressUpdater = new PlatformProgressUpdater(this.platformService, this.getMigrationId(), this.transferId, this.getContainerToken(), null, null, 48, null);
    }

    @Override
    public Logger getLog() {
        return this.log;
    }

    @PreDestroy
    public final void shutdown() {
        this.heartbeatScheduler.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        try {
            this.setHeartbeatScheduler();
            Plan plan2 = DiscoveryService.retrievePlanFor$default(this.getDiscoveryService(), this.task, false, 2, null);
            if (Intrinsics.areEqual((Object)plan2.isShadowPlan(), (Object)true)) {
                if (!(plan2.getOriginalMigrationId() != null)) {
                    boolean bl = false;
                    String string = "Shadow Plan should have an originalMigrationId";
                    throw new IllegalArgumentException(string.toString());
                }
                this.sendFinalStatusForShadowMigration(plan2.getOriginalMigrationId());
                return;
            }
            super.process();
        }
        catch (Exception ex) {
            this.getLog().warn(ex.getMessage());
            throw ex;
        }
        finally {
            this.heartbeatScheduler.shutdown();
        }
    }

    private final void sendFinalStatusForShadowMigration(String migrationId) {
        MigrationFinalStatus migrationFinalStatus = MigrationFinalStatusRepository.getShadowMigrationMetadata$default(this.migrationFinalStatusRepository, migrationId, this.crossProjectTask.getMigrationTaskType(), null, 4, null);
        if (migrationFinalStatus == null) {
            PlatformProgressUpdater.sendFinalStatus$default(this.progressUpdater, TransferStatus.FAILED, null, "No cached data for this migration", 2, null);
            return;
        }
        MigrationFinalStatus finalStatus = migrationFinalStatus;
        CrossProjectFinalStatus cfr_ignored_0 = (CrossProjectFinalStatus)finalStatus;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"dataExport", (Object)((CrossProjectFinalStatus)finalStatus).getDataExportFile()), TuplesKt.to((Object)"deletedUsersMappings", (Object)((CrossProjectFinalStatus)finalStatus).getDeletedUserMappingFile()), TuplesKt.to((Object)"tombstoneUsers", (Object)((CrossProjectFinalStatus)finalStatus).getTombstoneUserFile())};
        PlatformProgressUpdater.sendFinalStatus$default(this.progressUpdater, TransferStatus.SUCCESS, MapsKt.mapOf((Pair[])pairArray), null, 4, null);
    }

    private final void setHeartbeatScheduler() {
        if (this.migrationFeatures.getEnableV3AsyncHeartbeat()) {
            this.heartbeatScheduler.scheduleAtFixedRate(PlatformUtilKt.createHeartbeatRunnable((Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ V3CrossProjectDataProcessor this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    AbstractCrossProjectDataProcessor.sendHeartbeat$default(this.this$0, null, 1, null);
                }
            }), this.task, MigrationProtocol.V3), 0L, this.getHeartbeatFrequency(), PlatformUtilKt.getHEARTBEAT_TIME_UNIT());
        }
    }

    @Override
    public void sendHeartbeat(@Nullable String msg) {
        this.heartbeater.sendHeartbeat();
    }

    @Override
    public void sendFinalStatus() {
        String string = ((UUID)this.getMigrationId().getValue()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        MigrationFinalStatusRepository.create$default(this.migrationFinalStatusRepository, string, new CrossProjectFinalStatus(this.getCrossProjectDataFile().getFileId(), this.getDeletedUsersFile().getFileId(), this.getTombstoneUsersFile().getFileId()), null, 4, null);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"dataExport", (Object)this.getCrossProjectDataFile().getFileId()), TuplesKt.to((Object)"deletedUsersMappings", (Object)this.getDeletedUsersFile().getFileId()), TuplesKt.to((Object)"tombstoneUsers", (Object)this.getTombstoneUsersFile().getFileId())};
        PlatformProgressUpdater.sendFinalStatus$default(this.progressUpdater, TransferStatus.SUCCESS, MapsKt.mapOf((Pair[])pairArray), null, 4, null);
    }

    @Override
    public long getHeartbeatFrequency() {
        return 10L;
    }
}

