/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.cpd;

import com.atlassian.jira.migration.GroupedThreadFactory;
import com.atlassian.jira.migration.analytics.MetricsEventService;
import com.atlassian.jira.migration.analytics.MigAssetStatsService;
import com.atlassian.jira.migration.common.LocalFileDataOutput;
import com.atlassian.jira.migration.datafilters.DataFiltersContextService;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.export.ExportFacade;
import com.atlassian.jira.migration.migration.DryRunMigrationRepository;
import com.atlassian.jira.migration.migration.MigrationCommand;
import com.atlassian.jira.migration.migration.MigrationCommandService;
import com.atlassian.jira.migration.migration.MigrationProtocol;
import com.atlassian.jira.migration.orchestratorclient.tasks.ProgressUnit;
import com.atlassian.jira.migration.plan.ExecutionType;
import com.atlassian.jira.migration.platform.PlatformService;
import com.atlassian.jira.migration.prc.PrcCommandExecutor;
import com.atlassian.jira.migration.prc.PrcStatusUpdateService;
import com.atlassian.jira.migration.prc.model.CrossProjectMigrationPayload;
import com.atlassian.jira.migration.prc.model.PrcCommandPayload;
import com.atlassian.jira.migration.preflight.reports.DryRunWriteService;
import com.atlassian.jira.migration.scope.MigrationScopeManager;
import com.atlassian.jira.migration.shadow.db.MigrationFinalStatusRepository;
import com.atlassian.jira.migration.tracking.polling.InProgressMigrationIds;
import com.atlassian.jira.migration.tracking.tasks.PrcTask;
import com.atlassian.jira.migration.tracking.tasks.V4Worker;
import com.atlassian.jira.migration.usersmigrationservice.UsersMigrationServiceClient;
import com.atlassian.jira.migration.workers.DryRunReportProcessor;
import com.atlassian.jira.migration.workers.MigrationTaskMetadataProvider;
import com.atlassian.jira.migration.workers.WorkerDataConvertor;
import com.atlassian.jira.migration.workers.cpd.V4CrossProjectDataProcessor;
import com.atlassian.jira.migration.workers.tombstone.TombstoneAccountManager;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.thread.JiraThreadLocalUtil;
import com.atlassian.migration.prc.model.CommandName;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00dc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u00b7\u0001\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\u0006\u0010\u0019\u001a\u00020\u001a\u0012\u0006\u0010\u001b\u001a\u00020\u001c\u0012\u0006\u0010\u001d\u001a\u00020\u001e\u0012\u0006\u0010\u001f\u001a\u00020 \u0012\u0006\u0010!\u001a\u00020\"\u0012\u0006\u0010#\u001a\u00020$\u0012\u0006\u0010%\u001a\u00020&\u0012\u0006\u0010'\u001a\u00020(\u0012\u0006\u0010)\u001a\u00020*\u0012\u0006\u0010+\u001a\u00020,\u0012\u0006\u0010-\u001a\u00020.\u00a2\u0006\u0002\u0010/J\u0018\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020>2\u0006\u0010I\u001a\u00020JH\u0016J\u0010\u0010K\u001a\u00020G2\u0006\u0010L\u001a\u00020MH\u0016J\u0010\u0010N\u001a\u00020G2\u0006\u0010L\u001a\u00020MH\u0002J\u0010\u0010O\u001a\u00020G2\u0006\u0010L\u001a\u00020MH\u0002R\u0014\u00100\u001a\u000201X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00104\u001a\u000205X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00108\u001a\u000209X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010<\u001a\n\u0012\u0006\b\u0001\u0012\u00020>0=X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010@R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010A\u001a\b\u0012\u0004\u0012\u00020C0BX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010ER\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lcom/atlassian/jira/migration/workers/cpd/V4CrossProjectDataWorker;", "Lcom/atlassian/jira/migration/tracking/tasks/V4Worker;", "Lcom/atlassian/jira/migration/prc/PrcCommandExecutor;", "exportFacade", "Lcom/atlassian/jira/migration/export/ExportFacade;", "migrationTaskMetadataProvider", "Lcom/atlassian/jira/migration/workers/MigrationTaskMetadataProvider;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "migrationScopeManager", "Lcom/atlassian/jira/migration/scope/MigrationScopeManager;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "tombstoneAccountManager", "Lcom/atlassian/jira/migration/workers/tombstone/TombstoneAccountManager;", "usersMigrationServiceClient", "Lcom/atlassian/jira/migration/usersmigrationservice/UsersMigrationServiceClient;", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "metricsEventService", "Lcom/atlassian/jira/migration/analytics/MetricsEventService;", "platformService", "Lcom/atlassian/jira/migration/platform/PlatformService;", "migAssetStatsService", "Lcom/atlassian/jira/migration/analytics/MigAssetStatsService;", "prcStatusUpdateService", "Lcom/atlassian/jira/migration/prc/PrcStatusUpdateService;", "migrationFinalStatusRepository", "Lcom/atlassian/jira/migration/shadow/db/MigrationFinalStatusRepository;", "migrationCommandService", "Lcom/atlassian/jira/migration/migration/MigrationCommandService;", "migrationIds", "Lcom/atlassian/jira/migration/tracking/polling/InProgressMigrationIds;", "dataFiltersContextService", "Lcom/atlassian/jira/migration/datafilters/DataFiltersContextService;", "workerDataConvertor", "Lcom/atlassian/jira/migration/workers/WorkerDataConvertor;", "dryRunWriteService", "Lcom/atlassian/jira/migration/preflight/reports/DryRunWriteService;", "jiraThreadLocalUtil", "Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;", "userManager", "Lcom/atlassian/jira/user/util/UserManager;", "localFileDataOutput", "Lcom/atlassian/jira/migration/common/LocalFileDataOutput;", "dryRunMigrationRepository", "Lcom/atlassian/jira/migration/migration/DryRunMigrationRepository;", "(Lcom/atlassian/jira/migration/export/ExportFacade;Lcom/atlassian/jira/migration/workers/MigrationTaskMetadataProvider;Lcom/atlassian/jira/migration/discovery/DiscoveryService;Lcom/atlassian/jira/migration/scope/MigrationScopeManager;Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/migration/workers/tombstone/TombstoneAccountManager;Lcom/atlassian/jira/migration/usersmigrationservice/UsersMigrationServiceClient;Lcom/atlassian/jira/project/ProjectManager;Lcom/atlassian/jira/migration/analytics/MetricsEventService;Lcom/atlassian/jira/migration/platform/PlatformService;Lcom/atlassian/jira/migration/analytics/MigAssetStatsService;Lcom/atlassian/jira/migration/prc/PrcStatusUpdateService;Lcom/atlassian/jira/migration/shadow/db/MigrationFinalStatusRepository;Lcom/atlassian/jira/migration/migration/MigrationCommandService;Lcom/atlassian/jira/migration/tracking/polling/InProgressMigrationIds;Lcom/atlassian/jira/migration/datafilters/DataFiltersContextService;Lcom/atlassian/jira/migration/workers/WorkerDataConvertor;Lcom/atlassian/jira/migration/preflight/reports/DryRunWriteService;Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;Lcom/atlassian/jira/user/util/UserManager;Lcom/atlassian/jira/migration/common/LocalFileDataOutput;Lcom/atlassian/jira/migration/migration/DryRunMigrationRepository;)V", "commandName", "Lcom/atlassian/migration/prc/model/CommandName;", "getCommandName", "()Lcom/atlassian/migration/prc/model/CommandName;", "id", "", "getId", "()Ljava/lang/String;", "migrationProtocol", "Lcom/atlassian/jira/migration/migration/MigrationProtocol;", "getMigrationProtocol", "()Lcom/atlassian/jira/migration/migration/MigrationProtocol;", "payloadClassType", "Lkotlin/reflect/KClass;", "Lcom/atlassian/jira/migration/prc/model/PrcCommandPayload;", "getPayloadClassType", "()Lkotlin/reflect/KClass;", "supportedUnits", "", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/ProgressUnit;", "getSupportedUnits", "()Ljava/util/List;", "executeTask", "", "commandPayload", "prcCommandId", "", "process", "task", "Lcom/atlassian/jira/migration/tracking/tasks/PrcTask;", "processCrossProjectData", "processDryRunReport", "jira-migration-plugin"})
public final class V4CrossProjectDataWorker
implements V4Worker,
PrcCommandExecutor {
    @NotNull
    private final ExportFacade exportFacade;
    @NotNull
    private final MigrationTaskMetadataProvider migrationTaskMetadataProvider;
    @NotNull
    private final DiscoveryService discoveryService;
    @NotNull
    private final MigrationScopeManager migrationScopeManager;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final TombstoneAccountManager tombstoneAccountManager;
    @NotNull
    private final UsersMigrationServiceClient usersMigrationServiceClient;
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final MetricsEventService metricsEventService;
    @NotNull
    private final PlatformService platformService;
    @NotNull
    private final MigAssetStatsService migAssetStatsService;
    @NotNull
    private final PrcStatusUpdateService prcStatusUpdateService;
    @NotNull
    private final MigrationFinalStatusRepository migrationFinalStatusRepository;
    @NotNull
    private final MigrationCommandService migrationCommandService;
    @NotNull
    private final InProgressMigrationIds migrationIds;
    @NotNull
    private final DataFiltersContextService dataFiltersContextService;
    @NotNull
    private final WorkerDataConvertor workerDataConvertor;
    @NotNull
    private final DryRunWriteService dryRunWriteService;
    @NotNull
    private final JiraThreadLocalUtil jiraThreadLocalUtil;
    @NotNull
    private final UserManager userManager;
    @NotNull
    private final LocalFileDataOutput localFileDataOutput;
    @NotNull
    private final DryRunMigrationRepository dryRunMigrationRepository;
    @NotNull
    private final String id;
    @NotNull
    private final MigrationProtocol migrationProtocol;
    @NotNull
    private final List<ProgressUnit> supportedUnits;
    @NotNull
    private final CommandName commandName;
    @NotNull
    private final KClass<? extends PrcCommandPayload> payloadClassType;

    @Inject
    public V4CrossProjectDataWorker(@NotNull ExportFacade exportFacade, @NotNull MigrationTaskMetadataProvider migrationTaskMetadataProvider, @NotNull DiscoveryService discoveryService, @NotNull MigrationScopeManager migrationScopeManager, @NotNull MigrationEventBus migrationEventBus, @NotNull TombstoneAccountManager tombstoneAccountManager, @NotNull UsersMigrationServiceClient usersMigrationServiceClient, @NotNull ProjectManager projectManager, @NotNull MetricsEventService metricsEventService, @NotNull PlatformService platformService, @NotNull MigAssetStatsService migAssetStatsService, @NotNull PrcStatusUpdateService prcStatusUpdateService, @NotNull MigrationFinalStatusRepository migrationFinalStatusRepository, @NotNull MigrationCommandService migrationCommandService, @NotNull InProgressMigrationIds migrationIds, @NotNull DataFiltersContextService dataFiltersContextService, @NotNull WorkerDataConvertor workerDataConvertor, @NotNull DryRunWriteService dryRunWriteService, @NotNull JiraThreadLocalUtil jiraThreadLocalUtil, @NotNull UserManager userManager, @NotNull LocalFileDataOutput localFileDataOutput, @NotNull DryRunMigrationRepository dryRunMigrationRepository) {
        Intrinsics.checkNotNullParameter((Object)exportFacade, (String)"exportFacade");
        Intrinsics.checkNotNullParameter((Object)migrationTaskMetadataProvider, (String)"migrationTaskMetadataProvider");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)migrationScopeManager, (String)"migrationScopeManager");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)tombstoneAccountManager, (String)"tombstoneAccountManager");
        Intrinsics.checkNotNullParameter((Object)usersMigrationServiceClient, (String)"usersMigrationServiceClient");
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)metricsEventService, (String)"metricsEventService");
        Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
        Intrinsics.checkNotNullParameter((Object)migAssetStatsService, (String)"migAssetStatsService");
        Intrinsics.checkNotNullParameter((Object)prcStatusUpdateService, (String)"prcStatusUpdateService");
        Intrinsics.checkNotNullParameter((Object)migrationFinalStatusRepository, (String)"migrationFinalStatusRepository");
        Intrinsics.checkNotNullParameter((Object)migrationCommandService, (String)"migrationCommandService");
        Intrinsics.checkNotNullParameter((Object)migrationIds, (String)"migrationIds");
        Intrinsics.checkNotNullParameter((Object)dataFiltersContextService, (String)"dataFiltersContextService");
        Intrinsics.checkNotNullParameter((Object)workerDataConvertor, (String)"workerDataConvertor");
        Intrinsics.checkNotNullParameter((Object)dryRunWriteService, (String)"dryRunWriteService");
        Intrinsics.checkNotNullParameter((Object)jiraThreadLocalUtil, (String)"jiraThreadLocalUtil");
        Intrinsics.checkNotNullParameter((Object)userManager, (String)"userManager");
        Intrinsics.checkNotNullParameter((Object)((Object)localFileDataOutput), (String)"localFileDataOutput");
        Intrinsics.checkNotNullParameter((Object)dryRunMigrationRepository, (String)"dryRunMigrationRepository");
        this.exportFacade = exportFacade;
        this.migrationTaskMetadataProvider = migrationTaskMetadataProvider;
        this.discoveryService = discoveryService;
        this.migrationScopeManager = migrationScopeManager;
        this.migrationEventBus = migrationEventBus;
        this.tombstoneAccountManager = tombstoneAccountManager;
        this.usersMigrationServiceClient = usersMigrationServiceClient;
        this.projectManager = projectManager;
        this.metricsEventService = metricsEventService;
        this.platformService = platformService;
        this.migAssetStatsService = migAssetStatsService;
        this.prcStatusUpdateService = prcStatusUpdateService;
        this.migrationFinalStatusRepository = migrationFinalStatusRepository;
        this.migrationCommandService = migrationCommandService;
        this.migrationIds = migrationIds;
        this.dataFiltersContextService = dataFiltersContextService;
        this.workerDataConvertor = workerDataConvertor;
        this.dryRunWriteService = dryRunWriteService;
        this.jiraThreadLocalUtil = jiraThreadLocalUtil;
        this.userManager = userManager;
        this.localFileDataOutput = localFileDataOutput;
        this.dryRunMigrationRepository = dryRunMigrationRepository;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.id = string;
        this.migrationProtocol = MigrationProtocol.V4;
        this.supportedUnits = CollectionsKt.listOf((Object)((Object)ProgressUnit.CROSS_PROJECT_ENTITY));
        this.commandName = CommandName.JIRA_CROSS_PROJECT_UPLOAD;
        this.payloadClassType = Reflection.getOrCreateKotlinClass(CrossProjectMigrationPayload.class);
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public MigrationProtocol getMigrationProtocol() {
        return this.migrationProtocol;
    }

    @Override
    @NotNull
    public List<ProgressUnit> getSupportedUnits() {
        return this.supportedUnits;
    }

    @Override
    @NotNull
    public CommandName getCommandName() {
        return this.commandName;
    }

    @Override
    @NotNull
    public KClass<? extends PrcCommandPayload> getPayloadClassType() {
        return this.payloadClassType;
    }

    @Override
    public void executeTask(@NotNull PrcCommandPayload commandPayload, long prcCommandId) {
        Intrinsics.checkNotNullParameter((Object)commandPayload, (String)"commandPayload");
        PrcTask task = this.workerDataConvertor.toPrcTaskFromMigrationPayload(commandPayload, prcCommandId, this.getCommandName());
        MigrationCommand migrationCommand = this.migrationCommandService.upsertVersion(task.getMigrationId(), String.valueOf(prcCommandId));
        task.setVersion(migrationCommand.getVersion());
        this.process(task);
    }

    private final void processDryRunReport(PrcTask task) {
        ExportFacade exportFacade = this.exportFacade;
        DryRunWriteService dryRunWriteService = this.dryRunWriteService;
        JiraThreadLocalUtil jiraThreadLocalUtil = this.jiraThreadLocalUtil;
        PrcStatusUpdateService prcStatusUpdateService = this.prcStatusUpdateService;
        LocalFileDataOutput localFileDataOutput = this.localFileDataOutput;
        ProjectManager projectManager = this.projectManager;
        DataFiltersContextService dataFiltersContextService = this.dataFiltersContextService;
        MigrationCommandService migrationCommandService = this.migrationCommandService;
        InProgressMigrationIds inProgressMigrationIds = this.migrationIds;
        DiscoveryService discoveryService = this.discoveryService;
        UserManager userManager = this.userManager;
        DryRunMigrationRepository dryRunMigrationRepository = this.dryRunMigrationRepository;
        new DryRunReportProcessor(exportFacade, dryRunWriteService, jiraThreadLocalUtil, prcStatusUpdateService, task, localFileDataOutput, projectManager, dataFiltersContextService, dryRunMigrationRepository, migrationCommandService, inProgressMigrationIds, discoveryService, userManager, null, null, 24576, null).process();
    }

    private final void processCrossProjectData(PrcTask task) {
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new GroupedThreadFactory("V4CrossProjectDataWorker"));
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"newSingleThreadScheduledExecutor(...)");
        new V4CrossProjectDataProcessor(task, this.migrationTaskMetadataProvider, this.exportFacade, this.discoveryService, this.migrationScopeManager, this.migrationEventBus, this.tombstoneAccountManager, this.usersMigrationServiceClient, this.projectManager, this.metricsEventService, this.platformService, this.migAssetStatsService, this.prcStatusUpdateService, this.migrationFinalStatusRepository, scheduledExecutorService, this.getMigrationProtocol(), this.migrationCommandService, this.migrationIds, this.dataFiltersContextService).process();
    }

    @Override
    public void process(@NotNull PrcTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (task.getExecutionType() == ExecutionType.DRY_RUN) {
            this.processDryRunReport(task);
        } else {
            this.processCrossProjectData(task);
        }
    }
}

