/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.customers;

import com.atlassian.jira.migration.prc.exception.CommandCancelledException;
import com.atlassian.jira.migration.serverdataextractors.usergroup.Customer;
import com.atlassian.jira.migration.serverdataextractors.usergroup.ExportUpdate;
import com.atlassian.jira.migration.tracking.tasks.Task;
import com.atlassian.jira.migration.workers.customers.CustomersProcessorDataRetriever;
import com.atlassian.jira.migration.workers.customers.CustomersProcessorMetricsService;
import com.atlassian.jira.migration.workers.customers.CustomersProcessorService;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0015\u001a\u00020\u0016H&J\b\u0010\u0017\u001a\u00020\u0012H\u0016J\b\u0010\u0018\u001a\u00020\u0012H&J\u0014\u0010\u0019\u001a\u00020\u00122\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001bH&J\u001e\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH&R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/atlassian/jira/migration/workers/customers/AbstractCustomersProcessor;", "", "customersProcessorDataRetriever", "Lcom/atlassian/jira/migration/workers/customers/CustomersProcessorDataRetriever;", "customersProcessorMetricsService", "Lcom/atlassian/jira/migration/workers/customers/CustomersProcessorMetricsService;", "task", "Lcom/atlassian/jira/migration/tracking/tasks/Task;", "customersProcessorService", "Lcom/atlassian/jira/migration/workers/customers/CustomersProcessorService;", "(Lcom/atlassian/jira/migration/workers/customers/CustomersProcessorDataRetriever;Lcom/atlassian/jira/migration/workers/customers/CustomersProcessorMetricsService;Lcom/atlassian/jira/migration/tracking/tasks/Task;Lcom/atlassian/jira/migration/workers/customers/CustomersProcessorService;)V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "onProgressUpdate", "Lkotlin/Function1;", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/ExportUpdate;", "", "getOnProgressUpdate", "()Lkotlin/jvm/functions/Function1;", "getHeartbeatFrequency", "", "process", "sendFinalStatus", "sendHeartbeat", "msg", "", "uploadCustomersData", "migrationScopeId", "customers", "", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/Customer;", "jira-migration-plugin"})
public abstract class AbstractCustomersProcessor {
    @NotNull
    private final CustomersProcessorDataRetriever customersProcessorDataRetriever;
    @NotNull
    private final CustomersProcessorMetricsService customersProcessorMetricsService;
    @NotNull
    private final Task task;
    @NotNull
    private final CustomersProcessorService customersProcessorService;

    public AbstractCustomersProcessor(@NotNull CustomersProcessorDataRetriever customersProcessorDataRetriever, @NotNull CustomersProcessorMetricsService customersProcessorMetricsService, @NotNull Task task, @NotNull CustomersProcessorService customersProcessorService) {
        Intrinsics.checkNotNullParameter((Object)customersProcessorDataRetriever, (String)"customersProcessorDataRetriever");
        Intrinsics.checkNotNullParameter((Object)customersProcessorMetricsService, (String)"customersProcessorMetricsService");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)customersProcessorService, (String)"customersProcessorService");
        this.customersProcessorDataRetriever = customersProcessorDataRetriever;
        this.customersProcessorMetricsService = customersProcessorMetricsService;
        this.task = task;
        this.customersProcessorService = customersProcessorService;
    }

    @NotNull
    public abstract Logger getLog();

    public void process() {
        String migrationScopeId2 = this.customersProcessorDataRetriever.logMigrationScopeId(this.task, this.getLog());
        this.customersProcessorMetricsService.postStartEvent(this.task);
        try {
            List<Customer> customers = this.customersProcessorService.processCustomers(this.task, this.getLog(), this.getOnProgressUpdate());
            this.uploadCustomersData(migrationScopeId2, customers);
            this.sendFinalStatus();
            this.customersProcessorMetricsService.sendSuccessfulEvent(this.task);
        }
        catch (CommandCancelledException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.customersProcessorMetricsService.postFailedEvent(this.task, ex);
            this.customersProcessorMetricsService.sendFailedEvent(this.task);
            this.customersProcessorService.checkEnabledTraceStoring(this.task, ex);
            throw ex;
        }
    }

    public abstract long getHeartbeatFrequency();

    public abstract void uploadCustomersData(@NotNull String var1, @NotNull List<Customer> var2);

    @NotNull
    public abstract Function1<ExportUpdate, Unit> getOnProgressUpdate();

    public abstract void sendHeartbeat(@Nullable String var1);

    public static /* synthetic */ void sendHeartbeat$default(AbstractCustomersProcessor abstractCustomersProcessor, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sendHeartbeat");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        abstractCustomersProcessor.sendHeartbeat(string);
    }

    public abstract void sendFinalStatus();
}

