/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.customers;

import com.atlassian.jira.migration.common.MigrationTaskMetadata;
import com.atlassian.jira.migration.datafilters.DataFiltersContextService;
import com.atlassian.jira.migration.datafilters.model.DataFilterContext;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.events.ExportStatistics;
import com.atlassian.jira.migration.export.ExportFacade;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.plan.CrossProjectConfig;
import com.atlassian.jira.migration.plan.CrossProjectExportConfig;
import com.atlassian.jira.migration.plan.JsdCustomersMigrationOption;
import com.atlassian.jira.migration.plan.MigrationType;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.plan.ProjectDataMigrationMode;
import com.atlassian.jira.migration.plan.UsersGroupsMigrationOption;
import com.atlassian.jira.migration.serverdataextractors.usergroup.ExportUpdate;
import com.atlassian.jira.migration.serverdataextractors.usergroup.GroupsWithReferences;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JsmCustomerReader;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UsersAndGroupsWithReferences;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UsersGroupsExtractionResult;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UsersWithReferences;
import com.atlassian.jira.migration.tracking.tasks.Task;
import com.atlassian.jira.migration.workers.MigrationTaskMetadataProvider;
import com.atlassian.jira.migration.workers.customers.CustomerExtractor;
import com.atlassian.jira.migration.workers.usersgroups.ScopedUserExtractor;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.thread.JiraThreadLocalUtil;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 ?2\u00020\u0001:\u0001?BO\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J9\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192#\b\u0002\u0010\u001a\u001a\u001d\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020 0\u001bJ\u008f\u0001\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0010\b\u0002\u0010+\u001a\n\u0012\u0004\u0012\u00020,\u0018\u00010$2\u0006\u0010-\u001a\u00020\u00172\b\u0010.\u001a\u0004\u0018\u00010/2\n\b\u0002\u00100\u001a\u0004\u0018\u0001012\b\b\u0002\u00102\u001a\u0002032\u0014\b\u0002\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020 0\u001b\u00a2\u0006\u0002\u00104J\u0087\u0001\u00105\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0010\b\u0002\u0010+\u001a\n\u0012\u0004\u0012\u00020,\u0018\u00010$2\u0006\u00106\u001a\u0002072\u0014\b\u0002\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020 0\u001b2\b\u0010.\u001a\u0004\u0018\u00010/2\b\u00100\u001a\u0004\u0018\u0001012\b\b\u0002\u00102\u001a\u000203H\u0002\u00a2\u0006\u0002\u00108J\u0014\u00109\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010:\u001a\u00020;J\u0014\u0010<\u001a\u00020=2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/atlassian/jira/migration/workers/customers/CustomerExtractor;", "", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "migrationTaskMetadataProvider", "Lcom/atlassian/jira/migration/workers/MigrationTaskMetadataProvider;", "jsmCustomerReader", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JsmCustomerReader;", "userManager", "Lcom/atlassian/jira/user/util/UserManager;", "exportFacade", "Lcom/atlassian/jira/migration/export/ExportFacade;", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "jiraThreadLocalUtil", "Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;", "dataFiltersContextService", "Lcom/atlassian/jira/migration/datafilters/DataFiltersContextService;", "(Lcom/atlassian/jira/migration/discovery/DiscoveryService;Lcom/atlassian/jira/migration/workers/MigrationTaskMetadataProvider;Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JsmCustomerReader;Lcom/atlassian/jira/user/util/UserManager;Lcom/atlassian/jira/migration/export/ExportFacade;Lcom/atlassian/jira/project/ProjectManager;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;Lcom/atlassian/jira/migration/datafilters/DataFiltersContextService;)V", "extract", "Lkotlin/sequences/Sequence;", "Lcom/atlassian/jira/user/ApplicationUser;", "task", "Lcom/atlassian/jira/migration/tracking/tasks/Task;", "onProgressUpdate", "Lkotlin/Function1;", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/ExportUpdate;", "Lkotlin/ParameterName;", "name", "update", "", "id", "", "projectKeys", "", "usersGroupsMigrationOption", "Lcom/atlassian/jira/migration/plan/UsersGroupsMigrationOption;", "projectDataMigrationMode", "Lcom/atlassian/jira/migration/plan/ProjectDataMigrationMode;", "migrationType", "Lcom/atlassian/jira/migration/plan/MigrationType;", "advancedRoadmapsPlanIds", "", "startedUser", "crossProjectConfig", "Lcom/atlassian/jira/migration/plan/CrossProjectConfig;", "migrateArchivedIssues", "", "dataFilterContext", "Lcom/atlassian/jira/migration/datafilters/model/DataFilterContext;", "(Ljava/lang/String;Ljava/util/List;Lcom/atlassian/jira/migration/plan/UsersGroupsMigrationOption;Lcom/atlassian/jira/migration/plan/ProjectDataMigrationMode;Lcom/atlassian/jira/migration/plan/MigrationType;Ljava/util/List;Lcom/atlassian/jira/user/ApplicationUser;Lcom/atlassian/jira/migration/plan/CrossProjectConfig;Ljava/lang/Boolean;Lcom/atlassian/jira/migration/datafilters/model/DataFilterContext;Lkotlin/jvm/functions/Function1;)Lkotlin/sequences/Sequence;", "extractCustomers", "taskMetadata", "Lcom/atlassian/jira/migration/common/MigrationTaskMetadata;", "(Ljava/util/List;Lcom/atlassian/jira/migration/plan/UsersGroupsMigrationOption;Lcom/atlassian/jira/migration/plan/ProjectDataMigrationMode;Lcom/atlassian/jira/migration/plan/MigrationType;Ljava/util/List;Lcom/atlassian/jira/migration/common/MigrationTaskMetadata;Lkotlin/jvm/functions/Function1;Lcom/atlassian/jira/migration/plan/CrossProjectConfig;Ljava/lang/Boolean;Lcom/atlassian/jira/migration/datafilters/model/DataFilterContext;)Lkotlin/sequences/Sequence;", "getCustomers", "usersAndGroupsWithReferences", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UsersAndGroupsWithReferences;", "getReferencedExtractionResult", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UsersGroupsExtractionResult;", "customers", "Companion", "jira-migration-plugin"})
public final class CustomerExtractor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DiscoveryService discoveryService;
    @NotNull
    private final MigrationTaskMetadataProvider migrationTaskMetadataProvider;
    @NotNull
    private final JsmCustomerReader jsmCustomerReader;
    @NotNull
    private final UserManager userManager;
    @NotNull
    private final ExportFacade exportFacade;
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final JiraThreadLocalUtil jiraThreadLocalUtil;
    @NotNull
    private final DataFiltersContextService dataFiltersContextService;
    private static final Logger log = LoggerFactory.getLogger(CustomerExtractor.class);

    @Inject
    public CustomerExtractor(@NotNull DiscoveryService discoveryService, @NotNull MigrationTaskMetadataProvider migrationTaskMetadataProvider, @NotNull JsmCustomerReader jsmCustomerReader, @NotNull UserManager userManager, @NotNull ExportFacade exportFacade, @NotNull ProjectManager projectManager, @NotNull MigrationFeatures migrationFeatures, @NotNull JiraThreadLocalUtil jiraThreadLocalUtil, @NotNull DataFiltersContextService dataFiltersContextService) {
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)migrationTaskMetadataProvider, (String)"migrationTaskMetadataProvider");
        Intrinsics.checkNotNullParameter((Object)jsmCustomerReader, (String)"jsmCustomerReader");
        Intrinsics.checkNotNullParameter((Object)userManager, (String)"userManager");
        Intrinsics.checkNotNullParameter((Object)exportFacade, (String)"exportFacade");
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)jiraThreadLocalUtil, (String)"jiraThreadLocalUtil");
        Intrinsics.checkNotNullParameter((Object)dataFiltersContextService, (String)"dataFiltersContextService");
        this.discoveryService = discoveryService;
        this.migrationTaskMetadataProvider = migrationTaskMetadataProvider;
        this.jsmCustomerReader = jsmCustomerReader;
        this.userManager = userManager;
        this.exportFacade = exportFacade;
        this.projectManager = projectManager;
        this.migrationFeatures = migrationFeatures;
        this.jiraThreadLocalUtil = jiraThreadLocalUtil;
        this.dataFiltersContextService = dataFiltersContextService;
    }

    @NotNull
    public final Sequence<ApplicationUser> extract(@NotNull Task task, @NotNull Function1<? super ExportUpdate, Unit> onProgressUpdate2) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter(onProgressUpdate2, (String)"onProgressUpdate");
        Plan plan2 = DiscoveryService.retrievePlanFor$default(this.discoveryService, task, false, 2, null);
        List list = plan2.getAdvancedRoadmapsPlanIds();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List advancedRoadmapsPlanIds = list;
        log.info("Extracting customers for task {}", (Object)task.getMigrationId());
        return this.extractCustomers(plan2.getProjectKeys(), plan2.getUsersGroupsMigrationOption(), plan2.getProjectDataMigrationMode(), plan2.getMigrationType(), advancedRoadmapsPlanIds, this.migrationTaskMetadataProvider.get(task), onProgressUpdate2, new CrossProjectConfig(new CrossProjectExportConfig(plan2.getCrossProjectBoardsAndFiltersMigrationOption(), plan2.getDashboardsMigrationMode())), plan2.getMigrateArchivedIssues(), DataFiltersContextService.getDataFilterContext$default(this.dataFiltersContextService, plan2.getProjectDataMigrationMode(), plan2.getIssueFilters(), null, 4, null));
    }

    public static /* synthetic */ Sequence extract$default(CustomerExtractor customerExtractor, Task task, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = extract.1.INSTANCE;
        }
        return customerExtractor.extract(task, (Function1<? super ExportUpdate, Unit>)function1);
    }

    @NotNull
    public final Sequence<ApplicationUser> extract(@NotNull String id, @NotNull List<String> projectKeys, @NotNull UsersGroupsMigrationOption usersGroupsMigrationOption, @NotNull ProjectDataMigrationMode projectDataMigrationMode, @NotNull MigrationType migrationType, @Nullable List<Long> advancedRoadmapsPlanIds, @NotNull ApplicationUser startedUser, @Nullable CrossProjectConfig crossProjectConfig, @Nullable Boolean migrateArchivedIssues, @NotNull DataFilterContext dataFilterContext, @NotNull Function1<? super ExportUpdate, Unit> onProgressUpdate2) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(projectKeys, (String)"projectKeys");
        Intrinsics.checkNotNullParameter((Object)usersGroupsMigrationOption, (String)"usersGroupsMigrationOption");
        Intrinsics.checkNotNullParameter((Object)((Object)projectDataMigrationMode), (String)"projectDataMigrationMode");
        Intrinsics.checkNotNullParameter((Object)((Object)migrationType), (String)"migrationType");
        Intrinsics.checkNotNullParameter((Object)startedUser, (String)"startedUser");
        Intrinsics.checkNotNullParameter((Object)dataFilterContext, (String)"dataFilterContext");
        Intrinsics.checkNotNullParameter(onProgressUpdate2, (String)"onProgressUpdate");
        log.info("Extracting customers for task {}", (Object)id);
        MigrationTaskMetadata migrationTaskMetadata2 = MigrationTaskMetadata.Companion.dummyMigrationMetadata$default(MigrationTaskMetadata.Companion, id, startedUser, null, 4, null);
        return this.extractCustomers(projectKeys, usersGroupsMigrationOption, projectDataMigrationMode, migrationType, advancedRoadmapsPlanIds, migrationTaskMetadata2, onProgressUpdate2, crossProjectConfig, migrateArchivedIssues, dataFilterContext);
    }

    public static /* synthetic */ Sequence extract$default(CustomerExtractor customerExtractor, String string, List list, UsersGroupsMigrationOption usersGroupsMigrationOption, ProjectDataMigrationMode projectDataMigrationMode, MigrationType migrationType, List list2, ApplicationUser applicationUser, CrossProjectConfig crossProjectConfig, Boolean bl, DataFilterContext dataFilterContext, Function1 function1, int n, Object object) {
        if ((n & 0x20) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x100) != 0) {
            bl = false;
        }
        if ((n & 0x200) != 0) {
            dataFilterContext = new DataFilterContext(null, null, null, 7, null);
        }
        if ((n & 0x400) != 0) {
            function1 = extract.2.INSTANCE;
        }
        return customerExtractor.extract(string, list, usersGroupsMigrationOption, projectDataMigrationMode, migrationType, list2, applicationUser, crossProjectConfig, bl, dataFilterContext, (Function1<? super ExportUpdate, Unit>)function1);
    }

    private final Sequence<ApplicationUser> extractCustomers(List<String> projectKeys, UsersGroupsMigrationOption usersGroupsMigrationOption, ProjectDataMigrationMode projectDataMigrationMode, MigrationType migrationType, List<Long> advancedRoadmapsPlanIds, MigrationTaskMetadata taskMetadata, Function1<? super ExportUpdate, Unit> onProgressUpdate2, CrossProjectConfig crossProjectConfig, Boolean migrateArchivedIssues, DataFilterContext dataFilterContext) {
        Sequence sequence;
        JsdCustomersMigrationOption jsdCustomersMigrationOption = usersGroupsMigrationOption.getJsdCustomersMigrationOption();
        log.info("Extracting customers in mode {} for task {}", (Object)(jsdCustomersMigrationOption != null ? jsdCustomersMigrationOption.getMode() : null), (Object)taskMetadata.getMigrationId());
        if (usersGroupsMigrationOption.getJsdCustomersMigrationOption() == null) {
            return SequencesKt.sequenceOf((Object[])new ApplicationUser[0]);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[usersGroupsMigrationOption.getJsdCustomersMigrationOption().getMode().ordinal()]) {
            case 1: {
                sequence = SequencesKt.sequenceOf((Object[])new ApplicationUser[0]);
                break;
            }
            case 2: {
                sequence = SequencesKt.mapNotNull(this.jsmCustomerReader.getAllJsmCustomers(), (Function1)((Function1)new Function1<String, ApplicationUser>(this){
                    final /* synthetic */ CustomerExtractor this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @Nullable
                    public final ApplicationUser invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return CustomerExtractor.access$getUserManager$p(this.this$0).getUserByName(it);
                    }
                }));
                break;
            }
            case 3: {
                ScopedUserExtractor referencedUserReader = new ScopedUserExtractor(this.exportFacade, projectKeys, taskMetadata, usersGroupsMigrationOption, projectDataMigrationMode, migrationType, onProgressUpdate2, this.projectManager, advancedRoadmapsPlanIds, this.jsmCustomerReader, this.jiraThreadLocalUtil, this.migrationFeatures, crossProjectConfig, migrateArchivedIssues, null, dataFilterContext, 16384, null);
                UsersAndGroupsWithReferences usersAndGroupsWithReferences = referencedUserReader.getAllUsersGroupsWithReferences();
                return this.getCustomers(usersAndGroupsWithReferences);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Sequence customersResult2 = sequence;
        return customersResult2;
    }

    static /* synthetic */ Sequence extractCustomers$default(CustomerExtractor customerExtractor, List list, UsersGroupsMigrationOption usersGroupsMigrationOption, ProjectDataMigrationMode projectDataMigrationMode, MigrationType migrationType, List list2, MigrationTaskMetadata migrationTaskMetadata2, Function1 function1, CrossProjectConfig crossProjectConfig, Boolean bl, DataFilterContext dataFilterContext, int n, Object object) {
        if ((n & 0x10) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x40) != 0) {
            function1 = extractCustomers.1.INSTANCE;
        }
        if ((n & 0x200) != 0) {
            dataFilterContext = new DataFilterContext(null, null, null, 7, null);
        }
        return customerExtractor.extractCustomers(list, usersGroupsMigrationOption, projectDataMigrationMode, migrationType, list2, migrationTaskMetadata2, (Function1<? super ExportUpdate, Unit>)function1, crossProjectConfig, bl, dataFilterContext);
    }

    @NotNull
    public final Sequence<ApplicationUser> getCustomers(@NotNull UsersAndGroupsWithReferences usersAndGroupsWithReferences) {
        Intrinsics.checkNotNullParameter((Object)usersAndGroupsWithReferences, (String)"usersAndGroupsWithReferences");
        return SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)usersAndGroupsWithReferences.getCustomers().names()), (Function1)((Function1)new Function1<String, ApplicationUser>(this){
            final /* synthetic */ CustomerExtractor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final ApplicationUser invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return CustomerExtractor.access$getUserManager$p(this.this$0).getUserByKey(it);
            }
        }));
    }

    @NotNull
    public final UsersGroupsExtractionResult getReferencedExtractionResult(@NotNull Sequence<? extends ApplicationUser> customers) {
        Intrinsics.checkNotNullParameter(customers, (String)"customers");
        Sequence allCustomers2 = SequencesKt.map(customers, (Function1)getReferencedExtractionResult.allCustomers.1.INSTANCE);
        return new UsersGroupsExtractionResult(new UsersWithReferences(SequencesKt.toList((Sequence)allCustomers2)), GroupsWithReferences.Companion.getEMPTY(), MapsKt.emptyMap(), ExportStatistics.Companion.getEMPTY(), false);
    }

    public static final /* synthetic */ UserManager access$getUserManager$p(CustomerExtractor $this) {
        return $this.userManager;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/workers/customers/CustomerExtractor$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JsdCustomersMigrationOption.JsdCustomersMigrationMode.values().length];
            try {
                nArray[JsdCustomersMigrationOption.JsdCustomersMigrationMode.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsdCustomersMigrationOption.JsdCustomersMigrationMode.ALL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsdCustomersMigrationOption.JsdCustomersMigrationMode.REFERENCED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

