/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.customers;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.scope.MigrationScopeManager;
import com.atlassian.jira.migration.tracking.tasks.Task;
import com.atlassian.jira.timezone.TimeZoneInfo;
import com.atlassian.jira.timezone.TimeZoneService;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0018\u001a\n \r*\u0004\u0018\u00010\u00190\u00192\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a\u00b2\u0006\n\u0010\u001b\u001a\u00020\u0017X\u008a\u0084\u0002"}, d2={"Lcom/atlassian/jira/migration/workers/customers/CustomersProcessorDataRetriever;", "", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "localeManager", "Lcom/atlassian/jira/config/LocaleManager;", "timeZoneService", "Lcom/atlassian/jira/timezone/TimeZoneService;", "migrationScopeManager", "Lcom/atlassian/jira/migration/scope/MigrationScopeManager;", "(Lcom/atlassian/jira/migration/discovery/DiscoveryService;Lcom/atlassian/jira/config/LocaleManager;Lcom/atlassian/jira/timezone/TimeZoneService;Lcom/atlassian/jira/migration/scope/MigrationScopeManager;)V", "localeOfUser", "Ljava/util/Locale;", "kotlin.jvm.PlatformType", "applicationUser", "Lcom/atlassian/jira/user/ApplicationUser;", "logMigrationScopeId", "", "task", "Lcom/atlassian/jira/migration/tracking/tasks/Task;", "log", "Lorg/slf4j/Logger;", "retrieveLazyPlan", "Lcom/atlassian/jira/migration/plan/Plan;", "timeZoneOfUser", "Lcom/atlassian/jira/timezone/TimeZoneInfo;", "jira-migration-plugin", "plan"})
public final class CustomersProcessorDataRetriever {
    @NotNull
    private final DiscoveryService discoveryService;
    @NotNull
    private final LocaleManager localeManager;
    @NotNull
    private final TimeZoneService timeZoneService;
    @NotNull
    private final MigrationScopeManager migrationScopeManager;

    @Inject
    public CustomersProcessorDataRetriever(@NotNull DiscoveryService discoveryService, @NotNull LocaleManager localeManager, @NotNull TimeZoneService timeZoneService, @NotNull MigrationScopeManager migrationScopeManager) {
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)localeManager, (String)"localeManager");
        Intrinsics.checkNotNullParameter((Object)timeZoneService, (String)"timeZoneService");
        Intrinsics.checkNotNullParameter((Object)migrationScopeManager, (String)"migrationScopeManager");
        this.discoveryService = discoveryService;
        this.localeManager = localeManager;
        this.timeZoneService = timeZoneService;
        this.migrationScopeManager = migrationScopeManager;
    }

    @NotNull
    public final Plan retrieveLazyPlan(@NotNull Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Lazy plan$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Plan>(this, task){
            final /* synthetic */ CustomersProcessorDataRetriever this$0;
            final /* synthetic */ Task $task;
            {
                this.this$0 = $receiver;
                this.$task = $task;
                super(0);
            }

            @NotNull
            public final Plan invoke() {
                return DiscoveryService.retrievePlanFor$default(CustomersProcessorDataRetriever.access$getDiscoveryService$p(this.this$0), this.$task, false, 2, null);
            }
        }));
        return CustomersProcessorDataRetriever.retrieveLazyPlan$lambda$0((Lazy<Plan>)plan$delegate);
    }

    public final Locale localeOfUser(@Nullable ApplicationUser applicationUser) {
        return this.localeManager.getLocaleFor(applicationUser);
    }

    public final TimeZoneInfo timeZoneOfUser(@Nullable ApplicationUser applicationUser) {
        return this.timeZoneService.getUserTimeZoneInfo((JiraServiceContext)new JiraServiceContextImpl(applicationUser));
    }

    @NotNull
    public final String logMigrationScopeId(@NotNull Task task, @NotNull Logger log2) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)log2, (String)"log");
        String migrationScopeId2 = this.migrationScopeManager.getMigrationScope(task.getCloudSite());
        log2.info(task.getMigrationId() + '-' + task.getTaskId() + ": exporting JSD customers with migrationScopeId " + migrationScopeId2);
        return migrationScopeId2;
    }

    private static final Plan retrieveLazyPlan$lambda$0(Lazy<Plan> $plan$delegate) {
        Lazy<Plan> lazy = $plan$delegate;
        return (Plan)lazy.getValue();
    }

    public static final /* synthetic */ DiscoveryService access$getDiscoveryService$p(CustomersProcessorDataRetriever $this) {
        return $this.discoveryService;
    }
}

