/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.customers;

import com.atlassian.jira.migration.analytics.MetricsEventService;
import com.atlassian.jira.migration.analytics.errordispatcher.ExportErrorDto;
import com.atlassian.jira.migration.analytics.errordispatcher.ExportErrorRepository;
import com.atlassian.jira.migration.events.CustomersUploadFailed;
import com.atlassian.jira.migration.events.CustomersUploadStarted;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.tracking.tasks.Task;
import java.time.Instant;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000fJ\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/jira/migration/workers/customers/CustomersProcessorMetricsService;", "", "metricsEventService", "Lcom/atlassian/jira/migration/analytics/MetricsEventService;", "exportErrorRepository", "Lcom/atlassian/jira/migration/analytics/errordispatcher/ExportErrorRepository;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "(Lcom/atlassian/jira/migration/analytics/MetricsEventService;Lcom/atlassian/jira/migration/analytics/errordispatcher/ExportErrorRepository;Lcom/atlassian/jira/migration/events/MigrationEventBus;)V", "postFailedEvent", "", "task", "Lcom/atlassian/jira/migration/tracking/tasks/Task;", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "postStartEvent", "sendFailedEvent", "sendSuccessfulEvent", "storeStackTrace", "Companion", "jira-migration-plugin"})
public final class CustomersProcessorMetricsService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MetricsEventService metricsEventService;
    @NotNull
    private final ExportErrorRepository exportErrorRepository;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private static final String SUCCESS = "Success";
    @NotNull
    private static final String FAILED = "Failed";

    @Inject
    public CustomersProcessorMetricsService(@NotNull MetricsEventService metricsEventService, @NotNull ExportErrorRepository exportErrorRepository, @NotNull MigrationEventBus migrationEventBus) {
        Intrinsics.checkNotNullParameter((Object)metricsEventService, (String)"metricsEventService");
        Intrinsics.checkNotNullParameter((Object)exportErrorRepository, (String)"exportErrorRepository");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        this.metricsEventService = metricsEventService;
        this.exportErrorRepository = exportErrorRepository;
        this.migrationEventBus = migrationEventBus;
    }

    public final void sendSuccessfulEvent(@NotNull Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        MetricsEventService.sendEventForTask$default(this.metricsEventService, task.getMigrationTask().getMigrationTaskType(), SUCCESS, 0.0, 4, null);
    }

    public final void sendFailedEvent(@NotNull Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        MetricsEventService.sendEventForTask$default(this.metricsEventService, task.getMigrationTask().getMigrationTaskType(), FAILED, 0.0, 4, null);
    }

    public final void storeStackTrace(@NotNull Task task, @NotNull Exception ex) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        this.exportErrorRepository.save(new ExportErrorDto(Instant.now().toEpochMilli(), task.getCloudId(), task.getMigrationId(), null, StringsKt.substringBefore((String)task.getTaskId(), (String)"#", (String)"unknown_Task"), ExceptionsKt.stackTraceToString((Throwable)ex), 8, null));
    }

    public final void postStartEvent(@NotNull Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.migrationEventBus.post(new CustomersUploadStarted(task.getCloudId(), task.getMigrationId()));
    }

    public final void postFailedEvent(@NotNull Task task, @NotNull Exception ex) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        this.migrationEventBus.post(new CustomersUploadFailed(task.getCloudId(), task.getMigrationId(), ex.getMessage()));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/workers/customers/CustomersProcessorMetricsService$Companion;", "", "()V", "FAILED", "", "SUCCESS", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

