/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.customers;

import com.atlassian.jira.migration.common.LocalFileDataOutput;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.email.FixAllEmailsResult;
import com.atlassian.jira.migration.email.UserEmailFixer;
import com.atlassian.jira.migration.serverdataextractors.usergroup.Customer;
import com.atlassian.jira.migration.serverdataextractors.usergroup.ExportUpdate;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUser;
import com.atlassian.jira.migration.tracking.tasks.Task;
import com.atlassian.jira.migration.utils.FileUtil;
import com.atlassian.jira.migration.workers.customers.CustomerExtractor;
import com.atlassian.jira.migration.workers.customers.CustomersProcessorDataRetriever;
import com.atlassian.jira.migration.workers.customers.CustomersProcessorMetricsService;
import com.atlassian.jira.timezone.TimeZoneInfo;
import com.atlassian.jira.user.ApplicationUser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 ,2\u00020\u0001:\u0001,B7\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017J2\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00120\u001eH\u0002J2\u0010 \u001a\u0002H!\"\u0004\b\u0000\u0010!2\u0006\u0010\u0013\u001a\u00020\"2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H!0$H\u0082\b\u00a2\u0006\u0002\u0010%J0\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u00192\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00120\u001eJ2\u0010(\u001a\b\u0012\u0004\u0012\u00020'0\u00192\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00120\u001eH\u0002J\u0016\u0010)\u001a\u00020\u00122\f\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u0019H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/atlassian/jira/migration/workers/customers/CustomersProcessorService;", "", "customersProcessorMetricsService", "Lcom/atlassian/jira/migration/workers/customers/CustomersProcessorMetricsService;", "customersProcessorDataRetriever", "Lcom/atlassian/jira/migration/workers/customers/CustomersProcessorDataRetriever;", "userEmailFixer", "Lcom/atlassian/jira/migration/email/UserEmailFixer;", "customerExtractor", "Lcom/atlassian/jira/migration/workers/customers/CustomerExtractor;", "localFileDataOutput", "Lcom/atlassian/jira/migration/common/LocalFileDataOutput;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "(Lcom/atlassian/jira/migration/workers/customers/CustomersProcessorMetricsService;Lcom/atlassian/jira/migration/workers/customers/CustomersProcessorDataRetriever;Lcom/atlassian/jira/migration/email/UserEmailFixer;Lcom/atlassian/jira/migration/workers/customers/CustomerExtractor;Lcom/atlassian/jira/migration/common/LocalFileDataOutput;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "checkEnabledTraceStoring", "", "task", "Lcom/atlassian/jira/migration/tracking/tasks/Task;", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "extractUsers", "", "Lcom/atlassian/jira/user/ApplicationUser;", "log", "Lorg/slf4j/Logger;", "onProgressUpdate", "Lkotlin/Function1;", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/ExportUpdate;", "loggingTime", "T", "", "block", "Lkotlin/Function0;", "(Ljava/lang/String;Lorg/slf4j/Logger;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "processCustomers", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/Customer;", "processUsersWithGlobalEmailFixes", "saveCustomersBeforeEmailFixes", "allCustomersBeforeEmailFixes", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUser;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nCustomersProcessorService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomersProcessorService.kt\ncom/atlassian/jira/migration/workers/customers/CustomersProcessorService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,97:1\n81#1,4:140\n1549#2:98\n1620#2,3:99\n1477#2:102\n1502#2,3:103\n1505#2,3:113\n1238#2,4:118\n1549#2:122\n1620#2,3:123\n3190#2,10:126\n1549#2:136\n1620#2,3:137\n372#3,7:106\n453#3:116\n403#3:117\n*S KotlinDebug\n*F\n+ 1 CustomersProcessorService.kt\ncom/atlassian/jira/migration/workers/customers/CustomersProcessorService\n*L\n69#1:140,4\n40#1:98\n40#1:99,3\n50#1:102\n50#1:103,3\n50#1:113,3\n50#1:118,4\n52#1:122\n52#1:123,3\n59#1:126,10\n59#1:136\n59#1:137,3\n50#1:106,7\n50#1:116\n50#1:117\n*E\n"})
public final class CustomersProcessorService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CustomersProcessorMetricsService customersProcessorMetricsService;
    @NotNull
    private final CustomersProcessorDataRetriever customersProcessorDataRetriever;
    @NotNull
    private final UserEmailFixer userEmailFixer;
    @NotNull
    private final CustomerExtractor customerExtractor;
    @NotNull
    private final LocalFileDataOutput localFileDataOutput;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    public static final String CUSTOMERS_EXPORT_BEFORE_EMAIL_FIXES_FILE_NAME = "customers-export-before-email-fixes-only-for-troubleshooting.json";

    @Inject
    public CustomersProcessorService(@NotNull CustomersProcessorMetricsService customersProcessorMetricsService, @NotNull CustomersProcessorDataRetriever customersProcessorDataRetriever, @NotNull UserEmailFixer userEmailFixer, @NotNull CustomerExtractor customerExtractor, @NotNull LocalFileDataOutput localFileDataOutput, @NotNull ObjectMapperFactory objectMapperFactory) {
        Intrinsics.checkNotNullParameter((Object)customersProcessorMetricsService, (String)"customersProcessorMetricsService");
        Intrinsics.checkNotNullParameter((Object)customersProcessorDataRetriever, (String)"customersProcessorDataRetriever");
        Intrinsics.checkNotNullParameter((Object)userEmailFixer, (String)"userEmailFixer");
        Intrinsics.checkNotNullParameter((Object)customerExtractor, (String)"customerExtractor");
        Intrinsics.checkNotNullParameter((Object)((Object)localFileDataOutput), (String)"localFileDataOutput");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        this.customersProcessorMetricsService = customersProcessorMetricsService;
        this.customersProcessorDataRetriever = customersProcessorDataRetriever;
        this.userEmailFixer = userEmailFixer;
        this.customerExtractor = customerExtractor;
        this.localFileDataOutput = localFileDataOutput;
        this.objectMapper = objectMapperFactory.createObjectMapper();
    }

    @NotNull
    public final List<Customer> processCustomers(@NotNull Task task, @NotNull Logger log2, @NotNull Function1<? super ExportUpdate, Unit> onProgressUpdate2) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)log2, (String)"log");
        Intrinsics.checkNotNullParameter(onProgressUpdate2, (String)"onProgressUpdate");
        return this.processUsersWithGlobalEmailFixes(task, log2, onProgressUpdate2);
    }

    public final void checkEnabledTraceStoring(@NotNull Task task, @NotNull Exception ex) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        this.customersProcessorMetricsService.storeStackTrace(task, ex);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Customer> processUsersWithGlobalEmailFixes(Task task, Logger log2, Function1<? super ExportUpdate, Unit> onProgressUpdate2) {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object value$iv$iv$iv;
        Map $this$getOrPut$iv$iv$iv;
        Object key$iv$iv;
        void $this$groupByTo$iv$iv;
        Object object;
        void $this$mapTo$iv$iv3;
        List<ApplicationUser> applicationUsers = this.extractUsers(task, log2, onProgressUpdate2);
        Iterable $this$map$iv = applicationUsers;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it;
            ApplicationUser applicationUser = (ApplicationUser)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(JiraUser.Companion.fromApplicationUser((ApplicationUser)it));
        }
        List jiraUsers = (List)destination$iv$iv;
        log2.info("JSM customers found before applying Global Email Fixes: " + jiraUsers.size() + " .");
        if (!((Collection)jiraUsers).isEmpty()) {
            this.saveCustomersBeforeEmailFixes(jiraUsers);
        }
        FixAllEmailsResult inMemoryFix = this.userEmailFixer.safelyFixAllCustomerEmailInMemory(jiraUsers, this.customersProcessorDataRetriever.logMigrationScopeId(task, log2), task.getCloudSite().getContainerToken());
        List customersToUpload = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)inMemoryFix.getValid(), (Iterable)inMemoryFix.getNewMail()), (Iterable)inMemoryFix.getMerge());
        Object $this$groupBy$iv = applicationUsers;
        boolean $i$f$groupBy = false;
        Object object2 = $this$groupBy$iv;
        Object destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object3;
            ApplicationUser p0 = (ApplicationUser)element$iv$iv;
            boolean bl = false;
            key$iv$iv = p0.getUsername();
            $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object3 = answer$iv$iv$iv;
            } else {
                object3 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object3;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv2;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean bl = false;
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object = $this$getOrPut$iv$iv$iv;
            boolean bl3 = false;
            ApplicationUser applicationUser = (ApplicationUser)CollectionsKt.first((List)((List)it.getValue()));
            object.put(k, applicationUser);
        }
        Map applicationUsersMap = destination$iv$iv2;
        Iterable $this$map$iv2 = customersToUpload;
        boolean $i$f$map2 = false;
        destination$iv$iv2 = $this$map$iv2;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            JiraUser element$iv$iv$iv = (JiraUser)item$iv$iv;
            object = destination$iv$iv3;
            boolean bl = false;
            ApplicationUser applicationUser = (ApplicationUser)applicationUsersMap.get(it.getUserName());
            Locale localeOfUser = this.customersProcessorDataRetriever.localeOfUser(applicationUser);
            TimeZoneInfo timeZoneOfUser = this.customersProcessorDataRetriever.timeZoneOfUser(applicationUser);
            object.add(new Customer((JiraUser)it, localeOfUser.toLanguageTag(), timeZoneOfUser.getTimeZoneId()));
        }
        List correctedCustomers = (List)destination$iv$iv3;
        Iterable $this$partition$iv = correctedCustomers;
        boolean $i$f$partition = false;
        Iterable<Object> first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            Customer it = (Customer)element$iv;
            boolean bl = false;
            if (it.getActive()) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Iterable $this$map$iv3 = TuplesKt.toList((Pair)new Pair(first$iv, second$iv));
        boolean $i$f$map3 = false;
        first$iv = $this$map$iv3;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            List bl = (List)item$iv$iv;
            object = destination$iv$iv4;
            boolean bl4 = false;
            object.add(it.size());
        }
        List list = (List)destination$iv$iv4;
        int activeCustomersCount = ((Number)list.get(0)).intValue();
        int inactiveCustomersCount = ((Number)list.get(1)).intValue();
        log2.info(task.getMigrationId() + '-' + task.getTaskId() + ": " + correctedCustomers.size() + "  JSD customers after applying Global Email Fixes found: " + activeCustomersCount + " active, " + inactiveCustomersCount + " inactive");
        return correctedCustomers;
    }

    private final List<ApplicationUser> extractUsers(Task task, Logger log2, Function1<? super ExportUpdate, Unit> onProgressUpdate2) {
        CustomersProcessorService customersProcessorService = this;
        String task$iv = "extractAllUsers";
        boolean $i$f$loggingTime = false;
        long startTime$iv = System.nanoTime();
        boolean bl = false;
        return SequencesKt.toList((Sequence)SequencesKt.mapIndexed(this.customerExtractor.extract(task, onProgressUpdate2), (Function2)((Function2)new Function2<Integer, ApplicationUser, ApplicationUser>(onProgressUpdate2){
            final /* synthetic */ Function1<ExportUpdate, Unit> $onProgressUpdate;
            {
                this.$onProgressUpdate = $onProgressUpdate;
                super(2);
            }

            @NotNull
            public final ApplicationUser invoke(int index, @NotNull ApplicationUser applicationUser) {
                Intrinsics.checkNotNullParameter((Object)applicationUser, (String)"applicationUser");
                long currentCount = (long)index + 1L;
                this.$onProgressUpdate.invoke((Object)new ExportUpdate.CustomerExported(currentCount));
                return applicationUser;
            }
        })));
    }

    private final <T> T loggingTime(String task, Logger log2, Function0<? extends T> block) {
        Object object;
        boolean $i$f$loggingTime = false;
        long startTime = System.nanoTime();
        Object it = object = block.invoke();
        boolean bl = false;
        log2.debug(task + " took " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime));
        return (T)object;
    }

    private final void saveCustomersBeforeEmailFixes(List<JiraUser> allCustomersBeforeEmailFixes) {
        Path allCustomersFilePath = FileUtil.createNewFile$default((FileUtil)FileUtil.INSTANCE, (Path)this.localFileDataOutput.exportDirectory(), (String)CUSTOMERS_EXPORT_BEFORE_EMAIL_FIXES_FILE_NAME, (boolean)false, (int)4, null);
        File allCustomersFile = allCustomersFilePath.toFile();
        this.objectMapper.writeValue(allCustomersFile, allCustomersBeforeEmailFixes);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/workers/customers/CustomersProcessorService$Companion;", "", "()V", "CUSTOMERS_EXPORT_BEFORE_EMAIL_FIXES_FILE_NAME", "", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

