/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.customers;

import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.migration.MigrationProtocol;
import com.atlassian.jira.migration.orchestratorclient.tasks.CustomerTransferMigrationTask;
import com.atlassian.jira.migration.orchestratorclient.tasks.MigrationTask;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.platform.PlatformService;
import com.atlassian.jira.migration.platform.TransferStatus;
import com.atlassian.jira.migration.serverdataextractors.usergroup.ExportUpdate;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UserExportMismatchService;
import com.atlassian.jira.migration.shadow.db.CustomerExportFinalStatus;
import com.atlassian.jira.migration.shadow.db.MigrationFinalStatus;
import com.atlassian.jira.migration.shadow.db.MigrationFinalStatusRepository;
import com.atlassian.jira.migration.tracking.tasks.Task;
import com.atlassian.jira.migration.workers.PlatformHeartbeater;
import com.atlassian.jira.migration.workers.PlatformProgressUpdater;
import com.atlassian.jira.migration.workers.PlatformUtilKt;
import com.atlassian.jira.migration.workers.customers.AbstractCustomersProcessor;
import com.atlassian.jira.migration.workers.customers.AbstractPlatformCustomersProcessor;
import com.atlassian.jira.migration.workers.customers.CustomersProcessorDataRetriever;
import com.atlassian.jira.migration.workers.customers.CustomersProcessorMetricsService;
import com.atlassian.jira.migration.workers.customers.CustomersProcessorService;
import com.atlassian.migration.api.MigrationId;
import com.atlassian.migration.api.TransferId;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\b\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020$H\u0016J\b\u0010.\u001a\u00020$H\u0016J\u0010\u0010/\u001a\u00020$2\u0006\u0010\u001f\u001a\u000200H\u0002J\u0012\u00101\u001a\u00020$2\b\u00102\u001a\u0004\u0018\u000100H\u0016J\u0006\u00103\u001a\u00020$R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$0\"X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/atlassian/jira/migration/workers/customers/V3CustomersProcessor;", "Lcom/atlassian/jira/migration/workers/customers/AbstractPlatformCustomersProcessor;", "platformService", "Lcom/atlassian/jira/migration/platform/PlatformService;", "customersProcessorDataRetriever", "Lcom/atlassian/jira/migration/workers/customers/CustomersProcessorDataRetriever;", "customersProcessorMetricsService", "Lcom/atlassian/jira/migration/workers/customers/CustomersProcessorMetricsService;", "task", "Lcom/atlassian/jira/migration/tracking/tasks/Task;", "customersProcessorService", "Lcom/atlassian/jira/migration/workers/customers/CustomersProcessorService;", "userExportMismatchService", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UserExportMismatchService;", "migrationFinalStatusRepository", "Lcom/atlassian/jira/migration/shadow/db/MigrationFinalStatusRepository;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "heartbeatScheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "(Lcom/atlassian/jira/migration/platform/PlatformService;Lcom/atlassian/jira/migration/workers/customers/CustomersProcessorDataRetriever;Lcom/atlassian/jira/migration/workers/customers/CustomersProcessorMetricsService;Lcom/atlassian/jira/migration/tracking/tasks/Task;Lcom/atlassian/jira/migration/workers/customers/CustomersProcessorService;Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UserExportMismatchService;Lcom/atlassian/jira/migration/shadow/db/MigrationFinalStatusRepository;Lcom/atlassian/jira/migration/discovery/DiscoveryService;Lcom/atlassian/jira/migration/features/MigrationFeatures;Ljava/util/concurrent/ScheduledExecutorService;)V", "customersTask", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/CustomerTransferMigrationTask;", "heartbeater", "Lcom/atlassian/jira/migration/workers/PlatformHeartbeater;", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "migrationId", "Lcom/atlassian/migration/api/MigrationId;", "onProgressUpdate", "Lkotlin/Function1;", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/ExportUpdate;", "", "getOnProgressUpdate", "()Lkotlin/jvm/functions/Function1;", "progressUpdater", "Lcom/atlassian/jira/migration/workers/PlatformProgressUpdater;", "transferId", "Lcom/atlassian/migration/api/TransferId;", "getHeartbeatFrequency", "", "process", "sendFinalStatus", "sendFinalStatusForShadowMigration", "", "sendHeartbeat", "msg", "setHeartbeatScheduler", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nV3CustomersWorker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 V3CustomersWorker.kt\ncom/atlassian/jira/migration/workers/customers/V3CustomersProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,188:1\n1#2:189\n*E\n"})
public final class V3CustomersProcessor
extends AbstractPlatformCustomersProcessor {
    @NotNull
    private final PlatformService platformService;
    @NotNull
    private final Task task;
    @NotNull
    private final CustomersProcessorService customersProcessorService;
    @NotNull
    private final UserExportMismatchService userExportMismatchService;
    @NotNull
    private final MigrationFinalStatusRepository migrationFinalStatusRepository;
    @NotNull
    private final DiscoveryService discoveryService;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final ScheduledExecutorService heartbeatScheduler;
    @NotNull
    private final Logger log;
    @NotNull
    private final CustomerTransferMigrationTask customersTask;
    @NotNull
    private final MigrationId migrationId;
    @NotNull
    private final TransferId transferId;
    @NotNull
    private final PlatformHeartbeater heartbeater;
    @NotNull
    private final PlatformProgressUpdater progressUpdater;
    @NotNull
    private final Function1<ExportUpdate, Unit> onProgressUpdate;

    public V3CustomersProcessor(@NotNull PlatformService platformService, @NotNull CustomersProcessorDataRetriever customersProcessorDataRetriever, @NotNull CustomersProcessorMetricsService customersProcessorMetricsService, @NotNull Task task, @NotNull CustomersProcessorService customersProcessorService, @NotNull UserExportMismatchService userExportMismatchService, @NotNull MigrationFinalStatusRepository migrationFinalStatusRepository, @NotNull DiscoveryService discoveryService, @NotNull MigrationFeatures migrationFeatures, @NotNull ScheduledExecutorService heartbeatScheduler) {
        Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
        Intrinsics.checkNotNullParameter((Object)customersProcessorDataRetriever, (String)"customersProcessorDataRetriever");
        Intrinsics.checkNotNullParameter((Object)customersProcessorMetricsService, (String)"customersProcessorMetricsService");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)customersProcessorService, (String)"customersProcessorService");
        Intrinsics.checkNotNullParameter((Object)userExportMismatchService, (String)"userExportMismatchService");
        Intrinsics.checkNotNullParameter((Object)migrationFinalStatusRepository, (String)"migrationFinalStatusRepository");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)heartbeatScheduler, (String)"heartbeatScheduler");
        super(platformService, customersProcessorDataRetriever, customersProcessorMetricsService, task, customersProcessorService, userExportMismatchService);
        this.platformService = platformService;
        this.task = task;
        this.customersProcessorService = customersProcessorService;
        this.userExportMismatchService = userExportMismatchService;
        this.migrationFinalStatusRepository = migrationFinalStatusRepository;
        this.discoveryService = discoveryService;
        this.migrationFeatures = migrationFeatures;
        this.heartbeatScheduler = heartbeatScheduler;
        Logger logger2 = LoggerFactory.getLogger(V3CustomersProcessor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        this.log = logger2;
        MigrationTask migrationTask = this.task.getMigrationTask();
        Intrinsics.checkNotNull((Object)migrationTask, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.orchestratorclient.tasks.CustomerTransferMigrationTask");
        this.customersTask = (CustomerTransferMigrationTask)migrationTask;
        this.migrationId = new MigrationId(this.task.getMigrationId());
        this.transferId = new TransferId(this.customersTask.getTransferId());
        this.heartbeater = new PlatformHeartbeater(this.platformService, this.getContainerToken(), this.customersTask.getHeartbeatUrl(), null, null, 24, null);
        this.progressUpdater = new PlatformProgressUpdater(this.platformService, this.migrationId, this.transferId, this.getContainerToken(), null, null, 48, null);
        this.onProgressUpdate = (Function1)new Function1<ExportUpdate, Unit>(this){
            final /* synthetic */ V3CustomersProcessor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ExportUpdate update) {
                Intrinsics.checkNotNullParameter((Object)update, (String)"update");
                AbstractCustomersProcessor.sendHeartbeat$default(this.this$0, null, 1, null);
                if (update instanceof ExportUpdate.CustomerExported) {
                    PlatformProgressUpdater.sendProgressUpdate$default(V3CustomersProcessor.access$getProgressUpdater$p(this.this$0), null, null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"customersExported", (Object)((ExportUpdate.CustomerExported)update).getSuccessfullyCompleted())), false, 11, null);
                }
            }
        };
    }

    @Override
    @NotNull
    public Logger getLog() {
        return this.log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        try {
            this.setHeartbeatScheduler();
            Plan plan2 = DiscoveryService.retrievePlanFor$default(this.discoveryService, this.task, false, 2, null);
            if (Intrinsics.areEqual((Object)plan2.isShadowPlan(), (Object)true)) {
                if (!(plan2.getOriginalMigrationId() != null)) {
                    boolean bl = false;
                    String string = "Shadow Plan should have an originalMigrationId";
                    throw new IllegalArgumentException(string.toString());
                }
                this.sendFinalStatusForShadowMigration(plan2.getOriginalMigrationId());
                return;
            }
            super.process();
        }
        catch (Exception ex) {
            this.getLog().warn(ex.getMessage());
            throw ex;
        }
        finally {
            this.heartbeatScheduler.shutdown();
        }
    }

    public final void setHeartbeatScheduler() {
        if (this.migrationFeatures.getEnableV3AsyncHeartbeat()) {
            this.heartbeatScheduler.scheduleAtFixedRate(PlatformUtilKt.createHeartbeatRunnable((Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ V3CustomersProcessor this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    AbstractCustomersProcessor.sendHeartbeat$default(this.this$0, null, 1, null);
                }
            }), this.task, MigrationProtocol.V3), 0L, this.getHeartbeatFrequency(), PlatformUtilKt.getHEARTBEAT_TIME_UNIT());
        }
    }

    @Override
    public long getHeartbeatFrequency() {
        return 10L;
    }

    private final void sendFinalStatusForShadowMigration(String migrationId) {
        MigrationFinalStatus migrationFinalStatus = MigrationFinalStatusRepository.getShadowMigrationMetadata$default(this.migrationFinalStatusRepository, migrationId, this.customersTask.getMigrationTaskType(), null, 4, null);
        if (migrationFinalStatus == null) {
            PlatformProgressUpdater.sendFinalStatus$default(this.progressUpdater, TransferStatus.FAILED, null, "No cached data for this migration", 2, null);
            return;
        }
        MigrationFinalStatus finalStatus = migrationFinalStatus;
        CustomerExportFinalStatus cfr_ignored_0 = (CustomerExportFinalStatus)finalStatus;
        Pair[] pairArray = this.progressUpdater;
        Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"customersExported", (Object)((CustomerExportFinalStatus)finalStatus).getCustomersExported()));
        PlatformProgressUpdater.sendProgressUpdate$default((PlatformProgressUpdater)pairArray, null, null, map, true, 3, null);
        pairArray = new Pair[]{TuplesKt.to((Object)"customersExport", (Object)((CustomerExportFinalStatus)finalStatus).getDataExportFile()), TuplesKt.to((Object)"customersExported", (Object)((CustomerExportFinalStatus)finalStatus).getCustomersExported())};
        PlatformProgressUpdater.sendFinalStatus$default(this.progressUpdater, TransferStatus.SUCCESS, MapsKt.mapOf((Pair[])pairArray), null, 4, null);
    }

    @Override
    @NotNull
    public Function1<ExportUpdate, Unit> getOnProgressUpdate() {
        return this.onProgressUpdate;
    }

    @Override
    public void sendHeartbeat(@Nullable String msg) {
        this.heartbeater.sendHeartbeat();
    }

    @Override
    public void sendFinalStatus() {
        long customersExported = this.progressUpdater.getProgressEntityCount("customersExported");
        Pair[] pairArray = this.progressUpdater;
        Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"customersExported", (Object)customersExported));
        PlatformProgressUpdater.sendProgressUpdate$default((PlatformProgressUpdater)pairArray, null, null, map, true, 3, null);
        String string = ((UUID)this.migrationId.getValue()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        MigrationFinalStatusRepository.create$default(this.migrationFinalStatusRepository, string, new CustomerExportFinalStatus(this.getCustomersFile().getFileId(), customersExported), null, 4, null);
        pairArray = new Pair[]{TuplesKt.to((Object)"customersExport", (Object)this.getCustomersFile().getFileId()), TuplesKt.to((Object)"customersExported", (Object)customersExported)};
        PlatformProgressUpdater.sendFinalStatus$default(this.progressUpdater, TransferStatus.SUCCESS, MapsKt.mapOf((Pair[])pairArray), null, 4, null);
    }

    public static final /* synthetic */ PlatformProgressUpdater access$getProgressUpdater$p(V3CustomersProcessor $this) {
        return $this.progressUpdater;
    }
}

