/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.customers;

import com.atlassian.jira.migration.GroupedThreadFactory;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.migration.MigrationProtocol;
import com.atlassian.jira.migration.orchestratorclient.tasks.MigrationTaskType;
import com.atlassian.jira.migration.orchestratorclient.tasks.ProgressUnit;
import com.atlassian.jira.migration.platform.PlatformService;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UserExportMismatchService;
import com.atlassian.jira.migration.shadow.db.MigrationFinalStatusRepository;
import com.atlassian.jira.migration.tracking.tasks.Task;
import com.atlassian.jira.migration.tracking.tasks.Worker;
import com.atlassian.jira.migration.workers.customers.CustomersProcessorDataRetriever;
import com.atlassian.jira.migration.workers.customers.CustomersProcessorMetricsService;
import com.atlassian.jira.migration.workers.customers.CustomersProcessorService;
import com.atlassian.jira.migration.workers.customers.V3CustomersProcessor;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001BG\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/atlassian/jira/migration/workers/customers/V3CustomersWorker;", "Lcom/atlassian/jira/migration/tracking/tasks/Worker;", "platformService", "Lcom/atlassian/jira/migration/platform/PlatformService;", "customersProcessorService", "Lcom/atlassian/jira/migration/workers/customers/CustomersProcessorService;", "customersProcessorDataRetriever", "Lcom/atlassian/jira/migration/workers/customers/CustomersProcessorDataRetriever;", "customersProcessorMetricsService", "Lcom/atlassian/jira/migration/workers/customers/CustomersProcessorMetricsService;", "userExportMismatchService", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UserExportMismatchService;", "migrationFinalStatusRepository", "Lcom/atlassian/jira/migration/shadow/db/MigrationFinalStatusRepository;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/platform/PlatformService;Lcom/atlassian/jira/migration/workers/customers/CustomersProcessorService;Lcom/atlassian/jira/migration/workers/customers/CustomersProcessorDataRetriever;Lcom/atlassian/jira/migration/workers/customers/CustomersProcessorMetricsService;Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UserExportMismatchService;Lcom/atlassian/jira/migration/shadow/db/MigrationFinalStatusRepository;Lcom/atlassian/jira/migration/discovery/DiscoveryService;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "id", "", "getId", "()Ljava/lang/String;", "migrationProtocol", "Lcom/atlassian/jira/migration/migration/MigrationProtocol;", "getMigrationProtocol", "()Lcom/atlassian/jira/migration/migration/MigrationProtocol;", "supportedUnits", "", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/ProgressUnit;", "getSupportedUnits", "()Ljava/util/List;", "taskType", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/MigrationTaskType;", "getTaskType", "()Lcom/atlassian/jira/migration/orchestratorclient/tasks/MigrationTaskType;", "process", "", "task", "Lcom/atlassian/jira/migration/tracking/tasks/Task;", "jira-migration-plugin"})
public final class V3CustomersWorker
implements Worker {
    @NotNull
    private final PlatformService platformService;
    @NotNull
    private final CustomersProcessorService customersProcessorService;
    @NotNull
    private final CustomersProcessorDataRetriever customersProcessorDataRetriever;
    @NotNull
    private final CustomersProcessorMetricsService customersProcessorMetricsService;
    @NotNull
    private final UserExportMismatchService userExportMismatchService;
    @NotNull
    private final MigrationFinalStatusRepository migrationFinalStatusRepository;
    @NotNull
    private final DiscoveryService discoveryService;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final String id;
    @NotNull
    private final List<ProgressUnit> supportedUnits;
    @NotNull
    private final MigrationTaskType taskType;
    @NotNull
    private final MigrationProtocol migrationProtocol;

    @Inject
    public V3CustomersWorker(@NotNull PlatformService platformService, @NotNull CustomersProcessorService customersProcessorService, @NotNull CustomersProcessorDataRetriever customersProcessorDataRetriever, @NotNull CustomersProcessorMetricsService customersProcessorMetricsService, @NotNull UserExportMismatchService userExportMismatchService, @NotNull MigrationFinalStatusRepository migrationFinalStatusRepository, @NotNull DiscoveryService discoveryService, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
        Intrinsics.checkNotNullParameter((Object)customersProcessorService, (String)"customersProcessorService");
        Intrinsics.checkNotNullParameter((Object)customersProcessorDataRetriever, (String)"customersProcessorDataRetriever");
        Intrinsics.checkNotNullParameter((Object)customersProcessorMetricsService, (String)"customersProcessorMetricsService");
        Intrinsics.checkNotNullParameter((Object)userExportMismatchService, (String)"userExportMismatchService");
        Intrinsics.checkNotNullParameter((Object)migrationFinalStatusRepository, (String)"migrationFinalStatusRepository");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.platformService = platformService;
        this.customersProcessorService = customersProcessorService;
        this.customersProcessorDataRetriever = customersProcessorDataRetriever;
        this.customersProcessorMetricsService = customersProcessorMetricsService;
        this.userExportMismatchService = userExportMismatchService;
        this.migrationFinalStatusRepository = migrationFinalStatusRepository;
        this.discoveryService = discoveryService;
        this.migrationFeatures = migrationFeatures;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.id = string;
        this.supportedUnits = CollectionsKt.listOf((Object)((Object)ProgressUnit.CUSTOMER));
        this.taskType = MigrationTaskType.ALL_CUSTOMER_UPLOAD;
        this.migrationProtocol = MigrationProtocol.V3;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public List<ProgressUnit> getSupportedUnits() {
        return this.supportedUnits;
    }

    @Override
    @NotNull
    public MigrationTaskType getTaskType() {
        return this.taskType;
    }

    @Override
    @NotNull
    public MigrationProtocol getMigrationProtocol() {
        return this.migrationProtocol;
    }

    @Override
    public void process(@NotNull Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new GroupedThreadFactory("V3CustomersWorker"));
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"newSingleThreadScheduledExecutor(...)");
        new V3CustomersProcessor(this.platformService, this.customersProcessorDataRetriever, this.customersProcessorMetricsService, task, this.customersProcessorService, this.userExportMismatchService, this.migrationFinalStatusRepository, this.discoveryService, this.migrationFeatures, scheduledExecutorService).process();
    }
}

