/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.customers;

import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.migration.MigrationCommandService;
import com.atlassian.jira.migration.migration.MigrationProtocol;
import com.atlassian.jira.migration.migrationservice.MigrationServiceClient;
import com.atlassian.jira.migration.migrationservice.shadow.AnonymiseMappingData;
import com.atlassian.jira.migration.migrationservice.shadow.AnonymiseMappingResponse;
import com.atlassian.jira.migration.orchestratorclient.tasks.MigrationTask;
import com.atlassian.jira.migration.orchestratorclient.tasks.V4CustomersMigrationTask;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.platform.PlatformService;
import com.atlassian.jira.migration.platform.TransferStatus;
import com.atlassian.jira.migration.prc.PrcStatusUpdateService;
import com.atlassian.jira.migration.prc.exception.CommandCancelledException;
import com.atlassian.jira.migration.scope.MigrationScopeManager;
import com.atlassian.jira.migration.serverdataextractors.usergroup.ExportUpdate;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UserExportMismatchService;
import com.atlassian.jira.migration.shadow.ShadowMigrationProtocol;
import com.atlassian.jira.migration.shadow.db.CustomerExportFinalStatus;
import com.atlassian.jira.migration.shadow.db.MigrationFinalStatus;
import com.atlassian.jira.migration.shadow.db.MigrationFinalStatusRepository;
import com.atlassian.jira.migration.tracking.polling.InProgressMigrationIds;
import com.atlassian.jira.migration.tracking.tasks.PrcTask;
import com.atlassian.jira.migration.workers.PlatformUtilKt;
import com.atlassian.jira.migration.workers.PrcProgressUpdater;
import com.atlassian.jira.migration.workers.customers.AbstractPlatformCustomersProcessor;
import com.atlassian.jira.migration.workers.customers.CustomersProcessorDataRetriever;
import com.atlassian.jira.migration.workers.customers.CustomersProcessorMetricsService;
import com.atlassian.jira.migration.workers.customers.CustomersProcessorService;
import com.atlassian.migration.api.MigrationId;
import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.PreDestroy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B}\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u0012\u0006\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\u0002\u0010 J\b\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u00020.H\u0016J\b\u00106\u001a\u00020.H\u0016J$\u00107\u001a\u00020.2\u0006\u00108\u001a\u0002092\b\u0010:\u001a\u0004\u0018\u00010;2\b\u0010<\u001a\u0004\u0018\u000109H\u0002J\u0012\u0010=\u001a\u00020.2\b\u0010>\u001a\u0004\u0018\u000109H\u0016J\b\u0010?\u001a\u00020.H\u0002J\b\u0010@\u001a\u00020.H\u0007R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\u00020$X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010+\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020.0,X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/atlassian/jira/migration/workers/customers/V4CustomersProcessor;", "Lcom/atlassian/jira/migration/workers/customers/AbstractPlatformCustomersProcessor;", "platformService", "Lcom/atlassian/jira/migration/platform/PlatformService;", "customersProcessorDataRetriever", "Lcom/atlassian/jira/migration/workers/customers/CustomersProcessorDataRetriever;", "customersProcessorMetricsService", "Lcom/atlassian/jira/migration/workers/customers/CustomersProcessorMetricsService;", "task", "Lcom/atlassian/jira/migration/tracking/tasks/PrcTask;", "customersProcessorService", "Lcom/atlassian/jira/migration/workers/customers/CustomersProcessorService;", "userExportMismatchService", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UserExportMismatchService;", "heartbeatScheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "prcStatusUpdateService", "Lcom/atlassian/jira/migration/prc/PrcStatusUpdateService;", "migrationFinalStatusRepository", "Lcom/atlassian/jira/migration/shadow/db/MigrationFinalStatusRepository;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "migrationProtocol", "Lcom/atlassian/jira/migration/migration/MigrationProtocol;", "migrationCommandService", "Lcom/atlassian/jira/migration/migration/MigrationCommandService;", "migrationIds", "Lcom/atlassian/jira/migration/tracking/polling/InProgressMigrationIds;", "migrationServiceClient", "Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient;", "migrationScopeManager", "Lcom/atlassian/jira/migration/scope/MigrationScopeManager;", "(Lcom/atlassian/jira/migration/platform/PlatformService;Lcom/atlassian/jira/migration/workers/customers/CustomersProcessorDataRetriever;Lcom/atlassian/jira/migration/workers/customers/CustomersProcessorMetricsService;Lcom/atlassian/jira/migration/tracking/tasks/PrcTask;Lcom/atlassian/jira/migration/workers/customers/CustomersProcessorService;Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UserExportMismatchService;Ljava/util/concurrent/ScheduledExecutorService;Lcom/atlassian/jira/migration/prc/PrcStatusUpdateService;Lcom/atlassian/jira/migration/shadow/db/MigrationFinalStatusRepository;Lcom/atlassian/jira/migration/discovery/DiscoveryService;Lcom/atlassian/jira/migration/migration/MigrationProtocol;Lcom/atlassian/jira/migration/migration/MigrationCommandService;Lcom/atlassian/jira/migration/tracking/polling/InProgressMigrationIds;Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient;Lcom/atlassian/jira/migration/scope/MigrationScopeManager;)V", "customersTask", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/V4CustomersMigrationTask;", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "migrationId", "Lcom/atlassian/migration/api/MigrationId;", "getMigrationScopeManager", "()Lcom/atlassian/jira/migration/scope/MigrationScopeManager;", "onProgressUpdate", "Lkotlin/Function1;", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/ExportUpdate;", "", "getOnProgressUpdate", "()Lkotlin/jvm/functions/Function1;", "progressUpdater", "Lcom/atlassian/jira/migration/workers/PrcProgressUpdater;", "getHeartbeatFrequency", "", "process", "sendFinalStatus", "sendFinalStatusForShadowMigration", "originalMigrationId", "", "shadowMigrationProtocol", "Lcom/atlassian/jira/migration/shadow/ShadowMigrationProtocol;", "cloudRegion", "sendHeartbeat", "msg", "setHeartbeatScheduler", "shutdown", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nV4CustomersProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 V4CustomersProcessor.kt\ncom/atlassian/jira/migration/workers/customers/V4CustomersProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,198:1\n1#2:199\n*E\n"})
public final class V4CustomersProcessor
extends AbstractPlatformCustomersProcessor {
    @NotNull
    private final PrcTask task;
    @NotNull
    private final ScheduledExecutorService heartbeatScheduler;
    @NotNull
    private final PrcStatusUpdateService prcStatusUpdateService;
    @NotNull
    private final MigrationFinalStatusRepository migrationFinalStatusRepository;
    @NotNull
    private final DiscoveryService discoveryService;
    @NotNull
    private final MigrationProtocol migrationProtocol;
    @NotNull
    private final MigrationCommandService migrationCommandService;
    @NotNull
    private final InProgressMigrationIds migrationIds;
    @NotNull
    private final MigrationServiceClient migrationServiceClient;
    @NotNull
    private final MigrationScopeManager migrationScopeManager;
    @NotNull
    private final Logger log;
    @NotNull
    private final MigrationId migrationId;
    @NotNull
    private final PrcProgressUpdater progressUpdater;
    @NotNull
    private final V4CustomersMigrationTask customersTask;
    @NotNull
    private final Function1<ExportUpdate, Unit> onProgressUpdate;

    public V4CustomersProcessor(@NotNull PlatformService platformService, @NotNull CustomersProcessorDataRetriever customersProcessorDataRetriever, @NotNull CustomersProcessorMetricsService customersProcessorMetricsService, @NotNull PrcTask task, @NotNull CustomersProcessorService customersProcessorService, @NotNull UserExportMismatchService userExportMismatchService, @NotNull ScheduledExecutorService heartbeatScheduler, @NotNull PrcStatusUpdateService prcStatusUpdateService, @NotNull MigrationFinalStatusRepository migrationFinalStatusRepository, @NotNull DiscoveryService discoveryService, @NotNull MigrationProtocol migrationProtocol, @NotNull MigrationCommandService migrationCommandService, @NotNull InProgressMigrationIds migrationIds, @NotNull MigrationServiceClient migrationServiceClient, @NotNull MigrationScopeManager migrationScopeManager) {
        Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
        Intrinsics.checkNotNullParameter((Object)customersProcessorDataRetriever, (String)"customersProcessorDataRetriever");
        Intrinsics.checkNotNullParameter((Object)customersProcessorMetricsService, (String)"customersProcessorMetricsService");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)customersProcessorService, (String)"customersProcessorService");
        Intrinsics.checkNotNullParameter((Object)userExportMismatchService, (String)"userExportMismatchService");
        Intrinsics.checkNotNullParameter((Object)heartbeatScheduler, (String)"heartbeatScheduler");
        Intrinsics.checkNotNullParameter((Object)prcStatusUpdateService, (String)"prcStatusUpdateService");
        Intrinsics.checkNotNullParameter((Object)migrationFinalStatusRepository, (String)"migrationFinalStatusRepository");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)((Object)migrationProtocol), (String)"migrationProtocol");
        Intrinsics.checkNotNullParameter((Object)migrationCommandService, (String)"migrationCommandService");
        Intrinsics.checkNotNullParameter((Object)migrationIds, (String)"migrationIds");
        Intrinsics.checkNotNullParameter((Object)migrationServiceClient, (String)"migrationServiceClient");
        Intrinsics.checkNotNullParameter((Object)migrationScopeManager, (String)"migrationScopeManager");
        super(platformService, customersProcessorDataRetriever, customersProcessorMetricsService, task, customersProcessorService, userExportMismatchService);
        this.task = task;
        this.heartbeatScheduler = heartbeatScheduler;
        this.prcStatusUpdateService = prcStatusUpdateService;
        this.migrationFinalStatusRepository = migrationFinalStatusRepository;
        this.discoveryService = discoveryService;
        this.migrationProtocol = migrationProtocol;
        this.migrationCommandService = migrationCommandService;
        this.migrationIds = migrationIds;
        this.migrationServiceClient = migrationServiceClient;
        this.migrationScopeManager = migrationScopeManager;
        Logger logger2 = LoggerFactory.getLogger(V4CustomersProcessor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        this.log = logger2;
        this.migrationId = new MigrationId(this.task.getMigrationId());
        this.progressUpdater = new PrcProgressUpdater(this.prcStatusUpdateService, this.migrationId, this.migrationCommandService, this.migrationIds, null, null, 48, null);
        MigrationTask migrationTask = this.task.getMigrationTask();
        Intrinsics.checkNotNull((Object)migrationTask, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.orchestratorclient.tasks.V4CustomersMigrationTask");
        this.customersTask = (V4CustomersMigrationTask)migrationTask;
        this.onProgressUpdate = (Function1)new Function1<ExportUpdate, Unit>(this){
            final /* synthetic */ V4CustomersProcessor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ExportUpdate update) {
                Intrinsics.checkNotNullParameter((Object)update, (String)"update");
                if (update instanceof ExportUpdate.CustomerExported) {
                    PrcProgressUpdater.sendProgressUpdate$default(V4CustomersProcessor.access$getProgressUpdater$p(this.this$0), null, null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"customersExported", (Object)((ExportUpdate.CustomerExported)update).getSuccessfullyCompleted())), false, V4CustomersProcessor.access$getTask$p(this.this$0), 11, null);
                }
            }
        };
    }

    @NotNull
    public final MigrationScopeManager getMigrationScopeManager() {
        return this.migrationScopeManager;
    }

    @Override
    @NotNull
    public Logger getLog() {
        return this.log;
    }

    @PreDestroy
    public final void shutdown() {
        this.heartbeatScheduler.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        try {
            this.setHeartbeatScheduler();
            this.getLog().info("Customer processing started " + this.task.getMigrationId() + "} prcCommandId: " + this.task.getPrcCommandId() + '}');
            Plan plan2 = DiscoveryService.retrievePlanFor$default(this.discoveryService, this.task, false, 2, null);
            if (Intrinsics.areEqual((Object)plan2.isShadowPlan(), (Object)true)) {
                if (!(plan2.getOriginalMigrationId() != null)) {
                    boolean bl = false;
                    String string = "Shadow Plan should have an originalMigrationId";
                    throw new IllegalArgumentException(string.toString());
                }
                this.sendFinalStatusForShadowMigration(plan2.getOriginalMigrationId(), plan2.getShadowMigrationProtocol(), plan2.getCloudRegion());
                return;
            }
            super.process();
        }
        catch (CommandCancelledException ex) {
            this.getLog().warn(ex.getMessage());
        }
        finally {
            this.heartbeatScheduler.shutdown();
        }
    }

    private final void setHeartbeatScheduler() {
        this.heartbeatScheduler.scheduleAtFixedRate(PlatformUtilKt.createHeartbeatRunnable((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ V4CustomersProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                V4CustomersProcessor.access$getPrcStatusUpdateService$p(this.this$0).sendHeartbeat(V4CustomersProcessor.access$getTask$p(this.this$0));
            }
        }), this.task, this.migrationProtocol), 0L, this.getHeartbeatFrequency(), PlatformUtilKt.getHEARTBEAT_TIME_UNIT());
    }

    @Override
    @NotNull
    public Function1<ExportUpdate, Unit> getOnProgressUpdate() {
        return this.onProgressUpdate;
    }

    @Override
    public void sendHeartbeat(@Nullable String msg) {
    }

    @Override
    public long getHeartbeatFrequency() {
        return 1L;
    }

    @Override
    public void sendFinalStatus() {
        long customersExported = this.progressUpdater.getProgressEntityCount("customersExported");
        Pair[] pairArray = this.progressUpdater;
        Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"customersExported", (Object)customersExported));
        PrcTask prcTask = this.task;
        PrcProgressUpdater.sendProgressUpdate$default((PrcProgressUpdater)pairArray, null, null, map, true, prcTask, 3, null);
        String string = ((UUID)this.migrationId.getValue()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        MigrationFinalStatusRepository.create$default(this.migrationFinalStatusRepository, string, new CustomerExportFinalStatus(this.getCustomersFile().getFileId(), customersExported), null, 4, null);
        pairArray = new Pair[]{TuplesKt.to((Object)"customersExport", (Object)this.getCustomersFile().getFileId()), TuplesKt.to((Object)"customersExported", (Object)customersExported)};
        PrcProgressUpdater.sendFinalStatus$default(this.progressUpdater, TransferStatus.SUCCESS, MapsKt.mapOf((Pair[])pairArray), null, this.task, 4, null);
    }

    private final void sendFinalStatusForShadowMigration(String originalMigrationId, ShadowMigrationProtocol shadowMigrationProtocol, String cloudRegion) {
        MigrationFinalStatus migrationFinalStatus = MigrationFinalStatusRepository.getShadowMigrationMetadata$default(this.migrationFinalStatusRepository, originalMigrationId, this.customersTask.getMigrationTaskType(), null, 4, null);
        if (migrationFinalStatus == null) {
            PrcProgressUpdater.sendFinalStatus$default(this.progressUpdater, TransferStatus.FAILED, null, "No cached data for this migration", this.task, 2, null);
            return;
        }
        MigrationFinalStatus finalStatus = migrationFinalStatus;
        CustomerExportFinalStatus cfr_ignored_0 = (CustomerExportFinalStatus)finalStatus;
        String customerExportFile = ((CustomerExportFinalStatus)finalStatus).getDataExportFile();
        String anonymisedCustomerMapping = "";
        if (shadowMigrationProtocol == ShadowMigrationProtocol.V4_WDCS) {
            CloudSite cloudSite2 = DiscoveryService.retrieveCloudSiteFor$default(this.discoveryService, originalMigrationId, false, 2, null);
            if (cloudSite2 == null) {
                PrcProgressUpdater.sendFinalStatus$default(this.progressUpdater, TransferStatus.FAILED, null, "No cloud site data retrieved for original migration", this.task, 2, null);
                return;
            }
            CloudSite originalCloudSite = cloudSite2;
            String string = ((UUID)this.migrationId.getValue()).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            CloudSite cloudSite3 = DiscoveryService.retrieveCloudSiteFor$default(this.discoveryService, string, false, 2, null);
            Intrinsics.checkNotNull((Object)cloudSite3);
            CloudSite shadowCloudSite = cloudSite3;
            String string2 = ((CustomerExportFinalStatus)finalStatus).getDataExportFile();
            Serializable serializable = this.getContainerToken().getValue();
            Intrinsics.checkNotNullExpressionValue((Object)serializable, (String)"getValue(...)");
            String string3 = (String)((Object)serializable);
            String string4 = ((UUID)this.migrationId.getValue()).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
            AnonymiseMappingResponse response2 = this.migrationServiceClient.anonymizeCustomerMappings(string2, string3, new AnonymiseMappingData(string4, this.migrationScopeManager.getMigrationScope(shadowCloudSite), originalMigrationId, this.migrationScopeManager.getMigrationScope(originalCloudSite), cloudRegion));
            String string5 = response2.getFileId();
            Intrinsics.checkNotNull((Object)string5);
            customerExportFile = string5;
            String string6 = response2.getPiiToAnonymisedPIIMappingFileId();
            Intrinsics.checkNotNull((Object)string6);
            anonymisedCustomerMapping = string6;
            this.getLog().info("anonymised mappings received " + customerExportFile + " for migrationId " + this.migrationId);
        }
        Pair[] pairArray = this.progressUpdater;
        Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"customersExported", (Object)((CustomerExportFinalStatus)finalStatus).getCustomersExported()));
        PrcTask prcTask = this.task;
        PrcProgressUpdater.sendProgressUpdate$default((PrcProgressUpdater)pairArray, null, null, map, true, prcTask, 3, null);
        pairArray = new Pair[]{TuplesKt.to((Object)"customersExport", (Object)customerExportFile), TuplesKt.to((Object)"customersExported", (Object)((CustomerExportFinalStatus)finalStatus).getCustomersExported()), TuplesKt.to((Object)"anonymisedMapping", (Object)anonymisedCustomerMapping)};
        PrcProgressUpdater.sendFinalStatus$default(this.progressUpdater, TransferStatus.SUCCESS, MapsKt.mapOf((Pair[])pairArray), null, this.task, 4, null);
    }

    public static final /* synthetic */ PrcStatusUpdateService access$getPrcStatusUpdateService$p(V4CustomersProcessor $this) {
        return $this.prcStatusUpdateService;
    }

    public static final /* synthetic */ PrcTask access$getTask$p(V4CustomersProcessor $this) {
        return $this.task;
    }

    public static final /* synthetic */ PrcProgressUpdater access$getProgressUpdater$p(V4CustomersProcessor $this) {
        return $this.progressUpdater;
    }
}

