/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.customers;

import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.migration.MigrationCommand;
import com.atlassian.jira.migration.migration.MigrationCommandService;
import com.atlassian.jira.migration.migration.MigrationProtocol;
import com.atlassian.jira.migration.migrationservice.MigrationServiceClient;
import com.atlassian.jira.migration.orchestratorclient.tasks.ProgressUnit;
import com.atlassian.jira.migration.platform.PlatformService;
import com.atlassian.jira.migration.prc.PrcCommandExecutor;
import com.atlassian.jira.migration.prc.PrcStatusUpdateService;
import com.atlassian.jira.migration.prc.model.CustomersGroupsMigrationPayload;
import com.atlassian.jira.migration.prc.model.PrcCommandPayload;
import com.atlassian.jira.migration.scope.MigrationScopeManager;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UserExportMismatchService;
import com.atlassian.jira.migration.shadow.db.MigrationFinalStatusRepository;
import com.atlassian.jira.migration.tracking.polling.InProgressMigrationIds;
import com.atlassian.jira.migration.tracking.tasks.PrcTask;
import com.atlassian.jira.migration.tracking.tasks.V4Worker;
import com.atlassian.jira.migration.utils.ScheduledExecutorFactory;
import com.atlassian.jira.migration.workers.WorkerDataConvertor;
import com.atlassian.jira.migration.workers.customers.CustomersProcessorDataRetriever;
import com.atlassian.jira.migration.workers.customers.CustomersProcessorMetricsService;
import com.atlassian.jira.migration.workers.customers.CustomersProcessorService;
import com.atlassian.jira.migration.workers.customers.V4CustomersProcessor;
import com.atlassian.migration.prc.model.CommandName;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002Bw\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\u0006\u0010\u0019\u001a\u00020\u001a\u0012\u0006\u0010\u001b\u001a\u00020\u001c\u0012\u0006\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\u0002\u0010\u001fJ\u0018\u00108\u001a\u0002092\u0006\u0010:\u001a\u0002002\u0006\u0010;\u001a\u00020<H\u0016J\u0010\u0010=\u001a\u0002092\u0006\u0010>\u001a\u00020?H\u0016R\u0014\u0010 \u001a\u00020!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\u00020%X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\u00020)X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010.\u001a\n\u0012\u0006\b\u0001\u0012\u0002000/X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00103\u001a\b\u0012\u0004\u0012\u00020504X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/atlassian/jira/migration/workers/customers/V4CustomersWorker;", "Lcom/atlassian/jira/migration/tracking/tasks/V4Worker;", "Lcom/atlassian/jira/migration/prc/PrcCommandExecutor;", "platformService", "Lcom/atlassian/jira/migration/platform/PlatformService;", "customersProcessorService", "Lcom/atlassian/jira/migration/workers/customers/CustomersProcessorService;", "customersProcessorDataRetriever", "Lcom/atlassian/jira/migration/workers/customers/CustomersProcessorDataRetriever;", "customersProcessorMetricsService", "Lcom/atlassian/jira/migration/workers/customers/CustomersProcessorMetricsService;", "userExportMismatchService", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UserExportMismatchService;", "prcStatusUpdateService", "Lcom/atlassian/jira/migration/prc/PrcStatusUpdateService;", "migrationFinalStatusRepository", "Lcom/atlassian/jira/migration/shadow/db/MigrationFinalStatusRepository;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "migrationCommandService", "Lcom/atlassian/jira/migration/migration/MigrationCommandService;", "migrationIds", "Lcom/atlassian/jira/migration/tracking/polling/InProgressMigrationIds;", "scheduledExecutorFactory", "Lcom/atlassian/jira/migration/utils/ScheduledExecutorFactory;", "migrationServiceClient", "Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient;", "workerDataConvertor", "Lcom/atlassian/jira/migration/workers/WorkerDataConvertor;", "migrationScopeManager", "Lcom/atlassian/jira/migration/scope/MigrationScopeManager;", "(Lcom/atlassian/jira/migration/platform/PlatformService;Lcom/atlassian/jira/migration/workers/customers/CustomersProcessorService;Lcom/atlassian/jira/migration/workers/customers/CustomersProcessorDataRetriever;Lcom/atlassian/jira/migration/workers/customers/CustomersProcessorMetricsService;Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UserExportMismatchService;Lcom/atlassian/jira/migration/prc/PrcStatusUpdateService;Lcom/atlassian/jira/migration/shadow/db/MigrationFinalStatusRepository;Lcom/atlassian/jira/migration/discovery/DiscoveryService;Lcom/atlassian/jira/migration/migration/MigrationCommandService;Lcom/atlassian/jira/migration/tracking/polling/InProgressMigrationIds;Lcom/atlassian/jira/migration/utils/ScheduledExecutorFactory;Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient;Lcom/atlassian/jira/migration/workers/WorkerDataConvertor;Lcom/atlassian/jira/migration/scope/MigrationScopeManager;)V", "commandName", "Lcom/atlassian/migration/prc/model/CommandName;", "getCommandName", "()Lcom/atlassian/migration/prc/model/CommandName;", "id", "", "getId", "()Ljava/lang/String;", "migrationProtocol", "Lcom/atlassian/jira/migration/migration/MigrationProtocol;", "getMigrationProtocol", "()Lcom/atlassian/jira/migration/migration/MigrationProtocol;", "getMigrationScopeManager", "()Lcom/atlassian/jira/migration/scope/MigrationScopeManager;", "payloadClassType", "Lkotlin/reflect/KClass;", "Lcom/atlassian/jira/migration/prc/model/PrcCommandPayload;", "getPayloadClassType", "()Lkotlin/reflect/KClass;", "supportedUnits", "", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/ProgressUnit;", "getSupportedUnits", "()Ljava/util/List;", "executeTask", "", "commandPayload", "prcCommandId", "", "process", "task", "Lcom/atlassian/jira/migration/tracking/tasks/PrcTask;", "jira-migration-plugin"})
public final class V4CustomersWorker
implements V4Worker,
PrcCommandExecutor {
    @NotNull
    private final PlatformService platformService;
    @NotNull
    private final CustomersProcessorService customersProcessorService;
    @NotNull
    private final CustomersProcessorDataRetriever customersProcessorDataRetriever;
    @NotNull
    private final CustomersProcessorMetricsService customersProcessorMetricsService;
    @NotNull
    private final UserExportMismatchService userExportMismatchService;
    @NotNull
    private final PrcStatusUpdateService prcStatusUpdateService;
    @NotNull
    private final MigrationFinalStatusRepository migrationFinalStatusRepository;
    @NotNull
    private final DiscoveryService discoveryService;
    @NotNull
    private final MigrationCommandService migrationCommandService;
    @NotNull
    private final InProgressMigrationIds migrationIds;
    @NotNull
    private final ScheduledExecutorFactory scheduledExecutorFactory;
    @NotNull
    private final MigrationServiceClient migrationServiceClient;
    @NotNull
    private final WorkerDataConvertor workerDataConvertor;
    @NotNull
    private final MigrationScopeManager migrationScopeManager;
    @NotNull
    private final String id;
    @NotNull
    private final List<ProgressUnit> supportedUnits;
    @NotNull
    private final CommandName commandName;
    @NotNull
    private final KClass<? extends PrcCommandPayload> payloadClassType;
    @NotNull
    private final MigrationProtocol migrationProtocol;

    @Inject
    public V4CustomersWorker(@NotNull PlatformService platformService, @NotNull CustomersProcessorService customersProcessorService, @NotNull CustomersProcessorDataRetriever customersProcessorDataRetriever, @NotNull CustomersProcessorMetricsService customersProcessorMetricsService, @NotNull UserExportMismatchService userExportMismatchService, @NotNull PrcStatusUpdateService prcStatusUpdateService, @NotNull MigrationFinalStatusRepository migrationFinalStatusRepository, @NotNull DiscoveryService discoveryService, @NotNull MigrationCommandService migrationCommandService, @NotNull InProgressMigrationIds migrationIds, @NotNull ScheduledExecutorFactory scheduledExecutorFactory, @NotNull MigrationServiceClient migrationServiceClient, @NotNull WorkerDataConvertor workerDataConvertor, @NotNull MigrationScopeManager migrationScopeManager) {
        Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
        Intrinsics.checkNotNullParameter((Object)customersProcessorService, (String)"customersProcessorService");
        Intrinsics.checkNotNullParameter((Object)customersProcessorDataRetriever, (String)"customersProcessorDataRetriever");
        Intrinsics.checkNotNullParameter((Object)customersProcessorMetricsService, (String)"customersProcessorMetricsService");
        Intrinsics.checkNotNullParameter((Object)userExportMismatchService, (String)"userExportMismatchService");
        Intrinsics.checkNotNullParameter((Object)prcStatusUpdateService, (String)"prcStatusUpdateService");
        Intrinsics.checkNotNullParameter((Object)migrationFinalStatusRepository, (String)"migrationFinalStatusRepository");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)migrationCommandService, (String)"migrationCommandService");
        Intrinsics.checkNotNullParameter((Object)migrationIds, (String)"migrationIds");
        Intrinsics.checkNotNullParameter((Object)scheduledExecutorFactory, (String)"scheduledExecutorFactory");
        Intrinsics.checkNotNullParameter((Object)migrationServiceClient, (String)"migrationServiceClient");
        Intrinsics.checkNotNullParameter((Object)workerDataConvertor, (String)"workerDataConvertor");
        Intrinsics.checkNotNullParameter((Object)migrationScopeManager, (String)"migrationScopeManager");
        this.platformService = platformService;
        this.customersProcessorService = customersProcessorService;
        this.customersProcessorDataRetriever = customersProcessorDataRetriever;
        this.customersProcessorMetricsService = customersProcessorMetricsService;
        this.userExportMismatchService = userExportMismatchService;
        this.prcStatusUpdateService = prcStatusUpdateService;
        this.migrationFinalStatusRepository = migrationFinalStatusRepository;
        this.discoveryService = discoveryService;
        this.migrationCommandService = migrationCommandService;
        this.migrationIds = migrationIds;
        this.scheduledExecutorFactory = scheduledExecutorFactory;
        this.migrationServiceClient = migrationServiceClient;
        this.workerDataConvertor = workerDataConvertor;
        this.migrationScopeManager = migrationScopeManager;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.id = string;
        this.supportedUnits = CollectionsKt.listOf((Object)((Object)ProgressUnit.CUSTOMER));
        this.commandName = CommandName.ALL_CUSTOMER_UPLOAD;
        this.payloadClassType = Reflection.getOrCreateKotlinClass(CustomersGroupsMigrationPayload.class);
        this.migrationProtocol = MigrationProtocol.V4;
    }

    @NotNull
    public final MigrationScopeManager getMigrationScopeManager() {
        return this.migrationScopeManager;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public List<ProgressUnit> getSupportedUnits() {
        return this.supportedUnits;
    }

    @Override
    @NotNull
    public CommandName getCommandName() {
        return this.commandName;
    }

    @Override
    @NotNull
    public KClass<? extends PrcCommandPayload> getPayloadClassType() {
        return this.payloadClassType;
    }

    @Override
    @NotNull
    public MigrationProtocol getMigrationProtocol() {
        return this.migrationProtocol;
    }

    @Override
    public void executeTask(@NotNull PrcCommandPayload commandPayload, long prcCommandId) {
        Intrinsics.checkNotNullParameter((Object)commandPayload, (String)"commandPayload");
        PrcTask task = this.workerDataConvertor.toPrcTaskFromMigrationPayload(commandPayload, prcCommandId, this.getCommandName());
        MigrationCommand migrationCommand = this.migrationCommandService.upsertVersion(task.getMigrationId(), String.valueOf(prcCommandId));
        task.setVersion(migrationCommand.getVersion());
        this.process(task);
    }

    @Override
    public void process(@NotNull PrcTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        new V4CustomersProcessor(this.platformService, this.customersProcessorDataRetriever, this.customersProcessorMetricsService, task, this.customersProcessorService, this.userExportMismatchService, this.scheduledExecutorFactory.createSingleThreadScheduledExecutor("V4CustomersWorker"), this.prcStatusUpdateService, this.migrationFinalStatusRepository, this.discoveryService, this.getMigrationProtocol(), this.migrationCommandService, this.migrationIds, this.migrationServiceClient, this.migrationScopeManager).process();
    }
}

