/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.projects;

import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.migration.analytics.AnalyticsEventService;
import com.atlassian.jira.migration.analytics.MetricsEventService;
import com.atlassian.jira.migration.analytics.MigAssetStatsService;
import com.atlassian.jira.migration.common.LocalFileDataOutput;
import com.atlassian.jira.migration.datafilters.DataFiltersContextService;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.events.JiraEventDetectionService;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.export.DataExportOutcome;
import com.atlassian.jira.migration.export.ExportFacade;
import com.atlassian.jira.migration.migrationservice.CloudProject;
import com.atlassian.jira.migration.migrationservice.MigrationServiceClient;
import com.atlassian.jira.migration.platform.CreateFileMpResponse;
import com.atlassian.jira.migration.platform.PlatformService;
import com.atlassian.jira.migration.scope.MigrationScopeManager;
import com.atlassian.jira.migration.serverdataextractors.usergroup.DeletedUserMapping;
import com.atlassian.jira.migration.tracking.tasks.Task;
import com.atlassian.jira.migration.usersmigrationservice.TombstoneUser;
import com.atlassian.jira.migration.usersmigrationservice.UsersMigrationServiceClient;
import com.atlassian.jira.migration.utility.FileChunkUtility;
import com.atlassian.jira.migration.workers.AttachmentMediaIdService;
import com.atlassian.jira.migration.workers.MigrationTaskMetadataProvider;
import com.atlassian.jira.migration.workers.projects.AbstractProjectProcessor;
import com.atlassian.jira.migration.workers.tombstone.TombstoneAccountManager;
import com.atlassian.jira.project.Project;
import com.atlassian.migration.api.ContainerToken;
import com.atlassian.migration.api.MigrationId;
import java.io.File;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00d0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u009d\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u0012\u0006\u0010\u001e\u001a\u00020\u001f\u0012\u0006\u0010 \u001a\u00020!\u0012\u0006\u0010\"\u001a\u00020#\u0012\u0006\u0010$\u001a\u00020%\u0012\u0006\u0010&\u001a\u00020'\u00a2\u0006\u0002\u0010(J\u0010\u0010B\u001a\u00020.2\u0006\u0010C\u001a\u000204H\u0002J\u0010\u0010D\u001a\u0002042\u0006\u0010E\u001a\u00020FH\u0002J\u000e\u0010G\u001a\b\u0012\u0004\u0012\u00020I0HH\u0004J\u0018\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u0002042\u0006\u0010M\u001a\u00020NH\u0016J\u0018\u0010O\u001a\u00020K2\u0006\u0010P\u001a\u0002042\u0006\u0010Q\u001a\u00020RH\u0016J\u001e\u0010S\u001a\u00020K2\u0006\u0010L\u001a\u0002042\f\u0010T\u001a\b\u0012\u0004\u0012\u00020V0UH\u0016R\u0014\u0010)\u001a\u00020*X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010-\u001a\u00020.8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u00102\u001a\u0004\b/\u00100R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00103\u001a\u000204X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u0014\u00109\u001a\u00020:X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010?\u001a\u00020.8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\bA\u00102\u001a\u0004\b@\u00100R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006W"}, d2={"Lcom/atlassian/jira/migration/workers/projects/AbstractPlatformProjectProcessor;", "Lcom/atlassian/jira/migration/workers/projects/AbstractProjectProcessor;", "export", "Lcom/atlassian/jira/migration/export/ExportFacade;", "migrationScopeManager", "Lcom/atlassian/jira/migration/scope/MigrationScopeManager;", "migrationTaskMetadataProvider", "Lcom/atlassian/jira/migration/workers/MigrationTaskMetadataProvider;", "attachmentMediaIdService", "Lcom/atlassian/jira/migration/workers/AttachmentMediaIdService;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "tombstoneAccountManager", "Lcom/atlassian/jira/migration/workers/tombstone/TombstoneAccountManager;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "localFileDataOutput", "Lcom/atlassian/jira/migration/common/LocalFileDataOutput;", "issueManager", "Lcom/atlassian/jira/issue/IssueManager;", "project", "Lcom/atlassian/jira/project/Project;", "task", "Lcom/atlassian/jira/migration/tracking/tasks/Task;", "usersMigrationServiceClient", "Lcom/atlassian/jira/migration/usersmigrationservice/UsersMigrationServiceClient;", "metricsEventService", "Lcom/atlassian/jira/migration/analytics/MetricsEventService;", "jiraEventDetectionService", "Lcom/atlassian/jira/migration/events/JiraEventDetectionService;", "platformService", "Lcom/atlassian/jira/migration/platform/PlatformService;", "migAssetStatsService", "Lcom/atlassian/jira/migration/analytics/MigAssetStatsService;", "analyticsEventService", "Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;", "migrationServiceClient", "Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient;", "dataFiltersContextService", "Lcom/atlassian/jira/migration/datafilters/DataFiltersContextService;", "(Lcom/atlassian/jira/migration/export/ExportFacade;Lcom/atlassian/jira/migration/scope/MigrationScopeManager;Lcom/atlassian/jira/migration/workers/MigrationTaskMetadataProvider;Lcom/atlassian/jira/migration/workers/AttachmentMediaIdService;Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/migration/workers/tombstone/TombstoneAccountManager;Lcom/atlassian/jira/migration/discovery/DiscoveryService;Lcom/atlassian/jira/migration/common/LocalFileDataOutput;Lcom/atlassian/jira/issue/IssueManager;Lcom/atlassian/jira/project/Project;Lcom/atlassian/jira/migration/tracking/tasks/Task;Lcom/atlassian/jira/migration/usersmigrationservice/UsersMigrationServiceClient;Lcom/atlassian/jira/migration/analytics/MetricsEventService;Lcom/atlassian/jira/migration/events/JiraEventDetectionService;Lcom/atlassian/jira/migration/platform/PlatformService;Lcom/atlassian/jira/migration/analytics/MigAssetStatsService;Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient;Lcom/atlassian/jira/migration/datafilters/DataFiltersContextService;)V", "containerToken", "Lcom/atlassian/migration/api/ContainerToken;", "getContainerToken", "()Lcom/atlassian/migration/api/ContainerToken;", "deletedUsersFile", "Lcom/atlassian/jira/migration/platform/CreateFileMpResponse;", "getDeletedUsersFile", "()Lcom/atlassian/jira/migration/platform/CreateFileMpResponse;", "deletedUsersFile$delegate", "Lkotlin/Lazy;", "fileId", "", "getFileId", "()Ljava/lang/String;", "setFileId", "(Ljava/lang/String;)V", "migrationId", "Lcom/atlassian/migration/api/MigrationId;", "getMigrationId", "()Lcom/atlassian/migration/api/MigrationId;", "getProject", "()Lcom/atlassian/jira/project/Project;", "tombstoneUsersFile", "getTombstoneUsersFile", "tombstoneUsersFile$delegate", "createFile", "filename", "createFileMultipart", "file", "Ljava/io/File;", "getConflictingProjects", "", "Lcom/atlassian/jira/migration/migrationservice/CloudProject;", "uploadDeletedUserMappings", "", "migrationScope", "deletedUserMapping", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/DeletedUserMapping;", "uploadExportedFile", "migrationScopeId", "outcome", "Lcom/atlassian/jira/migration/export/DataExportOutcome;", "uploadTombStoneMappings", "tombstoneUsers", "", "Lcom/atlassian/jira/migration/usersmigrationservice/TombstoneUser;", "jira-migration-plugin"})
public abstract class AbstractPlatformProjectProcessor
extends AbstractProjectProcessor {
    @NotNull
    private final DiscoveryService discoveryService;
    @NotNull
    private final Project project;
    @NotNull
    private final Task task;
    @NotNull
    private final UsersMigrationServiceClient usersMigrationServiceClient;
    @NotNull
    private final PlatformService platformService;
    @NotNull
    private final MigrationServiceClient migrationServiceClient;
    @NotNull
    private final DataFiltersContextService dataFiltersContextService;
    @NotNull
    private final ContainerToken containerToken;
    @NotNull
    private final MigrationId migrationId;
    @NotNull
    private final Lazy deletedUsersFile$delegate;
    protected String fileId;
    @NotNull
    private final Lazy tombstoneUsersFile$delegate;

    public AbstractPlatformProjectProcessor(@NotNull ExportFacade export2, @NotNull MigrationScopeManager migrationScopeManager, @NotNull MigrationTaskMetadataProvider migrationTaskMetadataProvider, @NotNull AttachmentMediaIdService attachmentMediaIdService, @NotNull MigrationEventBus migrationEventBus, @NotNull TombstoneAccountManager tombstoneAccountManager, @NotNull DiscoveryService discoveryService, @NotNull LocalFileDataOutput localFileDataOutput, @NotNull IssueManager issueManager, @NotNull Project project, @NotNull Task task, @NotNull UsersMigrationServiceClient usersMigrationServiceClient, @NotNull MetricsEventService metricsEventService, @NotNull JiraEventDetectionService jiraEventDetectionService, @NotNull PlatformService platformService, @NotNull MigAssetStatsService migAssetStatsService, @NotNull AnalyticsEventService analyticsEventService, @NotNull MigrationServiceClient migrationServiceClient, @NotNull DataFiltersContextService dataFiltersContextService) {
        Intrinsics.checkNotNullParameter((Object)export2, (String)"export");
        Intrinsics.checkNotNullParameter((Object)migrationScopeManager, (String)"migrationScopeManager");
        Intrinsics.checkNotNullParameter((Object)migrationTaskMetadataProvider, (String)"migrationTaskMetadataProvider");
        Intrinsics.checkNotNullParameter((Object)attachmentMediaIdService, (String)"attachmentMediaIdService");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)tombstoneAccountManager, (String)"tombstoneAccountManager");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)((Object)localFileDataOutput), (String)"localFileDataOutput");
        Intrinsics.checkNotNullParameter((Object)issueManager, (String)"issueManager");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)usersMigrationServiceClient, (String)"usersMigrationServiceClient");
        Intrinsics.checkNotNullParameter((Object)metricsEventService, (String)"metricsEventService");
        Intrinsics.checkNotNullParameter((Object)jiraEventDetectionService, (String)"jiraEventDetectionService");
        Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
        Intrinsics.checkNotNullParameter((Object)migAssetStatsService, (String)"migAssetStatsService");
        Intrinsics.checkNotNullParameter((Object)analyticsEventService, (String)"analyticsEventService");
        Intrinsics.checkNotNullParameter((Object)migrationServiceClient, (String)"migrationServiceClient");
        Intrinsics.checkNotNullParameter((Object)dataFiltersContextService, (String)"dataFiltersContextService");
        super(export2, migrationScopeManager, attachmentMediaIdService, migrationEventBus, tombstoneAccountManager, localFileDataOutput, task, issueManager, migrationTaskMetadataProvider, discoveryService, metricsEventService, jiraEventDetectionService, migAssetStatsService, analyticsEventService, dataFiltersContextService);
        this.discoveryService = discoveryService;
        this.project = project;
        this.task = task;
        this.usersMigrationServiceClient = usersMigrationServiceClient;
        this.platformService = platformService;
        this.migrationServiceClient = migrationServiceClient;
        this.dataFiltersContextService = dataFiltersContextService;
        this.containerToken = new ContainerToken(this.task.getCloudSite().getContainerToken());
        this.migrationId = new MigrationId(this.task.getMigrationId());
        this.deletedUsersFile$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<CreateFileMpResponse>(this){
            final /* synthetic */ AbstractPlatformProjectProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final CreateFileMpResponse invoke() {
                return AbstractPlatformProjectProcessor.access$createFile(this.this$0, "deleted-users");
            }
        }));
        this.tombstoneUsersFile$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<CreateFileMpResponse>(this){
            final /* synthetic */ AbstractPlatformProjectProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final CreateFileMpResponse invoke() {
                return AbstractPlatformProjectProcessor.access$createFile(this.this$0, "tombstone-users");
            }
        }));
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    protected final ContainerToken getContainerToken() {
        return this.containerToken;
    }

    @NotNull
    protected final MigrationId getMigrationId() {
        return this.migrationId;
    }

    @NotNull
    protected final CreateFileMpResponse getDeletedUsersFile() {
        Lazy lazy = this.deletedUsersFile$delegate;
        return (CreateFileMpResponse)lazy.getValue();
    }

    @NotNull
    protected final String getFileId() {
        String string = this.fileId;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"fileId");
        return null;
    }

    protected final void setFileId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.fileId = string;
    }

    @NotNull
    protected final CreateFileMpResponse getTombstoneUsersFile() {
        Lazy lazy = this.tombstoneUsersFile$delegate;
        return (CreateFileMpResponse)lazy.getValue();
    }

    @Override
    public void uploadDeletedUserMappings(@NotNull String migrationScope, @NotNull DeletedUserMapping deletedUserMapping2) {
        Intrinsics.checkNotNullParameter((Object)migrationScope, (String)"migrationScope");
        Intrinsics.checkNotNullParameter((Object)deletedUserMapping2, (String)"deletedUserMapping");
        this.platformService.uploadDataToUrl(this.getDeletedUsersFile(), this.containerToken, this.migrationId, deletedUserMapping2, "deleted-users", (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ AbstractPlatformProjectProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                AbstractProjectProcessor.sendHeartbeat$default(this.this$0, null, 1, null);
            }
        }));
    }

    @Override
    public void uploadExportedFile(@NotNull String migrationScopeId2, @NotNull DataExportOutcome outcome) {
        Intrinsics.checkNotNullParameter((Object)migrationScopeId2, (String)"migrationScopeId");
        Intrinsics.checkNotNullParameter((Object)outcome, (String)"outcome");
        this.setFileId(this.createFileMultipart(outcome.getFile()));
    }

    @Override
    public void uploadTombStoneMappings(@NotNull String migrationScope, @NotNull Set<TombstoneUser> tombstoneUsers) {
        Intrinsics.checkNotNullParameter((Object)migrationScope, (String)"migrationScope");
        Intrinsics.checkNotNullParameter(tombstoneUsers, (String)"tombstoneUsers");
        this.usersMigrationServiceClient.publishTombstoneUsers(migrationScope, this.task.getCloudSite().getContainerToken(), tombstoneUsers);
        this.platformService.uploadDataToUrl(this.getTombstoneUsersFile(), this.containerToken, this.migrationId, tombstoneUsers, "tombstone-users", (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ AbstractPlatformProjectProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                AbstractProjectProcessor.sendHeartbeat$default(this.this$0, null, 1, null);
            }
        }));
    }

    private final CreateFileMpResponse createFile(String filename) {
        return this.platformService.generateFile(this.containerToken, this.migrationId, filename, String.valueOf(this.getProject().getId()));
    }

    private final String createFileMultipart(File file2) {
        return this.platformService.uploadMultiPart(this.containerToken, this.migrationId, "project-export", String.valueOf(this.getProject().getId()), file2, FileChunkUtility.INSTANCE.calculateChunkSize(file2.length()), (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ AbstractPlatformProjectProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                AbstractProjectProcessor.sendHeartbeat$default(this.this$0, null, 1, null);
            }
        }));
    }

    @NotNull
    protected final List<CloudProject> getConflictingProjects() {
        List<CloudProject> conflictingCloudProjects = CollectionsKt.emptyList();
        try {
            conflictingCloudProjects = this.migrationServiceClient.getConflictingCloudProjects(this.task.getCloudSite().getContainerToken(), CollectionsKt.listOf((Object)this.getProject().getKey()), CollectionsKt.listOf((Object)this.getProject().getName()));
        }
        catch (Exception exception) {
            this.getLog().warn("Project Key Name Check failed for project " + this.getProject().getKey() + " - " + this.getProject().getName());
        }
        return conflictingCloudProjects;
    }

    public static final /* synthetic */ CreateFileMpResponse access$createFile(AbstractPlatformProjectProcessor $this, String filename) {
        return $this.createFile(filename);
    }
}

