/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.workers.projects;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.migration.analytics.AnalyticsEventService;
import com.atlassian.jira.migration.analytics.MetricsEventService;
import com.atlassian.jira.migration.analytics.MigAssetStatsService;
import com.atlassian.jira.migration.analytics.MigrationAnalyticsEvent;
import com.atlassian.jira.migration.common.LocalFileDataOutput;
import com.atlassian.jira.migration.common.LongExtensionsKt;
import com.atlassian.jira.migration.common.MigrationTaskMetadata;
import com.atlassian.jira.migration.datafilters.DataFiltersContextService;
import com.atlassian.jira.migration.datafilters.model.DataFilterContext;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.events.IssueExportLatencyEvent;
import com.atlassian.jira.migration.events.IssueExportStatistics;
import com.atlassian.jira.migration.events.JiraEventDetectionService;
import com.atlassian.jira.migration.events.MigAssetStats;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.ProjectDataUploadFailed;
import com.atlassian.jira.migration.events.ProjectDataUploadStarted;
import com.atlassian.jira.migration.export.DataExportOutcome;
import com.atlassian.jira.migration.export.ExportFacade;
import com.atlassian.jira.migration.httpclient.exceptions.UnexpectedStatusCodeException;
import com.atlassian.jira.migration.plan.MigrationType;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.plan.ProjectDataMigrationMode;
import com.atlassian.jira.migration.plan.UsersGroupsMigrationOption;
import com.atlassian.jira.migration.prc.exception.CommandCancelledException;
import com.atlassian.jira.migration.scope.MigrationScopeManager;
import com.atlassian.jira.migration.serverdataextractors.usergroup.DeletedUserMapping;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UserInfo;
import com.atlassian.jira.migration.tracking.tasks.Task;
import com.atlassian.jira.migration.tracking.tasks.process.OperationProcessor;
import com.atlassian.jira.migration.usersmigrationservice.TombstoneUser;
import com.atlassian.jira.migration.workers.AttachmentMediaIdService;
import com.atlassian.jira.migration.workers.MigrationTaskMetadataProvider;
import com.atlassian.jira.migration.workers.projects.AbstractProjectProcessor;
import com.atlassian.jira.migration.workers.projects.TotalIssueCount;
import com.atlassian.jira.migration.workers.tombstone.TombstoneAccountManager;
import com.atlassian.jira.project.Project;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@VisibleForTesting
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00da\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u0000 d2\u00020\u0001:\u0001dB}\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u0012\u0006\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\u0002\u0010 J\"\u0010B\u001a\u0014\u0012\u0004\u0012\u00020C\u0012\n\u0012\b\u0012\u0004\u0012\u0002020D0,2\u0006\u00105\u001a\u000206H\u0002J\u0010\u0010E\u001a\u00020C2\u0006\u00105\u001a\u000206H\u0002J\b\u0010F\u001a\u00020.H\u0002J\b\u0010G\u001a\u00020-H&J\b\u0010H\u001a\u00020.H\u0016J\u001e\u0010I\u001a\u00020.2\u0006\u0010J\u001a\u0002022\f\u0010B\u001a\b\u0012\u0004\u0012\u0002020DH\u0002J\u0018\u0010K\u001a\u00020.2\u0006\u0010L\u001a\u0002022\u0006\u0010M\u001a\u00020CH\u0002J&\u0010N\u001a\u00020.2\u0006\u0010J\u001a\u0002022\f\u0010B\u001a\b\u0012\u0004\u0012\u0002020D2\u0006\u00105\u001a\u000206H\u0002J\u0014\u0010O\u001a\u00020.2\n\u0010P\u001a\u00060Qj\u0002`RH\u0002J\b\u0010S\u001a\u00020.H&J\u0014\u0010T\u001a\u00020.2\n\b\u0002\u0010U\u001a\u0004\u0018\u000102H&J\u0018\u0010V\u001a\u00020.2\u0006\u0010W\u001a\u00020C2\u0006\u0010X\u001a\u000202H\u0002J\b\u0010Y\u001a\u00020.H\u0002J\u0010\u0010Z\u001a\u00020[2\u0006\u00105\u001a\u000206H\u0002J\u0018\u0010\\\u001a\u00020.2\u0006\u0010J\u001a\u0002022\u0006\u0010]\u001a\u00020^H&J\u0018\u0010_\u001a\u00020.2\u0006\u0010L\u001a\u0002022\u0006\u0010M\u001a\u00020CH&J\u001e\u0010`\u001a\u00020.2\u0006\u0010J\u001a\u0002022\f\u0010a\u001a\b\u0012\u0004\u0012\u00020c0bH&R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010!\u001a\u00020\"X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010%\u001a\u00020&8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b'\u0010(R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010+\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020.0,X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0012\u00101\u001a\u000202X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0011\u00105\u001a\u000206\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u0012\u00109\u001a\u00020:X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010=\u001a\u00020>8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bA\u0010*\u001a\u0004\b?\u0010@\u00a8\u0006e"}, d2={"Lcom/atlassian/jira/migration/workers/projects/AbstractProjectProcessor;", "Lcom/atlassian/jira/migration/tracking/tasks/process/OperationProcessor;", "export", "Lcom/atlassian/jira/migration/export/ExportFacade;", "migrationScopeManager", "Lcom/atlassian/jira/migration/scope/MigrationScopeManager;", "attachmentMediaIdService", "Lcom/atlassian/jira/migration/workers/AttachmentMediaIdService;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "tombstoneAccountManager", "Lcom/atlassian/jira/migration/workers/tombstone/TombstoneAccountManager;", "localFileDataOutput", "Lcom/atlassian/jira/migration/common/LocalFileDataOutput;", "task", "Lcom/atlassian/jira/migration/tracking/tasks/Task;", "issueManager", "Lcom/atlassian/jira/issue/IssueManager;", "migrationTaskMetadataProvider", "Lcom/atlassian/jira/migration/workers/MigrationTaskMetadataProvider;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "metricsEventService", "Lcom/atlassian/jira/migration/analytics/MetricsEventService;", "jiraEventDetectionService", "Lcom/atlassian/jira/migration/events/JiraEventDetectionService;", "migAssetStatsService", "Lcom/atlassian/jira/migration/analytics/MigAssetStatsService;", "analyticsEventService", "Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;", "dataFiltersContextService", "Lcom/atlassian/jira/migration/datafilters/DataFiltersContextService;", "(Lcom/atlassian/jira/migration/export/ExportFacade;Lcom/atlassian/jira/migration/scope/MigrationScopeManager;Lcom/atlassian/jira/migration/workers/AttachmentMediaIdService;Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/migration/workers/tombstone/TombstoneAccountManager;Lcom/atlassian/jira/migration/common/LocalFileDataOutput;Lcom/atlassian/jira/migration/tracking/tasks/Task;Lcom/atlassian/jira/issue/IssueManager;Lcom/atlassian/jira/migration/workers/MigrationTaskMetadataProvider;Lcom/atlassian/jira/migration/discovery/DiscoveryService;Lcom/atlassian/jira/migration/analytics/MetricsEventService;Lcom/atlassian/jira/migration/events/JiraEventDetectionService;Lcom/atlassian/jira/migration/analytics/MigAssetStatsService;Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;Lcom/atlassian/jira/migration/datafilters/DataFiltersContextService;)V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "migrationTaskMetadata", "Lcom/atlassian/jira/migration/common/MigrationTaskMetadata;", "getMigrationTaskMetadata", "()Lcom/atlassian/jira/migration/common/MigrationTaskMetadata;", "migrationTaskMetadata$delegate", "Lkotlin/Lazy;", "onProgressUpdate", "Lkotlin/Function1;", "", "", "getOnProgressUpdate", "()Lkotlin/jvm/functions/Function1;", "operationKeyPrefix", "", "getOperationKeyPrefix", "()Ljava/lang/String;", "plan", "Lcom/atlassian/jira/migration/plan/Plan;", "getPlan", "()Lcom/atlassian/jira/migration/plan/Plan;", "project", "Lcom/atlassian/jira/project/Project;", "getProject", "()Lcom/atlassian/jira/project/Project;", "totalIssueCount", "Lcom/atlassian/jira/migration/workers/projects/TotalIssueCount;", "getTotalIssueCount", "()Lcom/atlassian/jira/migration/workers/projects/TotalIssueCount;", "totalIssueCount$delegate", "deletedUserKeys", "Lcom/atlassian/jira/migration/export/DataExportOutcome;", "", "exportProjectData", "generateAttachmentMediaIds", "getHeartbeatFrequency", "process", "processDeletedUserMappings", "migrationScope", "processExportedFile", "migrationScopeId", "outcome", "publishTombStoneMappings", "sendFailedEvent", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "sendFinalStatus", "sendHeartbeat", "msg", "sendIssueStatsMetrics", "exportOutcome", "operationKey", "sendStartEvent", "shouldPublishTombStoneMappings", "", "uploadDeletedUserMappings", "deletedUserMapping", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/DeletedUserMapping;", "uploadExportedFile", "uploadTombStoneMappings", "tombstoneUsers", "", "Lcom/atlassian/jira/migration/usersmigrationservice/TombstoneUser;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAbstractProjectProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractProjectProcessor.kt\ncom/atlassian/jira/migration/workers/projects/AbstractProjectProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,300:1\n1#2:301\n*E\n"})
public abstract class AbstractProjectProcessor
extends OperationProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExportFacade export;
    @NotNull
    private final MigrationScopeManager migrationScopeManager;
    @NotNull
    private final AttachmentMediaIdService attachmentMediaIdService;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final TombstoneAccountManager tombstoneAccountManager;
    @NotNull
    private final LocalFileDataOutput localFileDataOutput;
    @NotNull
    private final Task task;
    @NotNull
    private final IssueManager issueManager;
    @NotNull
    private final MigrationTaskMetadataProvider migrationTaskMetadataProvider;
    @NotNull
    private final MigAssetStatsService migAssetStatsService;
    @NotNull
    private final AnalyticsEventService analyticsEventService;
    @NotNull
    private final DataFiltersContextService dataFiltersContextService;
    @NotNull
    private final Lazy migrationTaskMetadata$delegate;
    @NotNull
    private final Lazy totalIssueCount$delegate;
    @NotNull
    private final Plan plan;
    public static final int IGNORED_ERROR_CODE = 409;

    public AbstractProjectProcessor(@NotNull ExportFacade export2, @NotNull MigrationScopeManager migrationScopeManager, @NotNull AttachmentMediaIdService attachmentMediaIdService, @NotNull MigrationEventBus migrationEventBus, @NotNull TombstoneAccountManager tombstoneAccountManager, @NotNull LocalFileDataOutput localFileDataOutput, @NotNull Task task, @NotNull IssueManager issueManager, @NotNull MigrationTaskMetadataProvider migrationTaskMetadataProvider, @NotNull DiscoveryService discoveryService, @NotNull MetricsEventService metricsEventService, @NotNull JiraEventDetectionService jiraEventDetectionService, @NotNull MigAssetStatsService migAssetStatsService, @NotNull AnalyticsEventService analyticsEventService, @NotNull DataFiltersContextService dataFiltersContextService) {
        Intrinsics.checkNotNullParameter((Object)export2, (String)"export");
        Intrinsics.checkNotNullParameter((Object)migrationScopeManager, (String)"migrationScopeManager");
        Intrinsics.checkNotNullParameter((Object)attachmentMediaIdService, (String)"attachmentMediaIdService");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)tombstoneAccountManager, (String)"tombstoneAccountManager");
        Intrinsics.checkNotNullParameter((Object)((Object)localFileDataOutput), (String)"localFileDataOutput");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)issueManager, (String)"issueManager");
        Intrinsics.checkNotNullParameter((Object)migrationTaskMetadataProvider, (String)"migrationTaskMetadataProvider");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)metricsEventService, (String)"metricsEventService");
        Intrinsics.checkNotNullParameter((Object)jiraEventDetectionService, (String)"jiraEventDetectionService");
        Intrinsics.checkNotNullParameter((Object)migAssetStatsService, (String)"migAssetStatsService");
        Intrinsics.checkNotNullParameter((Object)analyticsEventService, (String)"analyticsEventService");
        Intrinsics.checkNotNullParameter((Object)dataFiltersContextService, (String)"dataFiltersContextService");
        super(metricsEventService, jiraEventDetectionService);
        this.export = export2;
        this.migrationScopeManager = migrationScopeManager;
        this.attachmentMediaIdService = attachmentMediaIdService;
        this.migrationEventBus = migrationEventBus;
        this.tombstoneAccountManager = tombstoneAccountManager;
        this.localFileDataOutput = localFileDataOutput;
        this.task = task;
        this.issueManager = issueManager;
        this.migrationTaskMetadataProvider = migrationTaskMetadataProvider;
        this.migAssetStatsService = migAssetStatsService;
        this.analyticsEventService = analyticsEventService;
        this.dataFiltersContextService = dataFiltersContextService;
        this.migrationTaskMetadata$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<MigrationTaskMetadata>(this){
            final /* synthetic */ AbstractProjectProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final MigrationTaskMetadata invoke() {
                return AbstractProjectProcessor.access$getMigrationTaskMetadataProvider$p(this.this$0).get(AbstractProjectProcessor.access$getTask$p(this.this$0));
            }
        }));
        this.totalIssueCount$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TotalIssueCount>(this){
            final /* synthetic */ AbstractProjectProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final TotalIssueCount invoke() {
                return new TotalIssueCount((Function0<Long>)((Function0)new Function0<Long>(this.this$0){
                    final /* synthetic */ AbstractProjectProcessor this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final Long invoke() {
                        return AbstractProjectProcessor.access$getIssueManager$p(this.this$0).getIssueCountForProject(this.this$0.getProject().getId());
                    }
                }));
            }
        }));
        this.plan = DiscoveryService.retrievePlanFor$default(discoveryService, this.task, false, 2, null);
    }

    private final MigrationTaskMetadata getMigrationTaskMetadata() {
        Lazy lazy = this.migrationTaskMetadata$delegate;
        return (MigrationTaskMetadata)lazy.getValue();
    }

    @NotNull
    public final TotalIssueCount getTotalIssueCount() {
        Lazy lazy = this.totalIssueCount$delegate;
        return (TotalIssueCount)lazy.getValue();
    }

    @NotNull
    public final Plan getPlan() {
        return this.plan;
    }

    @NotNull
    public abstract String getOperationKeyPrefix();

    @NotNull
    public abstract Project getProject();

    @NotNull
    public abstract Logger getLog();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        if (!(!this.plan.isV2AttachmentsOnly())) {
            boolean bl = false;
            String string = "ProjectsWorker should never be called for ProjectMigrationMode.ATTACHMENTS_ONLY_V2";
            throw new IllegalArgumentException(string.toString());
        }
        this.sendStartEvent();
        this.getLog().info(this.task.getMigrationId() + '-' + this.task.getTaskId() + ": exporting project " + this.getProject().getKey() + " as " + this.getMigrationTaskMetadata().getStartedUser() + " for mode " + (Object)((Object)this.plan.getProjectDataMigrationMode()));
        try {
            this.generateAttachmentMediaIds();
            AutoCloseable autoCloseable = this.exportProjectData(this.plan);
            Throwable throwable = null;
            try {
                DataExportOutcome outcome = (DataExportOutcome)autoCloseable;
                boolean bl = false;
                String migrationScopeId2 = this.migrationScopeManager.getMigrationScope(this.task.getCloudSite());
                this.getLog().info(this.task.getMigrationId() + '-' + this.task.getMigrationTask().getTaskId() + ": migration scope id " + migrationScopeId2);
                this.processDeletedUserMappings(migrationScopeId2, (List)this.deletedUserKeys(this.plan).invoke((Object)outcome));
                this.publishTombStoneMappings(migrationScopeId2, (List)this.deletedUserKeys(this.plan).invoke((Object)outcome), this.plan);
                AbstractProjectProcessor.sendHeartbeat$default(this, null, 1, null);
                this.processExportedFile(migrationScopeId2, outcome);
                this.migAssetStatsService.publishProjectAssetMetrics(this.task.getMigrationId(), migrationScopeId2, outcome.getFile(), MigAssetStats.StatsType.PROJECT, this.getProject().getKey(), this.getProject().getId(), this.issueManager.getIssueCountForProject(this.getProject().getId()));
                this.migAssetStatsService.publishDiskStats(this.task.getMigrationId(), migrationScopeId2);
                this.sendFinalStatus();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (CommandCancelledException ex) {
            throw ex;
        }
        catch (UnexpectedStatusCodeException ex) {
            if (ex.getStatusCode() != 409) {
                this.getLog().error(this.task.getMigrationId() + '-' + this.task.getTaskId() + ": exporting project " + this.getProject().getKey() + " failed");
                this.sendFailedEvent(ex);
                throw ex;
            }
            this.getLog().info(this.task.getMigrationId() + '-' + this.task.getTaskId() + ": ignoring " + ex.getStatusCode() + " for project " + this.getProject().getKey());
        }
        catch (Exception ex) {
            this.getLog().error(this.task.getMigrationId() + '-' + this.task.getTaskId() + ": exporting project " + this.getProject().getKey() + " failed");
            this.sendFailedEvent(ex);
            throw ex;
        }
        this.getLog().info(this.task.getMigrationId() + '-' + this.task.getTaskId() + ": notified MO complete for project " + this.getProject().getKey());
    }

    private final Function1<DataExportOutcome, List<String>> deletedUserKeys(Plan plan2) {
        return plan2.isLegacyAttachmentsOnly() ? (Function1)deletedUserKeys.1.INSTANCE : (Function1)deletedUserKeys.2.INSTANCE;
    }

    private final void processDeletedUserMappings(String migrationScope, List<String> deletedUserKeys2) {
        OperationProcessor.runTimedOperation$default(this, MetricsEventService.OperationType.PROJECT_UPLOAD_DELETED_USER_MAPPING, this.getOperationKeyPrefix() + "-upload-deleted-users", null, (Function0)new Function0<OperationProcessor.OperationOutcome>(this, deletedUserKeys2, migrationScope){
            final /* synthetic */ AbstractProjectProcessor this$0;
            final /* synthetic */ List<String> $deletedUserKeys;
            final /* synthetic */ String $migrationScope;
            {
                this.this$0 = $receiver;
                this.$deletedUserKeys = $deletedUserKeys;
                this.$migrationScope = $migrationScope;
                super(0);
            }

            @NotNull
            public final OperationProcessor.OperationOutcome invoke() {
                DeletedUserMapping deletedUserMapping2 = TombstoneAccountManager.buildDeleteUserMappings$default(AbstractProjectProcessor.access$getTombstoneAccountManager$p(this.this$0), AbstractProjectProcessor.access$getTask$p(this.this$0), this.$deletedUserKeys, false, (Function0)new Function0<Unit>(this.this$0){
                    final /* synthetic */ AbstractProjectProcessor this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        AbstractProjectProcessor.sendHeartbeat$default(this.this$0, null, 1, null);
                    }
                }, 4, null);
                this.this$0.uploadDeletedUserMappings(this.$migrationScope, deletedUserMapping2);
                this.this$0.getLog().info(AbstractProjectProcessor.access$getTask$p(this.this$0).getMigrationId() + '-' + AbstractProjectProcessor.access$getTask$p(this.this$0).getTaskId() + ": uploaded deleted user keys to AAID mappings " + this.this$0.getProject().getKey() + " to MO");
                return new OperationProcessor.OperationOutcome(LongExtensionsKt.safeDivide(Long.valueOf(deletedUserMapping2.getDeletedUsersInfo().size()), 5));
            }
        }, 4, null);
    }

    public abstract void uploadDeletedUserMappings(@NotNull String var1, @NotNull DeletedUserMapping var2);

    private final void publishTombStoneMappings(String migrationScope, List<String> deletedUserKeys2, Plan plan2) {
        if (this.shouldPublishTombStoneMappings(plan2)) {
            OperationProcessor.runTimedOperation$default(this, MetricsEventService.OperationType.PROJECT_PUBLISH_TOMBSTONE_MAPPINGS, this.getOperationKeyPrefix() + "-publish-tombstones", null, (Function0)new Function0<OperationProcessor.OperationOutcome>(this, deletedUserKeys2, migrationScope){
                final /* synthetic */ AbstractProjectProcessor this$0;
                final /* synthetic */ List<String> $deletedUserKeys;
                final /* synthetic */ String $migrationScope;
                {
                    this.this$0 = $receiver;
                    this.$deletedUserKeys = $deletedUserKeys;
                    this.$migrationScope = $migrationScope;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final OperationProcessor.OperationOutcome invoke() {
                    List<UserInfo> deletedUsersInfo2 = TombstoneAccountManager.buildDeleteUserMappings$default(AbstractProjectProcessor.access$getTombstoneAccountManager$p(this.this$0), AbstractProjectProcessor.access$getTask$p(this.this$0), this.$deletedUserKeys, false, (Function0)new Function0<Unit>(this.this$0){
                        final /* synthetic */ AbstractProjectProcessor this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        public final void invoke() {
                            AbstractProjectProcessor.sendHeartbeat$default(this.this$0, null, 1, null);
                        }
                    }, 4, null).getDeletedUsersInfo();
                    if (!((Collection)deletedUsersInfo2).isEmpty()) {
                        void $this$mapTo$iv$iv;
                        List<UserInfo> list = deletedUsersInfo2;
                        AbstractProjectProcessor abstractProjectProcessor = this.this$0;
                        String string = this.$migrationScope;
                        List<UserInfo> $this$invoke_u24lambda_u241 = list;
                        boolean bl = false;
                        Iterable $this$map$iv = $this$invoke_u24lambda_u241;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void user;
                            UserInfo userInfo = (UserInfo)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl2 = false;
                            String string2 = user.getAaid();
                            Intrinsics.checkNotNull((Object)string2);
                            collection.add(new TombstoneUser(string2, user.getUserName(), user.getUserKey(), user.getDisplayName()));
                        }
                        List tombstoneUsers = (List)destination$iv$iv;
                        abstractProjectProcessor.uploadTombStoneMappings(string, CollectionsKt.toSet((Iterable)tombstoneUsers));
                        this.this$0.getLog().info(AbstractProjectProcessor.access$getTask$p(this.this$0).getMigrationId() + '-' + AbstractProjectProcessor.access$getTask$p(this.this$0).getTaskId() + ": tombstones published to UMS.");
                    }
                    return new OperationProcessor.OperationOutcome(LongExtensionsKt.safeDivide(Long.valueOf(deletedUsersInfo2.size()), 5));
                }
            }, 4, null);
        }
    }

    public abstract void uploadTombStoneMappings(@NotNull String var1, @NotNull Set<TombstoneUser> var2);

    private final void processExportedFile(String migrationScopeId2, DataExportOutcome outcome) {
        OperationProcessor.runTimedOperation$default(this, MetricsEventService.OperationType.PROJECT_UPLOAD, this.getOperationKeyPrefix() + "-upload-export", null, (Function0)new Function0<OperationProcessor.OperationOutcome>(this, migrationScopeId2, outcome){
            final /* synthetic */ AbstractProjectProcessor this$0;
            final /* synthetic */ String $migrationScopeId;
            final /* synthetic */ DataExportOutcome $outcome;
            {
                this.this$0 = $receiver;
                this.$migrationScopeId = $migrationScopeId;
                this.$outcome = $outcome;
                super(0);
            }

            @NotNull
            public final OperationProcessor.OperationOutcome invoke() {
                this.this$0.uploadExportedFile(this.$migrationScopeId, this.$outcome);
                return new OperationProcessor.OperationOutcome(LongExtensionsKt.safeDivide(this.$outcome.getFile().length(), 102400));
            }
        }, 4, null);
        this.getLog().info(this.task.getMigrationId() + '-' + this.task.getTaskId() + ": uploaded project " + this.getProject().getKey() + " to MO");
    }

    public abstract void uploadExportedFile(@NotNull String var1, @NotNull DataExportOutcome var2);

    private final boolean shouldPublishTombStoneMappings(Plan plan2) {
        return !plan2.isLegacyAttachmentsOnly();
    }

    private final DataExportOutcome exportProjectData(Plan plan2) {
        String operationKey = this.getOperationKeyPrefix() + "-export";
        return (DataExportOutcome)OperationProcessor.runTimedOperationWithResult$default(this, MetricsEventService.OperationType.PROJECT_EXPORT, operationKey, null, (Function0)new Function0<OperationProcessor.OperationOutcomeWithResult<DataExportOutcome>>(plan2, this, operationKey){
            final /* synthetic */ Plan $plan;
            final /* synthetic */ AbstractProjectProcessor this$0;
            final /* synthetic */ String $operationKey;
            {
                this.$plan = $plan;
                this.this$0 = $receiver;
                this.$operationKey = $operationKey;
                super(0);
            }

            @NotNull
            public final OperationProcessor.OperationOutcomeWithResult<DataExportOutcome> invoke() {
                DataExportOutcome dataExportOutcome;
                if (this.$plan.isLegacyAttachmentsOnly()) {
                    LocalFileDataOutput localFileDataOutput = AbstractProjectProcessor.access$getLocalFileDataOutput$p(this.this$0);
                    String string = AbstractProjectProcessor.access$getTask$p(this.this$0).getMigrationId();
                    String string2 = this.this$0.getProject().getKey();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getKey(...)");
                    File file2 = LocalFileDataOutput.outputFileForProjectData$default(localFileDataOutput, string, string2, null, 4, null);
                    FilesKt.writeText$default((File)file2, (String)"{\"entities\": []}", null, (int)2, null);
                    dataExportOutcome = new DataExportOutcome(file2, SetsKt.emptySet(), 0);
                } else {
                    ExportFacade exportFacade = AbstractProjectProcessor.access$getExport$p(this.this$0);
                    Project project = this.this$0.getProject();
                    MigrationTaskMetadata migrationTaskMetadata2 = AbstractProjectProcessor.access$getMigrationTaskMetadata(this.this$0);
                    Function1<Long, String> function1 = AbstractProjectProcessor.access$getAttachmentMediaIdService$p(this.this$0).attachmentMediaIdResolvingAction(AbstractProjectProcessor.access$getTask$p(this.this$0).getCloudSite().getContainerToken());
                    UsersGroupsMigrationOption usersGroupsMigrationOption = this.$plan.getUsersGroupsMigrationOption();
                    ProjectDataMigrationMode projectDataMigrationMode = this.$plan.getProjectDataMigrationMode();
                    Boolean bl = this.$plan.getMigrateArchivedIssues();
                    String string = this.$plan.getId();
                    MigrationType migrationType = this.$plan.getMigrationType();
                    Function1<Long, Unit> function12 = this.this$0.getOnProgressUpdate();
                    Task task = AbstractProjectProcessor.access$getTask$p(this.this$0);
                    DataFilterContext dataFilterContext = DataFiltersContextService.getDataFilterContext$default(AbstractProjectProcessor.access$getDataFiltersContextService$p(this.this$0), this.$plan.getProjectDataMigrationMode(), this.$plan.getIssueFilters(), null, 4, null);
                    dataExportOutcome = ExportFacade.exportProjectData$default(exportFacade, project, migrationTaskMetadata2, usersGroupsMigrationOption, projectDataMigrationMode, string, migrationType, bl, function1, function12, null, task, dataFilterContext, 512, null);
                }
                DataExportOutcome exportOutcome2 = dataExportOutcome;
                AbstractProjectProcessor.access$sendIssueStatsMetrics(this.this$0, exportOutcome2, this.$operationKey);
                this.this$0.getLog().info(AbstractProjectProcessor.access$getTask$p(this.this$0).getMigrationId() + '-' + AbstractProjectProcessor.access$getTask$p(this.this$0).getTaskId() + ": generated export file for project " + this.this$0.getProject().getKey() + " (path " + exportOutcome2.getFile().getAbsolutePath() + ", size=" + exportOutcome2.getFile().length() + "B)");
                this.this$0.getLog().info(AbstractProjectProcessor.access$getTask$p(this.this$0).getMigrationId() + '-' + AbstractProjectProcessor.access$getTask$p(this.this$0).getTaskId() + ": exporting project " + this.this$0.getProject().getKey() + " completed");
                return new OperationProcessor.OperationOutcomeWithResult<DataExportOutcome>(LongExtensionsKt.safeDivide(Long.valueOf(exportOutcome2.getExportedEntities()), 100), exportOutcome2);
            }
        }, 4, null);
    }

    private final void generateAttachmentMediaIds() {
        OperationProcessor.runTimedOperation$default(this, MetricsEventService.OperationType.PROJECT_MEDIA_ID_GENERATION, this.getOperationKeyPrefix() + "-media-id-gen", null, (Function0)new Function0<OperationProcessor.OperationOutcome>(this){
            final /* synthetic */ AbstractProjectProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final OperationProcessor.OperationOutcome invoke() {
                int attachCount2 = AbstractProjectProcessor.access$getAttachmentMediaIdService$p(this.this$0).generateAttachmentMediaIds(AbstractProjectProcessor.access$getTask$p(this.this$0), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this.this$0){
                    final /* synthetic */ AbstractProjectProcessor this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.this$0.sendHeartbeat(it);
                    }
                }), new DataFilterContext(null, null, null, 7, null));
                return new OperationProcessor.OperationOutcome(LongExtensionsKt.safeDivide(Long.valueOf(attachCount2), 25));
            }
        }, 4, null);
    }

    private final void sendStartEvent() {
        String string = this.task.getCloudId();
        String string2 = this.task.getMigrationId();
        String string3 = this.getProject().getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getKey(...)");
        Long l = this.getProject().getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        long l2 = ((Number)l).longValue();
        String string4 = this.getProject().getProjectTypeKey().getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getKey(...)");
        this.migrationEventBus.post(new ProjectDataUploadStarted(string, string2, string3, l2, string4));
    }

    private final void sendFailedEvent(Exception ex) {
        String string = this.task.getCloudId();
        String string2 = this.task.getMigrationId();
        String string3 = this.getProject().getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getKey(...)");
        Long l = this.getProject().getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        this.migrationEventBus.post(new ProjectDataUploadFailed(string, string2, string3, ((Number)l).longValue(), ex.getMessage()));
    }

    private final void sendIssueStatsMetrics(DataExportOutcome exportOutcome2, String operationKey) {
        block4: {
            Object object;
            IssueExportStatistics issueExportStatistics = exportOutcome2.getStatistics();
            IssueExportLatencyEvent issueLatencyEvent = issueExportStatistics != null ? issueExportStatistics.getIssueLatencyEvent(this.task.getMigrationId()) : null;
            Object object2 = this;
            try {
                MigrationAnalyticsEvent migrationAnalyticsEvent;
                AbstractProjectProcessor $this$sendIssueStatsMetrics_u24lambda_u243 = object2;
                boolean bl = false;
                IssueExportLatencyEvent issueExportLatencyEvent = issueLatencyEvent;
                if (issueExportLatencyEvent != null) {
                    IssueExportLatencyEvent it = issueExportLatencyEvent;
                    boolean bl2 = false;
                    $this$sendIssueStatsMetrics_u24lambda_u243.recordMetric(MetricsEventService.OperationType.PROJECT_ISSUE_EXPORT, operationKey, it.getAvgLatency(), it.toTimerEventTags());
                    $this$sendIssueStatsMetrics_u24lambda_u243.recordMetric(MetricsEventService.OperationType.PROJECT_ISSUE_ACTUAL_EXPORT, operationKey, it.getActualLatency(), it.toTimerEventTagsForActualLatency());
                    migrationAnalyticsEvent = AnalyticsEventService.saveAnalyticsEvent$default($this$sendIssueStatsMetrics_u24lambda_u243.analyticsEventService, (EventDto)it.toOperationalEvent(), null, 2, null);
                } else {
                    migrationAnalyticsEvent = null;
                }
                object = Result.constructor-impl(migrationAnalyticsEvent);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block4;
            Object it = object = throwable;
            boolean bl = false;
            this.getLog().error("Exception while recording Metric for issue export", (Throwable)it);
        }
    }

    @NotNull
    public abstract Function1<Long, Unit> getOnProgressUpdate();

    public abstract void sendHeartbeat(@Nullable String var1);

    public static /* synthetic */ void sendHeartbeat$default(AbstractProjectProcessor abstractProjectProcessor, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sendHeartbeat");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        abstractProjectProcessor.sendHeartbeat(string);
    }

    public abstract void sendFinalStatus();

    public abstract long getHeartbeatFrequency();

    public static final /* synthetic */ TombstoneAccountManager access$getTombstoneAccountManager$p(AbstractProjectProcessor $this) {
        return $this.tombstoneAccountManager;
    }

    public static final /* synthetic */ Task access$getTask$p(AbstractProjectProcessor $this) {
        return $this.task;
    }

    public static final /* synthetic */ LocalFileDataOutput access$getLocalFileDataOutput$p(AbstractProjectProcessor $this) {
        return $this.localFileDataOutput;
    }

    public static final /* synthetic */ ExportFacade access$getExport$p(AbstractProjectProcessor $this) {
        return $this.export;
    }

    public static final /* synthetic */ MigrationTaskMetadata access$getMigrationTaskMetadata(AbstractProjectProcessor $this) {
        return $this.getMigrationTaskMetadata();
    }

    public static final /* synthetic */ AttachmentMediaIdService access$getAttachmentMediaIdService$p(AbstractProjectProcessor $this) {
        return $this.attachmentMediaIdService;
    }

    public static final /* synthetic */ DataFiltersContextService access$getDataFiltersContextService$p(AbstractProjectProcessor $this) {
        return $this.dataFiltersContextService;
    }

    public static final /* synthetic */ void access$sendIssueStatsMetrics(AbstractProjectProcessor $this, DataExportOutcome exportOutcome2, String operationKey) {
        $this.sendIssueStatsMetrics(exportOutcome2, operationKey);
    }

    public static final /* synthetic */ MigrationTaskMetadataProvider access$getMigrationTaskMetadataProvider$p(AbstractProjectProcessor $this) {
        return $this.migrationTaskMetadataProvider;
    }

    public static final /* synthetic */ IssueManager access$getIssueManager$p(AbstractProjectProcessor $this) {
        return $this.issueManager;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/workers/projects/AbstractProjectProcessor$Companion;", "", "()V", "IGNORED_ERROR_CODE", "", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

